/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.IOException;
import java.net.Socket;
import java.util.Date;
import net.i2p.util.SimpleTimer2;

public class SocketTimeout
extends SimpleTimer2.TimedEvent {
    private volatile Socket _targetSocket;
    private final long _startTime;
    private volatile long _inactivityDelay;
    private volatile long _lastActivity;
    private volatile long _totalTimeoutTime;
    private volatile boolean _cancelled;
    private volatile Runnable _command;

    public SocketTimeout(long delay) {
        this((Socket)null, delay);
    }

    public SocketTimeout(Socket socket, long delay) {
        super(SimpleTimer2.getInstance());
        this._inactivityDelay = delay;
        this._targetSocket = socket;
        this._cancelled = false;
        this._lastActivity = this._startTime = System.currentTimeMillis();
        this._totalTimeoutTime = -1L;
        this.schedule(delay);
    }

    @Override
    public void timeReached() {
        if (this._cancelled) {
            return;
        }
        if (this._totalTimeoutTime > 0L && this._totalTimeoutTime <= System.currentTimeMillis() || this._inactivityDelay + this._lastActivity <= System.currentTimeMillis()) {
            if (this._targetSocket != null) {
                try {
                    if (!this._targetSocket.isClosed()) {
                        this._targetSocket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this._command != null) {
                this._command.run();
            }
        } else {
            this.schedule(this._inactivityDelay);
        }
    }

    @Override
    public boolean cancel() {
        this._cancelled = true;
        return super.cancel();
    }

    public void setSocket(Socket s) {
        this._targetSocket = s;
    }

    public void resetTimer() {
        this._lastActivity = System.currentTimeMillis();
    }

    public void setInactivityTimeout(long timeout) {
        this._inactivityDelay = timeout;
    }

    public void setTotalTimeoutPeriod(long timeoutPeriod) {
        this._totalTimeoutTime = timeoutPeriod > 0L ? this._startTime + timeoutPeriod : -1L;
    }

    public void setTimeoutCommand(Runnable job) {
        this._command = job;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("SocketTimeout started on ");
        buf.append(new Date(this._startTime));
        buf.append(" idle for ");
        buf.append(System.currentTimeMillis() - this._lastActivity);
        buf.append("ms ");
        if (this._totalTimeoutTime > 0L) {
            buf.append("total timeout at ").append(new Date(this._totalTimeoutTime));
        }
        buf.append("cancelled? ").append(this._cancelled);
        return buf.toString();
    }
}

