/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.util.OrderedProperties;

public class GetDateMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 32;
    private String _version;
    private Properties _options;

    public GetDateMessage() {
    }

    public GetDateMessage(String version) {
        this._version = version;
    }

    public GetDateMessage(String version, Properties options) {
        if (version == null && options != null && !options.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this._version = version;
        this._options = options;
    }

    public String getVersion() {
        return this._version;
    }

    public Properties getOptions() {
        return this._options;
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        if (size > 0) {
            try {
                this._version = DataHelper.readString(in);
                if (size > 1 + this._version.length()) {
                    this._options = DataHelper.readProperties(in);
                }
            }
            catch (DataFormatException dfe) {
                throw new I2CPMessageException("Bad version string", dfe);
            }
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._version == null) {
            return new byte[0];
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(this._options != null ? 128 : 16);
        try {
            DataHelper.writeString(os, this._version);
            if (this._options != null && !this._options.isEmpty()) {
                DataHelper.writeProperties(os, this._options, true);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    @Override
    public int getType() {
        return 32;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[GetDateMessage]");
        buf.append("\n\tVersion: ").append(this._version);
        if (this._options != null && !this._options.isEmpty()) {
            buf.append("\n\tOptions: #: ").append(this._options.size());
            OrderedProperties sorted = new OrderedProperties();
            sorted.putAll((Map<?, ?>)this._options);
            for (Map.Entry<Object, Object> e : ((Properties)sorted).entrySet()) {
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                buf.append("\n\t\t[").append(key).append("] = [").append(val).append("]");
            }
        }
        return buf.toString();
    }
}

