/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import net.i2p.I2PAppContext;
import net.i2p.crypto.HMACGenerator;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;

public final class HMAC256Generator
extends HMACGenerator {
    public HMAC256Generator(I2PAppContext context) {
    }

    @Override
    public void calculate(SessionKey key, byte[] data, int offset, int length, byte[] target, int targetOffset) {
        this.calculate(key.getData(), data, offset, length, target, targetOffset);
    }

    public void calculate(byte[] key, byte[] data, int offset, int length, byte[] target, int targetOffset) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            HMACKey keyObj = new HMACKey(key);
            mac.init(keyObj);
            mac.update(data, offset, length);
            mac.doFinal(target, targetOffset);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("HmacSHA256", e);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("HmacSHA256", e);
        }
    }

    @Override
    public boolean verify(SessionKey key, byte[] curData, int curOffset, int curLength, byte[] origMAC, int origMACOffset, int origMACLength) {
        byte[] calc = this.acquireTmp();
        this.calculate(key, curData, curOffset, curLength, calc, 0);
        boolean eq = DataHelper.eq(calc, 0, origMAC, origMACOffset, origMACLength);
        this.releaseTmp(calc);
        return eq;
    }

    static final class HMACKey
    implements SecretKey {
        private final byte[] _data;

        public HMACKey(byte[] data) {
            this._data = data;
        }

        @Override
        public String getAlgorithm() {
            return "HmacSHA256";
        }

        @Override
        public byte[] getEncoded() {
            return Arrays.copyOf(this._data, 32);
        }

        @Override
        public String getFormat() {
            return "RAW";
        }
    }
}

