/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SigAlgo;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.HexDump;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

public final class CertUtil {
    private static final String CERT_DIR = "certificates";
    private static final String REVOCATION_DIR = "revocations";
    private static final int LINE_LENGTH = 64;
    private static final long CHECK = 10368000000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveCert(Certificate cert, File file) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            CertUtil.exportCert(cert, os);
            boolean bl = true;
            return bl;
        }
        catch (CertificateEncodingException cee) {
            CertUtil.error("Error writing X509 Certificate " + file.getAbsolutePath(), cee);
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            CertUtil.error("Error writing X509 Certificate " + file.getAbsolutePath(), ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void exportPrivateKey(PrivateKey pk, Certificate[] certs, OutputStream out) throws IOException, GeneralSecurityException {
        CertUtil.exportPrivateKey(pk, out);
        if (certs == null) {
            return;
        }
        for (int i = 0; i < certs.length; ++i) {
            CertUtil.exportCert(certs[i], out);
        }
    }

    public static void exportCert(Certificate cert, OutputStream out) throws IOException, CertificateEncodingException {
        byte[] buf = cert.getEncoded();
        CertUtil.writePEM(buf, "CERTIFICATE", out);
    }

    private static void exportPrivateKey(PrivateKey pk, OutputStream out) throws IOException, InvalidKeyException {
        byte[] buf = pk.getEncoded();
        if (buf == null) {
            throw new InvalidKeyException("encoding unsupported for this key");
        }
        CertUtil.writePEM(buf, "PRIVATE KEY", out);
    }

    private static void writePEM(byte[] buf, String what, OutputStream out) throws IOException {
        PrintWriter wr = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
        wr.println("-----BEGIN " + what + "-----");
        String b64 = Base64.encode(buf, true);
        for (int i = 0; i < b64.length(); i += 64) {
            wr.println(b64.substring(i, Math.min(i + 64, b64.length())));
        }
        wr.println("-----END " + what + "-----");
        wr.flush();
        if (wr.checkError()) {
            throw new IOException("Failed write to " + out);
        }
    }

    public static Set<String> getSubjectAlternativeNames(X509Certificate cert) {
        HashSet<String> rv = new HashSet<String>(8);
        try {
            Collection<List<?>> c = cert.getSubjectAlternativeNames();
            if (c != null) {
                for (List<?> list : c) {
                    try {
                        rv.add((String)list.get(1));
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return rv;
    }

    public static String getSubjectValue(X509Certificate cert, String type) {
        X500Principal p = cert.getSubjectX500Principal();
        return CertUtil.getValue(p, type);
    }

    public static String getIssuerValue(X509Certificate cert, String type) {
        X500Principal p = cert.getIssuerX500Principal();
        return CertUtil.getValue(p, type);
    }

    private static String getValue(X500Principal p, String type) {
        if (SystemVersion.isAndroid()) {
            CertUtil.error("Don't call this in Android", new UnsupportedOperationException("I did it"));
            return null;
        }
        if (p == null) {
            return null;
        }
        type = type.toUpperCase(Locale.US);
        String subj = p.getName();
        try {
            Class<?> ldapName = Class.forName("javax.naming.ldap.LdapName");
            Constructor<?> ldapCtor = ldapName.getConstructor(String.class);
            Object name = ldapCtor.newInstance(subj);
            Method getRdns = ldapName.getDeclaredMethod("getRdns", new Class[0]);
            Class<?> rdnClass = Class.forName("javax.naming.ldap.Rdn");
            Method getType = rdnClass.getDeclaredMethod("getType", new Class[0]);
            Method getValue = rdnClass.getDeclaredMethod("getValue", new Class[0]);
            for (Object rdn : (List)getRdns.invoke(name, new Object[0])) {
                if (!type.equals(((String)getType.invoke(rdn, new Object[0])).toUpperCase(Locale.US))) continue;
                return (String)getValue.invoke(rdn, new Object[0]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static void error(String msg, Throwable t) {
        CertUtil.log(I2PAppContext.getGlobalContext(), 40, msg, t);
    }

    private static void log(I2PAppContext ctx, int level, String msg, Throwable t) {
        Log l = ctx.logManager().getLog(CertUtil.class);
        l.log(level, msg, t);
    }

    public static PublicKey loadKey(File kd) throws IOException, GeneralSecurityException {
        X509Certificate cert = CertUtil.loadCert(kd);
        if (CertUtil.isRevoked(cert)) {
            throw new CRLException("Certificate is revoked");
        }
        return cert.getPublicKey();
    }

    public static X509Certificate loadCert(File kd) throws IOException, GeneralSecurityException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(kd);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(fis);
            cert.checkValidity();
            X509Certificate x509Certificate = cert;
            return x509Certificate;
        }
        catch (IllegalArgumentException iae) {
            throw new GeneralSecurityException("cert error", iae);
        }
        finally {
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static PrivateKey loadPrivateKey(InputStream in) throws IOException, GeneralSecurityException {
        try {
            String line;
            while (!((line = DataHelper.readLine(in)) == null || line.startsWith("---") && line.contains("BEGIN") && line.contains("PRIVATE"))) {
            }
            if (line == null) {
                throw new IOException("no private key found");
            }
            StringBuilder buf = new StringBuilder(128);
            while ((line = DataHelper.readLine(in)) != null && !line.startsWith("---")) {
                buf.append(line.trim());
            }
            if (buf.length() <= 0) {
                throw new IOException("no private key found");
            }
            byte[] data = Base64.decode(buf.toString(), true);
            if (data == null) {
                throw new CertificateEncodingException("bad base64 cert");
            }
            PrivateKey rv = null;
            for (SigAlgo algo : EnumSet.allOf(SigAlgo.class)) {
                try {
                    PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(data);
                    String alg = algo.getName();
                    KeyFactory kf = KeyFactory.getInstance(alg);
                    rv = kf.generatePrivate(ks);
                    break;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
            }
            if (rv == null) {
                throw new InvalidKeyException("unsupported key type");
            }
            return rv;
        }
        catch (IllegalArgumentException iae) {
            throw new GeneralSecurityException("key error", iae);
        }
    }

    public static List<X509Certificate> loadCerts(InputStream in) throws IOException, GeneralSecurityException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = cf.generateCertificates(in);
            ArrayList<X509Certificate> rv = new ArrayList<X509Certificate>(certs.size());
            for (Certificate certificate : certs) {
                if (!(certificate instanceof X509Certificate)) {
                    throw new GeneralSecurityException("not a X.509 cert");
                }
                X509Certificate xcert = (X509Certificate)certificate;
                xcert.checkValidity();
                rv.add(xcert);
            }
            if (rv.isEmpty()) {
                throw new IOException("no certs found");
            }
            ArrayList<X509Certificate> arrayList = rv;
            return arrayList;
        }
        catch (IllegalArgumentException iae) {
            throw new GeneralSecurityException("cert error", iae);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveCRL(X509CRL crl, File file) {
        SecureFileOutputStream os = null;
        try {
            os = new SecureFileOutputStream(file);
            CertUtil.exportCRL(crl, os);
            boolean bl = true;
            return bl;
        }
        catch (CRLException ce) {
            CertUtil.error("Error writing X509 CRL " + file.getAbsolutePath(), ce);
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            CertUtil.error("Error writing X509 CRL " + file.getAbsolutePath(), ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void exportCRL(X509CRL crl, OutputStream out) throws IOException, CRLException {
        byte[] buf = crl.getEncoded();
        CertUtil.writePEM(buf, "X509 CRL", out);
    }

    public static boolean isRevoked(Certificate cert) {
        return CertUtil.isRevoked(I2PAppContext.getGlobalContext(), cert);
    }

    public static boolean isRevoked(I2PAppContext ctx, Certificate cert) {
        CertStore store = CertUtil.loadCRLs(ctx);
        return CertUtil.isRevoked(store, cert);
    }

    public static boolean isRevoked(CertStore store, Certificate cert) {
        try {
            for (CRL cRL : store.getCRLs(null)) {
                if (!cRL.isRevoked(cert)) continue;
                return true;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return false;
    }

    public static CertStore loadCRLs() {
        return CertUtil.loadCRLs(I2PAppContext.getGlobalContext());
    }

    public static CertStore loadCRLs(I2PAppContext ctx) {
        HashSet<X509CRL> crls = new HashSet<X509CRL>(8);
        File dir = new File(ctx.getBaseDir(), CERT_DIR);
        dir = new File(dir, REVOCATION_DIR);
        CertUtil.loadCRLs(crls, dir);
        boolean diff = true;
        try {
            diff = !ctx.getBaseDir().getCanonicalPath().equals(ctx.getConfigDir().getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (diff) {
            File dir2 = new File(ctx.getConfigDir(), CERT_DIR);
            dir2 = new File(dir2, REVOCATION_DIR);
            CertUtil.loadCRLs(crls, dir2);
        }
        CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(crls);
        try {
            CertStore store = CertStore.getInstance("Collection", ccsp);
            return store;
        }
        catch (GeneralSecurityException gse) {
            CertUtil.error("CertStore", gse);
            throw new UnsupportedOperationException(gse);
        }
    }

    private static void loadCRLs(Set<X509CRL> crls, File dir) {
        File[] files;
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles(new FileSuffixFilter(".crl"))) != null) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                try {
                    X509CRL crl = CertUtil.loadCRL(f);
                    crls.add(crl);
                    continue;
                }
                catch (IOException ioe) {
                    CertUtil.error("Cannot load CRL from " + f, ioe);
                    continue;
                }
                catch (GeneralSecurityException crle) {
                    CertUtil.error("Cannot load CRL from " + f, crle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509CRL loadCRL(File file) throws IOException, GeneralSecurityException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            X509CRL x509CRL = CertUtil.loadCRL(in);
            return x509CRL;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static X509CRL loadCRL(InputStream in) throws GeneralSecurityException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509CRL)cf.generateCRL(in);
    }

    public static final void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: [loadcert | loadcrl | loadcrldir | loadcrldirs | isrevoked | loadprivatekey | checkall] file");
            System.exit(1);
        }
        try {
            File f = new File(args[1]);
            if (args[0].equals("loadcert")) {
                X509Certificate cert = CertUtil.loadCert(f);
                System.out.println(HexDump.dump(cert.getEncoded()));
            } else if (args[0].equals("loadcrl")) {
                CertUtil.loadCRL(f);
            } else if (args[0].equals("loadcrldir")) {
                HashSet<X509CRL> crls = new HashSet<X509CRL>(8);
                CertUtil.loadCRLs(crls, f);
                System.out.println("Found " + crls.size() + " CRLs");
            } else if (args[0].equals("loadcrldirs")) {
                CertStore store = CertUtil.loadCRLs(I2PAppContext.getGlobalContext());
                Collection<? extends CRL> crls = store.getCRLs(null);
                System.out.println("Found " + crls.size() + " CRLs");
            } else if (args[0].equals("isrevoked")) {
                X509Certificate cert = CertUtil.loadCert(f);
                boolean rv = CertUtil.isRevoked(I2PAppContext.getGlobalContext(), (Certificate)cert);
                System.out.println("Revoked? " + rv);
            } else if (args[0].equals("checkall")) {
                int n = CertUtil.checkAll(f);
            } else {
                System.out.println("Usage: [loadcert | loadcrl | loadcrldir | loadcrldirs | isrevoked | loadprivatekey | checkall] file");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static int checkAll(File dir) {
        CertStore store;
        int good = 0;
        int soon = 0;
        int bad = 0;
        HashSet<X509CRL> crls = new HashSet<X509CRL>(8);
        File rdir = new File(dir, REVOCATION_DIR);
        CertUtil.loadCRLs(crls, rdir);
        CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(crls);
        try {
            store = CertStore.getInstance("Collection", ccsp);
        }
        catch (GeneralSecurityException gse) {
            CertUtil.error("CertStore", gse);
            throw new UnsupportedOperationException(gse);
        }
        long now = System.currentTimeMillis();
        File[] dirs = dir.listFiles();
        if (dirs != null) {
            for (int i = 0; i < dirs.length; ++i) {
                File[] files;
                File d = dirs[i];
                if (!d.isDirectory() || d.getName().equals(REVOCATION_DIR) || (files = d.listFiles(new FileSuffixFilter(".crt"))) == null) continue;
                for (int j = 0; j < files.length; ++j) {
                    File f = files[j];
                    try {
                        X509Certificate cert = CertUtil.loadCert(f);
                        if (CertUtil.isRevoked(store, (Certificate)cert)) {
                            System.out.println("ERROR: Revoked cert " + f);
                            ++bad;
                            continue;
                        }
                        long exp = cert.getNotAfter().getTime() - now;
                        if (exp < 10368000000L) {
                            System.out.println("**** WARNING: Cert " + f + " expires in " + DataHelper.formatDuration(exp));
                            ++soon;
                            continue;
                        }
                        ++good;
                        continue;
                    }
                    catch (IOException ioe) {
                        System.out.println("**** ERROR: Cannot load cert from " + f + ": " + ioe);
                        ++bad;
                        continue;
                    }
                    catch (CertificateExpiredException cee) {
                        System.out.println("**** WARNING: Cert expired " + f + ": " + cee);
                        ++bad;
                        continue;
                    }
                    catch (GeneralSecurityException gse) {
                        System.out.println("**** ERROR: Cannot load cert from " + f + ": " + gse);
                        ++bad;
                    }
                }
            }
        }
        System.out.println("Found " + good + " valid certs, " + bad + " bad certs, " + soon + " about to expire certs");
        return bad > 0 ? 1 : 0;
    }
}

