/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.addressbook;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.i2p.data.DataHelper;
import net.i2p.util.SecureFile;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

class ConfigParser {
    private static final boolean isWindows = SystemVersion.isWindows();

    ConfigParser() {
    }

    public static String stripComments(String inputLine) {
        if (inputLine.startsWith(";")) {
            return "";
        }
        int hash = inputLine.indexOf(35);
        if (hash >= 0) {
            return inputLine.substring(0, hash);
        }
        return inputLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> parse(BufferedReader input) throws IOException {
        try {
            String inputLine;
            HashMap<String, String> result = new HashMap<String, String>();
            while ((inputLine = input.readLine()) != null) {
                String[] splitLine;
                if ((inputLine = ConfigParser.stripComments(inputLine)).length() == 0 || (splitLine = DataHelper.split((String)inputLine, (String)"=", (int)2)).length != 2) continue;
                result.put(splitLine[0].trim().toLowerCase(Locale.US), splitLine[1].trim());
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> parse(File file) throws IOException {
        FileInputStream fileStream = null;
        try {
            Map<String, String> rv;
            fileStream = new FileInputStream(file);
            BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)fileStream, "UTF-8"));
            Map<String, String> map = rv = ConfigParser.parse(input);
            return map;
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Map<String, String> parse(File file, Map<String, String> map) {
        Map<String, String> result;
        try {
            result = ConfigParser.parse(file);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (result.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        catch (IOException exp) {
            result = map;
            try {
                ConfigParser.write(result, file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> parseSubscriptions(BufferedReader input) throws IOException {
        try {
            String inputLine;
            ArrayList<String> result = new ArrayList<String>(4);
            while ((inputLine = input.readLine()) != null) {
                if ((inputLine = ConfigParser.stripComments(inputLine).trim()).length() <= 0) continue;
                result.add(inputLine);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> parseSubscriptions(File file) throws IOException {
        FileInputStream fileStream = null;
        try {
            List<String> rv;
            fileStream = new FileInputStream(file);
            BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)fileStream, "UTF-8"));
            List<String> list = rv = ConfigParser.parseSubscriptions(input);
            return list;
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static List<String> parseSubscriptions(File file, List<String> list) {
        List<String> result;
        try {
            result = ConfigParser.parseSubscriptions(file);
            if (result.remove("http://www.i2p2.i2p/hosts.txt")) {
                for (String sub : list) {
                    if (result.contains(sub)) continue;
                    result.add(sub);
                }
                try {
                    ConfigParser.writeSubscriptions(result, file);
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException exp) {
            result = list;
            try {
                ConfigParser.writeSubscriptions(result, file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(Map<String, String> map, BufferedWriter output) throws IOException {
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                output.write(entry.getKey() + '=' + entry.getValue());
                output.newLine();
            }
        }
        finally {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void write(Map<String, String> map, File file) throws IOException {
        boolean success = false;
        if (!isWindows) {
            File tmp = SecureFile.createTempFile((String)"temp-", (String)".tmp", (File)file.getAbsoluteFile().getParentFile());
            ConfigParser.write(map, new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(tmp), "UTF-8")));
            success = tmp.renameTo(file);
            if (!success) {
                tmp.delete();
            }
        }
        if (!success) {
            ConfigParser.write(map, new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(file), "UTF-8")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSubscriptions(List<String> list, BufferedWriter output) throws IOException {
        try {
            for (String s : list) {
                output.write(s);
                output.newLine();
            }
        }
        finally {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void writeSubscriptions(List<String> list, File file) throws IOException {
        ConfigParser.writeSubscriptions(list, new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(file), "UTF-8")));
    }
}

