/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.kademlia.KBucketSet;
import net.i2p.kademlia.SelectionCollector;
import net.i2p.kademlia.XORComparator;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.util.MaskedIPSet;
import net.i2p.router.util.RandomIterator;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;

class FloodfillPeerSelector
extends PeerSelector {
    private static final int NO_FAIL_STORE_OK = 600000;
    private static final int NO_FAIL_STORE_GOOD = 1200000;
    private static final int NO_FAIL_LOOKUP_OK = 75000;
    private static final int NO_FAIL_LOOKUP_GOOD = 225000;
    private static final int MAX_GOOD_RESP_TIME = 5000;
    private static final long HEARD_AGE = 3600000L;
    private static final long INSTALL_AGE = 0x6DDD00L;

    public FloodfillPeerSelector(RouterContext ctx) {
        super(ctx);
    }

    @Override
    List<Hash> selectMostReliablePeers(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets) {
        return this.selectNearestExplicitThin(key, maxNumRouters, peersToIgnore, kbuckets, true);
    }

    @Override
    List<Hash> selectNearestExplicitThin(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets) {
        return this.selectNearestExplicitThin(key, maxNumRouters, peersToIgnore, kbuckets, false);
    }

    List<Hash> selectNearestExplicitThin(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets, boolean preferConnected) {
        if (peersToIgnore == null) {
            peersToIgnore = Collections.singleton(this._context.routerHash());
        } else {
            peersToIgnore.add(this._context.routerHash());
        }
        FloodfillSelectionCollector matches = new FloodfillSelectionCollector(key, peersToIgnore, maxNumRouters);
        if (kbuckets == null) {
            return new ArrayList<Hash>();
        }
        kbuckets.getAll(matches);
        List<Hash> rv = matches.get(maxNumRouters, preferConnected);
        if (this._log.shouldLog(10)) {
            this._log.debug("Searching for " + maxNumRouters + " peers close to " + key + ": " + rv + " (not including " + peersToIgnore + ") [allHashes.size = " + matches.size() + "]", new Exception("Search by"));
        }
        return rv;
    }

    List<Hash> selectFloodfillParticipants(KBucketSet<Hash> kbuckets) {
        Set<Hash> ignore = Collections.singleton(this._context.routerHash());
        return this.selectFloodfillParticipants(ignore, kbuckets);
    }

    private List<Hash> selectFloodfillParticipants(Set<Hash> toIgnore, KBucketSet<Hash> kbuckets) {
        Set<Hash> set = this._context.peerManager().getPeersByCapability('f');
        ArrayList<Hash> rv = new ArrayList<Hash>(set.size());
        for (Hash h : set) {
            if (toIgnore != null && toIgnore.contains(h) || this._context.banlist().isBanlistedForever(h)) continue;
            rv.add(h);
        }
        return rv;
    }

    List<Hash> selectFloodfillParticipants(Hash key, int maxNumRouters, KBucketSet<Hash> kbuckets) {
        Set<Hash> ignore = Collections.singleton(this._context.routerHash());
        return this.selectFloodfillParticipants(key, maxNumRouters, ignore, kbuckets);
    }

    List<Hash> selectFloodfillParticipants(Hash key, int howMany, Set<Hash> toIgnore, KBucketSet<Hash> kbuckets) {
        if (toIgnore == null) {
            toIgnore = Collections.singleton(this._context.routerHash());
        } else if (!toIgnore.contains(this._context.routerHash())) {
            toIgnore = new HashSet<Hash>(toIgnore);
            toIgnore.add(this._context.routerHash());
        }
        return this.selectFloodfillParticipantsIncludingUs(key, howMany, toIgnore, kbuckets);
    }

    private List<Hash> selectFloodfillParticipantsIncludingUs(Hash key, int howMany, Set<Hash> toIgnore, KBucketSet<Hash> kbuckets) {
        Hash entry;
        int i;
        Rate r;
        RateStat rs;
        List<Hash> ffs = this.selectFloodfillParticipants(toIgnore, kbuckets);
        TreeSet<Hash> sorted = new TreeSet<Hash>(new XORComparator<Hash>(key));
        sorted.addAll(ffs);
        ArrayList<Hash> rv = new ArrayList<Hash>(howMany);
        ArrayList<Hash> okff = new ArrayList<Hash>(ffs.size());
        ArrayList<Hash> badff = new ArrayList<Hash>(ffs.size());
        int found = 0;
        long now = this._context.clock().now();
        long installed = this._context.getProperty("router.firstInstalled", 0L);
        boolean enforceHeard = installed > 0L && now - installed > 0x6DDD00L;
        double maxFailRate = 100.0;
        if (this._context.router().getUptime() > 3600000L && (rs = this._context.statManager().getRate("peer.failedLookupRate")) != null && (r = rs.getRate(3600000L)) != null) {
            double currentFailRate = r.getAverageValue();
            maxFailRate = Math.max(0.2, 1.5 * currentFailRate);
        }
        int limit = Math.max(5, howMany);
        limit = Math.min(limit, ffs.size());
        MaskedIPSet maskedIPs = new MaskedIPSet(limit * 3);
        for (i = 0; found < howMany && i < limit && (entry = sorted.first()) != null; ++i) {
            Rate tunnelTestTime;
            sorted.remove(entry);
            RouterInfo info = this._context.netDb().lookupRouterInfoLocally(entry);
            MaskedIPSet entryIPs = new MaskedIPSet(this._context, entry, info, 2);
            boolean sameIP = false;
            for (String ip : entryIPs) {
                if (maskedIPs.add(ip)) continue;
                sameIP = true;
            }
            if (sameIP) {
                badff.add(entry);
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Same /16, family, or port: " + entry);
                continue;
            }
            if (info != null && now - info.getPublished() > 10800000L) {
                badff.add(entry);
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Old: " + entry);
                continue;
            }
            if (info != null && this._context.commSystem().isInStrictCountry(info)) {
                badff.add(entry);
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Bad country: " + entry);
                continue;
            }
            if (info != null && info.getBandwidthTier().equals("L")) {
                badff.add(entry);
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Slow: " + entry);
                continue;
            }
            PeerProfile prof = this._context.profileOrganizer().getProfile(entry);
            double maxGoodRespTime = 5000.0;
            RateStat ttst = this._context.statManager().getRate("tunnel.testSuccessTime");
            if (ttst != null && (tunnelTestTime = ttst.getRate(600000L)) != null && tunnelTestTime.getAverageValue() > 500.0) {
                maxGoodRespTime = 2.0 * tunnelTestTime.getAverageValue();
            }
            if (prof != null) {
                if (enforceHeard && prof.getFirstHeardAbout() > now - 3600000L) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Bad (new): " + entry);
                    }
                    badff.add(entry);
                    continue;
                }
                if (prof.getDBHistory() != null) {
                    if (prof.getDbResponseTime().getRate(600000L).getAverageValue() < maxGoodRespTime && prof.getDBHistory().getLastStoreFailed() < now - 1200000L && prof.getDBHistory().getLastLookupFailed() < now - 225000L && prof.getDBHistory().getFailedLookupRate().getRate(3600000L).getAverageValue() < maxFailRate) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Good: " + entry);
                        }
                        rv.add(entry);
                        ++found;
                        continue;
                    }
                    if (prof.getDBHistory().getLastStoreFailed() <= prof.getDBHistory().getLastStoreSuccessful() || prof.getDBHistory().getLastLookupFailed() <= prof.getDBHistory().getLastLookupSuccessful() || prof.getDBHistory().getLastStoreFailed() < now - 600000L && prof.getDBHistory().getLastLookupFailed() < now - 75000L) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("OK: " + entry);
                        }
                        okff.add(entry);
                        continue;
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Bad (DB): " + entry);
                    }
                    badff.add(entry);
                    continue;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Bad (no hist): " + entry);
                }
                badff.add(entry);
                continue;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Bad (no prof): " + entry);
            }
            badff.add(entry);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Good: " + rv + " OK: " + okff + " Bad: " + badff);
        }
        for (i = 0; found < howMany && i < okff.size(); ++found, ++i) {
            rv.add((Hash)okff.get(i));
        }
        for (i = 0; found < howMany && i < badff.size(); ++found, ++i) {
            rv.add((Hash)badff.get(i));
        }
        return rv;
    }

    @Override
    List<Hash> selectNearest(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets) {
        Hash rkey = this._context.routingKeyGenerator().getRoutingKey(key);
        if (peersToIgnore != null && peersToIgnore.contains(Hash.FAKE_HASH)) {
            peersToIgnore.addAll(this.selectFloodfillParticipants(peersToIgnore, kbuckets));
            FloodfillSelectionCollector matches = new FloodfillSelectionCollector(rkey, peersToIgnore, maxNumRouters);
            kbuckets.getAll(matches);
            return matches.get(maxNumRouters);
        }
        return this.selectFloodfillParticipantsIncludingUs(rkey, maxNumRouters, peersToIgnore, kbuckets);
    }

    private class FloodfillSelectionCollector
    implements SelectionCollector<Hash> {
        private final TreeSet<Hash> _sorted;
        private final List<Hash> _floodfillMatches;
        private final Hash _key;
        private final Set<Hash> _toIgnore;
        private int _matches;
        private final int _wanted;
        private static final int EXTRA_MATCHES = 100;

        public FloodfillSelectionCollector(Hash key, Set<Hash> toIgnore, int wanted) {
            this._key = key;
            this._sorted = new TreeSet<Hash>(new XORComparator<Hash>(key));
            this._floodfillMatches = new ArrayList<Hash>(8);
            this._toIgnore = toIgnore;
            this._wanted = wanted;
        }

        @Override
        public void add(Hash entry) {
            if (this._toIgnore != null && this._toIgnore.contains(entry)) {
                return;
            }
            if (FloodfillPeerSelector.this._context.banlist().isBanlistedForever(entry)) {
                return;
            }
            RouterInfo info = FloodfillPeerSelector.this._context.netDb().lookupRouterInfoLocally(entry);
            if (info != null && FloodfillNetworkDatabaseFacade.isFloodfill(info)) {
                this._floodfillMatches.add(entry);
            } else if (!SearchJob.onlyQueryFloodfillPeers(FloodfillPeerSelector.this._context) && this._wanted + 100 > this._matches && this._key != null) {
                this._sorted.add(entry);
            } else {
                return;
            }
            ++this._matches;
        }

        public List<Hash> get(int howMany) {
            return this.get(howMany, false);
        }

        public List<Hash> get(int howMany, boolean preferConnected) {
            int i;
            Hash entry;
            ArrayList<Hash> rv = new ArrayList<Hash>(howMany);
            ArrayList<Hash> badff = new ArrayList<Hash>(howMany);
            ArrayList<Hash> unconnectedff = new ArrayList<Hash>(howMany);
            int found = 0;
            long now = FloodfillPeerSelector.this._context.clock().now();
            RandomIterator<Hash> iter = new RandomIterator<Hash>(this._floodfillMatches);
            while (found < howMany && iter.hasNext()) {
                entry = (Hash)iter.next();
                RouterInfo info = FloodfillPeerSelector.this._context.netDb().lookupRouterInfoLocally(entry);
                if (info != null && now - info.getPublished() > 10800000L) {
                    badff.add(entry);
                    if (!FloodfillPeerSelector.this._log.shouldLog(10)) continue;
                    FloodfillPeerSelector.this._log.debug("Skipping, published a while ago: " + entry);
                    continue;
                }
                PeerProfile prof = FloodfillPeerSelector.this._context.profileOrganizer().getProfile(entry);
                if (prof != null && now - prof.getLastSendFailed() < 1800000L) {
                    badff.add(entry);
                    if (!FloodfillPeerSelector.this._log.shouldLog(10)) continue;
                    FloodfillPeerSelector.this._log.debug("Skipping, recent failed send: " + entry);
                    continue;
                }
                if (preferConnected && !FloodfillPeerSelector.this._context.commSystem().isEstablished(entry)) {
                    unconnectedff.add(entry);
                    if (!FloodfillPeerSelector.this._log.shouldLog(10)) continue;
                    FloodfillPeerSelector.this._log.debug("Skipping, unconnected: " + entry);
                    continue;
                }
                rv.add(entry);
                ++found;
            }
            for (i = 0; found < howMany && i < unconnectedff.size(); ++found, ++i) {
                rv.add((Hash)unconnectedff.get(i));
            }
            for (i = 0; found < howMany && i < badff.size(); ++found, ++i) {
                rv.add((Hash)badff.get(i));
            }
            for (i = rv.size(); i < howMany && !this._sorted.isEmpty(); ++i) {
                entry = this._sorted.first();
                rv.add(entry);
                this._sorted.remove(entry);
            }
            return rv;
        }

        public int size() {
            return this._matches;
        }
    }
}

