/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;

public abstract class FastI2NPMessageImpl
extends I2NPMessageImpl {
    protected byte _checksum;
    protected boolean _hasChecksum;
    private static final boolean VERIFY_TEST = false;

    public FastI2NPMessageImpl(I2PAppContext context) {
        super(context);
    }

    @Override
    public int readBytes(byte[] data, int type, int offset, int maxLen) throws I2NPMessageException {
        if (this._hasChecksum) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " read twice");
        }
        int headerSize = 16;
        if (type >= 0) {
            --headerSize;
        }
        if (maxLen < headerSize) {
            throw new I2NPMessageException("Payload is too short " + maxLen);
        }
        int cur = offset;
        if (type < 0) {
            type = data[cur] & 0xFF;
            ++cur;
        }
        this._uniqueId = DataHelper.fromLong(data, cur, 4);
        this._expiration = DataHelper.fromLong(data, cur += 4, 8);
        int size = (int)DataHelper.fromLong(data, cur += 8, 2);
        this._checksum = data[cur += 2];
        if (++cur + size > data.length || headerSize + size > maxLen) {
            throw new I2NPMessageException("Payload is too short [data.len=" + data.length + "maxLen=" + maxLen + " offset=" + offset + " cur=" + cur + " wanted=" + size + "]: " + this.getClass().getSimpleName());
        }
        int sz = Math.min(size, maxLen - headerSize);
        this.readMessage(data, cur, sz, type);
        this._hasChecksum = true;
        return (cur += sz) - offset;
    }

    @Override
    public int toByteArray(byte[] buffer) {
        if (this._hasChecksum) {
            return this.toByteArrayWithSavedChecksum(buffer);
        }
        return super.toByteArray(buffer);
    }

    protected int toByteArrayWithSavedChecksum(byte[] buffer) {
        try {
            int writtenLen = this.writeMessageBody(buffer, 16);
            int payloadLen = writtenLen - 16;
            int off = 0;
            buffer[off++] = (byte)this.getType();
            DataHelper.toLong(buffer, off, 4, this._uniqueId);
            DataHelper.toLong(buffer, off += 4, 8, this._expiration);
            DataHelper.toLong(buffer, off += 8, 2, payloadLen);
            buffer[off += 2] = this._checksum;
            return writtenLen;
        }
        catch (I2NPMessageException ime) {
            this._context.logManager().getLog(this.getClass()).log(50, "Error writing", ime);
            throw new IllegalStateException("Unable to serialize the message " + this.getClass().getSimpleName(), ime);
        }
    }
}

