/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessageException;

public class DataMessage
extends FastI2NPMessageImpl {
    public static final int MESSAGE_TYPE = 20;
    private byte[] _data;

    public DataMessage(I2PAppContext context) {
        super(context);
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        if (this._data != null) {
            throw new IllegalStateException();
        }
        this._data = data;
    }

    public int getSize() {
        return this._data.length;
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException {
        if (type != 20) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        long size = DataHelper.fromLong(data, curIndex, 4);
        curIndex += 4;
        if (size > 65536L) {
            throw new I2NPMessageException("too large msg, size=" + size);
        }
        this._data = new byte[(int)size];
        System.arraycopy(data, curIndex, this._data, 0, (int)size);
    }

    @Override
    protected int calculateWrittenLength() {
        if (this._data == null) {
            return 4;
        }
        return 4 + this._data.length;
    }

    @Override
    protected int writeMessageBody(byte[] out, int curIndex) {
        if (this._data == null) {
            out[curIndex++] = 0;
            out[curIndex++] = 0;
            out[curIndex++] = 0;
            out[curIndex++] = 0;
        } else {
            DataHelper.toLong(out, curIndex, 4, this._data.length);
            System.arraycopy(this._data, 0, out, curIndex += 4, this._data.length);
            curIndex += this._data.length;
        }
        return curIndex;
    }

    @Override
    public int getType() {
        return 20;
    }

    public int hashCode() {
        return DataHelper.hashCode(this._data);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DataMessage) {
            DataMessage msg = (DataMessage)object;
            return DataHelper.eq(this._data, msg._data);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[DataMessage: ");
        buf.append("\n\tData: ");
        if (this._data != null) {
            buf.append(this._data.length).append(" bytes");
            if (this._data.length <= 64) {
                buf.append(" : ").append(Base64.encode(this._data));
            }
        } else {
            buf.append("null");
        }
        buf.append("]");
        return buf.toString();
    }
}

