/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.EncryptedBuildRecord;

public class BuildRequestRecord {
    private final byte[] _data;
    private static final int FLAG_UNRESTRICTED_PREV = 128;
    private static final int FLAG_OUTBOUND_ENDPOINT = 64;
    public static final int IV_SIZE = 16;
    public static final int PEER_SIZE = 16;
    private static final int OFF_RECV_TUNNEL = 0;
    private static final int OFF_OUR_IDENT = 4;
    private static final int OFF_SEND_TUNNEL = 36;
    private static final int OFF_SEND_IDENT = 40;
    private static final int OFF_LAYER_KEY = 72;
    private static final int OFF_IV_KEY = 104;
    public static final int OFF_REPLY_KEY = 136;
    private static final int OFF_REPLY_IV = 168;
    private static final int OFF_FLAG = 184;
    private static final int OFF_REQ_TIME = 185;
    private static final int OFF_SEND_MSG_ID = 189;
    private static final int PADDING_SIZE = 29;
    private static final int LENGTH = 222;

    public byte[] getData() {
        return this._data;
    }

    public long readReceiveTunnelId() {
        return DataHelper.fromLong(this._data, 0, 4);
    }

    public long readNextTunnelId() {
        return DataHelper.fromLong(this._data, 36, 4);
    }

    public Hash readNextIdentity() {
        return Hash.create(this._data, 40);
    }

    public SessionKey readLayerKey() {
        byte[] key = new byte[32];
        System.arraycopy(this._data, 72, key, 0, 32);
        return new SessionKey(key);
    }

    public SessionKey readIVKey() {
        byte[] key = new byte[32];
        System.arraycopy(this._data, 104, key, 0, 32);
        return new SessionKey(key);
    }

    public SessionKey readReplyKey() {
        byte[] key = new byte[32];
        System.arraycopy(this._data, 136, key, 0, 32);
        return new SessionKey(key);
    }

    public byte[] readReplyIV() {
        byte[] iv = new byte[16];
        System.arraycopy(this._data, 168, iv, 0, 16);
        return iv;
    }

    public boolean readIsInboundGateway() {
        return (this._data[184] & 0x80) != 0;
    }

    public boolean readIsOutboundEndpoint() {
        return (this._data[184] & 0x40) != 0;
    }

    public long readRequestTime() {
        return DataHelper.fromLong(this._data, 185, 4) * 3600000L;
    }

    public long readReplyMessageId() {
        return DataHelper.fromLong(this._data, 189, 4);
    }

    public EncryptedBuildRecord encryptRecord(I2PAppContext ctx, PublicKey toKey, Hash toPeer) {
        byte[] out = new byte[528];
        System.arraycopy(toPeer.getData(), 0, out, 0, 16);
        byte[] encrypted = ctx.elGamalEngine().encrypt(this._data, toKey);
        System.arraycopy(encrypted, 1, out, 16, 256);
        System.arraycopy(encrypted, 258, out, 272, 256);
        return new EncryptedBuildRecord(out);
    }

    public BuildRequestRecord(I2PAppContext ctx, PrivateKey ourKey, EncryptedBuildRecord encryptedRecord) throws DataFormatException {
        byte[] preDecrypt = new byte[514];
        System.arraycopy(encryptedRecord.getData(), 16, preDecrypt, 1, 256);
        System.arraycopy(encryptedRecord.getData(), 272, preDecrypt, 258, 256);
        byte[] decrypted = ctx.elGamalEngine().decrypt(preDecrypt, ourKey);
        if (decrypted == null) {
            throw new DataFormatException("decrypt fail");
        }
        this._data = decrypted;
    }

    public BuildRequestRecord(I2PAppContext ctx, long receiveTunnelId, Hash peer, long nextTunnelId, Hash nextHop, long nextMsgId, SessionKey layerKey, SessionKey ivKey, SessionKey replyKey, byte[] iv, boolean isInGateway, boolean isOutEndpoint) {
        byte[] buf = new byte[222];
        this._data = buf;
        DataHelper.toLong(buf, 0, 4, receiveTunnelId);
        System.arraycopy(peer.getData(), 0, buf, 4, 32);
        DataHelper.toLong(buf, 36, 4, nextTunnelId);
        System.arraycopy(nextHop.getData(), 0, buf, 40, 32);
        System.arraycopy(layerKey.getData(), 0, buf, 72, 32);
        System.arraycopy(ivKey.getData(), 0, buf, 104, 32);
        System.arraycopy(replyKey.getData(), 0, buf, 136, 32);
        System.arraycopy(iv, 0, buf, 168, 16);
        if (isInGateway) {
            buf[184] = (byte)(buf[184] | 0x80);
        } else if (isOutEndpoint) {
            buf[184] = (byte)(buf[184] | 0x40);
        }
        long truncatedHour = ctx.clock().now();
        truncatedHour -= (long)ctx.random().nextInt(90000);
        DataHelper.toLong(buf, 185, 4, truncatedHour /= 3600000L);
        DataHelper.toLong(buf, 189, 4, nextMsgId);
        ctx.random().nextBytes(buf, 193, 29);
        byte[] wroteIV = this.readReplyIV();
        if (!DataHelper.eq(iv, wroteIV)) {
            throw new RuntimeException("foo");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("BRR ");
        boolean isIBGW = this.readIsInboundGateway();
        boolean isOBEP = this.readIsOutboundEndpoint();
        if (isIBGW) {
            buf.append("IBGW in: ").append(this.readReceiveTunnelId()).append(" out ").append(this.readNextTunnelId());
        } else if (isOBEP) {
            buf.append("OBEP in: ").append(this.readReceiveTunnelId());
        } else {
            buf.append("part. in: ").append(this.readReceiveTunnelId()).append(" out: ").append(this.readNextTunnelId());
        }
        buf.append(" to: ").append(this.readNextIdentity()).append(" layer key: ").append(this.readLayerKey()).append(" IV key: ").append(this.readIVKey()).append(" reply key: ").append(this.readReplyKey()).append(" reply IV: ").append(Base64.encode(this.readReplyIV())).append(" hour: ").append(new Date(this.readRequestTime())).append(" reply msg id: ").append(this.readReplyMessageId());
        return buf.toString();
    }
}

