/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.crypto.SigType;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.data.router.RouterKeyGenerator;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.DataStore;
import net.i2p.router.networkdb.kademlia.DirectLookupJob;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.router.networkdb.kademlia.FloodThrottler;
import net.i2p.router.networkdb.kademlia.FloodfillDatabaseLookupMessageHandler;
import net.i2p.router.networkdb.kademlia.FloodfillDatabaseStoreMessageHandler;
import net.i2p.router.networkdb.kademlia.FloodfillMonitorJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseSegmentor;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.FloodfillStoreJob;
import net.i2p.router.networkdb.kademlia.IterativeSearchJob;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.LookupThrottler;
import net.i2p.router.networkdb.kademlia.RefreshRoutersJob;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.router.networkdb.kademlia.StoreJob;
import net.i2p.router.peermanager.DBHistory;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;

public class FloodfillNetworkDatabaseFacade
extends KademliaNetworkDatabaseFacade {
    public static final char CAPABILITY_FLOODFILL = 'f';
    private final Map<Hash, FloodSearchJob> _activeFloodQueries = new HashMap<Hash, FloodSearchJob>();
    private boolean _floodfillEnabled;
    private final Set<Hash> _verifiesInProgress = new ConcurrentHashSet<Hash>(8);
    private FloodThrottler _floodThrottler;
    private LookupThrottler _lookupThrottler;
    private final Job _ffMonitor;
    public static final int MAX_TO_FLOOD = 3;
    private static final int FLOOD_PRIORITY = 200;
    private static final int FLOOD_TIMEOUT = 30000;
    static final long NEXT_RKEY_RI_ADVANCE_TIME = 2700000L;
    private static final long NEXT_RKEY_LS_ADVANCE_TIME = 600000L;
    private static final int NEXT_FLOOD_QTY = 2;
    static final long PUBLISH_TIMEOUT = 90000L;
    protected static final int MIN_ACTIVE_PEERS = 5;
    private static final int MAX_DB_BEFORE_SKIPPING_SEARCH;

    public FloodfillNetworkDatabaseFacade(RouterContext context) {
        this(context, FloodfillNetworkDatabaseSegmentor.MAIN_DBID);
    }

    public FloodfillNetworkDatabaseFacade(RouterContext context, Hash dbid) {
        super(context, dbid);
        long[] rate = new long[]{3600000L};
        this._context.statManager().createRequiredRateStat("netDb.successTime", "Time for successful lookup (ms)", "NetworkDatabase", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("netDb.failedTime", "How long a failed search takes", "NetworkDatabase", rate);
        this._context.statManager().createRateStat("netDb.failedRetries", "How many additional queries for an iterative search", "NetworkDatabase", rate);
        this._context.statManager().createRateStat("netDb.successRetries", "How many additional queries for an iterative search", "NetworkDatabase", rate);
        this._context.statManager().createRateStat("netDb.failedAttemptedPeers", "How many peers we sent a search to when the search fails", "NetworkDatabase", new long[]{600000L});
        this._context.statManager().createRateStat("netDb.successPeers", "How many peers are contacted in a successful search", "NetworkDatabase", rate);
        this._context.statManager().createRateStat("netDb.failedPeers", "How many peers fail to respond to a lookup?", "NetworkDatabase", rate);
        this._context.statManager().createRateStat("netDb.searchCount", "Overall number of searches sent", "NetworkDatabase", rate);
        this._context.statManager().createRateStat("netDb.searchMessageCount", "Overall number of mesages for all searches sent", "NetworkDatabase", rate);
        this._context.statManager().createRateStat("netDb.searchReplyValidated", "How many search replies we get that we are able to validate (fetch)", "NetworkDatabase", rate);
        this._context.statManager().createRateStat("netDb.searchReplyNotValidated", "How many search replies we get that we are NOT able to validate (fetch)", "NetworkDatabase", rate);
        this._context.statManager().createRateStat("netDb.searchReplyValidationSkipped", "How many search replies we get from unreliable peers that we skip?", "NetworkDatabase", rate);
        this._context.statManager().createRateStat("netDb.republishQuantity", "How many peers do we need to send a found leaseSet to?", "NetworkDatabase", rate);
        this._context.statManager().createRateStat("netDb.RILookupDirect", "Was an iterative RI lookup sent directly?", "NetworkDatabase", rate);
        this._ffMonitor = this.isClientDb() ? null : new FloodfillMonitorJob(this._context, this);
    }

    @Override
    public synchronized void startup() {
        boolean isFF;
        super.startup();
        if (this._ffMonitor != null) {
            this._context.jobQueue().addJob(this._ffMonitor);
        }
        if (this.isClientDb()) {
            isFF = false;
        } else {
            isFF = this._context.getBooleanProperty("router.floodfillParticipant");
            this._lookupThrottler = new LookupThrottler(this);
        }
        long down = this._context.router().getEstimatedDowntime();
        if (!this._context.commSystem().isDummy() && !this.isClientDb() && (down == 0L || !isFF && down > 1800000L || isFF && down > 86400000L)) {
            RefreshRoutersJob rrj = new RefreshRoutersJob(this._context, this);
            rrj.getTiming().setStartAfter(this._context.clock().now() + 300000L);
            this._context.jobQueue().addJob(rrj);
        }
    }

    @Override
    protected void createHandlers() {
        if (!this.isClientDb()) {
            this._context.inNetMessagePool().registerHandlerJobBuilder(2, new FloodfillDatabaseLookupMessageHandler(this._context, this));
            this._context.inNetMessagePool().registerHandlerJobBuilder(1, new FloodfillDatabaseStoreMessageHandler(this._context, this));
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this._floodfillEnabled && this._context.router().scheduledGracefulExitCode() != 4 && this._context.router().scheduledGracefulExitCode() != 5) {
            this._floodfillEnabled = false;
            this._context.router().rebuildRouterInfo(true);
            RouterInfo local = this._context.router().getRouterInfo();
            if (local != null && this._context.router().getUptime() > 300000L) {
                this.flood(local);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this._ffMonitor != null) {
            this._context.jobQueue().removeJob(this._ffMonitor);
        }
        super.shutdown();
    }

    @Override
    public void publish(RouterInfo localRouterInfo) throws IllegalArgumentException {
        if (localRouterInfo == null) {
            throw new IllegalArgumentException("impossible: null localRouterInfo?");
        }
        if (this._context.router().isHidden()) {
            return;
        }
        super.publish(localRouterInfo);
        if (!this.isInitialized()) {
            if (this._log.shouldWarn()) {
                this._log.warn("publish() before initialized: " + localRouterInfo, new Exception("I did it"));
            }
            return;
        }
        if (localRouterInfo.getAddresses().isEmpty()) {
            return;
        }
        if (this._context.router().getUptime() > 300000L) {
            this._log.info("Publishing our RI");
            this.sendStore(localRouterInfo.getIdentity().calculateHash(), localRouterInfo, null, null, 90000L, null);
        } else {
            this._log.info("Delay publishing our RI");
            DelayedPublish dp = new DelayedPublish(localRouterInfo);
            dp.schedule(3000L);
        }
    }

    @Override
    void sendStore(Hash key, DatabaseEntry ds, Job onSuccess, Job onFailure, long sendTimeout, Set<Hash> toIgnore) {
        if (this.floodfillEnabled() && ds.getType() == 0) {
            this.flood(ds);
            if (onSuccess != null) {
                this._context.jobQueue().addJob(onSuccess);
            }
        } else {
            this._context.jobQueue().addJob(new FloodfillStoreJob(this._context, this, key, ds, onSuccess, onFailure, sendTimeout, toIgnore));
        }
    }

    boolean shouldThrottleFlood(Hash key) {
        return this._floodThrottler != null && this._floodThrottler.shouldThrottle(key);
    }

    boolean shouldThrottleLookup(Hash from, TunnelId id) {
        return this._lookupThrottler == null || this._lookupThrottler.shouldThrottle(from, id);
    }

    public boolean floodConditional(DatabaseEntry ds) {
        if (!this.floodfillEnabled()) {
            return false;
        }
        Hash h = ds.getHash();
        if (this._context.banlist().isBanlistedForever(h)) {
            return false;
        }
        if (this.shouldThrottleFlood(h)) {
            this._context.statManager().addRateData("netDb.floodThrottled", 1L);
            return false;
        }
        this.flood(ds);
        return true;
    }

    public void flood(DatabaseEntry ds) {
        Hash key = ds.getHash();
        RouterKeyGenerator gen = this._context.routerKeyGenerator();
        Hash rkey = gen.getRoutingKey(key);
        FloodfillPeerSelector sel = (FloodfillPeerSelector)this.getPeerSelector();
        int type = ds.getType();
        boolean isls = ds.isLeaseSet();
        boolean isls2 = isls && type != 1;
        SigType lsSigType = isls && type != 5 ? ds.getKeysAndCert().getSigningPublicKey().getType() : null;
        int max = 3;
        if (type == 5) {
            max *= 4;
        } else if (isls2) {
            max *= 2;
        }
        List<Hash> peers = sel.selectFloodfillParticipants(rkey, max, this.getKBuckets());
        long until = gen.getTimeTillMidnight();
        if (type != 0 && until < 600000L && ((LeaseSet)ds).getLatestLeaseDate() - this._context.clock().now() > until || type == 0 && until < 2700000L) {
            Hash nkey = gen.getNextRoutingKey(key);
            List<Hash> nextPeers = sel.selectFloodfillParticipants(nkey, 2, this.getKBuckets());
            int i = 0;
            for (Hash h : nextPeers) {
                if (h.equals(key)) continue;
                if (!peers.contains(h)) {
                    peers.add(h);
                    ++i;
                }
                if (i < 3) continue;
                break;
            }
            if (i > 0) {
                max += i;
                if (this._log.shouldInfo()) {
                    this._log.info("Flooding the entry for " + key + " to " + i + " more, just before midnight");
                }
            }
        }
        int flooded = 0;
        for (int i = 0; i < peers.size(); ++i) {
            RouterInfo target;
            Hash peer = peers.get(i);
            if (!this.shouldFloodTo(key, type, lsSigType, peer, target = this.lookupRouterInfoLocally(peer))) {
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Too old, not flooding " + key.toBase64() + " to " + peer.toBase64());
                continue;
            }
            DatabaseStoreMessage msg = new DatabaseStoreMessage(this._context);
            msg.setEntry(ds);
            OutNetMessage m = new OutNetMessage(this._context, msg, this._context.clock().now() + 30000L, 200, target);
            FloodFailedJob floodFail = new FloodFailedJob(this._context, peer);
            m.setOnFailedSendJob(floodFail);
            FloodSuccessJob floodGood = new FloodSuccessJob(this._context, peer);
            m.setOnSendJob(floodGood);
            this._context.commSystem().processMessage(m);
            ++flooded;
            if (this._log.shouldLog(20)) {
                this._log.info("Flooding the entry for " + key.toBase64() + " to " + peer.toBase64());
            }
            if (flooded >= 3) break;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Flooded the data to " + flooded + " of " + peers.size() + " peers");
        }
    }

    private boolean shouldFloodTo(Hash key, int type, SigType lsSigType, Hash peer, RouterInfo target) {
        if (target == null || this._context.banlist().isBanlisted(peer)) {
            return false;
        }
        if (type == 0 && peer.equals(key)) {
            return false;
        }
        if (peer.equals(this._context.routerHash())) {
            return false;
        }
        if (!(type != 5 && lsSigType != SigType.RedDSA_SHA512_Ed25519 || StoreJob.shouldStoreEncLS2To(target))) {
            return false;
        }
        return StoreJob.shouldStoreTo(target);
    }

    public synchronized void setFloodfillEnabled(boolean yes) {
        if (yes != this._floodfillEnabled && this._ffMonitor != null) {
            this._context.jobQueue().removeJob(this._ffMonitor);
            this._ffMonitor.getTiming().setStartAfter(this._context.clock().now() + 1000L);
            this._context.jobQueue().addJob(this._ffMonitor);
        }
    }

    synchronized void setFloodfillEnabledFromMonitor(boolean yes) {
        this._floodfillEnabled = yes;
        if (yes && this._floodThrottler == null) {
            this._floodThrottler = new FloodThrottler();
            this._context.statManager().createRateStat("netDb.floodThrottled", "How often do we decline to flood?", "NetworkDatabase", new long[]{3600000L});
            this._context.statManager().createRateStat("netDb.storeFloodNew", "How long it takes to flood out a newly received entry?", "NetworkDatabase", new long[]{3600000L});
            this._context.statManager().createRateStat("netDb.storeFloodOld", "How often we receive an old entry?", "NetworkDatabase", new long[]{3600000L});
        }
    }

    @Override
    public boolean floodfillEnabled() {
        return this._floodfillEnabled;
    }

    public static boolean isFloodfill(RouterInfo peer) {
        if (peer == null) {
            return false;
        }
        String caps = peer.getCapabilities();
        return caps.indexOf(102) >= 0;
    }

    public List<RouterInfo> getKnownRouterData() {
        ArrayList<RouterInfo> rv = new ArrayList<RouterInfo>();
        DataStore ds = this.getDataStore();
        if (ds != null) {
            for (DatabaseEntry o : ds.getEntries()) {
                if (o.getType() != 0) continue;
                rv.add((RouterInfo)o);
            }
        }
        return rv;
    }

    @Override
    SearchJob search(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, boolean isLease) {
        return this.search(key, onFindJob, onFailedLookupJob, timeoutMs, isLease, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    SearchJob search(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, boolean isLease, Hash fromLocalDest) {
        FloodSearchJob searchJob;
        if (key == null) {
            throw new IllegalArgumentException("searchin for nothin, eh?");
        }
        if (fromLocalDest == null && this.isClientDb()) {
            throw new IllegalArgumentException("client subDbs cannot use exploratory tunnels");
        }
        boolean isNew = false;
        Map<Hash, FloodSearchJob> map = this._activeFloodQueries;
        synchronized (map) {
            searchJob = this._activeFloodQueries.get(key);
            if (searchJob == null) {
                searchJob = new IterativeSearchJob(this._context, this, key, onFindJob, onFailedLookupJob, (int)timeoutMs, isLease, fromLocalDest);
                this._activeFloodQueries.put(key, searchJob);
                isNew = true;
            }
        }
        if (isNew) {
            if (this._log.shouldDebug()) {
                this._log.debug("[dbid: " + this + "]: New ISJ (" + (fromLocalDest != null ? "through client tunnels" : "through exploratory tunnels") + ") for " + key.toBase64());
            }
            this._context.jobQueue().addJob(searchJob);
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("Wait for pending ISJ for " + key.toBase64());
            }
            searchJob.addDeferred(onFindJob, onFailedLookupJob, timeoutMs, isLease);
            this._context.statManager().addRateData("netDb.lookupDeferred", 1L, searchJob.getExpiration() - this._context.clock().now());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void complete(Hash key) {
        Map<Hash, FloodSearchJob> map = this._activeFloodQueries;
        synchronized (map) {
            this._activeFloodQueries.remove(key);
        }
    }

    public List<Hash> getFloodfillPeers() {
        FloodfillPeerSelector sel = (FloodfillPeerSelector)this.getPeerSelector();
        return sel.selectFloodfillParticipants(this.getKBuckets());
    }

    boolean isVerifyInProgress(Hash h) {
        return this._verifiesInProgress.contains(h);
    }

    void verifyStarted(Hash h) {
        this._verifiesInProgress.add(h);
    }

    void verifyFinished(Hash h) {
        this._verifiesInProgress.remove(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lookupBeforeDropping(Hash peer, RouterInfo info) {
        if (this._context.commSystem().isEstablished(peer)) {
            FloodSearchJob searchJob;
            boolean isNew = false;
            DropLookupFoundJob onFindJob = new DropLookupFoundJob(this._context, peer, info);
            DropLookupFailedJob onFailedLookupJob = new DropLookupFailedJob(this._context, peer, info);
            Map<Hash, FloodSearchJob> map = this._activeFloodQueries;
            synchronized (map) {
                searchJob = this._activeFloodQueries.get(peer);
                if (searchJob == null) {
                    searchJob = new DirectLookupJob(this._context, this, peer, info, (Job)onFindJob, onFailedLookupJob);
                    this._activeFloodQueries.put(peer, searchJob);
                    isNew = true;
                }
            }
            if (isNew) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Direct RI lookup for " + peer.toBase64());
                }
                this._context.jobQueue().addJob(searchJob);
            } else {
                if (this._log.shouldDebug()) {
                    this._log.debug("Pending Direct RI lookup for " + peer.toBase64());
                }
                searchJob.addDeferred(onFindJob, onFailedLookupJob, 10000L, false);
            }
            return;
        }
        long uptime = this._context.router().getUptime();
        int knownRouters = this.getKBucketSetSize();
        if (info.getNetworkId() == this._networkID && (knownRouters < 40 || uptime < 600000L || this._context.commSystem().countActivePeers() <= 5)) {
            if (this._log.shouldInfo()) {
                this._log.info("Not failing " + peer.toBase64() + " as we are just starting up or have problems");
            }
            return;
        }
        if (this._floodfillEnabled || knownRouters > MAX_DB_BEFORE_SKIPPING_SEARCH || this._context.jobQueue().getMaxLag() > 500L || this._context.router().gracefulShutdownInProgress() || this._context.banlist().isBanlistedForever(peer)) {
            super.lookupBeforeDropping(peer, info);
            return;
        }
        String caps = info.getCapabilities();
        if (caps.indexOf(85) >= 0 || caps.indexOf(76) >= 0) {
            super.lookupBeforeDropping(peer, info);
            return;
        }
        if (caps.indexOf(102) >= 0) {
            double failRate;
            Rate r;
            RateStat rs;
            boolean enforceHeard;
            PeerProfile prof = this._context.profileOrganizer().getProfile(peer);
            if (prof == null) {
                super.lookupBeforeDropping(peer, info);
                return;
            }
            long now = this._context.clock().now();
            long installed = this._context.getProperty("router.firstInstalled", 0L);
            boolean bl = enforceHeard = installed > 0L && now - installed > 0x6DDD00L;
            if (enforceHeard && prof.getFirstHeardAbout() > now - 10800000L) {
                super.lookupBeforeDropping(peer, info);
                return;
            }
            DBHistory hist = prof.getDBHistory();
            if (hist == null) {
                super.lookupBeforeDropping(peer, info);
                return;
            }
            long cutoff = now - 1800000L;
            long lastLookupSuccess = hist.getLastLookupSuccessful();
            long lastStoreSuccess = hist.getLastStoreSuccessful();
            if (uptime > 1800000L && lastLookupSuccess < cutoff && lastStoreSuccess < cutoff) {
                super.lookupBeforeDropping(peer, info);
                return;
            }
            cutoff = now - 0x6DDD00L;
            long lastLookupFailed = hist.getLastLookupFailed();
            long lastStoreFailed = hist.getLastStoreFailed();
            if (lastLookupFailed > cutoff || lastStoreFailed > cutoff || lastLookupFailed > lastLookupSuccess || lastStoreFailed > lastStoreSuccess) {
                super.lookupBeforeDropping(peer, info);
                return;
            }
            double maxFailRate = 0.95;
            if (this._context.router().getUptime() > 3600000L && (rs = this._context.statManager().getRate("peer.failedLookupRate")) != null && (r = rs.getRate(3600000L)) != null) {
                double currentFailRate = r.getAverageValue();
                maxFailRate = Math.min(0.95, Math.max(0.2, 1.25 * currentFailRate));
            }
            if ((failRate = hist.getFailedLookupRate().getRate(3600000L).getAverageValue()) >= 1.0 || failRate > maxFailRate) {
                super.lookupBeforeDropping(peer, info);
                return;
            }
        }
        if (this._log.shouldDebug()) {
            this._log.debug("ISJ lookup before dropping for " + peer.toBase64() + ' ' + info.getPublished());
        }
        this.search(peer, new DropLookupFoundJob(this._context, peer, info), new DropLookupFailedJob(this._context, peer, info), 10000L, false);
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        MAX_DB_BEFORE_SKIPPING_SEARCH = (int)Math.max(250L, Math.min(1250L, maxMemory / 134217L));
    }

    private class DelayedPublish
    extends SimpleTimer2.TimedEvent {
        private final RouterInfo localRouterInfo;

        public DelayedPublish(RouterInfo local) {
            super(FloodfillNetworkDatabaseFacade.this._context.simpleTimer2());
            this.localRouterInfo = local;
        }

        @Override
        public void timeReached() {
            RouterInfo latest = FloodfillNetworkDatabaseFacade.this._context.router().getRouterInfo();
            if (latest.getDate() == this.localRouterInfo.getDate()) {
                if (FloodfillNetworkDatabaseFacade.this._log.shouldWarn()) {
                    FloodfillNetworkDatabaseFacade.this._log.warn("Publishing our RI after delay: " + this.localRouterInfo);
                }
                FloodfillNetworkDatabaseFacade.this.sendStore(this.localRouterInfo.getIdentity().calculateHash(), this.localRouterInfo, null, null, 90000L, null);
            } else if (FloodfillNetworkDatabaseFacade.this._log.shouldWarn()) {
                FloodfillNetworkDatabaseFacade.this._log.warn("RI changed, not publishing old one: " + this.localRouterInfo);
            }
        }
    }

    private class DropLookupFailedJob
    extends JobImpl {
        private final Hash _peer;

        public DropLookupFailedJob(RouterContext ctx, Hash peer, RouterInfo info) {
            super(ctx);
            this._peer = peer;
        }

        @Override
        public String getName() {
            return "Lookup on failure of netDb peer timed out";
        }

        @Override
        public void runJob() {
            FloodfillNetworkDatabaseFacade.this.dropAfterLookupFailed(this._peer);
        }
    }

    private class DropLookupFoundJob
    extends JobImpl {
        private final Hash _peer;
        private final RouterInfo _info;

        public DropLookupFoundJob(RouterContext ctx, Hash peer, RouterInfo info) {
            super(ctx);
            this._peer = peer;
            this._info = info;
        }

        @Override
        public String getName() {
            return "Lookup on failure of netDb peer matched";
        }

        @Override
        public void runJob() {
            RouterInfo updated = FloodfillNetworkDatabaseFacade.this.lookupRouterInfoLocally(this._peer);
            if (updated == null || updated.getPublished() <= this._info.getPublished()) {
                FloodfillNetworkDatabaseFacade.this.dropAfterLookupFailed(this._peer);
            }
        }
    }

    private static class FloodFailedJob
    extends JobImpl {
        private final Hash _peer;

        public FloodFailedJob(RouterContext ctx, Hash peer) {
            super(ctx);
            this._peer = peer;
        }

        @Override
        public String getName() {
            return "Flood failed";
        }

        @Override
        public void runJob() {
            this.getContext().profileManager().dbStoreFailed(this._peer);
        }
    }

    private static class FloodSuccessJob
    extends JobImpl {
        private final Hash _peer;

        public FloodSuccessJob(RouterContext ctx, Hash peer) {
            super(ctx);
            this._peer = peer;
        }

        @Override
        public String getName() {
            return "Flood succeeded";
        }

        @Override
        public void runJob() {
            this.getContext().profileManager().dbStoreSuccessful(this._peer);
        }
    }
}

