/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.news;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.router.news.NewsEntry;
import net.i2p.router.news.RFC3339Date;
import net.i2p.router.news.XMLParser;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.Log;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import org.cybergarage.xml.Node;
import org.cybergarage.xml.ParserException;

class PersistNews {
    private static final String DIR = "docs/feed/news";
    private static final String PFX = "news-";
    private static final String SFX = ".xml.gz";
    private static final String XML_START = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";

    PersistNews() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean store(I2PAppContext ctx, List<Node> entries) {
        Log log = ctx.logManager().getLog(PersistNews.class);
        SecureDirectory dir = new SecureDirectory(ctx.getConfigDir(), DIR);
        if (!dir.exists()) {
            ((File)dir).mkdirs();
        }
        StringBuilder buf = new StringBuilder();
        boolean rv = false;
        for (Node entry : entries) {
            Node nid = entry.getNode("id");
            if (nid == null) {
                if (!log.shouldWarn()) continue;
                log.warn("entry without UUID");
                continue;
            }
            String id = nid.getValue();
            if (id == null) {
                if (!log.shouldWarn()) continue;
                log.warn("entry without UUID");
                continue;
            }
            String name = PersistNews.idToName(ctx, id);
            File file = new File(dir, name);
            if (!rv && !file.exists()) {
                rv = true;
            }
            Writer out = null;
            try {
                out = new OutputStreamWriter((OutputStream)new GZIPOutputStream(new SecureFileOutputStream(file)), "UTF-8");
                out.write(XML_START);
                XMLParser.toString(buf, entry);
                out.write(buf.toString());
                buf.setLength(0);
            }
            catch (IOException ioe) {
                if (!log.shouldWarn()) continue;
                log.warn("failed store to " + file, ioe);
            }
            finally {
                if (out == null) continue;
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<NewsEntry> load(I2PAppContext ctx) {
        Log log = ctx.logManager().getLog(PersistNews.class);
        File dir = new File(ctx.getConfigDir(), DIR);
        ArrayList<NewsEntry> rv = new ArrayList<NewsEntry>();
        File[] files = dir.listFiles(new FileSuffixFilter(PFX, SFX));
        if (files == null) {
            return rv;
        }
        for (File file : files) {
            String name = file.getName();
            XMLParser parser = new XMLParser(ctx);
            InputStream in = null;
            boolean error = false;
            try {
                in = new GZIPInputStream(new FileInputStream(file));
                Node node = parser.parse(in);
                NewsEntry entry = PersistNews.extract(node);
                if (entry != null) {
                    rv.add(entry);
                } else {
                    if (log.shouldWarn()) {
                        log.warn("load error from " + file);
                    }
                    error = true;
                }
            }
            catch (ParserException pe) {
                if (log.shouldWarn()) {
                    log.warn("load error from " + file, pe);
                }
                error = true;
            }
            catch (IOException ioe) {
                if (log.shouldWarn()) {
                    log.warn("load error from " + file, ioe);
                }
                error = true;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException pe) {}
                }
            }
            if (!error) continue;
            file.delete();
        }
        Collections.sort(rv);
        return rv;
    }

    private static NewsEntry extract(Node entry) {
        long time;
        String v;
        String a;
        NewsEntry e = new NewsEntry();
        Node n = entry.getNode("title");
        if (n != null) {
            e.title = n.getValue();
            if (e.title != null) {
                e.title = e.title.trim();
            }
        }
        if ((n = entry.getNode("link")) != null && (a = n.getAttributeValue("href")).length() > 0) {
            e.link = a.trim();
        }
        if ((n = entry.getNode("id")) != null) {
            e.id = n.getValue();
            if (e.id != null) {
                e.id = e.id.trim();
            }
        }
        if ((n = entry.getNode("updated")) != null && (v = n.getValue()) != null && (time = RFC3339Date.parse3339Date(v.trim())) > 0L) {
            e.updated = time;
        }
        if ((n = entry.getNode("summary")) != null) {
            e.summary = n.getValue();
            if (e.summary != null) {
                e.summary = e.summary.trim();
            }
        }
        if ((n = entry.getNode("author")) != null && (n = n.getNode("name")) != null) {
            e.authorName = n.getValue();
            if (e.authorName != null) {
                e.authorName = e.authorName.trim();
            }
        }
        if ((n = entry.getNode("content")) != null) {
            a = n.getAttributeValue("type");
            if (a.length() > 0) {
                e.contentType = a;
            }
            StringBuilder buf = new StringBuilder(256);
            for (int i = 0; i < n.getNNodes(); ++i) {
                Node sn = n.getNode(i);
                XMLParser.toString(buf, sn);
            }
            e.content = buf.toString();
        }
        return e;
    }

    public static boolean delete(I2PAppContext ctx, NewsEntry entry) {
        String id = entry.id;
        if (id == null) {
            return false;
        }
        String name = PersistNews.idToName(ctx, id);
        File dir = new File(ctx.getConfigDir(), DIR);
        File file = new File(dir, name);
        return file.delete();
    }

    private static String idToName(I2PAppContext ctx, String id) {
        byte[] bid = DataHelper.getUTF8(id);
        byte[] hash = new byte[32];
        ctx.sha().calculateHash(bid, 0, bid.length, hash, 0);
        return PFX + Base64.encode(hash) + SFX;
    }
}

