/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Bitfield;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

class SSU2Payload {
    public static final int BLOCK_HEADER_SIZE = 3;
    private static final int BLOCK_DATETIME = 0;
    private static final int BLOCK_OPTIONS = 1;
    private static final int BLOCK_ROUTERINFO = 2;
    private static final int BLOCK_I2NP = 3;
    private static final int BLOCK_FIRSTFRAG = 4;
    private static final int BLOCK_FOLLOWONFRAG = 5;
    public static final int BLOCK_TERMINATION = 6;
    private static final int BLOCK_RELAYREQ = 7;
    private static final int BLOCK_RELAYRESP = 8;
    private static final int BLOCK_RELAYINTRO = 9;
    private static final int BLOCK_PEERTEST = 10;
    private static final int BLOCK_NEXTNONCE = 11;
    private static final int BLOCK_ACK = 12;
    private static final int BLOCK_ADDRESS = 13;
    private static final int BLOCK_RELAYTAGREQ = 15;
    private static final int BLOCK_RELAYTAG = 16;
    private static final int BLOCK_NEWTOKEN = 17;
    private static final int BLOCK_PATHCHALLENGE = 18;
    private static final int BLOCK_PATHRESP = 19;
    private static final int BLOCK_CONGESTION = 21;
    private static final int BLOCK_PADDING = 254;

    SSU2Payload() {
    }

    public static int processPayload(I2PAppContext ctx, PayloadCallback cb, byte[] payload, int off, int length, boolean isHandshake, RemoteHostId from) throws IOException, DataFormatException, I2NPMessageException {
        int blocks = 0;
        boolean gotPadding = false;
        boolean gotTermination = false;
        int i = off;
        int end = off + length;
        while (i < end) {
            int len;
            int type = payload[i++] & 0xFF;
            if (gotPadding) {
                throw new IOException("Illegal block after padding: " + type);
            }
            if (gotTermination && type != 254) {
                throw new IOException("Illegal block after termination: " + type);
            }
            if (isHandshake && blocks == 0 && type != 0) {
                throw new IOException("Illegal first block in handshake: " + type);
            }
            if ((i += 2) + (len = (int)DataHelper.fromLong(payload, i, 2)) > end) {
                throw new IOException("Block " + blocks + " type " + type + " length " + len + " at offset " + (i - 3 - off) + " runs over frame of size " + length + '\n' + HexDump.dump(payload, off, length));
            }
            switch (type) {
                case 0: {
                    if (len != 4) {
                        throw new IOException("Bad length for DATETIME: " + len);
                    }
                    long time = DataHelper.fromLong(payload, i, 4) * 1000L;
                    cb.gotDateTime(time);
                    break;
                }
                case 1: {
                    byte[] options = new byte[len];
                    System.arraycopy(payload, i, options, 0, len);
                    cb.gotOptions(options, isHandshake);
                    break;
                }
                case 2: {
                    int flag = payload[i] & 0xFF;
                    boolean flood = (flag & 1) != 0;
                    boolean gz = (flag & 2) != 0;
                    int frag = payload[i + 1] & 0xFF;
                    int fnum = frag >> 4;
                    int ftot = frag & 0xF;
                    if (ftot == 0) {
                        throw new IOException("Bad fragment count for ROUTERINFO: " + ftot);
                    }
                    if (fnum == 0 && ftot == 1) {
                        ByteArrayInputStream bais;
                        if (gz) {
                            byte[] decompressed = DataHelper.decompress(payload, i + 2, len - 2);
                            if (decompressed.length > 4096) {
                                throw new DataFormatException("RI too big: " + decompressed.length);
                            }
                            bais = new ByteArrayInputStream(decompressed);
                        } else {
                            if (len - 2 > 4096) {
                                throw new DataFormatException("RI too big: " + (len - 2));
                            }
                            bais = new ByteArrayInputStream(payload, i + 2, len - 2);
                        }
                        if (bais.available() >= 3072) {
                            flood = false;
                        }
                        RouterInfo alice = new RouterInfo();
                        alice.readBytes(bais, true);
                        cb.gotRI(alice, isHandshake, flood);
                        break;
                    }
                    byte[] data = new byte[len - 2];
                    System.arraycopy(payload, i + 2, data, 0, len - 2);
                    cb.gotRIFragment(data, isHandshake, flood, gz, fnum, ftot);
                    break;
                }
                case 3: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    I2NPMessage msg = I2NPMessageImpl.fromRawByteArrayNTCP2(ctx, payload, i, len, null);
                    cb.gotI2NP(msg);
                    break;
                }
                case 4: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    if (len <= 9) {
                        throw new IOException("Bad length for FIRSTFRAG: " + len);
                    }
                    long id = DataHelper.fromLong(payload, i + 1, 4);
                    cb.gotFragment(payload, i, len, id, 0, false);
                    break;
                }
                case 5: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    if (len <= 5) {
                        throw new IOException("Bad length for FOLLOWON: " + len);
                    }
                    int frag = (payload[i] & 0xFF) >> 1;
                    if (frag == 0) {
                        throw new IOException("0 frag for FOLLOWON");
                    }
                    boolean isLast = (payload[i] & 1) != 0;
                    long id = DataHelper.fromLong(payload, i + 1, 4);
                    cb.gotFragment(payload, i + 5, len - 5, id, frag, isLast);
                    break;
                }
                case 12: {
                    byte[] ranges;
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    if (len < 5 || len % 2 != 1) {
                        throw new IOException("Bad length for ACK: " + len);
                    }
                    long ack = DataHelper.fromLong(payload, i, 4);
                    int acnt = payload[i + 4] & 0xFF;
                    int rcnt = len - 5;
                    if (rcnt > 0) {
                        ranges = new byte[rcnt];
                        System.arraycopy(payload, i + 5, ranges, 0, rcnt);
                    } else {
                        ranges = null;
                    }
                    cb.gotACK(ack, acnt, ranges);
                    break;
                }
                case 13: {
                    if (len != 6 && len != 18) {
                        throw new IOException("Bad length for Address: " + len);
                    }
                    int port = (int)DataHelper.fromLong(payload, i, 2);
                    byte[] ip = new byte[len - 2];
                    System.arraycopy(payload, i + 2, ip, 0, len - 2);
                    cb.gotAddress(ip, port);
                    break;
                }
                case 15: {
                    cb.gotRelayTagRequest();
                    break;
                }
                case 16: {
                    if (len < 4) {
                        throw new IOException("Bad length for RELAYTAG: " + len);
                    }
                    long tag = DataHelper.fromLong(payload, i, 4);
                    cb.gotRelayTag(tag);
                    break;
                }
                case 7: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    if (len < 61) {
                        throw new IOException("Bad length for RELAYREQ: " + len);
                    }
                    byte[] data = new byte[len - 1];
                    System.arraycopy(payload, i + 1, data, 0, len - 1);
                    cb.gotRelayRequest(data);
                    break;
                }
                case 8: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    if (len < 52) {
                        throw new IOException("Bad length for RELAYRESP: " + len);
                    }
                    int resp = payload[i + 1] & 0xFF;
                    byte[] data = new byte[len - 2];
                    System.arraycopy(payload, i + 2, data, 0, len - 2);
                    cb.gotRelayResponse(resp, data);
                    break;
                }
                case 9: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    if (len < 93) {
                        throw new IOException("Bad length for RELAYINTRO: " + len);
                    }
                    Hash h = Hash.create(payload, i + 1);
                    byte[] data = new byte[len - 33];
                    System.arraycopy(payload, i + 1 + 32, data, 0, data.length);
                    cb.gotRelayIntro(h, data);
                    break;
                }
                case 10: {
                    int datalen;
                    Hash h;
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    if (len < 19) {
                        throw new IOException("Bad length for PEERTEST: " + len);
                    }
                    int mnum = payload[i] & 0xFF;
                    if (mnum == 0 || mnum > 7) {
                        throw new DataFormatException("Bad PEERTEST number: " + mnum);
                    }
                    int resp = payload[i + 1] & 0xFF;
                    int o = i + 3;
                    if (mnum == 2 || mnum == 4) {
                        h = Hash.create(payload, o);
                        datalen = len - 35;
                        o += 32;
                    } else {
                        datalen = len - 3;
                        h = null;
                    }
                    byte[] data = new byte[datalen];
                    System.arraycopy(payload, o, data, 0, datalen);
                    cb.gotPeerTest(mnum, resp, h, data);
                    break;
                }
                case 17: {
                    if (len < 12) {
                        throw new IOException("Bad length for NEWTOKEN: " + len);
                    }
                    long exp = DataHelper.fromLong(payload, i, 4) * 1000L;
                    long token = DataHelper.fromLong8(payload, i + 4);
                    cb.gotToken(token, exp);
                    break;
                }
                case 6: {
                    if (len < 9) {
                        throw new IOException("Bad length for TERMINATION: " + len);
                    }
                    long last = DataHelper.fromLong8(payload, i);
                    int rsn = payload[i + 8] & 0xFF;
                    cb.gotTermination(rsn, last);
                    gotTermination = true;
                    break;
                }
                case 18: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    byte[] cdata = new byte[len];
                    System.arraycopy(payload, i, cdata, 0, len);
                    cb.gotPathChallenge(from, cdata);
                    break;
                }
                case 19: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    byte[] rdata = new byte[len];
                    System.arraycopy(payload, i, rdata, 0, len);
                    cb.gotPathResponse(from, rdata);
                    break;
                }
                case 254: {
                    gotPadding = true;
                    break;
                }
                default: {
                    Log log = ctx.logManager().getLog(SSU2Payload.class);
                    if (!log.shouldWarn()) break;
                    log.warn("Got UNKNOWN block, type: " + type + " len: " + len + " on " + cb);
                }
            }
            i += len;
            ++blocks;
        }
        if (isHandshake && blocks == 0) {
            throw new IOException("No blocks in handshake");
        }
        return blocks;
    }

    public static int writePayload(byte[] payload, int off, List<Block> blocks) {
        for (Block block : blocks) {
            off = block.write(payload, off);
        }
        return off;
    }

    public static class AckBlock
    extends Block {
        private final long t;
        private final int a;
        private final byte[] r;
        private final int rc;

        public AckBlock(long thru, int acnt, byte[] ranges, int rangeCount) {
            super(12);
            if (acnt > 255) {
                throw new IllegalArgumentException();
            }
            this.t = thru;
            this.a = acnt;
            this.r = ranges;
            this.rc = rangeCount;
        }

        @Override
        public int getDataLength() {
            return 5 + this.rc * 2;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            DataHelper.toLong(tgt, off, 4, this.t);
            off += 4;
            tgt[off++] = (byte)this.a;
            System.arraycopy(this.r, 0, tgt, off, this.rc * 2);
            return off + this.rc * 2;
        }

        @Override
        public String toString() {
            return SSU2Bitfield.toString(this.t, this.a, this.r, this.rc);
        }
    }

    public static class AddressBlock
    extends Block {
        private final byte[] i;
        private final int p;

        public AddressBlock(byte[] ip, int port) {
            super(13);
            this.i = ip;
            this.p = port;
        }

        @Override
        public int getDataLength() {
            return 2 + this.i.length;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            DataHelper.toLong(tgt, off, 2, this.p);
            System.arraycopy(this.i, 0, tgt, off += 2, this.i.length);
            return off + this.i.length;
        }
    }

    public static abstract class Block {
        private final int type;

        public Block(int ttype) {
            this.type = ttype;
        }

        public int getType() {
            return this.type;
        }

        public int write(byte[] tgt, int off) {
            tgt[off++] = (byte)this.type;
            int rv = this.writeData(tgt, off + 2);
            DataHelper.toLong(tgt, off, 2, rv - (off + 2));
            return rv;
        }

        public int getTotalLength() {
            return 3 + this.getDataLength();
        }

        public abstract int getDataLength();

        public abstract int writeData(byte[] var1, int var2);

        public String toString() {
            return "Payload block type " + this.type + " length " + this.getDataLength();
        }
    }

    public static class DateTimeBlock
    extends Block {
        private final long now;

        public DateTimeBlock(I2PAppContext ctx) {
            super(0);
            this.now = ctx.clock().now();
        }

        @Override
        public int getDataLength() {
            return 4;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            DataHelper.toLong(tgt, off, 4, (this.now + 500L) / 1000L);
            return off + 4;
        }
    }

    public static class FirstFragBlock
    extends Block {
        private final OutboundMessageState m;

        public FirstFragBlock(OutboundMessageState msg) {
            super(4);
            this.m = msg;
        }

        @Override
        public int getDataLength() {
            return this.m.fragmentSize(0);
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            return off + this.m.writeFragment(tgt, off, 0);
        }
    }

    public static class FollowFragBlock
    extends Block {
        private final OutboundMessageState m;
        private final int f;

        public FollowFragBlock(OutboundMessageState msg, int frag) {
            super(5);
            if (frag <= 0) {
                throw new IllegalArgumentException();
            }
            this.m = msg;
            this.f = frag;
        }

        @Override
        public int getDataLength() {
            return this.m.fragmentSize(this.f) + 5;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            byte b = (byte)(this.f << 1);
            if (this.f == this.m.getFragmentCount() - 1) {
                b = (byte)(b | 1);
            }
            tgt[off++] = b;
            DataHelper.toLong(tgt, off, 4, this.m.getMessageId());
            return (off += 4) + this.m.writeFragment(tgt, off, this.f);
        }
    }

    public static class I2NPBlock
    extends Block {
        private final OutboundMessageState m;

        public I2NPBlock(OutboundMessageState msg) {
            super(3);
            this.m = msg;
        }

        @Override
        public int getDataLength() {
            return this.m.getMessageSize();
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            return off + this.m.writeFragment(tgt, off, 0);
        }
    }

    public static class NewTokenBlock
    extends Block {
        private final EstablishmentManager.Token tok;

        public NewTokenBlock(EstablishmentManager.Token token) {
            super(17);
            this.tok = token;
        }

        @Override
        public int getDataLength() {
            return 12;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            DataHelper.toLong(tgt, off, 4, this.tok.getExpiration() / 1000L);
            DataHelper.toLong8(tgt, off += 4, this.tok.getToken());
            return off + 8;
        }
    }

    public static class OptionsBlock
    extends Block {
        private final byte[] opts;

        public OptionsBlock(byte[] options) {
            super(1);
            this.opts = options;
        }

        @Override
        public int getDataLength() {
            return this.opts.length;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            System.arraycopy(this.opts, 0, tgt, off, this.opts.length);
            return off + this.opts.length;
        }
    }

    public static class PaddingBlock
    extends Block {
        private final int sz;
        private final I2PAppContext ctx;

        public PaddingBlock(int size) {
            this(null, size);
        }

        public PaddingBlock(I2PAppContext context, int size) {
            super(254);
            this.sz = size;
            this.ctx = context;
        }

        @Override
        public int getDataLength() {
            return this.sz;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            if (this.ctx != null) {
                this.ctx.random().nextBytes(tgt, off, this.sz);
            } else {
                Arrays.fill(tgt, off, off + this.sz, (byte)0);
            }
            return off + this.sz;
        }
    }

    public static class PathChallengeBlock
    extends Block {
        private final byte[] d;

        public PathChallengeBlock(byte[] data) {
            super(18);
            this.d = data;
        }

        @Override
        public int getDataLength() {
            return this.d.length;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            System.arraycopy(this.d, 0, tgt, off, this.d.length);
            return off + this.d.length;
        }
    }

    public static class PathResponseBlock
    extends Block {
        private final byte[] d;

        public PathResponseBlock(byte[] data) {
            super(19);
            this.d = data;
        }

        @Override
        public int getDataLength() {
            return this.d.length;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            System.arraycopy(this.d, 0, tgt, off, this.d.length);
            return off + this.d.length;
        }
    }

    public static interface PayloadCallback {
        public void gotDateTime(long var1) throws DataFormatException;

        public void gotI2NP(I2NPMessage var1) throws I2NPMessageException;

        public void gotFragment(byte[] var1, int var2, int var3, long var4, int var6, boolean var7) throws DataFormatException;

        public void gotACK(long var1, int var3, byte[] var4);

        public void gotOptions(byte[] var1, boolean var2) throws DataFormatException;

        public void gotRI(RouterInfo var1, boolean var2, boolean var3) throws DataFormatException;

        public void gotRIFragment(byte[] var1, boolean var2, boolean var3, boolean var4, int var5, int var6);

        public void gotAddress(byte[] var1, int var2);

        public void gotRelayTagRequest();

        public void gotRelayTag(long var1);

        public void gotRelayRequest(byte[] var1);

        public void gotRelayResponse(int var1, byte[] var2);

        public void gotRelayIntro(Hash var1, byte[] var2);

        public void gotPeerTest(int var1, int var2, Hash var3, byte[] var4);

        public void gotToken(long var1, long var3);

        public void gotTermination(int var1, long var2);

        public void gotPathChallenge(RemoteHostId var1, byte[] var2);

        public void gotPathResponse(RemoteHostId var1, byte[] var2);
    }

    public static class PeerTestBlock
    extends Block {
        private final int n;
        private final int c;
        private final Hash h;
        private final byte[] d;

        public PeerTestBlock(int msgNum, int code, Hash hash, byte[] data) {
            super(10);
            this.n = msgNum;
            this.c = code;
            this.h = hash;
            this.d = data;
        }

        @Override
        public int getDataLength() {
            int rv = 3 + this.d.length;
            if (this.h != null) {
                rv += 32;
            }
            return rv;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            tgt[off++] = (byte)this.n;
            tgt[off++] = (byte)this.c;
            tgt[off++] = 0;
            if (this.h != null) {
                System.arraycopy(this.h.getData(), 0, tgt, off, 32);
                off += 32;
            }
            System.arraycopy(this.d, 0, tgt, off, this.d.length);
            return off + this.d.length;
        }
    }

    public static class RIBlock
    extends Block {
        private final byte[] data;
        private final int doff;
        private final int dlen;
        private final boolean f;
        private final boolean gz;
        private final int fr;
        private final int frt;

        public RIBlock(byte[] ridata, boolean flood, boolean gzipped) {
            this(ridata, 0, ridata.length, flood, gzipped, 0, 1);
        }

        public RIBlock(byte[] ridata, int off, int len, boolean flood, boolean gzipped, int frag, int total) {
            super(2);
            this.data = ridata;
            this.doff = off;
            this.dlen = len;
            this.f = flood;
            this.gz = gzipped;
            this.fr = frag;
            this.frt = total;
        }

        @Override
        public int getDataLength() {
            return 2 + this.data.length;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            byte b = (byte)(this.f ? 1 : 0);
            if (this.gz) {
                b = (byte)(b | 2);
            }
            tgt[off++] = b;
            b = (byte)(this.fr << 4 | this.frt);
            tgt[off++] = b;
            System.arraycopy(this.data, this.doff, tgt, off, this.dlen);
            return off + this.dlen;
        }
    }

    public static class RelayIntroBlock
    extends Block {
        private final byte[] d;

        public RelayIntroBlock(byte[] data) {
            super(9);
            this.d = data;
        }

        @Override
        public int getDataLength() {
            return this.d.length;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            System.arraycopy(this.d, 0, tgt, off, this.d.length);
            return off + this.d.length;
        }
    }

    public static class RelayRequestBlock
    extends Block {
        private final byte[] d;

        public RelayRequestBlock(byte[] data) {
            super(7);
            this.d = data;
        }

        @Override
        public int getDataLength() {
            return this.d.length;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            System.arraycopy(this.d, 0, tgt, off, this.d.length);
            return off + this.d.length;
        }
    }

    public static class RelayResponseBlock
    extends Block {
        private final byte[] d;

        public RelayResponseBlock(byte[] data) {
            super(8);
            this.d = data;
        }

        @Override
        public int getDataLength() {
            return this.d.length;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            System.arraycopy(this.d, 0, tgt, off, this.d.length);
            return off + this.d.length;
        }
    }

    public static class RelayTagBlock
    extends Block {
        private final long t;

        public RelayTagBlock(long tag) {
            super(16);
            this.t = tag;
        }

        @Override
        public int getDataLength() {
            return 4;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            DataHelper.toLong(tgt, off, 4, this.t);
            return off + 4;
        }
    }

    public static class RelayTagRequestBlock
    extends Block {
        public RelayTagRequestBlock() {
            super(15);
        }

        @Override
        public int getDataLength() {
            return 0;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            return off;
        }
    }

    public static class TerminationBlock
    extends Block {
        private final byte rsn;
        private final long rcvd;

        public TerminationBlock(int reason, long lastReceived) {
            super(6);
            this.rsn = (byte)reason;
            this.rcvd = lastReceived;
        }

        @Override
        public int getDataLength() {
            return 9;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            DataHelper.toLong8(tgt, off, this.rcvd);
            tgt[off + 8] = this.rsn;
            return off + 9;
        }
    }
}

