/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.data.i2np.UnknownI2NPMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.FragmentedMessage;
import net.i2p.util.ByteCache;
import net.i2p.util.HexDump;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;
import net.i2p.util.SimpleTimer2;

class FragmentHandler {
    protected final RouterContext _context;
    protected final Log _log;
    private final Map<Long, FragmentedMessage> _fragmentedMessages;
    private final DefragmentedReceiver _receiver;
    private final AtomicInteger _completed = new AtomicInteger();
    private final AtomicInteger _failed = new AtomicInteger();
    private final boolean _isInbound;
    static long MAX_DEFRAGMENT_TIME = 45000L;
    private static final ByteCache _cache = ByteCache.getInstance(512, 1024);
    private static final ByteCache _validateCache = ByteCache.getInstance(512, 1024);
    static final byte MASK_IS_SUBSEQUENT = -128;
    static final byte MASK_TYPE = 96;
    static final byte MASK_FRAGMENTED = 8;
    static final byte MASK_EXTENDED = 4;
    private static final int MASK_FRAGMENT_NUM = 126;
    static final short TYPE_LOCAL = 0;
    static final short TYPE_TUNNEL = 1;
    static final short TYPE_ROUTER = 2;
    static final short TYPE_UNDEF = 3;

    @Deprecated
    public FragmentHandler(RouterContext context, DefragmentedReceiver receiver) {
        this(context, receiver, true);
    }

    public FragmentHandler(RouterContext context, DefragmentedReceiver receiver, boolean isInbound) {
        this._context = context;
        this._log = context.logManager().getLog(FragmentHandler.class);
        this._fragmentedMessages = new HashMap<Long, FragmentedMessage>(16);
        this._receiver = receiver;
        this._isInbound = isInbound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receiveTunnelMessage(byte[] preprocessed, int offset, int length) {
        boolean ok = this.verifyPreprocessed(preprocessed, offset, length);
        if (!ok) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to verify preprocessed data (pre.length=" + preprocessed.length + " off=" + offset + " len=" + length);
            }
            _cache.release(new ByteArray(preprocessed));
            this._context.statManager().addRateData("tunnel.corruptMessage", 1L);
            return false;
        }
        offset += 16;
        offset += 4;
        int padding = 0;
        while (preprocessed[offset] != 0) {
            if (++offset >= 1024) {
                _cache.release(new ByteArray(preprocessed));
                this._context.statManager().addRateData("tunnel.corruptMessage", 1L);
                if (this._log.shouldWarn()) {
                    this._log.warn("Corrupt fragment received: off = " + offset);
                }
                return false;
            }
            ++padding;
        }
        ++offset;
        if (this._log.shouldLog(10)) {
            this._log.debug("Fragments begin at offset=" + offset + " padding=" + padding);
        }
        try {
            while (offset < length) {
                int off = this.receiveFragment(preprocessed, offset, length);
                if (off < 0) {
                    this._context.statManager().addRateData("tunnel.corruptMessage", 1L);
                    if (this._log.shouldWarn()) {
                        this._log.warn("Corrupt fragment received: off = " + off);
                    }
                    boolean bl = false;
                    return bl;
                }
                offset = off;
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this._context.statManager().addRateData("tunnel.corruptMessage", 1L);
            if (this._log.shouldWarn()) {
                this._log.warn("Corrupt fragment received: offset = " + offset, aioobe);
            }
            boolean bl = false;
            return bl;
        }
        catch (NullPointerException npe) {
            if (this._log.shouldWarn()) {
                this._log.warn("Corrupt fragment received: offset = " + offset, npe);
            }
            this._context.statManager().addRateData("tunnel.corruptMessage", 1L);
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException e) {
            if (this._log.shouldWarn()) {
                this._log.warn("Corrupt fragment received: offset = " + offset, e);
            }
            this._context.statManager().addRateData("tunnel.corruptMessage", 1L);
            boolean bl = false;
            return bl;
        }
        finally {
            _cache.release(new ByteArray(preprocessed));
        }
        return true;
    }

    public int getCompleteCount() {
        return this._completed.get();
    }

    public int getFailedCount() {
        return this._failed.get();
    }

    private boolean verifyPreprocessed(byte[] preprocessed, int offset, int length) {
        int paddingEnd = 20;
        while (preprocessed[offset + paddingEnd] != 0) {
            if (offset + ++paddingEnd < length) continue;
            if (this._log.shouldLog(30)) {
                this._log.warn("cannot verify, going past the end [off=" + offset + " len=" + length + " paddingEnd=" + paddingEnd + " data: " + Base64.encode(preprocessed, offset, length));
            }
            return false;
        }
        ByteArray ba = (ByteArray)_validateCache.acquire();
        byte[] preV = ba.getData();
        int validLength = length - offset - ++paddingEnd + 16;
        System.arraycopy(preprocessed, offset + paddingEnd, preV, 0, validLength - 16);
        System.arraycopy(preprocessed, 0, preV, validLength - 16, 16);
        byte[] v = SimpleByteCache.acquire(32);
        this._context.sha().calculateHash(preV, 0, validLength, v, 0);
        _validateCache.release(ba);
        boolean eq = DataHelper.eq(v, 0, preprocessed, offset + 16, 4);
        if (!eq && this._log.shouldLog(30)) {
            this._log.warn("Corrupt tunnel message - verification fails: " + Base64.encode(preprocessed, offset + 16, 4) + " != " + Base64.encode(v, 0, 4));
            this._log.warn("No matching endpoint: # pad bytes: " + (paddingEnd - 20 - 1) + " offset=" + offset + " length=" + length + " paddingEnd=" + paddingEnd + ' ' + Base64.encode(preprocessed, offset, length), new Exception("trace"));
        }
        SimpleByteCache.release(v);
        if (eq) {
            int excessPadding = paddingEnd - 21;
            if (excessPadding > 0) {
                this._context.statManager().addRateData("tunnel.smallFragments", excessPadding);
            } else {
                this._context.statManager().addRateData("tunnel.fullFragments", 1L);
            }
        }
        return eq;
    }

    private int receiveFragment(byte[] preprocessed, int offset, int length) {
        if (0 == (preprocessed[offset] & 0xFFFFFF80)) {
            return this.receiveInitialFragment(preprocessed, offset, length);
        }
        return this.receiveSubsequentFragment(preprocessed, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receiveInitialFragment(byte[] preprocessed, int offset, int length) {
        if (this._log.shouldLog(10)) {
            this._log.debug("initial begins at " + offset + " for " + length);
        }
        int type = (preprocessed[offset] & 0x60) >>> 5;
        boolean fragmented = 0 != (preprocessed[offset] & 8);
        boolean extended = 0 != (preprocessed[offset] & 4);
        ++offset;
        TunnelId tunnelId = null;
        Hash router = null;
        long messageId = -1L;
        if (type == 1) {
            if (offset + 4 >= preprocessed.length) {
                return -1;
            }
            long id = DataHelper.fromLong(preprocessed, offset, 4);
            if (id != 0L) {
                tunnelId = new TunnelId(id);
            }
            offset += 4;
        }
        if (type == 2 || type == 1) {
            if (offset + 32 >= preprocessed.length) {
                return -1;
            }
            router = Hash.create(preprocessed, offset);
            offset += 32;
        }
        if (fragmented) {
            if (offset + 4 >= preprocessed.length) {
                return -1;
            }
            messageId = DataHelper.fromLong(preprocessed, offset, 4);
            if (this._log.shouldLog(10)) {
                this._log.debug("reading messageId " + messageId + " at offset " + offset + " type = " + type + " router = " + (router != null ? router.toBase64().substring(0, 4) : "n/a") + " tunnelId = " + tunnelId);
            }
            offset += 4;
        }
        if (extended) {
            int extendedSize = preprocessed[offset] & 0xFF;
            ++offset;
            offset += extendedSize;
        }
        if (offset + 2 >= preprocessed.length) {
            return -1;
        }
        int size = (int)DataHelper.fromLong(preprocessed, offset, 2);
        offset += 2;
        if (type == 3) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping msg at tunnel endpoint with unsupported delivery instruction type " + type + " rcvr: " + this._receiver);
            }
            this._context.statManager().addRateData("tunnel.corruptMessage", 1L);
        } else if (type == 1 && tunnelId == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping msg at tunnel endpoint with delivery instruction to tunnel 0 gw: " + router + " fragmented? " + fragmented + " id: " + messageId + " size: " + size + " type: " + (preprocessed[offset] & 0xFF));
            }
            this._context.statManager().addRateData("tunnel.corruptMessage", 1L);
        } else {
            if (fragmented) {
                FragmentedMessage msg;
                Object object = this._fragmentedMessages;
                synchronized (object) {
                    msg = this._fragmentedMessages.get(messageId);
                    if (msg == null) {
                        msg = new FragmentedMessage(this._context, messageId);
                        this._fragmentedMessages.put(messageId, msg);
                    }
                }
                object = msg;
                synchronized (object) {
                    boolean ok = msg.receive(preprocessed, offset, size, false, router, tunnelId);
                    if (!ok) {
                        return -1;
                    }
                    if (msg.isComplete()) {
                        Map<Long, FragmentedMessage> map = this._fragmentedMessages;
                        synchronized (map) {
                            this._fragmentedMessages.remove(messageId);
                        }
                        if (msg.getExpireEvent() != null) {
                            msg.getExpireEvent().cancel();
                        }
                        this.receiveComplete(msg);
                    } else if (msg.getExpireEvent() == null) {
                        RemoveFailed evt = new RemoveFailed(msg);
                        msg.setExpireEvent(evt);
                        if (this._log.shouldLog(10)) {
                            this._log.debug("In " + MAX_DEFRAGMENT_TIME + " dropping " + messageId);
                        }
                        evt.schedule(MAX_DEFRAGMENT_TIME);
                    }
                }
            }
            this.receiveComplete(preprocessed, offset, size, router, tunnelId);
        }
        return offset += size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receiveSubsequentFragment(byte[] preprocessed, int offset, int length) {
        if (this._log.shouldLog(10)) {
            this._log.debug("subsequent begins at " + offset + " for " + length);
        }
        int fragmentNum = (preprocessed[offset] & 0x7E) >>> 1;
        boolean isLast = 0 != (preprocessed[offset] & 1);
        long messageId = DataHelper.fromLong(preprocessed, ++offset, 4);
        int size = (int)DataHelper.fromLong(preprocessed, offset += 4, 2);
        offset += 2;
        if (messageId < 0L) {
            throw new RuntimeException("Preprocessed message was invalid [messageId =" + messageId + " size=" + size + " offset=" + offset + " fragment=" + fragmentNum);
        }
        FragmentedMessage msg = null;
        Object object = this._fragmentedMessages;
        synchronized (object) {
            msg = this._fragmentedMessages.get(messageId);
            if (msg == null) {
                msg = new FragmentedMessage(this._context, messageId);
                this._fragmentedMessages.put(messageId, msg);
            }
        }
        object = msg;
        synchronized (object) {
            boolean ok = msg.receive(fragmentNum, preprocessed, offset, size, isLast);
            if (!ok) {
                return -1;
            }
            if (msg.isComplete()) {
                Map<Long, FragmentedMessage> map = this._fragmentedMessages;
                synchronized (map) {
                    this._fragmentedMessages.remove(messageId);
                }
                if (msg.getExpireEvent() != null) {
                    msg.getExpireEvent().cancel();
                }
                this._context.statManager().addRateData("tunnel.fragmentedComplete", msg.getFragmentCount(), msg.getLifetime());
                this.receiveComplete(msg);
            } else if (msg.getExpireEvent() == null) {
                RemoveFailed evt = new RemoveFailed(msg);
                msg.setExpireEvent(evt);
                if (this._log.shouldLog(10)) {
                    this._log.debug("In " + MAX_DEFRAGMENT_TIME + " dropping " + msg.getMessageId() + "/" + fragmentNum);
                }
                evt.schedule(MAX_DEFRAGMENT_TIME);
            }
        }
        return offset += size;
    }

    private void receiveComplete(FragmentedMessage msg) {
        block7: {
            if (msg == null) {
                return;
            }
            this._completed.incrementAndGet();
            byte[] data = null;
            try {
                I2NPMessage m;
                data = msg.toByteArray();
                if (data == null) {
                    throw new I2NPMessageException("null data");
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("RECV(" + data.length + "): ");
                }
                if (this._isInbound) {
                    m = new I2NPMessageHandler(this._context).readMessage(data);
                } else {
                    int utype = data[0] & 0xFF;
                    m = new UnknownI2NPMessage(this._context, utype);
                    m.readBytes(data, utype, 1);
                }
                this._receiver.receiveComplete(m, msg.getTargetRouter(), msg.getTargetTunnel());
            }
            catch (I2NPMessageException ime) {
                if (!this._log.shouldLog(30)) break block7;
                this._log.warn("Error receiving fragmented message (corrupt?): " + msg, ime);
                this._log.warn("DUMP:\n" + HexDump.dump(data));
                this._log.warn("RAW:\n" + Base64.encode(data));
            }
        }
    }

    private void receiveComplete(byte[] data, int offset, int len, Hash router, TunnelId tunnelId) {
        block5: {
            this._completed.incrementAndGet();
            try {
                I2NPMessage m;
                if (this._log.shouldLog(10)) {
                    this._log.debug("RECV unfrag(" + len + ')');
                }
                if (this._isInbound) {
                    I2NPMessageHandler h = new I2NPMessageHandler(this._context);
                    h.readMessage(data, offset, len);
                    m = h.lastRead();
                } else {
                    int utype = data[offset++] & 0xFF;
                    m = new UnknownI2NPMessage(this._context, utype);
                    m.readBytes(data, utype, offset, len - 1);
                }
                this._receiver.receiveComplete(m, router, tunnelId);
            }
            catch (I2NPMessageException ime) {
                if (!this._log.shouldLog(30)) break block5;
                this._log.warn("Error receiving unfragmented message (corrupt?)", ime);
                this._log.warn("DUMP:\n" + HexDump.dump(data, offset, len));
                this._log.warn("RAW:\n" + Base64.encode(data, offset, len));
            }
        }
    }

    public static interface DefragmentedReceiver {
        public void receiveComplete(I2NPMessage var1, Hash var2, TunnelId var3);
    }

    private class RemoveFailed
    extends SimpleTimer2.TimedEvent {
        private final FragmentedMessage _msg;

        public RemoveFailed(FragmentedMessage msg) {
            super(FragmentHandler.this._context.simpleTimer2());
            this._msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            boolean removed;
            Object object = FragmentHandler.this._fragmentedMessages;
            synchronized (object) {
                removed = null != FragmentHandler.this._fragmentedMessages.remove(this._msg.getMessageId());
            }
            object = this._msg;
            synchronized (object) {
                if (removed && !this._msg.getReleased()) {
                    FragmentHandler.this._failed.incrementAndGet();
                    if (FragmentHandler.this._log.shouldLog(30)) {
                        FragmentHandler.this._log.warn("Dropped incomplete fragmented message: " + this._msg);
                    }
                    FragmentHandler.this._context.statManager().addRateData("tunnel.fragmentedDropped", this._msg.getFragmentCount(), this._msg.getLifetime());
                    this._msg.failed();
                }
            }
        }
    }
}

