/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

class ValueScaler {
    static final String UNIT_UNKNOWN = "?";
    static final String[] UNIT_SYMBOLS = new String[]{"a", "f", "p", "n", "u", "m", " ", "k", "M", "G", "T", "P", "E"};
    static final int SYMB_CENTER = 6;
    private final double base;
    private double magfact = -1.0;
    private String unit;

    ValueScaler(double base) {
        this.base = base;
    }

    Scaled scale(double value, boolean mustRescale) {
        Scaled scaled;
        if (mustRescale) {
            scaled = this.rescale(value);
        } else if (this.magfact >= 0.0) {
            scaled = new Scaled(value / this.magfact, this.unit);
        } else {
            scaled = this.rescale(value);
            if (scaled.value == 0.0 || Double.isNaN(scaled.value)) {
                this.magfact = -1.0;
            }
        }
        return scaled;
    }

    private Scaled rescale(double value) {
        int sindex;
        if (value == 0.0 || Double.isNaN(value)) {
            sindex = 0;
            this.magfact = 1.0;
        } else {
            sindex = (int)Math.floor(Math.log(Math.abs(value)) / Math.log(this.base));
            this.magfact = Math.pow(this.base, sindex);
        }
        this.unit = sindex <= 6 && sindex >= -6 ? UNIT_SYMBOLS[sindex + 6] : UNIT_UNKNOWN;
        return new Scaled(value / this.magfact, this.unit);
    }

    static class Scaled {
        final double value;
        final String unit;

        public Scaled(double value, String unit) {
            this.value = value;
            this.unit = unit;
        }

        void dump() {
            System.out.println("[" + this.value + this.unit + "]");
        }
    }
}

