/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.crypto.SigAlgo;
import net.i2p.crypto.SigType;
import net.i2p.data.BlindData;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Destination;
import net.i2p.data.EncryptedLeaseSet;
import net.i2p.data.Hash;
import net.i2p.data.KeyCertificate;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.kademlia.KBucketSet;
import net.i2p.kademlia.RejectTrimmer;
import net.i2p.router.Job;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.FamilyKeyCrypto;
import net.i2p.router.networkdb.PublishLocalRouterInfoJob;
import net.i2p.router.networkdb.kademlia.BlindCache;
import net.i2p.router.networkdb.kademlia.DataStore;
import net.i2p.router.networkdb.kademlia.ExpireLeasesJob;
import net.i2p.router.networkdb.kademlia.ExpireRoutersJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseSegmentor;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.NegativeLookupCache;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.PersistentDataStore;
import net.i2p.router.networkdb.kademlia.RepublishLeaseSetJob;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.router.networkdb.kademlia.StartExplorersJob;
import net.i2p.router.networkdb.kademlia.TransientDataStore;
import net.i2p.router.networkdb.kademlia.UnsupportedCryptoException;
import net.i2p.router.networkdb.reseed.ReseedChecker;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public abstract class KademliaNetworkDatabaseFacade
extends NetworkDatabaseFacade {
    protected final Log _log;
    private KBucketSet<Hash> _kb;
    private DataStore _ds;
    private String _dbDir;
    private final Set<Hash> _exploreKeys;
    private boolean _initialized;
    private long _started;
    private StartExplorersJob _exploreJob;
    private long _lastExploreNew;
    protected final PeerSelector _peerSelector;
    protected final RouterContext _context;
    private final ReseedChecker _reseedChecker;
    private volatile long _lastRIPublishTime;
    private NegativeLookupCache _negativeCache;
    protected final int _networkID;
    private final BlindCache _blindCache;
    private final Hash _dbid;
    private final Job _elj;
    private final Job _erj;
    private final Map<Hash, RepublishLeaseSetJob> _publishingLeaseSets;
    private final Map<Hash, SearchJob> _activeRequests;
    protected static final long DONT_FAIL_PERIOD = 600000L;
    private static final boolean QUIET = false;
    public static final String PROP_DB_DIR = "router.networkDatabase.dbDir";
    public static final String DEFAULT_DB_DIR = "netDb";
    static final int MIN_RESEED = 50;
    protected static final int MIN_REMAINING_ROUTERS = 40;
    private static final long ROUTER_INFO_EXPIRATION = 97200000L;
    private static final long ROUTER_INFO_EXPIRATION_MIN = 3600000L;
    private static final long ROUTER_INFO_EXPIRATION_SHORT = 4500000L;
    private static final long ROUTER_INFO_EXPIRATION_FLOODFILL = 3600000L;
    private static final long ROUTER_INFO_EXPIRATION_INTRODUCED = 3240000L;
    private static final long MAX_LEASE_FUTURE = 900000L;
    private static final long MAX_META_LEASE_FUTURE = 65535000L;
    private static final long EXPLORE_JOB_DELAY = 600000L;
    protected static final long PUBLISH_JOB_DELAY = 300000L;
    static final int MAX_EXPLORE_QUEUE = 128;
    private static final int BUCKET_SIZE = 24;
    private static final int KAD_B = 4;
    private static final long PUBLISH_DELAY = 3000L;
    private static final int MIN_ROUTERS = 90;
    private static final int MIN_PER_PEER_TIMEOUT = 2000;
    private static final int MAX_PER_PEER_TIMEOUT = 5100;
    private static final int TIMEOUT_MULTIPLIER = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchComplete(Hash key) {
        if (this._log.shouldLog(10)) {
            this._log.debug("search Complete: " + key);
        }
        Map<Hash, SearchJob> map = this._activeRequests;
        synchronized (map) {
            this._activeRequests.remove(key);
        }
    }

    public KademliaNetworkDatabaseFacade(RouterContext context, Hash dbid) {
        this._context = context;
        this._dbid = dbid;
        this._log = this._context.logManager().getLog(this.getClass());
        this._networkID = context.router().getNetworkID();
        this._publishingLeaseSets = new HashMap<Hash, RepublishLeaseSetJob>(8);
        this._activeRequests = new HashMap<Hash, SearchJob>(8);
        if (this.isClientDb()) {
            this._reseedChecker = null;
            this._blindCache = null;
            this._exploreKeys = null;
            this._erj = null;
            this._peerSelector = ((KademliaNetworkDatabaseFacade)context.netDb()).getPeerSelector();
        } else {
            this._reseedChecker = new ReseedChecker(context);
            this._blindCache = new BlindCache(context);
            this._exploreKeys = new ConcurrentHashSet<Hash>(64);
            this._erj = new ExpireRoutersJob(this._context, this);
            this._peerSelector = this.createPeerSelector();
        }
        this._elj = new ExpireLeasesJob(this._context, this);
        if (this._log.shouldLog(10)) {
            this._log.debug("Created KademliaNetworkDatabaseFacade for id: " + dbid);
        }
        context.statManager().createRateStat("netDb.lookupDeferred", "how many lookups are deferred?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.exploreKeySet", "how many keys are queued for exploration?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.negativeCache", "Aborted lookup, already cached", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storeRouterInfoSent", "How many routerInfo store messages have we sent?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storeLeaseSetSent", "How many leaseSet store messages have we sent?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storePeers", "How many peers each netDb must be sent to before success?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.storeFailedPeers", "How many peers each netDb must be sent to before failing completely?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.ackTime", "How long does it take for a peer to ack a netDb store?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.replyTimeout", "How long after a netDb send does the timeout expire (when the peer doesn't reply in time)?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.republishLeaseSetCount", "How often we republish a leaseSet?", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.DSMAllZeros", "Store with zero key", "NetworkDatabase", new long[]{3600000L});
        context.statManager().createRateStat("netDb.DLMAllZeros", "Lookup with zero key", "NetworkDatabase", new long[]{3600000L});
    }

    @Override
    public boolean isInitialized() {
        return this._initialized && this._ds != null && this._ds.isInitialized();
    }

    protected PeerSelector createPeerSelector() {
        if (this.isClientDb()) {
            throw new IllegalStateException();
        }
        return new FloodfillPeerSelector(this._context);
    }

    public PeerSelector getPeerSelector() {
        return this._peerSelector;
    }

    @Override
    public ReseedChecker reseedChecker() {
        if (this.isClientDb()) {
            return null;
        }
        return this._reseedChecker;
    }

    protected BlindCache blindCache() {
        if (!this.isClientDb()) {
            return this._blindCache;
        }
        return ((FloodfillNetworkDatabaseFacade)this._context.netDb()).blindCache();
    }

    KBucketSet<Hash> getKBuckets() {
        return this._kb;
    }

    DataStore getDataStore() {
        return this._ds;
    }

    long getLastExploreNewDate() {
        return this._lastExploreNew;
    }

    void setLastExploreNewDate(long when) {
        this._lastExploreNew = when;
        if (this._exploreJob != null) {
            this._exploreJob.updateExploreSchedule();
        }
    }

    public Set<Hash> getExploreKeys() {
        if (!this._initialized || this.isClientDb()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this._exploreKeys);
    }

    public void removeFromExploreKeys(Collection<Hash> toRemove) {
        if (!this._initialized || this.isClientDb()) {
            return;
        }
        this._exploreKeys.removeAll(toRemove);
        this._context.statManager().addRateData("netDb.exploreKeySet", this._exploreKeys.size());
    }

    public void queueForExploration(Collection<Hash> keys) {
        if (!this._initialized || this.isClientDb()) {
            return;
        }
        Iterator<Hash> iter = keys.iterator();
        while (iter.hasNext() && this._exploreKeys.size() < 128) {
            this._exploreKeys.add(iter.next());
        }
        this._context.statManager().addRateData("netDb.exploreKeySet", this._exploreKeys.size());
    }

    @Override
    public synchronized void shutdown() {
        if (this._log.shouldWarn()) {
            this._log.warn("DB shutdown " + this);
        }
        this._initialized = false;
        if (!this._context.commSystem().isDummy() && !this.isClientDb() && this._context.router().getUptime() > 4260000L) {
            ExpireRoutersJob erj = new ExpireRoutersJob(this._context, this);
            erj.runJob();
        }
        this._context.jobQueue().removeJob(this._elj);
        if (this._erj != null) {
            this._context.jobQueue().removeJob(this._erj);
        }
        if (this._kb != null && !this.isClientDb()) {
            this._kb.clear();
        }
        if (this._ds != null) {
            this._ds.stop();
        }
        if (this._exploreKeys != null) {
            this._exploreKeys.clear();
        }
        if (this._negativeCache != null) {
            this._negativeCache.stop();
        }
        if (!this.isClientDb()) {
            this.blindCache().shutdown();
        }
    }

    @Override
    @Deprecated
    public synchronized void restart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rescan() {
        if (this.isInitialized()) {
            this._ds.rescan();
        }
    }

    String getDbDir() {
        return this._dbDir;
    }

    public boolean isClientDb() {
        return this._dbid != FloodfillNetworkDatabaseSegmentor.MAIN_DBID;
    }

    @Override
    public synchronized void startup() {
        if (this._log.shouldInfo()) {
            this._log.info("Starting up the " + this);
        }
        RouterInfo ri = this._context.router().getRouterInfo();
        String dbDir = this._context.getProperty(PROP_DB_DIR, DEFAULT_DB_DIR);
        this._kb = this.isClientDb() ? ((FloodfillNetworkDatabaseFacade)this._context.netDb()).getKBuckets() : new KBucketSet<Hash>(this._context, ri.getIdentity().getHash(), 24, 4, new RejectTrimmer());
        try {
            this._ds = !this.isClientDb() ? new PersistentDataStore(this._context, dbDir, this) : new TransientDataStore(this._context);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to initialize netdb storage", ioe);
        }
        this._dbDir = dbDir;
        this._negativeCache = new NegativeLookupCache(this._context);
        if (!this.isClientDb()) {
            this.blindCache().startup();
        }
        this.createHandlers();
        this._initialized = true;
        this._started = System.currentTimeMillis();
        long now = this._context.clock().now();
        this._elj.getTiming().setStartAfter(now + 660000L);
        this._context.jobQueue().addJob(this._elj);
        if (!this.isClientDb() && !this._context.commSystem().isDummy()) {
            boolean isFF = this._context.getBooleanProperty("router.floodfillParticipant");
            long down = this._context.router().getEstimatedDowntime();
            long delay = down == 0L || !isFF && down > 1800000L || isFF && down > 86400000L ? 4200000L : 600000L;
            this._erj.getTiming().setStartAfter(now + delay);
            this._context.jobQueue().addJob(this._erj);
        }
        if (!this.isClientDb()) {
            if (this._exploreJob == null) {
                this._exploreJob = new StartExplorersJob(this._context, this);
            }
            this._exploreJob.getTiming().setStartAfter(now + 600000L);
            this._context.jobQueue().addJob(this._exploreJob);
        }
        if (!this.isClientDb()) {
            PublishLocalRouterInfoJob plrij = new PublishLocalRouterInfoJob(this._context);
            this._context.jobQueue().addJob(plrij);
        }
    }

    protected void createHandlers() {
    }

    @Override
    public Set<Hash> findNearestRouters(Hash key, int maxNumRouters, Set<Hash> peersToIgnore) {
        if (this.isClientDb()) {
            this._log.warn("Subdb", new Exception("I did it"));
            return Collections.emptySet();
        }
        if (!this._initialized) {
            return Collections.emptySet();
        }
        return new HashSet<Hash>(this._peerSelector.selectNearest(key, maxNumRouters, peersToIgnore, this._kb));
    }

    @Override
    public Set<Hash> getAllRouters() {
        if (this.isClientDb()) {
            this._log.warn("Subdb", new Exception("I did it"));
            return Collections.emptySet();
        }
        if (!this._initialized) {
            return Collections.emptySet();
        }
        Set<Map.Entry<Hash, DatabaseEntry>> entries = this._ds.getMapEntries();
        HashSet<Hash> rv = new HashSet<Hash>(entries.size());
        for (Map.Entry<Hash, DatabaseEntry> entry : entries) {
            if (entry.getValue().getType() != 0) continue;
            rv.add(entry.getKey());
        }
        return rv;
    }

    @Override
    public int getKnownRouters() {
        if (this.isClientDb()) {
            this._log.warn("Subdb", new Exception("I did it"));
            return 0;
        }
        if (this._ds == null) {
            return 0;
        }
        int rv = 0;
        for (DatabaseEntry ds : this._ds.getEntries()) {
            if (ds.getType() != 0) continue;
            ++rv;
        }
        return rv;
    }

    @Override
    public int getKnownLeaseSets() {
        if (this._ds == null) {
            return 0;
        }
        int rv = 0;
        for (DatabaseEntry ds : this._ds.getEntries()) {
            if (!ds.isLeaseSet() || !((LeaseSet)ds).getReceivedAsPublished()) continue;
            ++rv;
        }
        return rv;
    }

    protected int getKBucketSetSize() {
        if (this._kb == null) {
            return 0;
        }
        return this._kb.size();
    }

    @Override
    public BlindData getBlindData(SigningPublicKey spk) {
        return this.blindCache().getData(spk);
    }

    @Override
    public void setBlindData(BlindData bd) {
        if (this._log.shouldWarn()) {
            this._log.warn("Adding to blind cache: " + bd);
        }
        this.blindCache().addToCache(bd);
    }

    @Override
    public List<BlindData> getBlindData() {
        return this.blindCache().getData();
    }

    @Override
    public boolean removeBlindData(SigningPublicKey spk) {
        return this.blindCache().removeBlindData(spk);
    }

    @Override
    public void routingKeyChanged() {
        this.blindCache().rollover();
        if (this._log.shouldInfo()) {
            this._log.info("UTC rollover, blind cache updated");
        }
    }

    @Override
    public DatabaseEntry lookupLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry rv = this._ds.get(key);
        if (rv == null) {
            return null;
        }
        int type = rv.getType();
        if (DatabaseEntry.isLeaseSet(type)) {
            LeaseSet ls = (LeaseSet)rv;
            if (ls.isCurrent(60000L)) {
                return rv;
            }
            key = this.blindCache().getHash(key);
            this.fail(key);
        } else if (type == 0) {
            try {
                if (this.validate((RouterInfo)rv) == null) {
                    return rv;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.fail(key);
        }
        return null;
    }

    @Override
    public DatabaseEntry lookupLocallyWithoutValidation(Hash key) {
        if (!this._initialized) {
            return null;
        }
        return this._ds.get(key);
    }

    @Override
    public void lookupLeaseSet(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs) {
        this.lookupLeaseSet(key, onFindJob, onFailedLookupJob, timeoutMs, null);
    }

    @Override
    public void lookupLeaseSet(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, Hash fromLocalDest) {
        if (!this._initialized) {
            return;
        }
        LeaseSet ls = this.lookupLeaseSetLocally(key);
        if (ls != null) {
            if (onFindJob != null) {
                this._context.jobQueue().addJob(onFindJob);
            }
        } else if (this.isNegativeCached(key)) {
            if (this._log.shouldInfo()) {
                this._log.info("Negative cached, not searching LS: " + key);
            }
            if (onFailedLookupJob != null) {
                this._context.jobQueue().addJob(onFailedLookupJob);
            }
        } else {
            key = this.blindCache().getHash(key);
            this.search(key, onFindJob, onFailedLookupJob, timeoutMs, true, fromLocalDest);
        }
    }

    @Override
    public void lookupLeaseSetRemotely(Hash key, Hash fromLocalDest) {
        if (!this._initialized) {
            return;
        }
        key = this.blindCache().getHash(key);
        if (this.isNegativeCached(key)) {
            return;
        }
        this.search(key, null, null, 20000L, true, fromLocalDest);
    }

    @Override
    public void lookupLeaseSetRemotely(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, Hash fromLocalDest) {
        if (!this._initialized) {
            return;
        }
        key = this.blindCache().getHash(key);
        if (this.isNegativeCached(key)) {
            return;
        }
        this.search(key, onFindJob, onFailedLookupJob, timeoutMs, true, fromLocalDest);
    }

    @Override
    public LeaseSet lookupLeaseSetLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry ds = this._ds.get(key);
        if (ds != null) {
            if (ds.isLeaseSet()) {
                LeaseSet ls = (LeaseSet)ds;
                if (ls.isCurrent(60000L)) {
                    return ls;
                }
                key = this.blindCache().getHash(key);
                this.fail(key);
                if (this._exploreKeys != null) {
                    this._exploreKeys.add(key);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public void lookupDestination(Hash key, Job onFinishedJob, long timeoutMs, Hash fromLocalDest) {
        if (!this._initialized) {
            return;
        }
        Destination d = this.lookupDestinationLocally(key);
        if (d != null) {
            this._context.jobQueue().addJob(onFinishedJob);
        } else if (this.isNegativeCached(key)) {
            if (this._log.shouldInfo()) {
                this._log.info("Negative cached, not searching dest: " + key);
            }
            this._context.jobQueue().addJob(onFinishedJob);
        } else {
            key = this.blindCache().getHash(key);
            this.search(key, onFinishedJob, onFinishedJob, timeoutMs, true, fromLocalDest);
        }
    }

    @Override
    public Destination lookupDestinationLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry ds = this._ds.get(key);
        if (ds != null) {
            if (ds.isLeaseSet()) {
                LeaseSet ls = (LeaseSet)ds;
                return ls.getDestination();
            }
        } else {
            return this._negativeCache.getBadDest(key);
        }
        return null;
    }

    @Override
    public void lookupRouterInfo(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs) {
        if (!this._initialized) {
            return;
        }
        RouterInfo ri = this.lookupRouterInfoLocally(key);
        if (ri != null) {
            if (onFindJob != null) {
                this._context.jobQueue().addJob(onFindJob);
            }
        } else if (this._context.banlist().isBanlistedForever(key)) {
            if (onFailedLookupJob != null) {
                this._context.jobQueue().addJob(onFailedLookupJob);
            }
        } else if (this.isNegativeCached(key)) {
            if (this._log.shouldInfo()) {
                this._log.info("Negative cached, not searching RI: " + key);
            }
            if (onFailedLookupJob != null) {
                this._context.jobQueue().addJob(onFailedLookupJob);
            }
        } else {
            this.search(key, onFindJob, onFailedLookupJob, timeoutMs, false);
        }
    }

    @Override
    public RouterInfo lookupRouterInfoLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        if (this.isClientDb()) {
            this._log.warn("Subdb", new Exception("I did it"));
            return null;
        }
        DatabaseEntry ds = this._ds.get(key);
        if (ds != null) {
            if (ds.getType() == 0) {
                boolean valid = true;
                try {
                    valid = null == this.validate((RouterInfo)ds);
                }
                catch (IllegalArgumentException iae) {
                    valid = false;
                }
                if (!valid) {
                    this.fail(key);
                    return null;
                }
                return (RouterInfo)ds;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LeaseSet localLeaseSet) throws IllegalArgumentException {
        RepublishLeaseSetJob j;
        int code;
        if (!this._initialized) {
            if (this._log.shouldWarn()) {
                this._log.warn("publish() before initialized: " + localLeaseSet, new Exception("I did it"));
            }
            return;
        }
        Hash h = localLeaseSet.getHash();
        try {
            this.store(h, localLeaseSet);
        }
        catch (IllegalArgumentException iae) {
            this._log.error("locally published leaseSet is not valid?", iae);
            throw iae;
        }
        if (!this._context.clientManager().shouldPublishLeaseSet(h)) {
            return;
        }
        if (this._context.router().gracefulShutdownInProgress() && ((code = this._context.router().scheduledGracefulExitCode()) == 2 || code == 3)) {
            return;
        }
        Map<Hash, RepublishLeaseSetJob> map = this._publishingLeaseSets;
        synchronized (map) {
            j = this._publishingLeaseSets.get(h);
            if (j == null) {
                j = new RepublishLeaseSetJob(this._context, this, h);
                this._publishingLeaseSets.put(h, j);
            }
        }
        long nextTime = Math.max(j.lastPublished() + 60000L, this._context.clock().now() + 3000L);
        this._context.jobQueue().removeJob(j);
        j.getTiming().setStartAfter(nextTime);
        if (this._log.shouldLog(20)) {
            this._log.info("Queueing to publish at " + new Date(nextTime) + ' ' + localLeaseSet);
        }
        this._context.jobQueue().addJob(j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopPublishing(Hash target) {
        Map<Hash, RepublishLeaseSetJob> map = this._publishingLeaseSets;
        synchronized (map) {
            this._publishingLeaseSets.remove(target);
        }
    }

    @Override
    public void publish(RouterInfo localRouterInfo) throws IllegalArgumentException {
        if (this.isClientDb()) {
            throw new IllegalArgumentException("RI publish to client DB");
        }
        if (!this._initialized) {
            return;
        }
        if (this._context.router().gracefulShutdownInProgress()) {
            return;
        }
        if (this._context.router().isHidden()) {
            return;
        }
        Hash h = localRouterInfo.getIdentity().getHash();
        this.store(h, localRouterInfo);
    }

    void routerInfoPublishSuccessful() {
        this._lastRIPublishTime = this._context.clock().now();
    }

    @Override
    public long getLastRouterInfoPublishTime() {
        return this._lastRIPublishTime;
    }

    public String validate(Hash key, LeaseSet leaseSet) throws UnsupportedCryptoException {
        long latest;
        long earliest;
        LeaseSet2 ls2;
        if (!key.equals(leaseSet.getHash())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid store attempt! key does not match leaseSet.destination!  key = " + key.toBase32() + ", leaseSet = " + leaseSet);
            }
            return "Key does not match leaseSet.destination - " + key.toBase64();
        }
        if (!leaseSet.verifySignature()) {
            this.processStoreFailure(key, leaseSet);
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid leaseSet signature! " + leaseSet);
            }
            return "Invalid leaseSet signature on " + key;
        }
        int type = leaseSet.getType();
        if (type == 5) {
            ls2 = (LeaseSet2)leaseSet;
            earliest = ls2.getPublished();
            latest = ls2.getExpires();
        } else if (type == 7) {
            ls2 = (LeaseSet2)leaseSet;
            earliest = Math.min(ls2.getEarliestLeaseDate(), ls2.getPublished());
            latest = Math.min(ls2.getLatestLeaseDate(), ls2.getExpires());
        } else {
            earliest = leaseSet.getEarliestLeaseDate();
            latest = leaseSet.getLatestLeaseDate();
        }
        long now = this._context.clock().now();
        if (earliest <= now - 600000L || latest <= now - 60000L) {
            String id;
            long age = now - earliest;
            Destination dest = leaseSet.getDestination();
            String string = id = dest != null ? dest.toBase32() : leaseSet.getHash().toBase32();
            if (this._log.shouldWarn()) {
                this._log.warn("Old leaseSet!  not storing it: " + id + " first exp. " + new Date(earliest) + " last exp. " + new Date(latest) + '\n' + leaseSet, new Exception("Rejecting store"));
            }
            if (leaseSet.getLeaseCount() == 0) {
                for (int i = 0; i < 3; ++i) {
                    this.lookupFailed(key);
                }
            }
            return "Expired leaseSet for " + id + " expired " + DataHelper.formatDuration(age) + " ago";
        }
        if (latest > now + 960000L && (leaseSet.getType() != 7 || latest > now + 65595000L)) {
            String id;
            long age = latest - now;
            Destination dest = leaseSet.getDestination();
            String string = id = dest != null ? dest.toBase32() : leaseSet.getHash().toBase32();
            if (this._log.shouldLog(30)) {
                this._log.warn("LeaseSet expires too far in the future: " + id + " expires " + DataHelper.formatDuration(age) + " from now");
            }
            return "Future expiring leaseSet for " + id + " expiring in " + DataHelper.formatDuration(age);
        }
        return null;
    }

    @Override
    public LeaseSet store(Hash key, LeaseSet leaseSet) throws IllegalArgumentException {
        LeaseSet2 ls2;
        String err;
        Destination dest;
        LeaseSet rv;
        if (!this._initialized) {
            return null;
        }
        try {
            rv = (LeaseSet)this._ds.get(key);
            if (rv != null && rv.getEarliestLeaseDate() >= leaseSet.getEarliestLeaseDate()) {
                Hash to;
                if (this._log.shouldDebug()) {
                    this._log.debug("Not storing older " + key);
                }
                if ((to = leaseSet.getReceivedBy()) != null) {
                    rv.setReceivedBy(to);
                } else if (leaseSet.getReceivedAsReply()) {
                    rv.setReceivedAsReply();
                }
                if (leaseSet.getReceivedAsPublished()) {
                    rv.setReceivedAsPublished();
                }
                return rv;
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Attempt to replace RI with " + leaseSet);
        }
        if (rv != null) {
            Destination d1 = leaseSet.getDestination();
            Destination d2 = rv.getDestination();
            if (d1 != null && d2 != null && !d1.equals(d2)) {
                throw new IllegalArgumentException("LS Hash collision");
            }
        }
        EncryptedLeaseSet encls = null;
        int type = leaseSet.getType();
        if (type == 5) {
            encls = (EncryptedLeaseSet)leaseSet;
            BlindData bd = this.blindCache().getReverseData(leaseSet.getSigningKey());
            if (bd != null) {
                String secret;
                if (this._log.shouldWarn()) {
                    this._log.warn("Found blind data for encls: " + bd);
                }
                if ((secret = bd.getSecret()) != null) {
                    encls.setSecret(secret);
                }
                if ((dest = bd.getDestination()) != null) {
                    encls.setDestination(dest);
                } else {
                    encls.setSigningKey(bd.getUnblindedPubKey());
                }
                if (bd.getAuthType() != 0) {
                    encls.setClientPrivateKey(bd.getAuthPrivKey());
                }
            } else if (encls.getDecryptedLeaseSet() == null && this._log.shouldWarn()) {
                this._log.warn("No blind data found for encls: " + leaseSet);
            }
        }
        if ((err = this.validate(key, leaseSet)) != null) {
            throw new IllegalArgumentException("Invalid store attempt - " + err);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Storing LS to the data store...");
        }
        this._ds.put(key, leaseSet);
        if (encls != null) {
            LeaseSet2 decls = encls.getDecryptedLeaseSet();
            if (decls != null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Successfully decrypted encls: " + decls);
                }
                dest = decls.getDestination();
                this.store(dest.getHash(), decls);
                this.blindCache().setBlinded(dest);
            }
        } else if ((type == 3 || type == 7) && (ls2 = (LeaseSet2)leaseSet).isBlindedWhenPublished() && (dest = leaseSet.getDestination()) != null) {
            this.blindCache().setBlinded(dest, null, null);
        }
        return rv;
    }

    private String validate(Hash key, RouterInfo routerInfo) throws IllegalArgumentException {
        if (!key.equals(routerInfo.getIdentity().getHash())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid store attempt! key does not match routerInfo.identity!  key = " + key + ", router = " + routerInfo);
            }
            return "Key does not match routerInfo.identity";
        }
        if (!routerInfo.isValid()) {
            this.processStoreFailure(key, routerInfo);
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid routerInfo signature!  forged router structure!  router = " + routerInfo);
            }
            return "Invalid routerInfo signature";
        }
        int id = routerInfo.getNetworkId();
        if (id != this._networkID) {
            if (id == -1) {
                this._context.banlist().banlistRouter(key, "No network specified", null, null, this._context.clock().now() + 2592000000L);
            } else {
                this._context.banlist().banlistRouterForever(key, "Not in our network: " + id);
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Not in our network: " + routerInfo, new Exception());
            }
            return "Not in our network";
        }
        FamilyKeyCrypto fkc = this._context.router().getFamilyKeyCrypto();
        if (fkc != null) {
            FamilyKeyCrypto.Result r = fkc.verify(routerInfo);
            switch (r) {
                case BAD_KEY: 
                case INVALID_SIG: {
                    Hash h = routerInfo.getHash();
                    if (h.equals(this._context.routerHash())) break;
                    return "Bad family " + (Object)((Object)r) + ' ' + h;
                }
                case NO_SIG: {
                    break;
                }
            }
        }
        return this.validate(routerInfo);
    }

    String validate(RouterInfo routerInfo) throws IllegalArgumentException {
        long age;
        long now = this._context.clock().now();
        boolean upLongEnough = this._context.router().getUptime() > 3600000L;
        long adjustedExpiration = this.floodfillEnabled() || this._ds != null && this._ds.size() > 5000 ? 3600000L : Math.min(97200000L, 3600000L + 8424000000L / (long)(this._kb.size() + 1));
        if (upLongEnough && !routerInfo.isCurrent(adjustedExpiration)) {
            age = now - routerInfo.getPublished();
            int existing = this._kb.size();
            if (existing >= 40) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Expired RI " + routerInfo.getIdentity().getHash(), new Exception());
                }
                return "Peer expired " + DataHelper.formatDuration(age) + " ago";
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Even though the peer is old, we have only " + existing + " peers left " + routerInfo);
            }
        }
        if ((age = now - routerInfo.getPublished()) < -120000L) {
            String skewString = DataHelper.formatDuration(0L - age);
            if (this._log.shouldLog(20)) {
                this._log.info("Peer " + routerInfo.getIdentity().getHash() + " published their routerInfo in the future?! [" + skewString + ']', new Exception());
            }
            if (upLongEnough && this._context.commSystem().countActivePeers() >= 50) {
                this._context.banlist().banlistRouter(routerInfo.getHash(), "Excessive clock skew: {0}", skewString, null, now + 3600000L);
            }
            return "Peer published " + skewString + " in the future?!";
        }
        if (!routerInfo.isCurrent(3240000L)) {
            if (routerInfo.getAddresses().isEmpty()) {
                return "Old peer with no addresses";
            }
            if (routerInfo.getCapabilities().indexOf(85) >= 0) {
                return "Old peer and thinks it is unreachable";
            }
            for (RouterAddress ra : routerInfo.getAddresses()) {
                if (ra.getOption("itag0") == null) continue;
                return "Old peer with SSU Introducers";
            }
        }
        if (upLongEnough && age > 172800000L) {
            return "Peer published " + DataHelper.formatDuration(age) + " ago";
        }
        if (upLongEnough && !routerInfo.isCurrent(4500000L) && routerInfo.getTargetAddresses("NTCP", "NTCP2").isEmpty()) {
            return "Peer published > 75m ago, SSU only without introducers";
        }
        return null;
    }

    @Override
    public RouterInfo store(Hash key, RouterInfo routerInfo) throws IllegalArgumentException {
        return this.store(key, routerInfo, true);
    }

    RouterInfo store(Hash key, RouterInfo routerInfo, boolean persist) throws IllegalArgumentException {
        RouterInfo rv;
        if (!this._initialized) {
            return null;
        }
        if (this.isClientDb()) {
            throw new IllegalArgumentException("RI store to client DB");
        }
        try {
            rv = (RouterInfo)this._ds.get(key, persist);
            if (rv != null && rv.getPublished() >= routerInfo.getPublished()) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Not storing older " + key);
                }
                return rv;
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Attempt to replace LS with " + routerInfo);
        }
        if (rv != null && !routerInfo.getIdentity().equals(rv.getIdentity())) {
            throw new IllegalArgumentException("RI Hash collision");
        }
        String err = this.validate(key, routerInfo);
        if (err != null) {
            throw new IllegalArgumentException("Invalid store attempt - " + err);
        }
        this._context.peerManager().setCapabilities(key, routerInfo.getCapabilities());
        this._ds.put(key, routerInfo, persist);
        if (rv == null) {
            this._kb.add(key);
        }
        return rv;
    }

    private void processStoreFailure(Hash h, DatabaseEntry entry) throws UnsupportedCryptoException {
        if (entry.getHash().equals(h)) {
            RouterInfo ri;
            RouterIdentity id;
            Certificate c;
            int etype = entry.getType();
            if (DatabaseEntry.isLeaseSet(etype)) {
                Certificate c2;
                LeaseSet ls = (LeaseSet)entry;
                Destination d = ls.getDestination();
                if (d != null && (c2 = d.getCertificate()).getCertificateType() == 5) {
                    try {
                        KeyCertificate kc = c2.toKeyCertificate();
                        SigType type = kc.getSigType();
                        if (type == null || !type.isAvailable() || type.getBaseAlgorithm() == SigAlgo.RSA) {
                            String stype;
                            this.failPermanently(d);
                            String string = stype = type != null ? type.toString() : Integer.toString(kc.getSigTypeCode());
                            if (this._log.shouldLog(30)) {
                                this._log.warn("Unsupported sig type " + stype + " for destination " + h);
                            }
                            throw new UnsupportedCryptoException("Sig type " + stype);
                        }
                    }
                    catch (DataFormatException kc) {}
                }
            } else if (etype == 0 && (c = (id = (ri = (RouterInfo)entry).getIdentity()).getCertificate()).getCertificateType() == 5) {
                try {
                    KeyCertificate kc = c.toKeyCertificate();
                    SigType type = kc.getSigType();
                    if (type == null || !type.isAvailable()) {
                        String stype = type != null ? type.toString() : Integer.toString(kc.getSigTypeCode());
                        this._context.banlist().banlistRouterForever(h, "Unsupported signature type " + stype);
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Unsupported sig type " + stype + " for router " + h);
                        }
                        throw new UnsupportedCryptoException("Sig type " + stype);
                    }
                }
                catch (DataFormatException dataFormatException) {
                    // empty catch block
                }
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Verify fail, cause unknown: " + entry);
        }
    }

    @Override
    public void fail(Hash dbEntry) {
        if (!this._initialized) {
            return;
        }
        DatabaseEntry o = this._ds.get(dbEntry);
        if (o == null) {
            if (this._kb != null) {
                this._kb.remove(dbEntry);
            }
            this._context.peerManager().removeCapabilities(dbEntry);
            return;
        }
        if (o.getType() == 0) {
            this.lookupBeforeDropping(dbEntry, (RouterInfo)o);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Dropping a lease: " + dbEntry);
        }
        if (!this.isClientDb()) {
            this._ds.remove(dbEntry, false);
        } else {
            this._ds.remove(dbEntry);
        }
    }

    protected void lookupBeforeDropping(Hash peer, RouterInfo info) {
        this.dropAfterLookupFailed(peer);
    }

    void dropAfterLookupFailed(Hash peer) {
        if (this.isClientDb()) {
            this._log.warn("Subdb", new Exception("I did it"));
            return;
        }
        this._context.peerManager().removeCapabilities(peer);
        this._negativeCache.cache(peer);
        this._kb.remove(peer);
        this._ds.remove(peer);
    }

    @Override
    public void unpublish(LeaseSet localLeaseSet) {
        if (!this._initialized) {
            return;
        }
        Hash h = localLeaseSet.getHash();
        DatabaseEntry data = this._ds.remove(h);
        if (data == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unpublished a lease we don't know...: " + localLeaseSet);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Unpublished a lease: " + h);
        }
    }

    SearchJob search(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, boolean isLease) {
        throw new UnsupportedOperationException();
    }

    SearchJob search(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, boolean isLease, Hash fromLocalDest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<LeaseSet> getLeases() {
        if (!this._initialized) {
            return null;
        }
        HashSet<LeaseSet> leases = new HashSet<LeaseSet>();
        for (DatabaseEntry o : this.getDataStore().getEntries()) {
            if (!o.isLeaseSet()) continue;
            leases.add((LeaseSet)o);
        }
        return leases;
    }

    @Override
    public Set<RouterInfo> getRouters() {
        if (this.isClientDb()) {
            this._log.warn("Subdb", new Exception("I did it"));
            return Collections.emptySet();
        }
        if (!this._initialized) {
            return null;
        }
        HashSet<RouterInfo> routers = new HashSet<RouterInfo>();
        for (DatabaseEntry o : this.getDataStore().getEntries()) {
            if (o.getType() != 0) continue;
            routers.add((RouterInfo)o);
        }
        return routers;
    }

    public int getPeerTimeout(Hash peer) {
        PeerProfile prof = this._context.profileOrganizer().getProfile(peer);
        double responseTime = 5100.0;
        if (prof != null && prof.getIsExpandedDB()) {
            responseTime = prof.getDbResponseTime().getRate(3600000L).getAvgOrLifetimeAvg();
            if (responseTime <= 0.0 || responseTime > 5100.0) {
                responseTime = 5100.0;
            } else if (responseTime < 2000.0) {
                responseTime = 2000.0;
            }
        }
        return 3 * (int)responseTime;
    }

    abstract void sendStore(Hash var1, DatabaseEntry var2, Job var3, Job var4, long var5, Set<Hash> var7);

    void lookupFailed(Hash key) {
        this._negativeCache.lookupFailed(key);
    }

    boolean isNegativeCached(Hash key) {
        boolean rv = this._negativeCache.isCached(key);
        if (rv) {
            this._context.statManager().addRateData("netDb.negativeCache", 1L);
        }
        return rv;
    }

    void failPermanently(Destination dest) {
        this._negativeCache.failPermanently(dest);
    }

    @Override
    public boolean isNegativeCachedForever(Hash key) {
        return this._negativeCache.getBadDest(key) != null;
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        if (this._kb == null) {
            return;
        }
        out.write(this._kb.toString().replace("\n", "<br>\n"));
    }

    public String toString() {
        if (!this.isClientDb()) {
            return "Main NetDB";
        }
        return "Client NetDB " + this._dbid.toBase64();
    }
}

