/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.dht;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.SendMessageOptions;
import net.i2p.client.datagram.I2PDatagramDissector;
import net.i2p.client.datagram.I2PDatagramMaker;
import net.i2p.client.datagram.I2PInvalidDatagramException;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.bencode.BDecoder;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.BEncoder;
import org.klomp.snark.bencode.InvalidBEncodingException;
import org.klomp.snark.dht.DHT;
import org.klomp.snark.dht.DHTNodes;
import org.klomp.snark.dht.DHTTracker;
import org.klomp.snark.dht.InfoHash;
import org.klomp.snark.dht.MsgID;
import org.klomp.snark.dht.NID;
import org.klomp.snark.dht.NodeInfo;
import org.klomp.snark.dht.NodeInfoComparator;
import org.klomp.snark.dht.PersistDHT;
import org.klomp.snark.dht.Token;

public class KRPC
implements I2PSessionMuxedListener,
DHT {
    private final I2PAppContext _context;
    private final Log _log;
    private final DHTTracker _tracker;
    private final DHTNodes _knownNodes;
    private final ConcurrentHashMap<MsgID, ReplyWaiter> _sentQueries;
    private final ConcurrentHashMap<Token, NodeInfo> _outgoingTokens;
    private final ConcurrentHashMap<NID, Token> _incomingTokens;
    private final Set<NID> _blacklist;
    private SimpleTimer2.TimedEvent _cleaner;
    private SimpleTimer2.TimedEvent _explorer;
    private final I2PSession _session;
    private final byte[] _myID;
    private final NID _myNID;
    private final NodeInfo _myNodeInfo;
    private final int _rPort;
    private final int _qPort;
    private final File _dhtFile;
    private final File _backupDhtFile;
    private volatile boolean _isRunning;
    private volatile boolean _hasBootstrapped;
    private final AtomicLong _rxPkts = new AtomicLong();
    private final AtomicLong _txPkts = new AtomicLong();
    private final AtomicLong _rxBytes = new AtomicLong();
    private final AtomicLong _txBytes = new AtomicLong();
    private long _started;
    private long _nodesLastSaved;
    public static final NID FAKE_NID = new NID(new byte[20]);
    private static final int K = 8;
    private static final int MAX_WANT = 36;
    private static final int REPLY_NONE = 0;
    private static final int REPLY_PONG = 1;
    private static final int REPLY_PEERS = 2;
    private static final int REPLY_NODES = 3;
    private static final int REPLY_NETWORK_FAIL = 4;
    public static final boolean SECURE_NID = true;
    private static final long MAX_TOKEN_AGE = 600000L;
    private static final long MAX_INBOUND_TOKEN_AGE = 480000L;
    private static final int MAX_OUTBOUND_TOKENS = 5000;
    private static final long MAX_MSGID_AGE = 120000L;
    private static final long DEFAULT_QUERY_TIMEOUT = 75000L;
    private static final long DEST_LOOKUP_TIMEOUT = 10000L;
    private static final long CLEAN_TIME = 63000L;
    private static final long EXPLORE_TIME = 877000L;
    private static final long BLACKLIST_CLEAN_TIME = 4020000L;
    private static final int BLACKLIST_MAX_PEERS = 500;
    private static final long NODES_SAVE_TIME = 10800000L;
    public static final String DHT_FILE_SUFFIX = ".dht.dat";
    private static final int SEND_CRYPTO_TAGS = 8;
    private static final int LOW_CRYPTO_TAGS = 4;

    public KRPC(I2PAppContext ctx, String baseName, I2PSession session) {
        this._context = ctx;
        this._session = session;
        this._log = ctx.logManager().getLog(KRPC.class);
        this._tracker = new DHTTracker(ctx);
        this._sentQueries = new ConcurrentHashMap();
        this._outgoingTokens = new ConcurrentHashMap();
        this._incomingTokens = new ConcurrentHashMap();
        this._blacklist = new ConcurrentHashSet<NID>();
        this._qPort = 6891 + ctx.random().nextInt(58634);
        this._rPort = this._qPort + 1;
        this._myNID = NodeInfo.generateNID(session.getMyDestination().calculateHash(), this._qPort, this._context.random());
        this._myID = this._myNID.getData();
        this._myNodeInfo = new NodeInfo(this._myNID, session.getMyDestination(), this._qPort);
        File conf = new File(ctx.getConfigDir(), baseName + ".config" + ".d");
        this._dhtFile = new File(conf, "i2psnark.dht.dat");
        if (baseName.equals("i2psnark")) {
            this._backupDhtFile = null;
        } else {
            File bconf = new File(ctx.getConfigDir(), "i2psnark.config.d");
            this._backupDhtFile = new File(bconf, "i2psnark.dht.dat");
        }
        this._knownNodes = new DHTNodes(ctx, this._myNID);
        this.start();
    }

    @Override
    public int size() {
        return this._knownNodes.size();
    }

    @Override
    public int getPort() {
        return this._qPort;
    }

    @Override
    public int getRPort() {
        return this._rPort;
    }

    @Override
    public void ping(Destination dest, int port) {
        NodeInfo nInfo = new NodeInfo(dest, port);
        this.sendPing(nInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void explore(NID target, int maxNodes, long maxWait, int parallel) {
        List<NodeInfo> nodes = this._knownNodes.findClosest(target, maxNodes);
        if (nodes.isEmpty()) {
            if (this._log.shouldLog(30)) {
                this._log.info("DHT is empty, cannot explore");
            }
            return;
        }
        TreeSet<NodeInfo> toTry = new TreeSet<NodeInfo>(new NodeInfoComparator(target));
        toTry.addAll(nodes);
        HashSet<NodeInfo> tried = new HashSet<NodeInfo>();
        if (this._log.shouldLog(20)) {
            this._log.info("Starting explore of " + target);
        }
        for (int i = 0; i < maxNodes && this._isRunning; ++i) {
            NodeInfo nInfo;
            try {
                nInfo = (NodeInfo)toTry.first();
            }
            catch (NoSuchElementException nsee) {
                break;
            }
            toTry.remove(nInfo);
            tried.add(nInfo);
            ReplyWaiter waiter = this.sendFindNode(nInfo, target);
            if (waiter == null) continue;
            ReplyWaiter replyWaiter = waiter;
            synchronized (replyWaiter) {
                try {
                    waiter.wait(maxWait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int replyType = waiter.getReplyCode();
            if (replyType == 0) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Got no reply");
                continue;
            }
            if (replyType == 3) {
                List reply = (List)waiter.getReplyObject();
                if (this._log.shouldLog(10)) {
                    this._log.debug("Got " + reply.size() + " nodes");
                }
                for (NodeInfo ni : reply) {
                    if (ni.equals(this._myNodeInfo) || toTry.contains(ni) && tried.contains(ni)) continue;
                    toTry.add(ni);
                }
                continue;
            }
            if (replyType == 4) break;
            if (!this._log.shouldLog(20)) continue;
            this._log.info("Got unexpected reply " + replyType + ": " + waiter.getReplyObject());
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Finished explore of " + target);
        }
    }

    public List<NodeInfo> findClosest(byte[] ih, int max) {
        List<NodeInfo> nodes = this._knownNodes.findClosest(new InfoHash(ih), max);
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Hash> getPeersAndAnnounce(byte[] ih, int max, long maxWait, int annMax, long annMaxWait, boolean isSeed, boolean noSeeds) {
        InfoHash iHash = new InfoHash(ih);
        Collection<Hash> rv = this._tracker.getPeers(iHash, max, noSeeds);
        rv.remove(this._myNodeInfo.getHash());
        if (rv.size() >= max) {
            return rv;
        }
        rv = new HashSet<Hash>(rv);
        long endTime = this._context.clock().now() + maxWait;
        int maxNodes = 30;
        List<NodeInfo> nodes = this._knownNodes.findClosest(iHash, maxNodes);
        NodeInfoComparator comp = new NodeInfoComparator(iHash);
        TreeSet<NodeInfo> toTry = new TreeSet<NodeInfo>(comp);
        TreeSet<NodeInfo> heardFrom = new TreeSet<NodeInfo>(comp);
        toTry.addAll(nodes);
        TreeSet<NodeInfo> tried = new TreeSet<NodeInfo>(comp);
        if (this._log.shouldLog(20)) {
            this._log.info("Starting getPeers for " + iHash + " (b64: " + new NID(ih) + ")  with " + nodes.size() + " to try");
        }
        for (int i = 0; i < maxNodes && this._isRunning; ++i) {
            ReplyWaiter waiter;
            NodeInfo nInfo;
            if (this._log.shouldLog(10)) {
                this._log.debug("Now to try: " + toTry);
            }
            try {
                nInfo = (NodeInfo)toTry.first();
            }
            catch (NoSuchElementException nsee) {
                break;
            }
            toTry.remove(nInfo);
            tried.add(nInfo);
            if (this._log.shouldLog(10)) {
                this._log.debug("Try " + i + ": " + nInfo);
            }
            if ((waiter = this.sendGetPeers(nInfo, iHash, noSeeds)) == null) continue;
            ReplyWaiter replyWaiter = waiter;
            synchronized (replyWaiter) {
                try {
                    waiter.wait(Math.max(30000L, Math.min(45000L, endTime - this._context.clock().now())));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int replyType = waiter.getReplyCode();
            if (replyType == 0) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Got no reply");
                }
            } else if (replyType == 1) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Got pong");
                }
            } else {
                List reply;
                if (replyType == 2) {
                    heardFrom.add(waiter.getSentTo());
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Got peers");
                    }
                    if (!(reply = (List)waiter.getReplyObject()).isEmpty()) {
                        for (int j = 0; j < reply.size() && rv.size() < max; ++j) {
                            Hash h = (Hash)reply.get(j);
                            if (h.equals(this._myNodeInfo.getHash())) continue;
                            rv.add(h);
                        }
                    }
                    if (!this._log.shouldLog(20)) break;
                    this._log.info("Finished get Peers, got " + reply.size() + " from DHT, returning " + rv.size());
                    break;
                }
                if (replyType == 3) {
                    heardFrom.add(waiter.getSentTo());
                    reply = (List)waiter.getReplyObject();
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Got " + reply.size() + " nodes");
                    }
                    for (NodeInfo ni : reply) {
                        if (ni.equals(this._myNodeInfo) || tried.contains(ni) || toTry.contains(ni)) continue;
                        toTry.add(ni);
                    }
                } else {
                    if (replyType == 4) break;
                    if (this._log.shouldLog(20)) {
                        this._log.info("Got unexpected reply " + replyType + ": " + waiter.getReplyObject());
                    }
                }
            }
            if (this._context.clock().now() > endTime) break;
            if (toTry.isEmpty() || heardFrom.isEmpty() || comp.compare((NodeInfo)toTry.first(), (NodeInfo)heardFrom.first()) < 0) continue;
            if (!this._log.shouldLog(20)) break;
            this._log.info("Finished get Peers, nothing closer to try after " + (i + 1));
            break;
        }
        if (!heardFrom.isEmpty()) {
            this.announce(ih, isSeed);
            int annCnt = 0;
            long start = this._context.clock().now();
            Iterator iter = heardFrom.iterator();
            while (iter.hasNext() && annCnt < annMax && this._isRunning) {
                long toWait;
                NodeInfo annTo = (NodeInfo)iter.next();
                if (this._log.shouldLog(20)) {
                    this._log.info("Announcing to closest from get peers: " + annTo);
                }
                long l = toWait = annMaxWait > 0L ? Math.min(annMaxWait, 60000L) : 0L;
                if (this.announce(ih, annTo, toWait, isSeed)) {
                    ++annCnt;
                }
                if (annMaxWait <= 0L || (annMaxWait -= this._context.clock().now() - start) >= 1000L) continue;
                break;
            }
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info("Announcing to closest in kbuckets after get peers failed");
            }
            this.announce(ih, annMax, annMaxWait, isSeed);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Finished get Peers, returning " + rv.size());
            this._log.info("Tried: " + tried);
            this._log.info("Heard from: " + heardFrom);
            this._log.info("Not tried: " + toTry);
        }
        return rv;
    }

    @Override
    public void announce(byte[] ih, boolean isSeed) {
        InfoHash iHash = new InfoHash(ih);
        this._tracker.announce(iHash, this._myNodeInfo.getHash(), isSeed);
    }

    @Override
    public void announce(byte[] ih, byte[] peerHash, boolean isSeed) {
        InfoHash iHash = new InfoHash(ih);
        this._tracker.announce(iHash, new Hash(peerHash), isSeed);
    }

    @Override
    public void unannounce(byte[] ih) {
        InfoHash iHash = new InfoHash(ih);
        this._tracker.unannounce(iHash, this._myNodeInfo.getHash());
    }

    @Override
    public int announce(byte[] ih, int max, long maxWait, boolean isSeed) {
        this.announce(ih, isSeed);
        int rv = 0;
        long start = this._context.clock().now();
        InfoHash iHash = new InfoHash(ih);
        List<NodeInfo> nodes = this._knownNodes.findClosest(iHash, max);
        if (this._log.shouldLog(20)) {
            this._log.info("Found " + nodes.size() + " to announce to for " + iHash);
        }
        for (NodeInfo nInfo : nodes) {
            if (!this._isRunning) break;
            if (this.announce(ih, nInfo, Math.min(maxWait, 60000L), isSeed)) {
                ++rv;
            }
            if ((maxWait -= this._context.clock().now() - start) >= 1000L) continue;
            break;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean announce(byte[] ih, NodeInfo nInfo, long maxWait, boolean isSeed) {
        ReplyWaiter waiter;
        InfoHash iHash = new InfoHash(ih);
        Token token = this._incomingTokens.get(nInfo.getNID());
        if (token != null && token.lastSeen() < this._context.clock().now() - 480000L) {
            token = null;
        }
        if (token == null) {
            if (maxWait <= 0L) {
                return false;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("No token for announce to " + nInfo + ", sending get_peers first");
            }
            if ((waiter = this.sendGetPeers(nInfo, iHash, false)) == null) {
                return false;
            }
            long start = this._context.clock().now();
            ReplyWaiter replyWaiter = waiter;
            synchronized (replyWaiter) {
                try {
                    waiter.wait(maxWait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int replyType = waiter.getReplyCode();
            if (replyType != 2 && replyType != 3) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Get_peers in announce() failed to " + nInfo);
                }
                return false;
            }
            token = this._incomingTokens.get(nInfo.getNID());
            if (token == null || token.lastSeen() < this._context.clock().now() - 480000L) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Huh? no token after get_peers in announce() succeeded to " + nInfo);
                }
                return false;
            }
            if ((maxWait -= this._context.clock().now() - start) < 1000L) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Ran out of time after get_peers in announce() succeeded to " + nInfo);
                }
                return false;
            }
        }
        if ((waiter = this.sendAnnouncePeer(nInfo, iHash, token, isSeed)) == null) {
            return false;
        }
        if (maxWait <= 0L) {
            return true;
        }
        ReplyWaiter start = waiter;
        synchronized (start) {
            try {
                waiter.wait(maxWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int replyType = waiter.getReplyCode();
        return replyType == 1;
    }

    public synchronized void start() {
        if (this._isRunning) {
            return;
        }
        if (this._log.shouldInfo()) {
            this._log.info("KRPC start", new Exception());
        }
        this._session.addMuxedSessionListener(this, 18, this._rPort);
        this._session.addMuxedSessionListener(this, 17, this._qPort);
        this._knownNodes.start();
        this._tracker.start();
        PersistDHT.loadDHT(this, this._dhtFile, this._backupDhtFile);
        this._isRunning = true;
        this._cleaner = new Cleaner();
        this._explorer = new Explorer(5000L);
        this._txPkts.set(0L);
        this._rxPkts.set(0L);
        this._txBytes.set(0L);
        this._rxBytes.set(0L);
        this._nodesLastSaved = this._started = this._context.clock().now();
    }

    @Override
    public synchronized void stop() {
        if (!this._isRunning) {
            return;
        }
        this._isRunning = false;
        if (this._log.shouldInfo()) {
            this._log.info("KRPC stop", new Exception());
        }
        this._cleaner.cancel();
        this._explorer.cancel();
        this._session.removeListener(17, this._qPort);
        this._session.removeListener(18, this._rPort);
        this._tracker.stop();
        boolean saveAll = this._context.clock().now() - this._started < 1200000L;
        PersistDHT.saveDHT(this._knownNodes, saveAll, this._dhtFile);
        this._knownNodes.stop();
        Iterator<ReplyWaiter> iter = this._sentQueries.values().iterator();
        while (iter.hasNext()) {
            ReplyWaiter waiter = iter.next();
            iter.remove();
            waiter.networkFail();
        }
        this._outgoingTokens.clear();
        this._incomingTokens.clear();
        this._blacklist.clear();
    }

    public void clear() {
        this._tracker.stop();
        this._knownNodes.clear();
    }

    @Override
    public String renderStatusHTML() {
        long uptime = Math.max(1000L, this._context.clock().now() - this._started);
        StringBuilder buf = new StringBuilder(256);
        buf.append("<br><hr class=\"debug\"><b>DHT DEBUG</b><br><hr class=\"debug\"><hr><b>TX:</b> ").append(this._txPkts.get()).append(" pkts / ").append(DataHelper.formatSize2(this._txBytes.get())).append("B / ").append(DataHelper.formatSize2Decimal(this._txBytes.get() * 1000L / uptime)).append("Bps<br><b>RX:</b> ").append(this._rxPkts.get()).append(" pkts / ").append(DataHelper.formatSize2(this._rxBytes.get())).append("B / ").append(DataHelper.formatSize2Decimal(this._rxBytes.get() * 1000L / uptime)).append("Bps<br><b>DHT Peers:</b> ").append(this._knownNodes.size()).append("<br><b>Blacklisted:</b> ").append(this._blacklist.size()).append("<br><b>Sent tokens:</b> ").append(this._outgoingTokens.size()).append("<br><b>Rcvd tokens:</b> ").append(this._incomingTokens.size()).append("<br><b>Pending queries:</b> ").append(this._sentQueries.size()).append("<br><br><hr class=\"debug\">");
        this._tracker.renderStatusHTML(buf);
        this._knownNodes.renderStatusHTML(buf);
        return buf.toString();
    }

    private ReplyWaiter sendPing(NodeInfo nInfo) {
        if (this._log.shouldLog(20)) {
            this._log.info("Sending ping to: " + nInfo);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("q", "ping");
        HashMap args = new HashMap();
        map.put("a", args);
        return this.sendQuery(nInfo, map, true);
    }

    private ReplyWaiter sendFindNode(NodeInfo nInfo, NID tID) {
        if (this._log.shouldLog(20)) {
            this._log.info("Sending find node of " + tID + " to: " + nInfo);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("q", "find_node");
        HashMap<String, byte[]> args = new HashMap<String, byte[]>();
        args.put("target", tID.getData());
        map.put("a", args);
        return this.sendQuery(nInfo, map, true);
    }

    private ReplyWaiter sendGetPeers(NodeInfo nInfo, InfoHash ih, boolean noSeeds) {
        if (this._log.shouldLog(20)) {
            this._log.info("Sending get peers of " + ih + " to: " + nInfo + " noseeds? " + noSeeds);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("q", "get_peers");
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("info_hash", ih.getData());
        if (noSeeds) {
            args.put("noseed", 1);
        }
        map.put("a", args);
        ReplyWaiter rv = this.sendQuery(nInfo, map, true);
        if (rv != null) {
            rv.setSentObject(ih);
        }
        return rv;
    }

    private ReplyWaiter sendAnnouncePeer(NodeInfo nInfo, InfoHash ih, Token token, boolean isSeed) {
        if (this._log.shouldLog(20)) {
            this._log.info("Sending announce of " + ih + " to: " + nInfo + " seed? " + isSeed);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("q", "announce_peer");
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("info_hash", ih.getData());
        args.put("port", 6881);
        args.put("token", token.getData());
        args.put("seed", isSeed ? 1 : 0);
        map.put("a", args);
        ReplyWaiter rv = this.sendQuery(nInfo, map, false);
        return rv;
    }

    private boolean sendPong(NodeInfo nInfo, MsgID msgID) {
        if (this._log.shouldLog(20)) {
            this._log.info("Sending pong to: " + nInfo);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap resps = new HashMap();
        map.put("r", resps);
        return this.sendResponse(nInfo, msgID, map);
    }

    private boolean sendNodes(NodeInfo nInfo, MsgID msgID, byte[] ids) {
        return this.sendNodes(nInfo, msgID, null, ids);
    }

    private boolean sendNodes(NodeInfo nInfo, MsgID msgID, Token token, byte[] ids) {
        if (this._log.shouldLog(20)) {
            this._log.info("Sending nodes to: " + nInfo);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, byte[]> resps = new HashMap<String, byte[]>();
        map.put("r", resps);
        if (token != null) {
            resps.put("token", token.getData());
        }
        resps.put("nodes", ids);
        return this.sendResponse(nInfo, msgID, map);
    }

    private boolean sendPeers(NodeInfo nInfo, MsgID msgID, Token token, List<byte[]> peers) {
        if (this._log.shouldLog(20)) {
            this._log.info("Sending peers to: " + nInfo);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> resps = new HashMap<String, Object>();
        map.put("r", resps);
        resps.put("token", token.getData());
        resps.put("values", peers);
        return this.sendResponse(nInfo, msgID, map);
    }

    private ReplyWaiter sendQuery(NodeInfo nInfo, Map<String, Object> map, boolean repliable) {
        boolean success;
        if (nInfo.equals(this._myNodeInfo)) {
            throw new IllegalArgumentException("don't send to ourselves");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending query to: " + nInfo);
        }
        if (nInfo.getDestination() == null) {
            NodeInfo newInfo = this._knownNodes.get(nInfo.getNID());
            if (newInfo != null && newInfo.getDestination() != null) {
                nInfo = newInfo;
            } else {
                if (!repliable) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Dropping non-repliable query, no dest for " + nInfo);
                    }
                    return null;
                }
                if (!this.lookupDest(nInfo)) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Dropping repliable query, no dest for " + nInfo);
                    }
                    this.timeout(nInfo);
                    return null;
                }
            }
        }
        map.put("y", "q");
        MsgID mID = new MsgID(this._context);
        map.put("t", mID.getData());
        Map args = (Map)map.get("a");
        if (args == null) {
            throw new IllegalArgumentException("no args");
        }
        args.put("id", this._myID);
        int port = nInfo.getPort();
        if (!repliable) {
            ++port;
        }
        if (success = this.sendMessage(nInfo.getDestination(), port, map, repliable)) {
            ReplyWaiter rv = new ReplyWaiter(mID, nInfo, null, null);
            this._sentQueries.put(mID, rv);
            return rv;
        }
        return null;
    }

    private boolean sendResponse(NodeInfo nInfo, MsgID msgID, Map<String, Object> map) {
        if (nInfo.equals(this._myNodeInfo)) {
            throw new IllegalArgumentException("don't send to ourselves");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending response to: " + nInfo);
        }
        if (nInfo.getDestination() == null) {
            NodeInfo newInfo = this._knownNodes.get(nInfo.getNID());
            if (newInfo != null && newInfo.getDestination() != null) {
                nInfo = newInfo;
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping response, no dest for " + nInfo);
                }
                return false;
            }
        }
        map.put("y", "r");
        map.put("t", msgID.getData());
        Map resps = (Map)map.get("r");
        if (resps == null) {
            throw new IllegalArgumentException("no resps");
        }
        resps.put("id", this._myID);
        return this.sendMessage(nInfo.getDestination(), nInfo.getPort() + 1, map, false);
    }

    private boolean sendError(NodeInfo nInfo, MsgID msgID, Map<String, Object> map) {
        if (nInfo.equals(this._myNodeInfo)) {
            throw new IllegalArgumentException("don't send to ourselves");
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Sending error to: " + nInfo);
        }
        if (nInfo.getDestination() == null) {
            NodeInfo newInfo = this._knownNodes.get(nInfo.getNID());
            if (newInfo != null && newInfo.getDestination() != null) {
                nInfo = newInfo;
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping sendError, no dest for " + nInfo);
                }
                return false;
            }
        }
        map.put("y", "e");
        map.put("t", msgID.getData());
        return this.sendMessage(nInfo.getDestination(), nInfo.getPort() + 1, map, false);
    }

    private boolean lookupDest(NodeInfo nInfo) {
        block6: {
            if (this._log.shouldLog(20)) {
                this._log.info("looking up dest for " + nInfo);
            }
            try {
                Destination dest = this._session.lookupDest(nInfo.getHash(), 10000L);
                if (dest != null) {
                    nInfo.setDestination(dest);
                    if (this._log.shouldLog(20)) {
                        this._log.info("lookup success for " + nInfo);
                    }
                    return true;
                }
            }
            catch (I2PSessionException ise) {
                if (!this._log.shouldLog(30)) break block6;
                this._log.warn("lookup fail", ise);
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("lookup fail for " + nInfo);
        }
        return false;
    }

    private boolean sendMessage(Destination dest, int toPort, Map<String, Object> map, boolean repliable) {
        I2PDatagramMaker dgMaker;
        if (this._session.isClosed()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Not sending message, session is closed");
            }
            return false;
        }
        if (dest.calculateHash().equals(this._myNodeInfo.getHash())) {
            throw new IllegalArgumentException("don't send to ourselves");
        }
        byte[] payload = BEncoder.bencode(map);
        if (this._log.shouldLog(10)) {
            ByteArrayInputStream bais = new ByteArrayInputStream(payload);
            try {
                this._log.debug("Sending to: " + dest.calculateHash() + ' ' + BDecoder.bdecode(bais).toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int fromPort = this._qPort;
        if (repliable && (payload = (dgMaker = new I2PDatagramMaker(this._session)).makeI2PDatagram(payload)) == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("DGM fail");
            }
            return false;
        }
        SendMessageOptions opts = new SendMessageOptions();
        opts.setDate(this._context.clock().now() + 60000L);
        opts.setTagsToSend(8);
        opts.setTagThreshold(4);
        opts.setGzip(false);
        if (!repliable) {
            opts.setSendLeaseSet(false);
        }
        try {
            boolean success = this._session.sendMessage(dest, payload, 0, payload.length, repliable ? 17 : 18, fromPort, toPort, opts);
            if (success) {
                this._txPkts.incrementAndGet();
                this._txBytes.addAndGet(payload.length);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("sendMessage fail");
            }
            return success;
        }
        catch (I2PSessionException ise) {
            if (this._log.shouldLog(30)) {
                this._log.warn("sendMessage fail", ise);
            }
            return false;
        }
    }

    private void receiveMessage(Destination from, int fromPort, byte[] payload) {
        block11: {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(payload);
                BDecoder dec = new BDecoder(is);
                BEValue bev = dec.bdecodeMap();
                Map<String, BEValue> map = bev.getMap();
                if (this._log.shouldLog(10)) {
                    this._log.debug("Got KRPC message " + bev.toString());
                }
                byte[] msgIDBytes = map.get("t").getBytes();
                MsgID mID = new MsgID(msgIDBytes);
                String type = map.get("y").getString();
                if (type.equals("q")) {
                    String method = map.get("q").getString();
                    Map<String, BEValue> args = map.get("a").getMap();
                    this.receiveQuery(mID, from, fromPort, method, args);
                    break block11;
                }
                if (type.equals("r") || type.equals("e")) {
                    ReplyWaiter waiter = this._sentQueries.remove(mID);
                    if (waiter != null) {
                        if (type.equals("r")) {
                            Map<String, BEValue> response = map.get("r").getMap();
                            this.receiveResponse(waiter, response);
                        } else {
                            List<BEValue> error = map.get("e").getList();
                            this.receiveError(waiter, error);
                        }
                    } else if (this._log.shouldLog(30)) {
                        this._log.warn("Rcvd msg with no one waiting: " + bev.toString());
                    }
                    break block11;
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unknown msg type rcvd: " + bev.toString());
                }
                throw new InvalidBEncodingException("Unknown type: " + type);
            }
            catch (Exception e) {
                if (!this._log.shouldLog(30)) break block11;
                this._log.warn("Receive error for message", e);
            }
        }
    }

    private void receiveQuery(MsgID msgID, Destination dest, int fromPort, String method, Map<String, BEValue> args) throws InvalidBEncodingException {
        NodeInfo nInfo;
        if (dest == null && !method.equals("announce_peer")) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Received non-announce_peer query method on reply port: " + method);
            }
            return;
        }
        byte[] nid = args.get("id").getBytes();
        if (dest != null) {
            nInfo = new NodeInfo(new NID(nid), dest, fromPort);
            nInfo = this.heardFrom(nInfo);
            nInfo.setDestination(dest);
        } else {
            nInfo = null;
        }
        if (method.equals("ping")) {
            this.receivePing(msgID, nInfo);
        } else if (method.equals("find_node")) {
            byte[] tid = args.get("target").getBytes();
            NID tID = new NID(tid);
            this.receiveFindNode(msgID, nInfo, tID);
        } else if (method.equals("get_peers")) {
            byte[] hash = args.get("info_hash").getBytes();
            InfoHash ih = new InfoHash(hash);
            boolean noSeeds = false;
            BEValue nos = args.get("noseed");
            if (nos != null) {
                noSeeds = nos.getInt() == 1;
            }
            this.receiveGetPeers(msgID, nInfo, ih, noSeeds);
        } else if (method.equals("announce_peer")) {
            byte[] hash = args.get("info_hash").getBytes();
            InfoHash ih = new InfoHash(hash);
            byte[] token = args.get("token").getBytes();
            boolean isSeed = false;
            BEValue iss = args.get("seed");
            if (iss != null) {
                isSeed = iss.getInt() == 1;
            }
            this.receiveAnnouncePeer(msgID, ih, token, isSeed);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Unknown query method rcvd: " + method);
        }
    }

    private NodeInfo heardFrom(NodeInfo nInfo) {
        if (nInfo.equals(this._myNodeInfo)) {
            return this._myNodeInfo;
        }
        NID nID = nInfo.getNID();
        NodeInfo oldInfo = this._knownNodes.get(nID);
        if (oldInfo == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Adding node: " + nInfo);
            }
            oldInfo = nInfo;
            NodeInfo nInfo2 = this._knownNodes.putIfAbsent(nInfo);
            if (nInfo2 != null) {
                oldInfo = nInfo2;
            }
        } else if (oldInfo.getDestination() == null && nInfo.getDestination() != null) {
            oldInfo.setDestination(nInfo.getDestination());
        }
        nID = oldInfo.getNID();
        nID.setLastSeen();
        if (this._blacklist.remove(nID) && this._log.shouldLog(20)) {
            this._log.info("UN-blacklisted: " + nID);
        }
        return oldInfo;
    }

    NodeInfo heardAbout(NodeInfo nInfo) {
        if (nInfo.equals(this._myNodeInfo)) {
            return this._myNodeInfo;
        }
        NodeInfo rv = this._knownNodes.putIfAbsent(nInfo);
        if (rv == null) {
            rv = nInfo;
            rv.getNID().setLastSeen();
        }
        return rv;
    }

    private void timeout(NodeInfo nInfo) {
        NID nid = nInfo.getNID();
        boolean remove = nid.timeout();
        if (remove) {
            if (this._knownNodes.remove(nid) != null && this._log.shouldLog(20)) {
                this._log.info("Removed after consecutive timeouts: " + nInfo);
            }
            nid.setLastSeen();
            boolean already = this._blacklist.remove(nid);
            this._blacklist.add(nid);
            if (!already && this._log.shouldLog(20)) {
                this._log.info("Blacklisted: " + nid);
            }
        }
    }

    private void receivePing(MsgID msgID, NodeInfo nInfo) throws InvalidBEncodingException {
        if (this._log.shouldLog(20)) {
            this._log.info("Rcvd ping from: " + nInfo);
        }
        this.sendPong(nInfo, msgID);
    }

    private void receiveFindNode(MsgID msgID, NodeInfo nInfo, NID tID) throws InvalidBEncodingException {
        NodeInfo peer;
        if (this._log.shouldLog(20)) {
            this._log.info("Rcvd find_node from: " + nInfo + " for: " + tID);
        }
        if ((peer = this._knownNodes.get(tID)) != null) {
            this.sendNodes(nInfo, msgID, peer.getData());
        } else {
            List<NodeInfo> nodes = this._knownNodes.findClosest(tID, 8);
            nodes.remove(nInfo);
            nodes.remove(this._myNodeInfo);
            byte[] nodeArray = new byte[nodes.size() * 54];
            for (int i = 0; i < nodes.size(); ++i) {
                System.arraycopy(nodes.get(i).getData(), 0, nodeArray, i * 54, 54);
            }
            this.sendNodes(nInfo, msgID, nodeArray);
        }
    }

    private void receiveGetPeers(MsgID msgID, NodeInfo nInfo, InfoHash ih, boolean noSeeds) throws InvalidBEncodingException {
        if (this._log.shouldLog(20)) {
            this._log.info("Rcvd get_peers from: " + nInfo + " for: " + ih + " noseeds? " + noSeeds);
        }
        Token token = new Token(this._context);
        this._outgoingTokens.put(token, nInfo);
        if (this._log.shouldLog(20)) {
            this._log.info("Stored new OB token: " + token + " for: " + nInfo);
        }
        List<Hash> peers = this._tracker.getPeers(ih, 36, noSeeds);
        boolean noPeers = peers.isEmpty();
        peers.remove(nInfo.getHash());
        if (noPeers) {
            List<NodeInfo> nodes = this._knownNodes.findClosest(ih, 8);
            nodes.remove(nInfo);
            nodes.remove(this._myNodeInfo);
            byte[] nodeArray = new byte[nodes.size() * 54];
            for (int i = 0; i < nodes.size(); ++i) {
                System.arraycopy(nodes.get(i).getData(), 0, nodeArray, i * 54, 54);
            }
            this.sendNodes(nInfo, msgID, token, nodeArray);
        } else {
            List<byte[]> hashes;
            if (peers.isEmpty()) {
                hashes = Collections.emptyList();
            } else {
                hashes = new ArrayList(peers.size());
                for (Hash peer : peers) {
                    hashes.add(peer.getData());
                }
            }
            this.sendPeers(nInfo, msgID, token, hashes);
        }
    }

    private void receiveAnnouncePeer(MsgID msgID, InfoHash ih, byte[] tok, boolean isSeed) throws InvalidBEncodingException {
        Token token = new Token(tok);
        NodeInfo nInfo = this._outgoingTokens.get(token);
        if (nInfo == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unknown token in announce_peer: " + token);
            }
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Rcvd announce from: " + nInfo + " for: " + ih + " seed? " + isSeed);
        }
        this._tracker.announce(ih, nInfo.getHash(), isSeed);
        this.sendPong(nInfo, msgID);
    }

    private void receiveResponse(ReplyWaiter waiter, Map<String, BEValue> response) throws InvalidBEncodingException {
        List<SimpleDataStructure> rlist;
        NodeInfo nInfo = waiter.getSentTo();
        BEValue nodes = response.get("nodes");
        BEValue values = response.get("values");
        if (nodes != null || values != null) {
            BEValue btok = response.get("token");
            InfoHash ih = (InfoHash)waiter.getSentObject();
            if (btok != null && ih != null) {
                byte[] tok = btok.getBytes();
                Token token = new Token(this._context, tok);
                this._incomingTokens.put(nInfo.getNID(), token);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Got token: " + token + ", must be a response to get_peers");
                }
            } else if (this._log.shouldLog(10)) {
                this._log.debug("No token and saved infohash, must be a response to find_node");
            }
        }
        if (nodes != null) {
            byte[] ids = nodes.getBytes();
            rlist = this.receiveNodes(nInfo, ids);
            waiter.gotReply(3, rlist);
        } else if (values != null) {
            List<BEValue> peers = values.getList();
            rlist = this.receivePeers(nInfo, peers);
            waiter.gotReply(2, rlist);
        } else {
            byte[] nid = response.get("id").getBytes();
            this.receivePong(nInfo, nid);
            waiter.gotReply(1, null);
        }
    }

    private List<NodeInfo> receiveNodes(NodeInfo nInfo, byte[] ids) throws InvalidBEncodingException {
        int max = Math.min(24, ids.length / 54);
        ArrayList<NodeInfo> rv = new ArrayList<NodeInfo>(max);
        for (int off = 0; off < ids.length && rv.size() < max; off += 54) {
            NodeInfo nInf = new NodeInfo(ids, off);
            if (this._blacklist.contains(nInf.getNID())) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Ignoring blacklisted " + nInf.getNID() + " from: " + nInfo);
                continue;
            }
            nInf = this.heardAbout(nInf);
            rv.add(nInf);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Rcvd nodes from: " + nInfo + ": " + DataHelper.toString(rv));
        }
        return rv;
    }

    private List<Hash> receivePeers(NodeInfo nInfo, List<BEValue> peers) throws InvalidBEncodingException {
        if (this._log.shouldLog(20)) {
            this._log.info("Rcvd peers from: " + nInfo);
        }
        int max = Math.min(72, peers.size());
        ArrayList<Hash> rv = new ArrayList<Hash>(max);
        for (BEValue bev : peers) {
            byte[] b = bev.getBytes();
            if (b.length != 32) {
                if (!this._log.shouldWarn()) continue;
                this._log.info("Bad peers entry from: " + nInfo);
                continue;
            }
            Hash h = Hash.create(b);
            rv.add(h);
            if (rv.size() < max) continue;
            break;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Rcvd " + peers.size() + " peers from: " + nInfo + ": " + DataHelper.toString(rv));
        }
        return rv;
    }

    private void receivePong(NodeInfo nInfo, byte[] nid) {
        if (nInfo.getNID().equals(FAKE_NID)) {
            NodeInfo newInfo = new NodeInfo(new NID(nid), nInfo.getHash(), nInfo.getPort());
            Destination dest = nInfo.getDestination();
            if (dest != null) {
                newInfo.setDestination(dest);
            }
            this.heardFrom(newInfo);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Rcvd pong from: " + nInfo);
        }
    }

    private void receiveError(ReplyWaiter waiter, List<BEValue> error) throws InvalidBEncodingException {
        int errorCode = error.get(0).getInt();
        String errorString = error.get(1).getString();
        if (this._log.shouldLog(30)) {
            this._log.warn("Rcvd error from: " + waiter + " num: " + errorCode + " msg: " + errorString);
        }
        waiter.gotReply(errorCode, errorString);
    }

    @Override
    public void messageAvailable(I2PSession session, int msgId, long size, int proto, int fromPort, int toPort) {
        block12: {
            try {
                byte[] payload = session.receiveMessage(msgId);
                if (payload == null) {
                    return;
                }
                this._rxPkts.incrementAndGet();
                this._rxBytes.addAndGet(payload.length);
                if (toPort == this._qPort) {
                    I2PDatagramDissector dgDiss = new I2PDatagramDissector();
                    dgDiss.loadI2PDatagram(payload);
                    payload = dgDiss.getPayload();
                    Destination from = dgDiss.getSender();
                    this.receiveMessage(from, fromPort, payload);
                } else if (toPort == this._rPort) {
                    this.receiveMessage(null, fromPort, payload);
                } else if (this._log.shouldLog(30)) {
                    this._log.warn("msg on bad port");
                }
            }
            catch (DataFormatException e) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("bad msg");
                }
            }
            catch (I2PInvalidDatagramException e) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("bad msg");
                }
            }
            catch (I2PSessionException e) {
                if (!this._log.shouldLog(30)) break block12;
                this._log.warn("bad msg");
            }
        }
    }

    @Override
    public void messageAvailable(I2PSession session, int msgId, long size) {
    }

    @Override
    public void reportAbuse(I2PSession session, int severity) {
    }

    @Override
    public void disconnected(I2PSession session) {
        if (this._log.shouldLog(30)) {
            this._log.warn("KRPC disconnected");
        }
        this.stop();
    }

    @Override
    public void errorOccurred(I2PSession session, String message, Throwable error) {
        if (this._log.shouldLog(30)) {
            this._log.warn("KRPC got error msg: ", error);
        }
    }

    private class Cleaner
    extends SimpleTimer2.TimedEvent {
        public Cleaner() {
            super(SimpleTimer2.getInstance(), 441000L);
        }

        @Override
        public void timeReached() {
            Token tok;
            if (!KRPC.this._isRunning) {
                return;
            }
            long now = KRPC.this._context.clock().now();
            if (KRPC.this._log.shouldLog(10)) {
                KRPC.this._log.debug("KRPC cleaner starting with " + KRPC.this._blacklist.size() + " in blacklist, " + KRPC.this._outgoingTokens.size() + " sent Tokens, " + KRPC.this._incomingTokens.size() + " rcvd Tokens");
            }
            int cnt = 0;
            long expire = now - 600000L;
            Iterator<Object> iter = ((ConcurrentHashMap.KeySetView)KRPC.this._outgoingTokens.keySet()).iterator();
            while (iter.hasNext()) {
                tok = (Token)iter.next();
                if (tok.lastSeen() < expire || cnt >= 5000) {
                    iter.remove();
                    continue;
                }
                ++cnt;
            }
            expire = now - 480000L;
            iter = KRPC.this._incomingTokens.values().iterator();
            while (iter.hasNext()) {
                tok = (Token)iter.next();
                if (tok.lastSeen() >= expire) continue;
                iter.remove();
            }
            expire = now - 4020000L;
            iter = KRPC.this._blacklist.iterator();
            while (iter.hasNext()) {
                NID nid = (NID)iter.next();
                if (nid.lastSeen() >= expire) continue;
                iter.remove();
            }
            int sz = KRPC.this._blacklist.size();
            if (sz > 500) {
                Iterator iter2 = KRPC.this._blacklist.iterator();
                while (iter2.hasNext() && sz > 500) {
                    iter2.next();
                    iter2.remove();
                    --sz;
                }
            }
            if (now - KRPC.this._nodesLastSaved > 10800000L) {
                PersistDHT.saveDHT(KRPC.this._knownNodes, false, KRPC.this._dhtFile);
                KRPC.this._nodesLastSaved = now;
            }
            if (KRPC.this._log.shouldLog(10)) {
                KRPC.this._log.debug("KRPC cleaner done, now with " + KRPC.this._blacklist.size() + " in blacklist, " + KRPC.this._outgoingTokens.size() + " sent Tokens, " + KRPC.this._incomingTokens.size() + " rcvd Tokens, " + KRPC.this._knownNodes.size() + " known peers, " + KRPC.this._sentQueries.size() + " queries awaiting response");
            }
            this.schedule(63000L);
        }
    }

    private class Explorer
    extends SimpleTimer2.TimedEvent {
        public Explorer(long delay) {
            super(SimpleTimer2.getInstance(), delay);
        }

        @Override
        public void timeReached() {
            if (!KRPC.this._isRunning) {
                return;
            }
            if (KRPC.this._knownNodes.size() > 0) {
                new I2PAppThread(new ExplorerThread(), "DHT Explore", true).start();
            } else {
                this.schedule(60000L);
            }
        }
    }

    private class ExplorerThread
    implements Runnable {
        private ExplorerThread() {
        }

        @Override
        public void run() {
            if (!KRPC.this._isRunning) {
                return;
            }
            if (!KRPC.this._hasBootstrapped) {
                if (KRPC.this._log.shouldLog(20)) {
                    KRPC.this._log.info("Bootstrap start, size: " + KRPC.this._knownNodes.size());
                }
                KRPC.this.explore(KRPC.this._myNID, 8, 60000L, 1);
                if (KRPC.this._log.shouldLog(20)) {
                    KRPC.this._log.info("Bootstrap done, size: " + KRPC.this._knownNodes.size());
                }
                KRPC.this._hasBootstrapped = true;
            }
            if (!KRPC.this._isRunning) {
                return;
            }
            if (KRPC.this._log.shouldLog(20)) {
                KRPC.this._log.info("Explore start. size: " + KRPC.this._knownNodes.size());
            }
            List<NID> keys = KRPC.this._knownNodes.getExploreKeys();
            for (NID nid : keys) {
                KRPC.this.explore(nid, 8, 60000L, 1);
                if (KRPC.this._isRunning) continue;
                return;
            }
            if (KRPC.this._log.shouldLog(20)) {
                KRPC.this._log.info("Explore of " + keys.size() + " buckets done, new size: " + KRPC.this._knownNodes.size());
            }
            KRPC.this._explorer = new Explorer(877000L);
        }
    }

    private class ReplyWaiter
    extends SimpleTimer2.TimedEvent {
        private final MsgID mid;
        private final NodeInfo sentTo;
        private final Runnable onReply;
        private final Runnable onTimeout;
        private volatile int replyCode;
        private Object sentObject;
        private Object replyObject;

        public ReplyWaiter(MsgID mID, NodeInfo nInfo, Runnable onReply, Runnable onTimeout) {
            super(SimpleTimer2.getInstance(), 75000L);
            this.mid = mID;
            this.sentTo = nInfo;
            this.onReply = onReply;
            this.onTimeout = onTimeout;
        }

        public NodeInfo getSentTo() {
            return this.sentTo;
        }

        public void setSentObject(Object o) {
            this.sentObject = o;
        }

        public Object getSentObject() {
            return this.sentObject;
        }

        public Object getReplyObject() {
            return this.replyObject;
        }

        public int getReplyCode() {
            return this.replyCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gotReply(int code, Object o) {
            this.cancel();
            KRPC.this._sentQueries.remove(this.mid);
            this.replyObject = o;
            this.replyCode = code;
            if (!this.sentTo.getNID().equals(FAKE_NID)) {
                KRPC.this.heardFrom(this.sentTo);
            }
            if (this.onReply != null) {
                this.onReply.run();
            }
            ReplyWaiter replyWaiter = this;
            synchronized (replyWaiter) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            KRPC.this._sentQueries.remove(this.mid);
            if (this.onTimeout != null) {
                this.onTimeout.run();
            }
            KRPC.this.timeout(this.sentTo);
            if (KRPC.this._log.shouldLog(20)) {
                KRPC.this._log.warn("timeout waiting for reply from " + this.sentTo);
            }
            ReplyWaiter replyWaiter = this;
            synchronized (replyWaiter) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void networkFail() {
            this.cancel();
            this.replyCode = 4;
            ReplyWaiter replyWaiter = this;
            synchronized (replyWaiter) {
                this.notifyAll();
            }
        }
    }
}

