/*
 * Decompiled with CFR 0.152.
 */
package net.metanotion.io.block.index;

import java.io.IOException;
import net.metanotion.io.Serializer;
import net.metanotion.io.block.BlockFile;
import net.metanotion.io.block.index.BSkipList;
import net.metanotion.io.block.index.BSkipSpan;
import net.metanotion.util.skiplist.SkipList;
import net.metanotion.util.skiplist.SkipSpan;

public class IBSkipSpan<K extends Comparable<? super K>, V>
extends BSkipSpan<K, V> {
    private K firstKey;

    @Override
    public SkipSpan<K, V> newInstance(SkipList<K, V> sl) {
        if (this.bf.log.shouldLog(10)) {
            this.bf.log.debug("Splitting page " + this.page + " containing " + this.nKeys + "/" + this.spanSize);
        }
        try {
            int newPage = this.bf.allocPage();
            IBSkipSpan.init(this.bf, newPage, this.bf.spanSize);
            IBSkipSpan<K, V> rv = new IBSkipSpan<K, V>(this.bf, (BSkipList)sl, newPage, this.keySer, this.valSer);
            rv.keys = new Comparable[this.bf.spanSize];
            rv.vals = new Object[this.bf.spanSize];
            return rv;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error creating database page", ioe);
        }
    }

    @Override
    public void flush() {
        super.flush();
        if (this.nKeys <= 0) {
            this.firstKey = null;
        }
        if (this.keys != null) {
            if (this.nKeys > 0) {
                this.firstKey = this.keys[0];
            }
            this.keys = null;
            this.vals = null;
            if (this.bf.log.shouldLog(10)) {
                this.bf.log.debug("Flushed data for page " + this.page + " containing " + this.nKeys + "/" + this.spanSize);
            }
        } else if (this.bf.log.shouldLog(10)) {
            this.bf.log.debug("Flushed pointers for for unloaded page " + this.page + " containing " + this.nKeys + "/" + this.spanSize);
        }
    }

    @Override
    protected void loadData() throws IOException {
        super.loadData();
        if (this.nKeys > 0) {
            this.firstKey = this.keys[0];
        }
        if (this.bf.log.shouldLog(10)) {
            this.bf.log.debug("Loaded data for page " + this.page + " containing " + this.nKeys + "/" + this.spanSize + " first key: " + String.valueOf(this.firstKey));
        }
    }

    private void loadFirstKey() throws IOException {
        if (this.nKeys <= 0) {
            return;
        }
        int curPage = this.page;
        int[] curNextPage = new int[]{this.overflowPage};
        int[] pageCounter = new int[]{20};
        int ksz = this.bf.file.readUnsignedShort();
        this.bf.file.skipBytes(2);
        pageCounter[0] = pageCounter[0] + 4;
        byte[] k = new byte[ksz];
        curPage = this.bf.readMultiPageData(k, curPage, pageCounter, curNextPage);
        this.firstKey = (Comparable)this.keySer.construct(k);
        if (this.firstKey == null) {
            this.bf.log.error("Null deserialized first key in page " + curPage);
            this.repair(1);
        }
        if (this.bf.log.shouldLog(10)) {
            this.bf.log.debug("Loaded header for page " + this.page + " containing " + this.nKeys + "/" + this.spanSize + " first key: " + String.valueOf(this.firstKey));
        }
    }

    private void seekData() throws IOException {
        if (this.isKilled) {
            throw new IOException("Already killed! " + String.valueOf(this));
        }
        BlockFile.pageSeek(this.bf.file, this.page);
        int magic = this.bf.file.readInt();
        if (magic != 1399873902) {
            throw new IOException("Bad SkipSpan magic number 0x" + Integer.toHexString(magic) + " on page " + this.page);
        }
        this.bf.file.skipBytes(16);
    }

    void seekAndLoadData() throws IOException {
        this.seekData();
        this.loadData();
    }

    private V getData(K key) throws IOException {
        this.seekData();
        int curPage = this.page;
        int[] curNextPage = new int[]{this.overflowPage};
        int[] pageCounter = new int[]{20};
        int fail = 0;
        for (int i = 0; i < this.nKeys; ++i) {
            if (pageCounter[0] + 4 > 1024) {
                BlockFile.pageSeek(this.bf.file, curNextPage[0]);
                int magic = this.bf.file.readInt();
                if (magic != 1129270868) {
                    this.bf.log.error("Lost " + (this.nKeys - i) + " entries - Bad SkipSpan magic number 0x" + Integer.toHexString(magic) + " on page " + curNextPage[0]);
                    this.lostEntries(i, curPage);
                    break;
                }
                curPage = curNextPage[0];
                curNextPage[0] = this.bf.file.readUnsignedInt();
                pageCounter[0] = 8;
            }
            int ksz = this.bf.file.readUnsignedShort();
            int vsz = this.bf.file.readUnsignedShort();
            pageCounter[0] = pageCounter[0] + 4;
            byte[] k = new byte[ksz];
            try {
                curPage = this.bf.readMultiPageData(k, curPage, pageCounter, curNextPage);
            }
            catch (IOException ioe) {
                this.bf.log.error("Lost " + (this.nKeys - i) + " entries - Error loading " + String.valueOf(this) + " on page " + curPage, ioe);
                this.lostEntries(i, curPage);
                break;
            }
            Comparable ckey = (Comparable)this.keySer.construct(k);
            if (ckey == null) {
                curPage = this.bf.skipMultiPageBytes(vsz, curPage, pageCounter, curNextPage);
                this.bf.log.error("Null deserialized key in entry " + i + " page " + curPage);
                ++fail;
                continue;
            }
            int diff = ckey.compareTo(key);
            if (diff == 0) {
                byte[] v = new byte[vsz];
                try {
                    curPage = this.bf.readMultiPageData(v, curPage, pageCounter, curNextPage);
                }
                catch (IOException ioe) {
                    this.bf.log.error("Lost " + (this.nKeys - i) + " entries - Error loading " + String.valueOf(this) + " on page " + curPage, ioe);
                    this.lostEntries(i, curPage);
                    break;
                }
                Object rv = this.valSer.construct(v);
                if (rv == null) {
                    this.bf.log.error("Null deserialized value in entry " + i + " page " + curPage + " key=" + String.valueOf(ckey));
                    ++fail;
                }
                if (fail > 0) {
                    this.repair(fail);
                }
                return (V)rv;
            }
            if (diff > 0) {
                if (fail > 0) {
                    this.repair(fail);
                }
                return null;
            }
            curPage = this.bf.skipMultiPageBytes(vsz, curPage, pageCounter, curNextPage);
        }
        if (fail > 0) {
            this.repair(fail);
        }
        return null;
    }

    private void repair(int fail) {
    }

    private IBSkipSpan(BlockFile bf, BSkipList<K, V> bsl) {
        super(bf, bsl);
    }

    public IBSkipSpan(BlockFile bf, BSkipList<K, V> bsl, int spanPage, Serializer<K> key, Serializer<V> val) throws IOException {
        super(bf, bsl);
        IBSkipSpan temp;
        if (bf.log.shouldLog(10)) {
            bf.log.debug("New ibss page " + spanPage);
        }
        BSkipSpan.loadInit(this, bf, bsl, spanPage, key, val);
        this.loadFirstKey();
        this.next = null;
        this.prev = null;
        IBSkipSpan bss = this;
        int np = this.nextPage;
        while (np != 0) {
            temp = (IBSkipSpan)bsl.spanHash.get(np);
            if (temp != null) {
                bss.next = temp;
                break;
            }
            bss.next = new IBSkipSpan<K, V>(bf, bsl);
            bss.next.next = null;
            bss.next.prev = bss;
            K previousFirstKey = bss.firstKey;
            bss = (IBSkipSpan)bss.next;
            BSkipSpan.loadInit(bss, bf, bsl, np, key, val);
            bss.loadFirstKey();
            K nextFirstKey = bss.firstKey;
            if (previousFirstKey == null || nextFirstKey == null || previousFirstKey.compareTo(nextFirstKey) >= 0) {
                bf.log.error("Corrupt database, span out of order " + ((BSkipSpan)bss.prev).page + " first key " + String.valueOf(previousFirstKey) + " next page " + bss.page + " first key " + String.valueOf(nextFirstKey));
            }
            np = bss.nextPage;
        }
        bss = this;
        np = this.prevPage;
        while (np != 0) {
            temp = (IBSkipSpan)bsl.spanHash.get(np);
            if (temp != null) {
                bss.prev = temp;
                break;
            }
            bss.prev = new IBSkipSpan<K, V>(bf, bsl);
            bss.prev.next = bss;
            bss.prev.prev = null;
            K nextFirstKey = bss.firstKey;
            bss = (IBSkipSpan)bss.prev;
            BSkipSpan.loadInit(bss, bf, bsl, np, key, val);
            bss.loadFirstKey();
            K previousFirstKey = bss.firstKey;
            if (previousFirstKey == null || nextFirstKey == null || previousFirstKey.compareTo(nextFirstKey) >= 0) {
                bf.log.error("Corrupt database, span out of order " + bss.page + " first key " + String.valueOf(previousFirstKey) + " next page " + ((BSkipSpan)bss.next).page + " first key " + String.valueOf(nextFirstKey));
            }
            np = bss.prevPage;
        }
    }

    @Override
    public K firstKey() {
        return this.firstKey;
    }

    @Override
    public SkipSpan<K, V> getSpan(K key, int[] search) {
        try {
            this.seekAndLoadData();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading database", ioe);
        }
        SkipSpan rv = super.getSpan(key, search);
        this.keys = null;
        this.vals = null;
        return rv;
    }

    @Override
    public V get(K key) {
        try {
            if (this.nKeys == 0) {
                return null;
            }
            if (this.next != null && this.next.firstKey().compareTo(key) <= 0) {
                return this.next.get(key);
            }
            return this.getData(key);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading database", ioe);
        }
    }

    @Override
    public SkipSpan<K, V> put(K key, V val, SkipList<K, V> sl) {
        try {
            this.seekAndLoadData();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading database", ioe);
        }
        SkipSpan<K, V> rv = super.put(key, val, sl);
        return rv;
    }

    @Override
    public Object[] remove(K key, SkipList<K, V> sl) {
        if (this.bf.log.shouldLog(10)) {
            this.bf.log.debug("Remove " + String.valueOf(key) + " in " + String.valueOf(this));
        }
        if (this.nKeys <= 0) {
            return null;
        }
        try {
            this.seekAndLoadData();
            if (this.nKeys == 1 && this.prev == null && this.next != null && this.next.keys == null) {
                if (this.bf.log.shouldLog(20)) {
                    this.bf.log.info("Loading next data for remove");
                }
                ((IBSkipSpan)this.next).seekAndLoadData();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading database attempting to remove " + String.valueOf(key), ioe);
        }
        Object[] rv = super.remove(key, sl);
        return rv;
    }
}

