/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.servlet;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.i2p.data.DataHelper;
import org.eclipse.jetty.ee8.nested.ResourceService;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollators;
import org.eclipse.jetty.util.resource.Resources;

public class I2PResourceService
extends ResourceService {
    private static final String FORMAT = "yyyy-MM-dd HH:mm";

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, String pathInContext) throws IOException {
        if (!this.isDirAllowed()) {
            response.sendError(403);
            return;
        }
        String base = URIUtil.addEncodedPaths((String)request.getRequestURI(), (String)"/");
        String dir = I2PResourceService.getListHTML(resource, base, pathInContext.length() > 1, request.getQueryString());
        if (dir == null) {
            response.sendError(403, "No directory");
            return;
        }
        byte[] data = dir.getBytes(StandardCharsets.UTF_8);
        response.setContentType("text/html;charset=utf-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }

    private static String getListHTML(Resource resource, String base, boolean parent, String query) throws IOException {
        Comparator sort;
        if ((base = URIUtil.normalizePath((String)base)) == null) {
            return null;
        }
        if (!Resources.isReadableDirectory((Resource)resource)) {
            return null;
        }
        List listing = resource.list().stream().filter(I2PResourceService.distinctBy(Resource::getFileName)).collect(Collectors.toCollection(ArrayList::new));
        boolean sortOrderAscending = true;
        String sortColumn = "N";
        if (query != null) {
            Fields params = new Fields(true);
            UrlEncoded.decodeUtf8To((String)query, (int)0, (int)query.length(), (Fields)params);
            String paramO = params.getValue("O");
            String paramC = params.getValue("C");
            if (StringUtil.isNotBlank((String)paramO)) {
                switch (paramO) {
                    case "A": {
                        sortOrderAscending = true;
                        break;
                    }
                    case "D": {
                        sortOrderAscending = false;
                    }
                }
            }
            if (StringUtil.isNotBlank((String)paramC) && (paramC.equals("N") || paramC.equals("M") || paramC.equals("S"))) {
                sortColumn = paramC;
            }
        }
        switch (sortColumn) {
            case "M": {
                sort = ResourceCollators.byLastModified((boolean)sortOrderAscending);
                break;
            }
            case "S": {
                sort = new SizeComparator();
                if (sortOrderAscending) break;
                sort = sort.reversed();
                break;
            }
            default: {
                sort = new FileComparator();
                if (sortOrderAscending) break;
                sort = sort.reversed();
            }
        }
        DataHelper.sort((List)listing, (Comparator)sort);
        String decodedBase = URIUtil.decodePath((String)base);
        String title = "Directory: " + I2PResourceService.deTag(decodedBase);
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
        buf.append("<head>\n");
        buf.append("<link href=\"jetty-dir.css\" rel=\"stylesheet\" />\n");
        buf.append("<title>");
        buf.append(title);
        buf.append("</title>\n");
        buf.append("</head>\n");
        buf.append("<body>\n");
        buf.append("<h1 class=\"title\">").append(title).append("</h1>\n");
        String ARROW_DOWN = "&nbsp; &#8681;";
        String ARROW_UP = "&nbsp; &#8679;";
        buf.append("<table class=\"listing\">\n");
        buf.append("<thead>\n");
        String arrow = "";
        String order = "A";
        if (sortColumn.equals("N")) {
            if (sortOrderAscending) {
                order = "D";
                arrow = "&nbsp; &#8679;";
            } else {
                order = "A";
                arrow = "&nbsp; &#8681;";
            }
        }
        buf.append("<tr><th class=\"name\"><a href=\"?C=N&amp;O=").append(order).append("\">");
        buf.append("Name").append(arrow);
        buf.append("</a></th>");
        arrow = "";
        order = "A";
        if (sortColumn.equals("M")) {
            if (sortOrderAscending) {
                order = "D";
                arrow = "&nbsp; &#8679;";
            } else {
                order = "A";
                arrow = "&nbsp; &#8681;";
            }
        }
        buf.append("<th class=\"lastmodified\"><a href=\"?C=M&amp;O=").append(order).append("\">");
        buf.append("Last Modified (UTC)").append(arrow);
        buf.append("</a></th>");
        arrow = "";
        order = "A";
        if (sortColumn.equals("S")) {
            if (sortOrderAscending) {
                order = "D";
                arrow = "&nbsp; &#8679;";
            } else {
                order = "A";
                arrow = "&nbsp; &#8681;";
            }
        }
        buf.append("<th class=\"size\"><a href=\"?C=S&amp;O=").append(order).append("\">");
        buf.append("Size").append(arrow);
        buf.append("</a></th></tr>\n");
        buf.append("</thead>\n");
        buf.append("<tbody>\n");
        String encodedBase = I2PResourceService.hrefEncodeURI(base);
        if (parent) {
            buf.append("<tr><td class=\"name\"><a href=\"");
            buf.append(URIUtil.addPaths((String)encodedBase, (String)"../"));
            buf.append("\">Parent Directory</a></td>");
            buf.append("<td class=\"lastmodified\">-</td>");
            buf.append("<td class=\"size\">-</td>");
            buf.append("</tr>\n");
        }
        SimpleDateFormat dfmt = new SimpleDateFormat(FORMAT, Locale.UK);
        TimeZone utc = TimeZone.getTimeZone("GMT");
        dfmt.setTimeZone(utc);
        for (Resource item : listing) {
            Object name = item.getFileName();
            if (StringUtil.isBlank((String)name)) continue;
            boolean isDir = item.isDirectory();
            if (isDir && !((String)name).endsWith("/")) {
                name = (String)name + "/";
            }
            buf.append("<tr><td class=\"name\"><a href=\"");
            String path = URIUtil.addEncodedPaths((String)encodedBase, (String)URIUtil.encodePath((String)name));
            buf.append(path);
            buf.append("\">");
            buf.append(I2PResourceService.deTag((String)name));
            buf.append("&nbsp;</a></td>");
            buf.append("<td class=\"lastmodified\">");
            Instant lastModified = item.lastModified();
            buf.append(dfmt.format(new Date(lastModified.toEpochMilli())));
            buf.append("&nbsp;</td>");
            buf.append("<td class=\"size\">");
            if (isDir) {
                buf.append('-');
            } else {
                long length = item.length();
                if (length >= 0L) {
                    buf.append(String.format("%,d bytes", item.length()));
                } else {
                    buf.append('-');
                }
            }
            buf.append("</td></tr>\n");
        }
        buf.append("</tbody>\n");
        buf.append("</table>\n");
        buf.append("</body></html>\n");
        return buf.toString();
    }

    private static <T> Predicate<T> distinctBy(Function<? super T, Object> keyExtractor) {
        HashSet map = new HashSet();
        return t -> map.add(keyExtractor.apply(t));
    }

    private static String hrefEncodeURI(String raw) {
        char c;
        int i;
        StringBuffer buf = null;
        block9: for (i = 0; i < raw.length(); ++i) {
            c = raw.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '<': 
                case '>': {
                    buf = new StringBuffer(raw.length() << 1);
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (buf == null) {
            return raw;
        }
        block10: for (i = 0; i < raw.length(); ++i) {
            c = raw.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("%22");
                    continue block10;
                }
                case '\'': {
                    buf.append("%27");
                    continue block10;
                }
                case '<': {
                    buf.append("%3C");
                    continue block10;
                }
                case '>': {
                    buf.append("%3E");
                    continue block10;
                }
                default: {
                    buf.append(c);
                    continue block10;
                }
            }
        }
        return buf.toString();
    }

    private static String deTag(String raw) {
        return StringUtil.sanitizeXmlString((String)raw);
    }

    private static class SizeComparator
    implements Comparator<Resource> {
        private final Comparator<Object> _coll = Collator.getInstance(Locale.US);

        @Override
        public int compare(Resource ra, Resource rb) {
            try {
                boolean da = ra.isDirectory();
                boolean db = rb.isDirectory();
                long sa = da ? -1L : ra.length();
                long sb = db ? -1L : rb.length();
                int rv = Long.compare(sa, sb);
                if (rv != 0) {
                    return rv;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this._coll.compare(ra.toString(), rb.toString());
        }
    }

    private static class FileComparator
    implements Comparator<Resource> {
        private final Comparator<Object> _coll = Collator.getInstance(Locale.US);

        @Override
        public int compare(Resource ra, Resource rb) {
            try {
                boolean da = ra.isDirectory();
                boolean db = rb.isDirectory();
                if (da && !db) {
                    return -1;
                }
                if (!da && db) {
                    return 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this._coll.compare(ra.toString(), rb.toString());
        }
    }
}

