/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.jetty;

import java.nio.channels.ClosedChannelException;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class I2PLogger
implements Logger {
    private final Log _log;
    private final StringBuilder _buffer = new StringBuilder();

    public I2PLogger() {
        this(I2PAppContext.getGlobalContext());
    }

    public I2PLogger(I2PAppContext ctx) {
        this._log = ctx.logManager().getLog(Server.class);
        if (System.getProperty("DEBUG") != null) {
            this.setDebugEnabled(true);
        }
    }

    public boolean isDebugEnabled() {
        return this._log.shouldLog(10);
    }

    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this._log.setMinimumPriority(10);
        } else {
            this._log.setMinimumPriority(40);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String msg, Object arg0, Object arg1) {
        if (arg0 == null && arg1 == null) {
            this._log.info(msg);
        } else if (arg0 != null && arg1 == null && arg0 instanceof Throwable) {
            this._log.info(msg, (Throwable)arg0);
        } else if (this._log.shouldLog(20)) {
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                this.format(msg, arg0, arg1);
                if (arg1 != null && arg1 instanceof Throwable) {
                    this._log.info(this._buffer.toString(), (Throwable)arg1);
                } else {
                    this._log.info(this._buffer.toString());
                }
            }
        }
    }

    public void debug(String msg, Throwable th) {
        this._log.debug(msg, th);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String msg, Object arg0, Object arg1) {
        if (arg0 == null && arg1 == null) {
            this._log.debug(msg);
        } else if (arg0 != null && arg1 == null && arg0 instanceof Throwable) {
            this._log.debug(msg, (Throwable)arg0);
        } else if (this._log.shouldLog(10)) {
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                this.format(msg, arg0, arg1);
                if (arg1 != null && arg1 instanceof Throwable) {
                    this._log.debug(this._buffer.toString(), (Throwable)arg1);
                } else {
                    this._log.debug(this._buffer.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg, Object arg0, Object arg1) {
        if (arg0 == null && arg1 == null) {
            this._log.warn(msg);
        } else if (arg0 != null && arg1 == null && arg0 instanceof Throwable) {
            this.warn(msg, (Throwable)arg0);
        } else if (this._log.shouldLog(30)) {
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                this.format(msg, arg0, arg1);
                if (arg1 != null && arg1 instanceof Throwable) {
                    this._log.warn(this._buffer.toString(), (Throwable)arg1);
                } else {
                    this._log.warn(this._buffer.toString());
                }
            }
        }
    }

    public void warn(String msg, Throwable th) {
        if (th != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(msg, th);
            } else if (!(th instanceof ClosedChannelException)) {
                this._log.logAlways(30, msg + ": " + String.valueOf(th));
            }
        } else {
            this._log.logAlways(30, msg);
        }
    }

    private void format(String msg, Object arg0, Object arg1) {
        int i1;
        this._buffer.setLength(0);
        int i0 = msg == null ? -1 : msg.indexOf("{}");
        int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
        if (i0 >= 0) {
            this.format(msg.substring(0, i0));
            this.format(String.valueOf(arg0 == null ? "null" : arg0));
            if (i1 >= 0) {
                this.format(msg.substring(i0 + 2, i1));
                this.format(String.valueOf(arg1 == null ? "null" : arg1));
                this.format(msg.substring(i1 + 2));
            } else {
                this.format(msg.substring(i0 + 2));
                if (arg1 != null) {
                    this._buffer.append(' ');
                    this.format(String.valueOf(arg1));
                }
            }
        } else {
            this.format(msg);
            if (arg0 != null) {
                this._buffer.append(' ');
                this.format(String.valueOf(arg0));
            }
            if (arg1 != null) {
                this._buffer.append(' ');
                this.format(String.valueOf(arg1));
            }
        }
    }

    private void format(String msg) {
        if (msg == null) {
            this._buffer.append("null");
        } else {
            this._buffer.append(msg);
        }
    }

    public Logger getLogger(String name) {
        return this;
    }

    public String toString() {
        return "I2PLogger";
    }

    public void ignore(Throwable ignored) {
        this.debug("IGNORED", ignored);
    }

    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    public void debug(String msg, Object ... args) {
        Object a1 = args.length > 0 ? args[0] : null;
        Object a2 = args.length > 1 ? args[1] : null;
        this.debug(msg, a1, a2);
    }

    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    public void info(String msg, Object ... args) {
        Object a1 = args.length > 0 ? args[0] : null;
        Object a2 = args.length > 1 ? args[1] : null;
        this.info(msg, a1, a2);
    }

    public void info(String msg, Throwable th) {
        this._log.info(msg, th);
    }

    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    public void warn(String msg, Object ... args) {
        Object a1 = args.length > 0 ? args[0] : null;
        Object a2 = args.length > 1 ? args[1] : null;
        this.warn(msg, a1, a2);
    }

    public String getName() {
        return "net.i2p.jetty.I2PLogger";
    }

    public void debug(String msg, long arg) {
        this.debug(msg, (Object)arg, (Object)null);
    }

    public void debug(Marker marker, String msg) {
        this.debug(msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.debug(format, arguments);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg, t);
    }

    public void error(Marker marker, String msg) {
        this.error(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(format, arg);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.error(format, arguments);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg, t);
    }

    public void info(Marker marker, String msg) {
        this.info(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(format, arg);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.info(format, arguments);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg, t);
    }

    public void trace(Marker marker, String msg) {
        this.trace(msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        this.trace(format, arguments);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg, t);
    }

    public void warn(Marker marker, String msg) {
        this.warn(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.warn(format, arguments);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this._log.shouldError();
    }

    public boolean isInfoEnabled() {
        return this._log.shouldInfo();
    }

    public boolean isTraceEnabled() {
        return this._log.shouldDebug();
    }

    public boolean isWarnEnabled() {
        return this._log.shouldWarn();
    }

    public void trace(String msg) {
        this.debug(msg);
    }

    public void trace(String format, Object arg) {
        this.debug(format, arg);
    }

    public void trace(String format, Object ... arguments) {
        this.debug(format, arguments);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    public void trace(String msg, Throwable t) {
        this.debug(msg, t);
    }

    public void debug(String msg, Object arg) {
        this.debug(msg, arg, (Object)null);
    }

    public void info(String msg, Object arg) {
        this.info(msg, arg, (Object)null);
    }

    public void warn(String msg, Object arg) {
        this.warn(msg, arg, (Object)null);
    }

    public void debug(String msg) {
        this.debug(msg, (Object)null, (Object)null);
    }

    public void info(String msg) {
        this.info(msg, (Object)null, (Object)null);
    }

    public void warn(String msg) {
        this.warn(msg, (Object)null, (Object)null);
    }

    public void error(String msg, Object arg0, Object arg1) {
        if (arg0 == null && arg1 == null) {
            this._log.error(msg);
        } else if (arg0 != null && arg1 == null && arg0 instanceof Throwable) {
            this.error(msg, (Throwable)arg0);
        } else {
            this.format(msg, arg0, arg1);
            if (arg1 != null && arg1 instanceof Throwable) {
                this._log.error(this._buffer.toString(), (Throwable)arg1);
            } else {
                this._log.error(this._buffer.toString());
            }
        }
    }

    public void error(String msg) {
        this._log.error(msg);
    }

    public void error(String msg, Throwable th) {
        this._log.error(msg, th);
    }

    public void error(Throwable thrown) {
        this.error("", thrown);
    }

    public void error(String msg, Object arg) {
        this.error(msg, arg, (Object)null);
    }

    public void error(String msg, Object ... args) {
        Object a1 = args.length > 0 ? args[0] : null;
        Object a2 = args.length > 1 ? args[1] : null;
        this.error(msg, a1, a2);
    }
}

