/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.cybergarage.util.Debug;

public class HostInterface {
    public static boolean USE_LOOPBACK_ADDR = false;
    public static boolean USE_ONLY_IPV4_ADDR = false;
    public static boolean USE_ONLY_IPV6_ADDR = false;
    private static String ifAddress = "";
    public static final int IPV4_BITMASK = 1;
    public static final int IPV6_BITMASK = 16;
    public static final int LOCAL_BITMASK = 256;

    public static final void setInterface(String ifaddr) {
        ifAddress = ifaddr;
    }

    public static final String getInterface() {
        return ifAddress;
    }

    private static final boolean hasAssignedInterface() {
        return 0 < ifAddress.length();
    }

    private static final boolean isUsableAddress(InetAddress addr) {
        if (!USE_LOOPBACK_ADDR && addr.isLoopbackAddress()) {
            return false;
        }
        if (USE_ONLY_IPV4_ADDR && addr instanceof Inet6Address) {
            return false;
        }
        return !USE_ONLY_IPV6_ADDR || !(addr instanceof Inet4Address);
    }

    public static final int getNHostAddresses() {
        if (HostInterface.hasAssignedInterface()) {
            return 1;
        }
        int nHostAddrs = 0;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!HostInterface.isUsableAddress(addr)) continue;
                    ++nHostAddrs;
                }
            }
        }
        catch (Exception e) {
            Debug.warning(e);
        }
        return nHostAddrs;
    }

    public static final InetAddress[] getInetAddress(int ipfilter, String[] interfaces) {
        Enumeration<NetworkInterface> nis;
        if (interfaces != null) {
            Vector<NetworkInterface> iflist = new Vector<NetworkInterface>();
            for (int i = 0; i < interfaces.length; ++i) {
                NetworkInterface ni;
                try {
                    ni = NetworkInterface.getByName(interfaces[i]);
                }
                catch (SocketException e) {
                    continue;
                }
                if (ni == null) continue;
                iflist.add(ni);
            }
            nis = iflist.elements();
        } else {
            try {
                nis = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException e) {
                return null;
            }
        }
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        while (nis.hasMoreElements()) {
            NetworkInterface ni = nis.nextElement();
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if ((ipfilter & 0x100) == 0 && addr.isLoopbackAddress()) continue;
                if ((ipfilter & 1) != 0 && addr instanceof Inet4Address) {
                    addresses.add(addr);
                    continue;
                }
                if ((ipfilter & 0x10) == 0 || !(addr instanceof Inet6Address)) continue;
                addresses.add(addr);
            }
        }
        return addresses.toArray(new InetAddress[0]);
    }

    public static final String getHostAddress(int n) {
        if (HostInterface.hasAssignedInterface()) {
            return HostInterface.getInterface();
        }
        int hostAddrCnt = 0;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!HostInterface.isUsableAddress(addr)) continue;
                    if (hostAddrCnt < n) {
                        ++hostAddrCnt;
                        continue;
                    }
                    String host = addr.getHostAddress();
                    return host;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static final boolean isIPv6Address(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            return addr instanceof Inet6Address;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean isIPv4Address(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            return addr instanceof Inet4Address;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean hasIPv4Addresses() {
        int addrCnt = HostInterface.getNHostAddresses();
        for (int n = 0; n < addrCnt; ++n) {
            String addr = HostInterface.getHostAddress(n);
            if (!HostInterface.isIPv4Address(addr)) continue;
            return true;
        }
        return false;
    }

    public static final boolean hasIPv6Addresses() {
        int addrCnt = HostInterface.getNHostAddresses();
        for (int n = 0; n < addrCnt; ++n) {
            String addr = HostInterface.getHostAddress(n);
            if (!HostInterface.isIPv6Address(addr)) continue;
            return true;
        }
        return false;
    }

    public static final String getIPv4Address() {
        int addrCnt = HostInterface.getNHostAddresses();
        for (int n = 0; n < addrCnt; ++n) {
            String addr = HostInterface.getHostAddress(n);
            if (!HostInterface.isIPv4Address(addr)) continue;
            return addr;
        }
        return "";
    }

    public static final String getIPv6Address() {
        int addrCnt = HostInterface.getNHostAddresses();
        for (int n = 0; n < addrCnt; ++n) {
            String addr = HostInterface.getHostAddress(n);
            if (!HostInterface.isIPv6Address(addr)) continue;
            return addr;
        }
        return "";
    }

    public static final String getHostURL(String host, int port, String uri) {
        Object hostAddr = host;
        if (HostInterface.isIPv6Address(host)) {
            hostAddr = "[" + host + "]";
        }
        return "http://" + (String)hostAddr + ":" + Integer.toString(port) + uri;
    }
}

