/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.FragmentHandler;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.HopProcessor;
import net.i2p.router.tunnel.InboundEndpointProcessor;
import net.i2p.router.tunnel.InboundMessageDistributor;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.TunnelDispatcher;
import net.i2p.util.Log;

class TunnelParticipant {
    private final RouterContext _context;
    private final Log _log;
    private final HopConfig _config;
    private final HopProcessor _processor;
    private final InboundEndpointProcessor _inboundEndpointProcessor;
    private final InboundMessageDistributor _inboundDistributor;
    private final FragmentHandler _handler;
    private RouterInfo _nextHopCache;
    private static final long MAX_LOOKUP_TIME = 15000L;
    private static final long LONG_MAX_LOOKUP_TIME = 30000L;
    private static final int PRIORITY = 200;

    public TunnelParticipant(RouterContext ctx, HopConfig config, HopProcessor processor) {
        this(ctx, config, processor, null);
    }

    public TunnelParticipant(RouterContext ctx, InboundEndpointProcessor inEndProc) {
        this(ctx, null, null, inEndProc);
    }

    private TunnelParticipant(RouterContext ctx, HopConfig config, HopProcessor processor, InboundEndpointProcessor inEndProc) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelParticipant.class);
        this._config = config;
        this._processor = processor;
        this._handler = config == null || config.getSendTo() == null ? new FragmentHandler(ctx, new DefragmentedHandler(), true) : null;
        this._inboundEndpointProcessor = inEndProc;
        this._inboundDistributor = inEndProc != null ? new InboundMessageDistributor(ctx, inEndProc.getDestination()) : null;
        if (this._config != null && this._config.getSendTo() != null) {
            this._nextHopCache = this._context.netDb().lookupRouterInfoLocally(this._config.getSendTo());
            if (this._nextHopCache == null) {
                this._context.netDb().lookupRouterInfo(this._config.getSendTo(), new Found(this._context), null, 30000L);
            }
        }
    }

    public void dispatch(TunnelDataMessage msg, Hash recvFrom) {
        boolean ok = false;
        byte[] data = msg.getData();
        if (this._processor != null) {
            ok = this._processor.process(data, 0, data.length, recvFrom);
        } else if (this._inboundEndpointProcessor != null) {
            ok = this._inboundEndpointProcessor.retrievePreprocessedData(data, 0, data.length, recvFrom);
        }
        if (!ok) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Failed to dispatch " + String.valueOf(msg) + ": processor=" + String.valueOf(this._processor) + " inboundEndpoint=" + String.valueOf(this._inboundEndpointProcessor));
            }
            if (this._config != null) {
                this._config.incrementProcessedMessages();
            }
            return;
        }
        if (this._config != null && this._config.getSendTo() != null) {
            this._config.incrementProcessedMessages();
            RouterInfo ri = this._nextHopCache;
            if (ri == null) {
                ri = this._context.netDb().lookupRouterInfoLocally(this._config.getSendTo());
            }
            if (ri != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Send off to nextHop directly (" + String.valueOf(this._config.getSendTo()) + " for " + String.valueOf(msg));
                }
                this.send(this._config, msg, ri);
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Lookup the nextHop (" + String.valueOf(this._config.getSendTo()) + " for " + String.valueOf(msg));
                }
                this._context.netDb().lookupRouterInfo(this._config.getSendTo(), new SendJob(this._context, msg), new TimeoutJob(this._context, msg), 15000L);
            }
        } else {
            TunnelCreatorConfig cfg = this._inboundEndpointProcessor.getConfig();
            cfg.incrementProcessedMessages();
            ok = this._handler.receiveTunnelMessage(data, 0, data.length);
            if (ok) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Receive fragment: on " + String.valueOf(this._config) + ": " + String.valueOf(msg));
                }
            } else {
                int lenm1 = cfg.getLength() - 1;
                if (lenm1 > 0) {
                    int pct = 100 / lenm1;
                    for (int i = 0; i < lenm1; ++i) {
                        Hash h = cfg.getPeer(i);
                        if (this._log.shouldLog(30)) {
                            this._log.warn(this.toString() + ": Blaming " + String.valueOf(h) + " " + pct + "%");
                        }
                        this._context.profileManager().tunnelFailed(h, pct);
                    }
                }
            }
        }
    }

    public int getCompleteCount() {
        if (this._handler != null) {
            return this._handler.getCompleteCount();
        }
        return 0;
    }

    public int getFailedCount() {
        if (this._handler != null) {
            return this._handler.getFailedCount();
        }
        return 0;
    }

    private void send(HopConfig config, TunnelDataMessage msg, RouterInfo ri) {
        if (this._context.tunnelDispatcher().shouldDropParticipatingMessage(TunnelDispatcher.Location.PARTICIPANT, 18, 1024)) {
            return;
        }
        long oldId = msg.getUniqueId();
        long newId = this._context.random().nextLong(0xFFFFFFFFL);
        this._context.messageHistory().wrap("TunnelDataMessage", oldId, "TunnelDataMessage", newId);
        msg.setUniqueId(newId);
        msg.setMessageExpiration(this._context.clock().now() + 20000L);
        msg.setTunnelId(config.getSendTunnel());
        OutNetMessage m = new OutNetMessage(this._context, msg, msg.getMessageExpiration(), 200, ri);
        if (this._log.shouldLog(10)) {
            this._log.debug("Forward on from " + String.valueOf(this._config) + ": " + String.valueOf(msg));
        }
        this._context.outNetMessagePool().add(m);
    }

    public String toString() {
        if (this._config != null) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("participant at ").append(this._config.toString());
            return buf.toString();
        }
        return "inbound endpoint";
    }

    private class DefragmentedHandler
    implements FragmentHandler.DefragmentedReceiver {
        private DefragmentedHandler() {
        }

        @Override
        public void receiveComplete(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
            if (TunnelParticipant.this._log.shouldLog(10)) {
                TunnelParticipant.this._log.debug("Receive complete: on " + String.valueOf(TunnelParticipant.this._config) + ": " + String.valueOf(msg));
            }
            TunnelParticipant.this._inboundDistributor.distribute(msg, toRouter, toTunnel);
        }
    }

    private class Found
    extends JobImpl {
        public Found(RouterContext ctx) {
            super(ctx);
        }

        @Override
        public String getName() {
            return "Next hop info found";
        }

        @Override
        public void runJob() {
            if (TunnelParticipant.this._nextHopCache == null) {
                TunnelParticipant.this._nextHopCache = TunnelParticipant.this._context.netDb().lookupRouterInfoLocally(TunnelParticipant.this._config.getSendTo());
                TunnelParticipant.this._context.statManager().addRateData("tunnel.participantLookupSuccess", 1L);
            }
        }
    }

    private class SendJob
    extends JobImpl {
        private final TunnelDataMessage _msg;

        public SendJob(RouterContext ctx, TunnelDataMessage msg) {
            super(ctx);
            this._msg = msg;
        }

        @Override
        public String getName() {
            return "Participant send after lookup";
        }

        @Override
        public void runJob() {
            if (TunnelParticipant.this._nextHopCache != null) {
                TunnelParticipant.this.send(TunnelParticipant.this._config, this._msg, TunnelParticipant.this._nextHopCache);
            } else {
                int stat;
                RouterInfo ri = TunnelParticipant.this._context.netDb().lookupRouterInfoLocally(TunnelParticipant.this._config.getSendTo());
                if (ri != null) {
                    TunnelParticipant.this._nextHopCache = ri;
                    TunnelParticipant.this.send(TunnelParticipant.this._config, this._msg, ri);
                    stat = 1;
                } else {
                    if (TunnelParticipant.this._log.shouldLog(30)) {
                        TunnelParticipant.this._log.warn("Lookup the nextHop (" + String.valueOf(TunnelParticipant.this._config.getSendTo()) + " failed!  where do we go for " + String.valueOf(TunnelParticipant.this._config) + "?  msg dropped: " + String.valueOf(this._msg));
                    }
                    stat = 0;
                }
                TunnelParticipant.this._context.statManager().addRateData("tunnel.participantLookupSuccess", stat);
            }
        }
    }

    private class TimeoutJob
    extends JobImpl {
        private final TunnelDataMessage _msg;

        public TimeoutJob(RouterContext ctx, TunnelDataMessage msg) {
            super(ctx);
            this._msg = msg;
        }

        @Override
        public String getName() {
            return "Participant next hop lookup timeout";
        }

        @Override
        public void runJob() {
            if (TunnelParticipant.this._nextHopCache != null) {
                return;
            }
            RouterInfo ri = TunnelParticipant.this._context.netDb().lookupRouterInfoLocally(TunnelParticipant.this._config.getSendTo());
            if (ri != null) {
                TunnelParticipant.this._nextHopCache = ri;
                if (TunnelParticipant.this._log.shouldLog(30)) {
                    TunnelParticipant.this._log.warn("Lookup the nextHop (" + String.valueOf(TunnelParticipant.this._config.getSendTo()) + " failed, but we found it!!  where do we go for " + String.valueOf(TunnelParticipant.this._config) + "?  msg dropped: " + String.valueOf(this._msg));
                }
            } else if (TunnelParticipant.this._log.shouldLog(30)) {
                TunnelParticipant.this._log.warn("Lookup the nextHop (" + String.valueOf(TunnelParticipant.this._config.getSendTo()) + " failed!  where do we go for " + String.valueOf(TunnelParticipant.this._config) + "?  msg dropped: " + String.valueOf(this._msg));
            }
            TunnelParticipant.this._context.statManager().addRateData("tunnel.participantLookupSuccess", 0L);
        }
    }
}

