/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.OutboundGatewayMessage;
import net.i2p.router.tunnel.PendingGatewayMessage;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.router.tunnel.TunnelGatewayPumper;
import net.i2p.router.util.CoDelBlockingQueue;
import net.i2p.router.util.CoDelPriorityBlockingQueue;

class PumpedTunnelGateway
extends TunnelGateway {
    private final BlockingQueue<PendingGatewayMessage> _prequeue;
    private final TunnelGatewayPumper _pumper;
    private final boolean _isInbound;
    private final Hash _nextHop;
    private static final int MAX_OB_MSGS_PER_PUMP = 64;
    private static final int MAX_IB_MSGS_PER_PUMP = 24;
    private static final int INITIAL_OB_QUEUE = 64;
    private static final int MAX_IB_QUEUE = 1024;

    public PumpedTunnelGateway(RouterContext context, TunnelGateway.QueuePreprocessor preprocessor, TunnelGateway.Sender sender, TunnelGateway.Receiver receiver, TunnelGatewayPumper pumper) {
        super(context, preprocessor, sender, receiver);
        if (this.getClass() == PumpedTunnelGateway.class) {
            this._prequeue = new CoDelPriorityBlockingQueue<PendingGatewayMessage>(context, "OBGW", 64);
            this._nextHop = receiver.getSendTo();
            this._isInbound = false;
        } else if (receiver != null) {
            this._prequeue = new CoDelBlockingQueue<PendingGatewayMessage>(context, "IBGW", 1024);
            this._nextHop = receiver.getSendTo();
            this._isInbound = true;
        } else {
            this._prequeue = null;
            this._nextHop = null;
            this._isInbound = true;
        }
        this._pumper = pumper;
    }

    @Override
    public void add(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
        OutboundGatewayMessage cur = new OutboundGatewayMessage(msg, toRouter, toTunnel);
        if (this._log.shouldLog(10)) {
            this._log.debug("OB PTG add type " + msg.getType() + " pri " + cur.getPriority());
        }
        this.add(cur);
    }

    protected void add(PendingGatewayMessage cur) {
        ++this._messagesSent;
        if (this._prequeue.offer(cur)) {
            this._pumper.wantsPumping(this);
        } else {
            this._context.statManager().addRateData("tunnel.dropGatewayOverflow", 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pump(List<PendingGatewayMessage> queueBuf) {
        boolean backlogged = this._context.commSystem().isBacklogged(this._nextHop);
        if (backlogged && this._log.shouldLog(20)) {
            this._log.info("PTG backlogged, queued to " + String.valueOf(this._nextHop) + " : " + this._prequeue.size() + " IB? " + this._isInbound);
        }
        int max = backlogged ? (this._isInbound ? 1 : 2) : (this._isInbound ? 24 : 64);
        this._prequeue.drainTo(queueBuf, max);
        if (queueBuf.isEmpty()) {
            return false;
        }
        boolean rv = !this._prequeue.isEmpty();
        boolean debug = this._log.shouldDebug();
        long startAdd = debug ? System.currentTimeMillis() : 0L;
        long beforeLock = startAdd;
        long afterAdded = -1L;
        boolean delayedFlush = false;
        long delayAmount = -1L;
        int remaining = 0;
        long afterPreprocess = 0L;
        long afterExpire = 0L;
        List list = this._queue;
        synchronized (list) {
            this._queue.addAll(queueBuf);
            if (debug) {
                afterAdded = System.currentTimeMillis();
                this._log.debug("Added before direct flush preprocessing for " + this.toString() + ": " + String.valueOf(this._queue));
            }
            delayedFlush = this._preprocessor.preprocessQueue(this._queue, this._sender, this._receiver);
            if (debug) {
                afterPreprocess = System.currentTimeMillis();
            }
            if (delayedFlush) {
                delayAmount = this._preprocessor.getDelayAmount();
            }
            this._lastFlush = this._context.clock().now();
            for (int i = 0; i < this._queue.size(); ++i) {
                PendingGatewayMessage m = (PendingGatewayMessage)this._queue.get(i);
                if (m.getExpiration() + 60000L >= this._lastFlush) continue;
                if (debug) {
                    this._log.debug("Expire on the queue (size=" + this._queue.size() + "): " + String.valueOf(m));
                }
                this._queue.remove(i);
                --i;
            }
            remaining = this._queue.size();
            if (debug) {
                afterExpire = System.currentTimeMillis();
                if (remaining > 0) {
                    this._log.debug("Remaining after preprocessing: " + String.valueOf(this._queue));
                }
            }
        }
        if (delayedFlush) {
            this._delayedFlush.reschedule(delayAmount);
        }
        if (debug) {
            long complete = System.currentTimeMillis();
            this._log.debug("Time to add " + queueBuf.size() + " messages to " + this.toString() + ": " + (complete - startAdd) + " delayed? " + delayedFlush + " remaining: " + remaining + " add: " + (afterAdded - beforeLock) + " preprocess: " + (afterPreprocess - afterAdded) + " expire: " + (afterExpire - afterPreprocess) + " queue flush: " + (complete - afterExpire));
        }
        queueBuf.clear();
        if (rv && this._log.shouldLog(20)) {
            this._log.info("PTG remaining to " + String.valueOf(this._nextHop) + " : " + this._prequeue.size() + " IB? " + this._isInbound + " backlogged? " + backlogged);
        }
        return rv;
    }
}

