/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.util.BandwidthEstimator;
import net.i2p.util.Log;

class SimpleBandwidthEstimator
implements BandwidthEstimator {
    private final I2PAppContext _context;
    private final Log _log;
    private final PeerState _state;
    private long _tAck;
    private float _bKFiltered;
    private float _bK_ns_est;
    private int _acked;
    private static final int DECAY_FACTOR = 8;
    private static final int WESTWOOD_RTT_MIN = 500;

    SimpleBandwidthEstimator(I2PAppContext ctx, PeerState state) {
        this._log = ctx.logManager().getLog(SimpleBandwidthEstimator.class);
        this._context = ctx;
        this._state = state;
        this._tAck = ctx.clock().now();
        this._acked = -1;
    }

    @Override
    public void addSample(int acked) {
        long now = this._context.clock().now();
        int rtt = this._state.getRTT();
        this.addSample(acked, now, rtt);
    }

    private synchronized void addSample(int acked, long now, int rtt) {
        if (this._acked < 0) {
            float bkdt;
            long deltaT = Math.max(now - this._tAck, 500L);
            this._bKFiltered = bkdt = (float)acked / (float)deltaT;
            this._bK_ns_est = bkdt;
            this._acked = 0;
            this._tAck = now;
            if (this._log.shouldDebug()) {
                this._log.debug("first sample bytes: " + acked + " deltaT: " + deltaT + " " + String.valueOf(this));
            }
        } else {
            this._acked += acked;
            if (now - this._tAck >= (long)Math.max(rtt, 500)) {
                this.computeBWE(now, rtt);
            }
        }
    }

    @Override
    public float getBandwidthEstimate() {
        return this.getBandwidthEstimate(this._context.clock().now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getBandwidthEstimate(long now) {
        int rtt = this._state.getRTT();
        SimpleBandwidthEstimator simpleBandwidthEstimator = this;
        synchronized (simpleBandwidthEstimator) {
            if (now - this._tAck >= (long)Math.max(rtt, 500)) {
                return this.computeBWE(now, rtt);
            }
            return this._bKFiltered;
        }
    }

    private synchronized float computeBWE(long now, int rtt) {
        if (this._acked < 0) {
            return 0.0f;
        }
        this.updateBK(now, this._acked, rtt);
        this._acked = 0;
        return this._bKFiltered;
    }

    private void decay() {
        this._bK_ns_est *= 0.875f;
        this._bKFiltered = SimpleBandwidthEstimator.westwood_do_filter(this._bKFiltered, this._bK_ns_est);
    }

    private void updateBK(long time, int packets, int rtt) {
        float bkdt;
        long deltaT = time - this._tAck;
        if (rtt < 500) {
            rtt = 500;
        }
        if (deltaT > (long)(2 * rtt)) {
            int numrtts = Math.min((int)(deltaT / (long)rtt - 1L), 16);
            for (int i = 0; i < numrtts; ++i) {
                this.decay();
            }
            deltaT -= (long)(numrtts * rtt);
            if (this._log.shouldDebug()) {
                this._log.debug("decayed " + numrtts + " times, new _bK_ns_est: " + this._bK_ns_est + " " + String.valueOf(this));
            }
        }
        if (packets > 0) {
            bkdt = (float)packets / (float)deltaT;
            this._bK_ns_est = SimpleBandwidthEstimator.westwood_do_filter(this._bK_ns_est, bkdt);
            this._bKFiltered = SimpleBandwidthEstimator.westwood_do_filter(this._bKFiltered, this._bK_ns_est);
        } else {
            bkdt = 0.0f;
            this.decay();
        }
        this._tAck = time;
        if (this._log.shouldDebug()) {
            this._log.debug("computeBWE bytes: " + packets + " deltaT: " + deltaT + " bk/deltaT: " + bkdt + " _bK_ns_est: " + this._bK_ns_est + " " + String.valueOf(this));
        }
    }

    private static float westwood_do_filter(float a, float b) {
        return (7.0f * a + b) / 8.0f;
    }

    public synchronized String toString() {
        return "SBE[ _bKFiltered " + this._bKFiltered + " _tAck " + this._tAck + "; " + DataHelper.formatSize2Decimal((long)(this._bKFiltered * 1000.0f), false) + "Bps]";
    }
}

