/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.router.OutNetMessage;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class NTCPSendFinisher {
    private static final int MIN_THREADS = 1;
    private static final int MAX_THREADS = 4;
    private final I2PAppContext _context;
    private final NTCPTransport _transport;
    private final Log _log;
    private static final AtomicInteger _count = new AtomicInteger();
    private ThreadPoolExecutor _executor;
    private static final int THREADS;

    public NTCPSendFinisher(I2PAppContext context, NTCPTransport transport) {
        this._context = context;
        this._log = this._context.logManager().getLog(NTCPSendFinisher.class);
        this._transport = transport;
    }

    public synchronized void start() {
        this._executor = new CustomThreadPoolExecutor(THREADS);
    }

    public synchronized void stop() {
        if (this._executor != null) {
            this._executor.shutdownNow();
        }
    }

    public void add(OutNetMessage msg) {
        try {
            this._executor.execute(new RunnableEvent(msg));
        }
        catch (RejectedExecutionException ree) {
            this._log.warn("NTCP send finisher stopped, discarding msg.afterSend()");
        }
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        THREADS = (int)Math.max(1L, Math.min(4L, 1L + maxMemory / 0x2000000L));
    }

    private static class CustomThreadPoolExecutor
    extends ThreadPoolExecutor {
        public CustomThreadPoolExecutor(int num) {
            super(num, num, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new CustomThreadFactory());
        }
    }

    private class RunnableEvent
    implements Runnable {
        private final OutNetMessage _msg;

        public RunnableEvent(OutNetMessage msg) {
            this._msg = msg;
        }

        @Override
        public void run() {
            try {
                NTCPSendFinisher.this._transport.afterSend(this._msg, true, false, this._msg.getSendTime());
            }
            catch (Throwable t) {
                NTCPSendFinisher.this._log.log(50, " afterSend broken?", t);
            }
        }
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private CustomThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread rv = Executors.defaultThreadFactory().newThread(r);
            rv.setName("NTCPSendFinisher " + _count.incrementAndGet() + "/" + THREADS);
            rv.setDaemon(true);
            return rv;
        }
    }
}

