/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.startup.WorkingDir;
import net.i2p.util.FileUtil;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.VersionComparator;

abstract class MigrateJetty {
    private static boolean _wasChecked;
    private static boolean _hasLatestJetty;
    private static final String NEW_CLASS = "net.i2p.jetty.JettyStart";
    private static final String TEST_CLASS = "org.eclipse.jetty.util.component.Environment";
    private static final String BACKUP_SUFFIX_9 = ".jetty9-id";
    private static final String BACKUP_SUFFIX_9_2 = ".jetty93-save";
    private static final String JETTY_TEMPLATE_DIR = "eepsite-jetty9";
    private static final String JETTY_TEMPLATE_PKGDIR = "eepsite";
    private static final String BASE_CONTEXT = "contexts/base-context.xml";
    private static final String CGI_CONTEXT = "contexts/cgi-context.xml";
    private static final String PROP_JETTY9_MIGRATED = "router.startup.jetty9.migrated";
    private static final String PROP_JETTY9_MIGRATED_2 = "router.startup.jetty-ids.migrated";
    private static final String PROP_JETTY12_MIGRATED = "router.startup.jetty12.migrated";
    private static final String M1 = "<Set name=\"handler\"";
    private static final String R1 = "     <Set name=\"defaultHandler\">\n       <New id=\"DefaultHandler\" class=\"org.eclipse.jetty.server.handler.DefaultHandler\">\n         <Set name=\"showContexts\">false</Set>\n       </New>\n     </Set>\n     <Set name=\"handler\">\n       <New id=\"Contexts\" class=\"org.eclipse.jetty.server.handler.ContextHandlerCollection\"/>\n     </Set>\n";
    private static final String R2 = "    <!-- Setup ee8 environment -->\n    <!-- First call needed to initialize the class and prevent NPE -->\n    <Call class=\"org.eclipse.jetty.util.component.Environment\" name=\"get\" >\n        <Arg>foo</Arg>\n    </Call>\n    <New id=\"EBuilder\" class=\"org.eclipse.jetty.xml.EnvironmentBuilder\" >\n      <Arg>ee8</Arg>\n    </New>\n    <Ref refid=\"EBuilder\">\n      <Call id=\"Environment\" name=\"build\" />\n    </Ref>\n    <Ref refid=\"Environment\">\n      <Call class=\"org.eclipse.jetty.util.Attributes\" name=\"setAttribute\">\n        <Arg>contextHandlerClass</Arg>\n        <Arg>org.eclipse.jetty.ee8.webapp.WebAppContext</Arg>\n      </Call>\n    </Ref>\n    <Call class=\"org.eclipse.jetty.util.component.Environment\" name=\"set\" >\n      <Arg>\n        <Ref refid=\"Environment\"/>\n      </Arg>\n    </Call>\n";
    private static final String D1 = "<Call name=\"setContextAttribute\"";
    private static final String M3 = "<New class=\"org.eclipse.jetty.deploy.providers.WebAppProvider\"";
    private static final String R3 = "          <New class=\"org.eclipse.jetty.deploy.providers.ContextProvider\">\n            <Set name=\"EnvironmentName\">ee8</Set>\n            <Set name=\"parentLoaderPriority\">true</Set>\n            <Set name=\"configurationClasses\" property=\"jetty.deploy.configurationClasses\" />\n";
    private static final String M4 = "<New id=\"WebAppProvider\" class=\"org.eclipse.jetty.deploy.providers.WebAppProvider\"";
    private static final String R4 = "          <New id=\"WebAppProvider\" class=\"org.eclipse.jetty.deploy.providers.ContextProvider\">\n            <Set name=\"EnvironmentName\">ee8</Set>\n            <Set name=\"parentLoaderPriority\">true</Set>\n            <Set name=\"configurationClasses\" property=\"jetty.deploy.configurationClasses\" />\n";
    private static final String M5 = "<Set name=\"parentLoaderPriority\">false</Set>";
    private static final String R5 = "<Set name=\"parentLoaderPriority\">true</Set>";
    private static final String D2 = "<Ref refid=\"RequestLog\">";
    private static final String M10 = "jetty/configure.dtd";
    private static final String R10 = "<!DOCTYPE Configure PUBLIC \"-//Jetty//Configure//EN\" \"http://www.eclipse.org/jetty/configure_10_0.dtd\">";
    private static final String M11 = "org.eclipse.jetty.servlet.ServletContextHandler";
    private static final String R11 = "<Configure class=\"org.eclipse.jetty.ee8.servlet.ServletContextHandler\">";
    private static final String M12 = "<Set name=\"resourceBase\"";
    private static final String R12 = "  <Set name=\"baseResourceAsString\"><Ref refid=\"baseroot\" /></Set>\n  <Call name=\"setErrorHandler\">\n    <Arg>\n      <New class=\"net.i2p.servlet.I2PErrorHandler\">\n        <Arg><Ref refid=\"baseroot\" /></Arg>\n      </New>\n    </Arg>\n  </Call>";
    private static final String M13 = "<Call name=\"setMimeTypes\"";
    private static final String M14 = "org.eclipse.jetty.servlet.DefaultServlet";
    private static final String R14 = "net.i2p.servlet.I2PDefaultServlet";

    MigrateJetty() {
    }

    public static void migrate(RouterContext ctx, List<ClientAppConfig> apps) {
        boolean migrated1;
        if (ctx.getBooleanProperty(PROP_JETTY12_MIGRATED)) {
            return;
        }
        String installed = ctx.getProperty("router.firstVersion");
        if (installed != null && VersionComparator.comp(installed, "2.11.0") >= 0) {
            ctx.router().saveConfig(PROP_JETTY12_MIGRATED, "true");
            return;
        }
        boolean migrated2 = ctx.getBooleanProperty(PROP_JETTY9_MIGRATED_2);
        if (!migrated2 && installed != null && VersionComparator.comp(installed, "2.9.0") >= 0) {
            ctx.router().saveConfig(PROP_JETTY9_MIGRATED_2, "true");
            migrated2 = true;
        }
        if (!(migrated1 = ctx.getBooleanProperty(PROP_JETTY9_MIGRATED)) && installed != null && VersionComparator.comp(installed, "0.9.30") >= 0) {
            ctx.router().saveConfig(PROP_JETTY9_MIGRATED, "true");
            migrated1 = true;
        }
        boolean migration2success = false;
        boolean migration3success = false;
        for (int i = 0; i < apps.size(); ++i) {
            boolean ok;
            File base;
            File tmpFile;
            boolean ok2;
            File xmlFile;
            String backupSuffix;
            String[] args;
            ClientAppConfig app = apps.get(i);
            String client = "client application " + i + " [" + app.clientName + "] from Jetty 9 to Jetty 12";
            if (migrated1) {
                if (!app.className.equals(NEW_CLASS)) {
                    continue;
                }
            } else {
                System.err.println("WARNING: Unable to migrate " + client + ", delete client or uninstall and reinstall I2P");
                app.disabled = true;
                continue;
            }
            if (!MigrateJetty.hasLatestJetty()) {
                System.err.println("WARNING: Jetty 12 unavailable, cannot migrate " + client);
                continue;
            }
            if (app.args == null || (args = LoadClientAppsJob.parseArgs(app.args)).length == 0) continue;
            System.err.println("Migrating " + client);
            if (!migrated2) {
                backupSuffix = BACKUP_SUFFIX_9;
                for (String xml : args) {
                    if (!xml.endsWith(".xml")) continue;
                    xmlFile = new File(xml);
                    if (!xmlFile.isAbsolute()) {
                        xmlFile = new File(ctx.getAppDir(), xml);
                    }
                    if (!xmlFile.exists()) {
                        System.err.println("WARNING: XML file " + String.valueOf(xmlFile) + " not found, cannot migrate " + client);
                        continue;
                    }
                    ok2 = MigrateJetty.backupFile(xmlFile, backupSuffix);
                    if (!ok2) {
                        System.err.println("WARNING: Failed to backup up XML file " + String.valueOf(xmlFile) + ", cannot migrate " + client);
                        continue;
                    }
                    tmpFile = new File(String.valueOf(xmlFile) + ".tmp");
                    try {
                        WorkingDir.migrateFileXML(xmlFile, tmpFile, "<Ref id=", "<Ref refid=", "/jetty/configure.dtd", "/jetty/configure_9_3.dtd");
                        ok2 = FileUtil.rename(tmpFile, xmlFile);
                        if (!ok2) {
                            throw new IOException();
                        }
                    }
                    catch (IOException ioe) {
                        System.err.println("WARNING: Failed to migrate XML file " + String.valueOf(xmlFile) + ", cannot migrate " + client);
                        ioe.printStackTrace();
                        continue;
                    }
                    migration2success = true;
                }
            }
            backupSuffix = BACKUP_SUFFIX_9_2;
            for (String xml : args) {
                if (!xml.endsWith(".xml")) continue;
                xmlFile = new File(xml);
                if (!xmlFile.isAbsolute()) {
                    xmlFile = new File(ctx.getAppDir(), xml);
                }
                if (!xmlFile.exists()) {
                    System.err.println("WARNING: XML file " + String.valueOf(xmlFile) + " not found, cannot migrate " + client);
                    continue;
                }
                ok2 = MigrateJetty.backupFile(xmlFile, backupSuffix);
                if (!ok2) {
                    System.err.println("WARNING: Failed to backup up XML file " + String.valueOf(xmlFile) + ", cannot migrate " + client);
                    continue;
                }
                tmpFile = new File(String.valueOf(xmlFile) + ".tmp");
                try {
                    WorkingDir.migrateFileXML(xmlFile, tmpFile, "/jetty/configure_9_3.dtd", "/jetty/configure_10_0.dtd", "This configuration supports Jetty 9.", "This configuration supports Jetty 12");
                    ok2 = FileUtil.rename(tmpFile, xmlFile);
                    if (!ok2) {
                        throw new IOException();
                    }
                    if (xmlFile.getName().equals("jetty-ssl.xml")) {
                        System.err.println("WARNING: SSL migration to Jetty 12 is not yet implemented.");
                        System.err.println("Cannot fully migrate " + client);
                        System.err.println("Remove jetty-ssl.xml from the command line for the client");
                        System.err.println("See http://zzz.i2p/topics/3702 for help on migrating SSL");
                        continue;
                    }
                    MigrateJetty.migrate9to12XML(xmlFile, tmpFile);
                    ok2 = FileUtil.rename(tmpFile, xmlFile);
                    if (!ok2) {
                        throw new IOException();
                    }
                }
                catch (IOException ioe) {
                    System.err.println("WARNING: Failed to migrate XML file " + String.valueOf(xmlFile) + ", cannot migrate " + client);
                    ioe.printStackTrace();
                    continue;
                }
                migration3success = true;
            }
            File xmlFile2 = new File(args[0]);
            if (!xmlFile2.isAbsolute()) {
                xmlFile2 = new File(ctx.getAppDir(), args[0]);
            }
            if ((xmlFile2 = new File(base = xmlFile2.getParentFile(), "jetty-gzip.xml")).exists()) {
                ok = MigrateJetty.backupFile(xmlFile2, backupSuffix);
                if (ok) {
                    ok = WorkingDir.copyFile(new File(ctx.getBaseDir(), "eepsite-jetty9.3/jetty-gzip.xml"), xmlFile2);
                }
                if (ok) {
                    System.err.println("Modified " + String.valueOf(xmlFile2));
                } else {
                    System.err.println("WARNING: Failed to backup up XML file " + String.valueOf(xmlFile2) + ", cannot migrate " + client);
                }
            }
            if ((xmlFile2 = new File(base, BASE_CONTEXT)).exists()) {
                try {
                    ok = MigrateJetty.backupFile(xmlFile2, backupSuffix);
                    if (ok) {
                        File tmpFile2 = new File(String.valueOf(xmlFile2) + ".tmp");
                        MigrateJetty.migrateBaseContextXML(xmlFile2, tmpFile2);
                        ok = FileUtil.rename(tmpFile2, xmlFile2);
                        if (!ok) {
                            throw new IOException();
                        }
                        System.err.println("Modified " + String.valueOf(xmlFile2));
                    }
                }
                catch (IOException ioe) {
                    System.err.println("WARNING: Failed to migrate XML file " + String.valueOf(xmlFile2) + ", cannot migrate " + client);
                    ioe.printStackTrace();
                }
            }
            if ((xmlFile2 = new File(base, CGI_CONTEXT)).exists()) {
                File save = new File(String.valueOf(xmlFile2) + BACKUP_SUFFIX_9_2);
                FileUtil.rename(xmlFile2, save);
                System.err.println("WARNING: CGI not supported on Jetty 12 and has been disabled.");
                System.err.println(String.valueOf(xmlFile2) + " moved to " + String.valueOf(save));
                System.err.println("See http://zzz.i2p/topics/3701 for help on migrating to FCGI if required");
            }
            System.err.println("Migrated " + client);
        }
        if (!migrated2 && migration2success) {
            ctx.router().saveConfig(PROP_JETTY9_MIGRATED_2, "true");
        }
        if (migration3success) {
            ctx.router().saveConfig(PROP_JETTY12_MIGRATED, "true");
        }
    }

    private static boolean hasLatestJetty() {
        if (!_wasChecked) {
            try {
                LoadClientAppsJob.testClient(TEST_CLASS, null);
                _hasLatestJetty = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            _wasChecked = true;
        }
        return _hasLatestJetty;
    }

    private static boolean backupFile(File from, String suffix) {
        boolean rv;
        if (!from.exists()) {
            return true;
        }
        File to = new File(from.getAbsolutePath() + suffix);
        if (to.exists()) {
            to = new File(to.getAbsolutePath() + "." + System.currentTimeMillis());
        }
        if (rv = WorkingDir.copyFile(from, to)) {
            System.err.println("Backed up file " + String.valueOf(from) + " to " + String.valueOf(to));
        } else {
            System.err.println("WARNING: Failed to back up file " + String.valueOf(from) + " to " + String.valueOf(to));
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migrate9to12XML(File oldFile, File newFile) throws IOException {
        FileInputStream in = null;
        PrintWriter out = null;
        try {
            in = new FileInputStream(oldFile);
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(newFile), "UTF-8")));
            String s = null;
            while ((s = DataHelper.readLine(in)) != null) {
                String t;
                if (s.endsWith("\r")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.contains(M1)) {
                    int i = 0;
                    while (!((t = DataHelper.readLine(in)) == null || t.contains("</Set") && i++ > 0)) {
                    }
                    out.println(R1);
                    out.println(R2);
                    continue;
                }
                if (s.contains(M3)) {
                    while ((t = DataHelper.readLine(in)) != null && !t.contains("\"monitoredDirName\"")) {
                    }
                    out.println(R3);
                    out.println(t);
                    continue;
                }
                if (s.contains(M4)) {
                    while ((t = DataHelper.readLine(in)) != null && !t.contains("\"monitoredDirName\"")) {
                    }
                    out.println(R4);
                    out.println(t);
                    continue;
                }
                if (s.contains(M5)) {
                    out.println(R5);
                    continue;
                }
                if (s.contains(D1)) {
                    while ((t = DataHelper.readLine(in)) != null && !t.contains("</Call")) {
                    }
                    continue;
                }
                if (s.contains(D2)) {
                    while ((t = DataHelper.readLine(in)) != null && !t.contains("</Ref")) {
                        out.println(t);
                    }
                    continue;
                }
                out.println(s);
            }
            out.println("<!-- Modified by I2P Jetty 12 migration script -->");
            System.err.println("Copied " + String.valueOf(oldFile) + " with modifications");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migrateBaseContextXML(File oldFile, File newFile) throws IOException {
        FileInputStream in = null;
        PrintWriter out = null;
        try {
            in = new FileInputStream(oldFile);
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(newFile), "UTF-8")));
            String s = null;
            block7: while ((s = DataHelper.readLine(in)) != null) {
                if (s.endsWith("\r")) {
                    s = s.substring(0, s.length() - 1);
                }
                if (s.contains(M10)) {
                    out.println(R10);
                    continue;
                }
                if (s.contains(M11)) {
                    out.println(R11);
                    continue;
                }
                if (s.contains(M12)) {
                    int gt = s.indexOf(62);
                    int lt = s.lastIndexOf(60);
                    if (gt < 0 || lt < 0 || lt <= gt) continue;
                    String rb = s.substring(gt + 1, lt).trim();
                    out.println("  <New id=\"baseroot\" class=\"java.lang.String\">");
                    out.println("    <Arg>" + rb + "</Arg>");
                    out.println("  </New>");
                    out.println(R12);
                    continue;
                }
                if (s.contains(M13)) {
                    String t;
                    int i = 1;
                    while ((t = DataHelper.readLine(in)) != null) {
                        if (t.contains("<Call")) {
                            ++i;
                        }
                        if (t.contains("</Call")) {
                            --i;
                        }
                        if (i != 0) continue;
                        continue block7;
                    }
                    continue;
                }
                if (s.contains(M14)) {
                    out.println(s.replace(M14, R14));
                    continue;
                }
                out.println(s);
            }
            out.println("<!-- Modified by I2P Jetty 12 migration script -->");
            System.err.println("Copied " + String.valueOf(oldFile) + " with modifications");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

