/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.MigrateJetty;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.FileUtil;
import net.i2p.util.ObjectCounterUnsafe;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SystemVersion;

public class ClientAppConfig {
    private static final long DEFAULT_STARTUP_DELAY = 120000L;
    private static final long I2PTUNNEL_STARTUP_DELAY = -1000L;
    private static final String PROP_CLIENT_CONFIG_FILENAME = "router.clientConfigFile";
    private static final String DEFAULT_CLIENT_CONFIG_FILENAME = "clients.config";
    private static final String CLIENT_CONFIG_DIR = "clients.config.d";
    private static final String PREFIX = "clientApp.";
    public String className;
    public String clientName;
    public String args;
    public boolean disabled;
    public final long delay;
    public final String classpath;
    public final String stopargs;
    public final String uninstallargs;
    File configFile;

    public ClientAppConfig(String cl, String client, String a, long d, boolean dis) {
        this(cl, client, a, d, dis, null, null, null);
    }

    public ClientAppConfig(String cl, String client, String a, long d, boolean dis, String cp, String sa, String ua) {
        this.className = cl;
        this.clientName = client;
        this.args = a;
        this.delay = d;
        this.disabled = dis;
        this.classpath = cp;
        this.stopargs = sa;
        this.uninstallargs = ua;
    }

    public static synchronized boolean isSplitConfig(I2PAppContext ctx) {
        File dir = new File(ctx.getConfigDir(), CLIENT_CONFIG_DIR);
        return dir.exists() && !ClientAppConfig.configFile(ctx).exists();
    }

    public static File configFile(I2PAppContext ctx) {
        String clientConfigFile = ctx.getProperty(PROP_CLIENT_CONFIG_FILENAME, DEFAULT_CLIENT_CONFIG_FILENAME);
        File cfgFile = new File(clientConfigFile);
        if (!cfgFile.isAbsolute()) {
            cfgFile = new File(ctx.getConfigDir(), clientConfigFile);
        }
        return cfgFile;
    }

    public static File configDir(I2PAppContext ctx) {
        return new File(ctx.getConfigDir(), CLIENT_CONFIG_DIR);
    }

    public static synchronized List<ClientAppConfig> getClientApps(RouterContext ctx) {
        Object[] files;
        SecureDirectory dir = new SecureDirectory(ctx.getConfigDir(), CLIENT_CONFIG_DIR);
        ArrayList<ClientAppConfig> rv = new ArrayList<ClientAppConfig>(8);
        File cf = ClientAppConfig.configFile(ctx);
        try {
            List<ClientAppConfig> cacs = ClientAppConfig.getClientApps(cf);
            if (!cacs.isEmpty()) {
                boolean ok;
                if (!SystemVersion.isAndroid()) {
                    MigrateJetty.migrate(ctx, cacs);
                }
                if (!(ok = ClientAppConfig.migrate(ctx, cacs, cf, dir))) {
                    rv.addAll(cacs);
                }
            }
        }
        catch (IOException ioe) {
            ctx.logManager().getLog(ClientAppConfig.class).error("Error loading the client app properties from " + String.valueOf(cf), ioe);
            System.out.println("Error loading the client app properties from " + String.valueOf(cf) + " " + String.valueOf(ioe));
        }
        if (dir.isDirectory() && (files = dir.listFiles(new FileSuffixFilter(".config"))) != null && files.length > 0) {
            Arrays.sort(files);
            for (Object f : files) {
                if (!((File)f).getName().endsWith(".config") || !((File)f).isFile()) continue;
                try {
                    List<ClientAppConfig> cacs = ClientAppConfig.getClientApps((File)f);
                    if (!cacs.isEmpty()) {
                        rv.addAll(cacs);
                        continue;
                    }
                    ctx.logManager().getLog(ClientAppConfig.class).error("Error loading the client app properties from " + String.valueOf(f));
                    System.out.println("Error loading the client app properties from " + String.valueOf(f));
                }
                catch (IOException ioe) {
                    ctx.logManager().getLog(ClientAppConfig.class).error("Error loading the client app properties from " + String.valueOf(f), ioe);
                    System.out.println("Error loading the client app properties from " + String.valueOf(f) + " " + String.valueOf(ioe));
                }
            }
            if (!rv.isEmpty() && !SystemVersion.isAndroid()) {
                MigrateJetty.migrate(ctx, rv);
            }
        }
        return rv;
    }

    public static synchronized List<ClientAppConfig> getClientApps(File cfgFile) throws IOException {
        if (!cfgFile.isFile()) {
            return new ArrayList<ClientAppConfig>();
        }
        Properties clientApps = new Properties();
        DataHelper.loadProps(clientApps, cfgFile);
        List<ClientAppConfig> rv = ClientAppConfig.getClientApps(clientApps);
        for (ClientAppConfig cac : rv) {
            cac.configFile = cfgFile;
        }
        return rv;
    }

    private static boolean migrate(I2PAppContext ctx, List<ClientAppConfig> apps, File from, File dir) {
        if (SystemVersion.isAndroid()) {
            return false;
        }
        try {
            if (ctx.getConfigDir().getCanonicalPath().equals(ctx.getBaseDir().getCanonicalPath())) {
                return false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return false;
        }
        boolean ok = true;
        for (int i = 0; i < apps.size(); ++i) {
            File f;
            ClientAppConfig cac = apps.get(i);
            String name = i + "-" + cac.className + "-clients.config";
            if (i < 10) {
                name = "0" + name;
            }
            cac.configFile = f = new File(dir, name);
            try {
                ClientAppConfig.writeClientAppConfig(ctx, cac);
                continue;
            }
            catch (IOException ioe) {
                ctx.logManager().getLog(ClientAppConfig.class).error("Error migrating the client app properties to " + String.valueOf(f), ioe);
                System.out.println("Error migrating the client app properties to " + String.valueOf(f) + " " + String.valueOf(ioe));
                cac.configFile = from;
                ok = false;
            }
        }
        if (ok && !FileUtil.rename(from, new File(from.getAbsolutePath() + ".bak"))) {
            from.delete();
        }
        return ok;
    }

    private static List<ClientAppConfig> getClientApps(Properties clientApps) {
        ClientAppConfig cac;
        ArrayList<ClientAppConfig> rv = new ArrayList<ClientAppConfig>(8);
        int i = 0;
        while ((cac = ClientAppConfig.getClientApp(clientApps, PREFIX + i)) != null) {
            ++i;
            rv.add(cac);
        }
        return rv;
    }

    private static ClientAppConfig getClientApp(Properties clientApps, String prefix) {
        long delay;
        String className = clientApps.getProperty(prefix + ".main");
        if (className == null) {
            return null;
        }
        String clientName = clientApps.getProperty(prefix + ".name");
        String args = clientApps.getProperty(prefix + ".args");
        String delayStr = clientApps.getProperty(prefix + ".delay");
        String onBoot = clientApps.getProperty(prefix + ".onBoot");
        String disabled = clientApps.getProperty(prefix + ".startOnLoad");
        String classpath = clientApps.getProperty(prefix + ".classpath");
        String stopargs = clientApps.getProperty(prefix + ".stopargs");
        String uninstallargs = clientApps.getProperty(prefix + ".uninstallargs");
        boolean dis = disabled != null && "false".equals(disabled);
        boolean onStartup = false;
        if (onBoot != null) {
            boolean bl = onStartup = "true".equals(onBoot) || "yes".equals(onBoot);
        }
        if (onStartup) {
            delay = 0L;
        } else if (className.equals("net.i2p.i2ptunnel.TunnelControllerGroup")) {
            delay = -1000L;
        } else {
            delay = 120000L;
            if (delayStr != null) {
                try {
                    delay = 1000 * Integer.parseInt(delayStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new ClientAppConfig(className, clientName, args, delay, dis, classpath, stopargs, uninstallargs);
    }

    public static synchronized void writeClientAppConfig(I2PAppContext ctx, ClientAppConfig app) throws IOException {
        if (app.configFile == null) {
            File f;
            SecureDirectory dir = new SecureDirectory(ctx.getConfigDir(), CLIENT_CONFIG_DIR);
            if (!dir.isDirectory() && !((File)dir).mkdirs()) {
                throw new IOException("Can't create " + String.valueOf(dir));
            }
            int i = 0;
            String[] files = dir.list();
            if (files != null) {
                i = files.length;
            }
            do {
                String name = i + "-" + app.className + "-clients.config";
                if (i < 10) {
                    name = "0" + name;
                }
                f = new File(dir, name);
                ++i;
            } while (f.exists());
            app.configFile = f;
        }
        ClientAppConfig.writeClientAppConfig(Collections.singletonList(app), app.configFile);
    }

    public static synchronized void writeClientAppConfig(I2PAppContext ctx, List<ClientAppConfig> apps) throws IOException {
        ObjectCounterUnsafe<File> counter = new ObjectCounterUnsafe<File>();
        for (ClientAppConfig cac : apps) {
            File f = cac.configFile;
            if (f == null) {
                throw new IllegalArgumentException("No file for " + cac.className);
            }
            counter.increment(f);
        }
        IOException e = null;
        Set files = counter.objects();
        for (File f : files) {
            ArrayList<ClientAppConfig> cacs = new ArrayList<ClientAppConfig>(8);
            for (ClientAppConfig cac : apps) {
                if (!cac.configFile.equals(f)) continue;
                cacs.add(cac);
            }
            try {
                ClientAppConfig.writeClientAppConfig(cacs, f);
            }
            catch (IOException ioe) {
                if (e != null) continue;
                e = ioe;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    private static void writeClientAppConfig(List<ClientAppConfig> apps, File cfgFile) throws IOException {
        if (cfgFile == null) {
            throw new IllegalArgumentException("No file");
        }
        OrderedProperties props = new OrderedProperties();
        for (int i = 0; i < apps.size(); ++i) {
            ClientAppConfig app = apps.get(i);
            String pfx = PREFIX + i;
            props.setProperty(pfx + ".main", app.className);
            props.setProperty(pfx + ".name", app.clientName);
            if (app.args != null) {
                props.setProperty(pfx + ".args", app.args);
            }
            props.setProperty(pfx + ".delay", Long.toString(app.delay / 1000L));
            props.setProperty(pfx + ".startOnLoad", Boolean.toString(!app.disabled));
        }
        DataHelper.storeProps(props, cfgFile);
    }

    public static synchronized boolean deleteClientAppConfig(ClientAppConfig cac) throws IOException {
        File f = cac.configFile;
        if (f == null) {
            throw new IllegalArgumentException("No file for " + cac.className);
        }
        List<ClientAppConfig> cacs = ClientAppConfig.getClientApps(f);
        if (cacs.remove(cac)) {
            if (cacs.isEmpty()) {
                return f.delete();
            }
            ClientAppConfig.writeClientAppConfig(cacs, f);
            return true;
        }
        return false;
    }

    public int hashCode() {
        return DataHelper.hashCode(this.className);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ClientAppConfig) {
            ClientAppConfig cac = (ClientAppConfig)o;
            return DataHelper.eq(this.className, cac.className) && DataHelper.eq(this.clientName, cac.clientName) && DataHelper.eq(this.args, cac.args);
        }
        return false;
    }
}

