/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.pqc;

import java.security.GeneralSecurityException;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyFactory;
import net.i2p.crypto.KeyPair;
import net.i2p.router.crypto.pqc.MLKEM;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class MLKEMKeyFactory
extends I2PThread
implements KeyFactory {
    private final I2PAppContext _context;
    private final Log _log;
    private final int _minSize;
    private final int _maxSize;
    private final int _calcDelay;
    private final LinkedBlockingQueue<KeyPair> _keys;
    private final EncType _type;
    private volatile boolean _isRunning;
    private long _checkDelay = 10000L;
    private static final String PROP_MLKEM_PRECALC_MIN = "crypto.mlkem.precalc.min";
    private static final String PROP_MLKEM_PRECALC_MAX = "crypto.mlkem.precalc.max";
    private static final String PROP_MLKEM_PRECALC_DELAY = "crypto.mlkem.precalc.delay";
    private static final int DEFAULT_MLKEM_PRECALC_MIN = 4;
    private static final int DEFAULT_MLKEM_PRECALC_MAX = 12;
    private static final int DEFAULT_MLKEM_PRECALC_DELAY = 25;

    public MLKEMKeyFactory(I2PAppContext ctx, EncType type) {
        super("MLKEM Precalc");
        this._context = ctx;
        this._type = type;
        this._log = ctx.logManager().getLog(MLKEMKeyFactory.class);
        ctx.statManager().createRateStat("crypto.MLKEMGenerateTime", "How long it takes to create keys", "Encryption", new long[]{3600000L});
        ctx.statManager().createRateStat("crypto.MLKEMUsed", "Take keys from the queue", "Encryption", new long[]{3600000L});
        ctx.statManager().createRateStat("crypto.MLKEMEmpty", "Queue empty", "Encryption", new long[]{3600000L});
        long maxMemory = SystemVersion.getMaxMemory();
        int factor = (int)Math.max(1L, Math.min(4L, 1L + maxMemory / 0x8000000L));
        if (SystemVersion.isSlow()) {
            factor *= 2;
        }
        int defaultMin = 4 * factor;
        int defaultMax = 12 * factor;
        this._minSize = ctx.getProperty(PROP_MLKEM_PRECALC_MIN, defaultMin);
        this._maxSize = ctx.getProperty(PROP_MLKEM_PRECALC_MAX, defaultMax);
        this._calcDelay = ctx.getProperty(PROP_MLKEM_PRECALC_DELAY, 25);
        if (this._log.shouldDebug()) {
            this._log.debug("MLKEM Precalc (minimum: " + this._minSize + " max: " + this._maxSize + ", delay: " + this._calcDelay + ")");
        }
        this._keys = new LinkedBlockingQueue(this._maxSize);
        if (!SystemVersion.isWindows()) {
            this.setPriority(4);
        }
    }

    public void shutdown() {
        this._isRunning = false;
        this.interrupt();
        this._keys.clear();
    }

    @Override
    public void run() {
        block4: {
            try {
                this.run2();
            }
            catch (GeneralSecurityException gse) {
                if (this._isRunning) {
                    throw new IllegalStateException(gse);
                }
            }
            catch (IllegalStateException ise) {
                if (!this._isRunning) break block4;
                throw ise;
            }
        }
    }

    private void run2() throws GeneralSecurityException {
        this._isRunning = true;
        while (this._isRunning) {
            int startSize = this.getSize();
            if (startSize <= this._minSize * 2 / 3 && this._checkDelay > 1000L) {
                this._checkDelay -= 1000L;
            } else if (startSize > this._minSize * 3 / 2 && this._checkDelay < 60000L) {
                this._checkDelay += 1000L;
            }
            if (startSize < this._minSize) {
                while (this.getSize() < this._maxSize && this._isRunning) {
                    long curStart = System.currentTimeMillis();
                    if (!this.addKeys(this.precalc())) break;
                    long curCalc = System.currentTimeMillis() - curStart;
                    if (MLKEMKeyFactory.interrupted()) continue;
                    try {
                        Thread.sleep(Math.min(200L, Math.max(10L, (long)this._calcDelay + curCalc * 3L)));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this._isRunning) break;
            try {
                Thread.sleep(this._checkDelay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public KeyPair getKeys() {
        this._context.statManager().addRateData("crypto.MLKEMUsed", 1L);
        KeyPair rv = this._keys.poll();
        if (rv == null) {
            this._context.statManager().addRateData("crypto.MLKEMEmpty", 1L);
            try {
                rv = this.precalc();
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalStateException(gse);
            }
            this.interrupt();
        }
        return rv;
    }

    private KeyPair precalc() throws GeneralSecurityException {
        long start = System.currentTimeMillis();
        KeyPair rv = MLKEM.getKeys(this._type);
        long end = System.currentTimeMillis();
        long diff = end - start;
        this._context.statManager().addRateData("crypto.MLKEMGenerateTime", diff);
        return rv;
    }

    public void returnUnused(KeyPair kp) {
        this._keys.offer(kp);
    }

    private final boolean addKeys(KeyPair kp) {
        return this._keys.offer(kp);
    }

    private final int getSize() {
        return this._keys.size();
    }
}

