/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2;

import com.maxmind.db.CHMCache;
import com.maxmind.db.Metadata;
import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DatabaseReader
implements Closeable {
    private final Reader reader;
    private final List<String> locales;

    private DatabaseReader(Builder builder) throws IOException {
        if (builder.stream != null) {
            this.reader = new Reader(builder.stream, builder.cache);
        } else if (builder.database != null) {
            this.reader = new Reader(builder.database, builder.mode, builder.cache);
        } else {
            throw new IllegalArgumentException("Unsupported Builder configuration: expected either File or URL");
        }
        this.locales = builder.locales;
    }

    private Object get(InetAddress ipAddress, String type) throws IOException {
        String databaseType = this.getMetadata().getDatabaseType();
        if (!databaseType.contains(type)) {
            String caller = Thread.currentThread().getStackTrace()[2].getMethodName();
            throw new UnsupportedOperationException("Invalid attempt to open a " + databaseType + " database using the " + caller + " method");
        }
        return this.reader.get(ipAddress);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public String country(String ipAddress) throws IOException {
        InetAddress ia = InetAddress.getByName(ipAddress);
        Object o = this.get(ia, "Country");
        if (!(o instanceof Map)) {
            return null;
        }
        Map m = (Map)o;
        if (!((o = m.get("country")) instanceof Map)) {
            return null;
        }
        m = (Map)o;
        if (!((o = m.get("iso_code")) instanceof String)) {
            return null;
        }
        return (String)o;
    }

    public void countryToIP(String country, Writer out) throws IOException {
        this.reader.countryToIP(country.toUpperCase(Locale.US), out);
    }

    public Metadata getMetadata() {
        return this.reader.getMetadata();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: DatabaseReader geoip2-file.mmdb ip");
            System.exit(1);
        }
        File f = new File(args[0]);
        Builder b = new Builder(f);
        b.withCache(new CHMCache(256));
        DatabaseReader r = b.build();
        System.out.println("Database Metadata: " + String.valueOf(r.getMetadata()));
        String c = r.country(args[1]);
        System.out.println("IP: " + args[1] + " country: " + c);
    }

    public static final class Builder {
        final File database;
        final InputStream stream;
        List<String> locales = Collections.singletonList("en");
        Reader.FileMode mode = Reader.FileMode.MEMORY_MAPPED;
        NodeCache cache = NoCache.getInstance();

        public Builder(InputStream stream) {
            this.stream = stream;
            this.database = null;
        }

        public Builder(File database) {
            this.database = database;
            this.stream = null;
        }

        public Builder locales(List<String> val) {
            this.locales = val;
            return this;
        }

        public Builder withCache(NodeCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder fileMode(Reader.FileMode val) {
            if (this.stream != null && Reader.FileMode.MEMORY != val) {
                throw new IllegalArgumentException("Only FileMode.MEMORY is supported when using an InputStream.");
            }
            this.mode = val;
            return this;
        }

        public DatabaseReader build() throws IOException {
            return new DatabaseReader(this);
        }
    }
}

