/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip;

import com.maxmind.geoip.Country;
import com.maxmind.geoip.DatabaseInfo;
import com.maxmind.geoip.InvalidDatabaseException;
import com.maxmind.geoip.Location;
import com.maxmind.geoip.Region;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class LookupService {
    private RandomAccessFile file;
    private final File databaseFile;
    private DatabaseInfo databaseInfo;
    private static final Charset charset = Charset.forName("ISO-8859-1");
    private final CharsetDecoder charsetDecoder = charset.newDecoder();
    private byte databaseType = 1;
    private int[] databaseSegments;
    private int recordLength;
    private int dboptions;
    private byte[] dbbuffer;
    private byte[] index_cache;
    private long mtime;
    private int last_netmask;
    private static final int US_OFFSET = 1;
    private static final int CANADA_OFFSET = 677;
    private static final int WORLD_OFFSET = 1353;
    private static final int FIPS_RANGE = 360;
    private static final int COUNTRY_BEGIN = 0xFFFF00;
    private static final int STATE_BEGIN_REV0 = 16700000;
    private static final int STATE_BEGIN_REV1 = 16000000;
    private static final int STRUCTURE_INFO_MAX_SIZE = 20;
    private static final int DATABASE_INFO_MAX_SIZE = 100;
    public static final int GEOIP_STANDARD = 0;
    public static final int GEOIP_MEMORY_CACHE = 1;
    public static final int GEOIP_CHECK_CACHE = 2;
    public static final int GEOIP_INDEX_CACHE = 4;
    public static final int GEOIP_UNKNOWN_SPEED = 0;
    public static final int GEOIP_DIALUP_SPEED = 1;
    public static final int GEOIP_CABLEDSL_SPEED = 2;
    public static final int GEOIP_CORPORATE_SPEED = 3;
    private static final int SEGMENT_RECORD_LENGTH = 3;
    private static final int STANDARD_RECORD_LENGTH = 3;
    private static final int ORG_RECORD_LENGTH = 4;
    private static final int MAX_RECORD_LENGTH = 4;
    private static final int MAX_ORG_RECORD_LENGTH = 300;
    private static final int FULL_RECORD_LENGTH = 60;
    private final Country UNKNOWN_COUNTRY = new Country("--", "N/A");
    private static final String[] countryCode = new String[]{"--", "AP", "EU", "AD", "AE", "AF", "AG", "AI", "AL", "AM", "CW", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "SX", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TM", "TN", "TO", "TL", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "RS", "ZA", "ZM", "ME", "ZW", "A1", "A2", "O1", "AX", "GG", "IM", "JE", "BL", "MF", "BQ", "SS", "O1"};
    private static final String[] countryName = new String[]{"N/A", "Asia/Pacific Region", "Europe", "Andorra", "United Arab Emirates", "Afghanistan", "Antigua and Barbuda", "Anguilla", "Albania", "Armenia", "Curacao", "Angola", "Antarctica", "Argentina", "American Samoa", "Austria", "Australia", "Aruba", "Azerbaijan", "Bosnia and Herzegovina", "Barbados", "Bangladesh", "Belgium", "Burkina Faso", "Bulgaria", "Bahrain", "Burundi", "Benin", "Bermuda", "Brunei Darussalam", "Bolivia", "Brazil", "Bahamas", "Bhutan", "Bouvet Island", "Botswana", "Belarus", "Belize", "Canada", "Cocos (Keeling) Islands", "Congo, The Democratic Republic of the", "Central African Republic", "Congo", "Switzerland", "Cote D'Ivoire", "Cook Islands", "Chile", "Cameroon", "China", "Colombia", "Costa Rica", "Cuba", "Cape Verde", "Christmas Island", "Cyprus", "Czech Republic", "Germany", "Djibouti", "Denmark", "Dominica", "Dominican Republic", "Algeria", "Ecuador", "Estonia", "Egypt", "Western Sahara", "Eritrea", "Spain", "Ethiopia", "Finland", "Fiji", "Falkland Islands (Malvinas)", "Micronesia, Federated States of", "Faroe Islands", "France", "Sint Maarten (Dutch part)", "Gabon", "United Kingdom", "Grenada", "Georgia", "French Guiana", "Ghana", "Gibraltar", "Greenland", "Gambia", "Guinea", "Guadeloupe", "Equatorial Guinea", "Greece", "South Georgia and the South Sandwich Islands", "Guatemala", "Guam", "Guinea-Bissau", "Guyana", "Hong Kong", "Heard Island and McDonald Islands", "Honduras", "Croatia", "Haiti", "Hungary", "Indonesia", "Ireland", "Israel", "India", "British Indian Ocean Territory", "Iraq", "Iran, Islamic Republic of", "Iceland", "Italy", "Jamaica", "Jordan", "Japan", "Kenya", "Kyrgyzstan", "Cambodia", "Kiribati", "Comoros", "Saint Kitts and Nevis", "Korea, Democratic People's Republic of", "Korea, Republic of", "Kuwait", "Cayman Islands", "Kazakhstan", "Lao People's Democratic Republic", "Lebanon", "Saint Lucia", "Liechtenstein", "Sri Lanka", "Liberia", "Lesotho", "Lithuania", "Luxembourg", "Latvia", "Libya", "Morocco", "Monaco", "Moldova, Republic of", "Madagascar", "Marshall Islands", "Macedonia", "Mali", "Myanmar", "Mongolia", "Macau", "Northern Mariana Islands", "Martinique", "Mauritania", "Montserrat", "Malta", "Mauritius", "Maldives", "Malawi", "Mexico", "Malaysia", "Mozambique", "Namibia", "New Caledonia", "Niger", "Norfolk Island", "Nigeria", "Nicaragua", "Netherlands", "Norway", "Nepal", "Nauru", "Niue", "New Zealand", "Oman", "Panama", "Peru", "French Polynesia", "Papua New Guinea", "Philippines", "Pakistan", "Poland", "Saint Pierre and Miquelon", "Pitcairn Islands", "Puerto Rico", "Palestinian Territory", "Portugal", "Palau", "Paraguay", "Qatar", "Reunion", "Romania", "Russian Federation", "Rwanda", "Saudi Arabia", "Solomon Islands", "Seychelles", "Sudan", "Sweden", "Singapore", "Saint Helena", "Slovenia", "Svalbard and Jan Mayen", "Slovakia", "Sierra Leone", "San Marino", "Senegal", "Somalia", "Suriname", "Sao Tome and Principe", "El Salvador", "Syrian Arab Republic", "Swaziland", "Turks and Caicos Islands", "Chad", "French Southern Territories", "Togo", "Thailand", "Tajikistan", "Tokelau", "Turkmenistan", "Tunisia", "Tonga", "Timor-Leste", "Turkey", "Trinidad and Tobago", "Tuvalu", "Taiwan", "Tanzania, United Republic of", "Ukraine", "Uganda", "United States Minor Outlying Islands", "United States", "Uruguay", "Uzbekistan", "Holy See (Vatican City State)", "Saint Vincent and the Grenadines", "Venezuela", "Virgin Islands, British", "Virgin Islands, U.S.", "Vietnam", "Vanuatu", "Wallis and Futuna", "Samoa", "Yemen", "Mayotte", "Serbia", "South Africa", "Zambia", "Montenegro", "Zimbabwe", "Anonymous Proxy", "Satellite Provider", "Other", "Aland Islands", "Guernsey", "Isle of Man", "Jersey", "Saint Barthelemy", "Saint Martin", "Bonaire, Saint Eustatius and Saba", "South Sudan", "Other"};

    public LookupService(String databaseFile) throws IOException {
        this(new File(databaseFile));
    }

    public LookupService(File databaseFile) throws IOException {
        this.databaseFile = databaseFile;
        this.file = new RandomAccessFile(databaseFile, "r");
        this.init();
    }

    public LookupService(String databaseFile, int options) throws IOException {
        this(new File(databaseFile), options);
    }

    public LookupService(File databaseFile, int options) throws IOException {
        this.databaseFile = databaseFile;
        this.file = new RandomAccessFile(databaseFile, "r");
        this.dboptions = options;
        this.init();
    }

    private synchronized void init() throws IOException {
        int l;
        byte[] delim = new byte[3];
        byte[] buf = new byte[3];
        if (this.file == null) {
            return;
        }
        if ((this.dboptions & 2) != 0) {
            this.mtime = this.databaseFile.lastModified();
        }
        this.file.seek(this.file.length() - 3L);
        for (int i = 0; i < 20; ++i) {
            this.file.readFully(delim);
            if (delim[0] == -1 && delim[1] == -1 && delim[2] == -1) {
                this.databaseType = this.file.readByte();
                if (this.databaseType >= 106) {
                    this.databaseType = (byte)(this.databaseType - 105);
                }
                if (this.databaseType == 7) {
                    this.databaseSegments = new int[1];
                    this.databaseSegments[0] = 16700000;
                    this.recordLength = 3;
                    break;
                }
                if (this.databaseType == 3) {
                    this.databaseSegments = new int[1];
                    this.databaseSegments[0] = 16000000;
                    this.recordLength = 3;
                    break;
                }
                if (this.databaseType != 6 && this.databaseType != 2 && this.databaseType != 5 && this.databaseType != 23 && this.databaseType != 4 && this.databaseType != 22 && this.databaseType != 11 && this.databaseType != 24 && this.databaseType != 9 && this.databaseType != 21 && this.databaseType != 32 && this.databaseType != 33 && this.databaseType != 31 && this.databaseType != 30) break;
                this.databaseSegments = new int[1];
                this.databaseSegments[0] = 0;
                this.recordLength = this.databaseType == 6 || this.databaseType == 2 || this.databaseType == 21 || this.databaseType == 32 || this.databaseType == 33 || this.databaseType == 31 || this.databaseType == 30 || this.databaseType == 9 ? 3 : 4;
                this.file.readFully(buf);
                for (int j = 0; j < 3; ++j) {
                    this.databaseSegments[0] = this.databaseSegments[0] + (LookupService.unsignedByteToInt(buf[j]) << j * 8);
                }
                break;
            }
            this.file.seek(this.file.getFilePointer() - 4L);
        }
        if (this.databaseType == 1 || this.databaseType == 12 || this.databaseType == 8 || this.databaseType == 10) {
            this.databaseSegments = new int[1];
            this.databaseSegments[0] = 0xFFFF00;
            this.recordLength = 3;
        }
        if ((this.dboptions & 1) == 1) {
            l = (int)this.file.length();
            this.dbbuffer = new byte[l];
            this.file.seek(0L);
            this.file.readFully(this.dbbuffer, 0, l);
            this.databaseInfo = this.getDatabaseInfo();
            this.file.close();
        }
        if ((this.dboptions & 4) != 0) {
            l = this.databaseSegments[0] * this.recordLength * 2;
            this.index_cache = new byte[l];
            this.file.seek(0L);
            this.file.readFully(this.index_cache, 0, l);
        } else {
            this.index_cache = null;
        }
    }

    public synchronized void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
            this.file = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<String> getAllCountryNames() {
        return Arrays.asList(Arrays.copyOf(countryName, countryName.length));
    }

    public List<String> getAllCountryCodes() {
        return Arrays.asList(Arrays.copyOf(countryCode, countryCode.length));
    }

    public Country getCountryV6(String ipAddress) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            return this.UNKNOWN_COUNTRY;
        }
        return this.getCountryV6(addr);
    }

    public Country getCountry(String ipAddress) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            return this.UNKNOWN_COUNTRY;
        }
        return this.getCountry(addr);
    }

    public synchronized Country getCountry(InetAddress ipAddress) {
        return this.getCountry(LookupService.bytesToLong(ipAddress.getAddress()));
    }

    public synchronized Country getCountryV6(InetAddress addr) {
        if (this.file == null && (this.dboptions & 1) == 0) {
            throw new IllegalStateException("Database has been closed.");
        }
        int ret = this.seekCountryV6(addr) - 0xFFFF00;
        if (ret == 0) {
            return this.UNKNOWN_COUNTRY;
        }
        return new Country(countryCode[ret], countryName[ret]);
    }

    public synchronized Country getCountry(long ipAddress) {
        if (this.file == null && (this.dboptions & 1) == 0) {
            throw new IllegalStateException("Database has been closed.");
        }
        int ret = this.seekCountry(ipAddress) - 0xFFFF00;
        if (ret == 0) {
            return this.UNKNOWN_COUNTRY;
        }
        return new Country(countryCode[ret], countryName[ret]);
    }

    public synchronized void countryToIP(String country, Writer out) throws IOException {
        if (this.file == null && (this.dboptions & 1) == 0) {
            throw new IllegalStateException("Database has been closed.");
        }
        country = country.toUpperCase(Locale.US);
        int id = 0;
        for (int i = 0; i < countryCode.length; ++i) {
            if (!countryCode[i].equals(country)) continue;
            id = i;
            break;
        }
        if (id <= 0) {
            return;
        }
        Walker walker = new Walker(id += 0xFFFF00, out);
        out.write("# IPs for country " + country + " from GeoIP database\n");
        walker.walk();
    }

    public int getID(String ipAddress) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            return 0;
        }
        return this.getID(LookupService.bytesToLong(addr.getAddress()));
    }

    public int getID(InetAddress ipAddress) {
        return this.getID(LookupService.bytesToLong(ipAddress.getAddress()));
    }

    public synchronized int getID(long ipAddress) {
        if (this.file == null && (this.dboptions & 1) == 0) {
            throw new IllegalStateException("Database has been closed.");
        }
        return this.seekCountry(ipAddress) - this.databaseSegments[0];
    }

    public int last_netmask() {
        return this.last_netmask;
    }

    public void netmask(int nm) {
        this.last_netmask = nm;
    }

    public synchronized DatabaseInfo getDatabaseInfo() {
        if (this.databaseInfo != null) {
            return this.databaseInfo;
        }
        try {
            int i;
            this._check_mtime();
            boolean hasStructureInfo = false;
            byte[] delim = new byte[3];
            this.file.seek(this.file.length() - 3L);
            for (i = 0; i < 20; ++i) {
                int read = this.file.read(delim);
                if (read == 3 && (delim[0] & 0xFF) == 255 && (delim[1] & 0xFF) == 255 && (delim[2] & 0xFF) == 255) {
                    hasStructureInfo = true;
                    break;
                }
                this.file.seek(this.file.getFilePointer() - 4L);
            }
            if (hasStructureInfo) {
                this.file.seek(this.file.getFilePointer() - 6L);
            } else {
                this.file.seek(this.file.length() - 3L);
            }
            for (i = 0; i < 100; ++i) {
                this.file.readFully(delim);
                if (delim[0] == 0 && delim[1] == 0 && delim[2] == 0) {
                    byte[] dbInfo = new byte[i];
                    this.file.readFully(dbInfo);
                    this.databaseInfo = new DatabaseInfo(new String(dbInfo, charset));
                    return this.databaseInfo;
                }
                this.file.seek(this.file.getFilePointer() - 4L);
            }
        }
        catch (IOException e) {
            throw new InvalidDatabaseException("Error reading database info", e);
        }
        return new DatabaseInfo("");
    }

    synchronized void _check_mtime() {
        try {
            long t;
            if ((this.dboptions & 2) != 0 && (t = this.databaseFile.lastModified()) != this.mtime) {
                this.close();
                this.file = new RandomAccessFile(this.databaseFile, "r");
                this.databaseInfo = null;
                this.init();
            }
        }
        catch (IOException e) {
            throw new InvalidDatabaseException("Database not found", e);
        }
    }

    public Location getLocationV6(String str) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(str);
        }
        catch (UnknownHostException e) {
            return null;
        }
        return this.getLocationV6(addr);
    }

    public Location getLocation(InetAddress addr) {
        return this.getLocation(LookupService.bytesToLong(addr.getAddress()));
    }

    public Location getLocation(String str) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(str);
        }
        catch (UnknownHostException e) {
            return null;
        }
        return this.getLocation(addr);
    }

    public synchronized Region getRegion(String str) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(str);
        }
        catch (UnknownHostException e) {
            return null;
        }
        return this.getRegion(LookupService.bytesToLong(addr.getAddress()));
    }

    public synchronized Region getRegion(InetAddress addr) {
        return this.getRegion(LookupService.bytesToLong(addr.getAddress()));
    }

    public synchronized Region getRegion(long ipnum) {
        Region record = new Region();
        if (this.databaseType == 7) {
            int seek_region = this.seekCountry(ipnum) - 16700000;
            char[] ch = new char[2];
            if (seek_region >= 1000) {
                record.countryCode = "US";
                record.countryName = "United States";
                ch[0] = (char)((seek_region - 1000) / 26 + 65);
                ch[1] = (char)((seek_region - 1000) % 26 + 65);
                record.region = new String(ch);
            } else {
                record.countryCode = countryCode[seek_region];
                record.countryName = countryName[seek_region];
                record.region = "";
            }
        } else if (this.databaseType == 3) {
            int seek_region = this.seekCountry(ipnum) - 16000000;
            char[] ch = new char[2];
            if (seek_region < 1) {
                record.countryCode = "";
                record.countryName = "";
                record.region = "";
            } else if (seek_region < 677) {
                record.countryCode = "US";
                record.countryName = "United States";
                ch[0] = (char)((seek_region - 1) / 26 + 65);
                ch[1] = (char)((seek_region - 1) % 26 + 65);
                record.region = new String(ch);
            } else if (seek_region < 1353) {
                record.countryCode = "CA";
                record.countryName = "Canada";
                ch[0] = (char)((seek_region - 677) / 26 + 65);
                ch[1] = (char)((seek_region - 677) % 26 + 65);
                record.region = new String(ch);
            } else {
                record.countryCode = countryCode[(seek_region - 1353) / 360];
                record.countryName = countryName[(seek_region - 1353) / 360];
                record.region = "";
            }
        }
        return record;
    }

    public synchronized Location getLocationV6(InetAddress addr) {
        try {
            int seek_country = this.seekCountryV6(addr);
            return this.readCityRecord(seek_country);
        }
        catch (IOException e) {
            throw new InvalidDatabaseException("Error while seting up segments", e);
        }
    }

    public synchronized Location getLocation(long ipnum) {
        try {
            int seek_country = this.seekCountry(ipnum);
            return this.readCityRecord(seek_country);
        }
        catch (IOException e) {
            throw new InvalidDatabaseException("Error while seting up segments", e);
        }
    }

    private Location readCityRecord(int seekCountry) throws IOException {
        if (seekCountry == this.databaseSegments[0]) {
            return null;
        }
        ByteBuffer buffer = this.readRecordBuf(seekCountry, 60);
        Location record = new Location();
        int country = LookupService.unsignedByteToInt(buffer.get());
        record.countryCode = countryCode[country];
        record.countryName = countryName[country];
        record.region = this.readString(buffer);
        record.city = this.readString(buffer);
        record.postalCode = this.readString(buffer);
        record.latitude = LookupService.readAngle(buffer);
        record.longitude = LookupService.readAngle(buffer);
        if (this.databaseType == 2 && "US".equals(record.countryCode)) {
            int metroarea_combo = LookupService.readMetroAreaCombo(buffer);
            record.metro_code = record.dma_code = metroarea_combo / 1000;
            record.area_code = metroarea_combo % 1000;
        }
        return record;
    }

    private ByteBuffer readRecordBuf(int seek, int maxLength) throws IOException {
        ByteBuffer buffer;
        int recordPointer = seek + (2 * this.recordLength - 1) * this.databaseSegments[0];
        if ((this.dboptions & 1) == 1) {
            buffer = ByteBuffer.wrap(this.dbbuffer, recordPointer, Math.min(this.dbbuffer.length - recordPointer, maxLength));
        } else {
            byte[] recordBuf = new byte[maxLength];
            this.file.seek(recordPointer);
            this.file.read(recordBuf);
            buffer = ByteBuffer.wrap(recordBuf);
        }
        return buffer;
    }

    private String readString(ByteBuffer buffer) throws CharacterCodingException {
        int start = buffer.position();
        int oldLimit = buffer.limit();
        while (buffer.hasRemaining() && buffer.get() != 0) {
        }
        int end = buffer.position() - 1;
        String str = null;
        if (end > start) {
            buffer.position(start);
            buffer.limit(end);
            str = this.charsetDecoder.decode(buffer).toString();
            buffer.limit(oldLimit);
        }
        buffer.position(end + 1);
        return str;
    }

    private static float readAngle(ByteBuffer buffer) {
        if (buffer.remaining() < 3) {
            throw new InvalidDatabaseException("Unexpected end of data record when reading angle");
        }
        double num = 0.0;
        for (int j = 0; j < 3; ++j) {
            num += (double)(LookupService.unsignedByteToInt(buffer.get()) << j * 8);
        }
        return (float)num / 10000.0f - 180.0f;
    }

    private static int readMetroAreaCombo(ByteBuffer buffer) {
        if (buffer.remaining() < 3) {
            throw new InvalidDatabaseException("Unexpected end of data record when reading metro area");
        }
        int metroareaCombo = 0;
        for (int j = 0; j < 3; ++j) {
            metroareaCombo += LookupService.unsignedByteToInt(buffer.get()) << j * 8;
        }
        return metroareaCombo;
    }

    public String getOrg(InetAddress addr) {
        return this.getOrg(LookupService.bytesToLong(addr.getAddress()));
    }

    public String getOrg(String str) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(str);
        }
        catch (UnknownHostException e) {
            return null;
        }
        return this.getOrg(addr);
    }

    public synchronized String getOrg(long ipnum) {
        try {
            int seekOrg = this.seekCountry(ipnum);
            return this.readOrgRecord(seekOrg);
        }
        catch (IOException e) {
            throw new InvalidDatabaseException("Error while reading org", e);
        }
    }

    public String getOrgV6(String str) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(str);
        }
        catch (UnknownHostException e) {
            return null;
        }
        return this.getOrgV6(addr);
    }

    public synchronized String getOrgV6(InetAddress addr) {
        try {
            int seekOrg = this.seekCountryV6(addr);
            return this.readOrgRecord(seekOrg);
        }
        catch (IOException e) {
            throw new InvalidDatabaseException("Error while reading org", e);
        }
    }

    private String readOrgRecord(int seekOrg) throws IOException {
        if (seekOrg == this.databaseSegments[0]) {
            return null;
        }
        ByteBuffer buf = this.readRecordBuf(seekOrg, 300);
        return this.readString(buf);
    }

    private synchronized int seekCountryV6(InetAddress addr) {
        byte[] v6vec = addr.getAddress();
        if (v6vec.length == 4) {
            byte[] t = new byte[16];
            System.arraycopy(v6vec, 0, t, 12, 4);
            v6vec = t;
        }
        byte[] buf = new byte[8];
        int[] x = new int[2];
        int offset = 0;
        this._check_mtime();
        for (int depth = 127; depth >= 0; --depth) {
            this.readNode(buf, x, offset);
            int bnum = 127 - depth;
            int idx = bnum >> 3;
            int b_mask = 1 << (bnum & 7 ^ 7);
            if ((v6vec[idx] & b_mask) > 0) {
                if (x[1] >= this.databaseSegments[0]) {
                    this.last_netmask = 128 - depth;
                    return x[1];
                }
                offset = x[1];
                continue;
            }
            if (x[0] >= this.databaseSegments[0]) {
                this.last_netmask = 128 - depth;
                return x[0];
            }
            offset = x[0];
        }
        throw new InvalidDatabaseException("Error seeking country while searching for " + addr.getHostAddress());
    }

    private synchronized int seekCountry(long ipAddress) {
        byte[] buf = new byte[8];
        int[] x = new int[2];
        int offset = 0;
        this._check_mtime();
        for (int depth = 31; depth >= 0; --depth) {
            this.readNode(buf, x, offset);
            if ((ipAddress & (long)(1 << depth)) > 0L) {
                if (x[1] >= this.databaseSegments[0]) {
                    this.last_netmask = 32 - depth;
                    return x[1];
                }
                offset = x[1];
                continue;
            }
            if (x[0] >= this.databaseSegments[0]) {
                this.last_netmask = 32 - depth;
                return x[0];
            }
            offset = x[0];
        }
        throw new InvalidDatabaseException("Error seeking country while searching for " + ipAddress);
    }

    private void readNode(byte[] buf, int[] x, int offset) {
        if ((this.dboptions & 1) == 1) {
            System.arraycopy(this.dbbuffer, 2 * this.recordLength * offset, buf, 0, 2 * this.recordLength);
        } else if ((this.dboptions & 4) != 0) {
            System.arraycopy(this.index_cache, 2 * this.recordLength * offset, buf, 0, 2 * this.recordLength);
        } else {
            try {
                this.file.seek(2 * this.recordLength * offset);
                this.file.read(buf);
            }
            catch (IOException e) {
                throw new InvalidDatabaseException("Error seeking in database", e);
            }
        }
        for (int i = 0; i < 2; ++i) {
            x[i] = 0;
            for (int j = 0; j < this.recordLength; ++j) {
                int y = buf[i * this.recordLength + j];
                if (y < 0) {
                    y += 256;
                }
                int n = i;
                x[n] = x[n] + (y << j * 8);
            }
        }
    }

    private static long bytesToLong(byte[] address) {
        long ipnum = 0L;
        for (int i = 0; i < 4; ++i) {
            long y = address[i];
            if (y < 0L) {
                y += 256L;
            }
            ipnum += y << (3 - i) * 8;
        }
        return ipnum;
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    static {
        if (countryCode.length != countryName.length) {
            throw new AssertionError((Object)"countryCode.length!=countryName.length");
        }
    }

    private class Walker {
        private final int _country;
        private final Writer _out;
        private final byte[] _buf = new byte[8];
        private final int[] _x = new int[2];
        private final int _dbs0;

        public Walker(int country, Writer out) throws IOException {
            this._dbs0 = LookupService.this.databaseSegments[0];
            this._country = country;
            this._out = out;
        }

        public void walk() throws IOException {
            this.walk(0, 0, 31);
        }

        private void walk(int offset, int ip, int depth) throws IOException {
            if (offset >= this._dbs0) {
                if (offset == this._country) {
                    String sip = (ip >> 24 & 0xFF) + "." + (ip >> 16 & 0xFF) + "." + (ip >> 8 & 0xFF) + "." + (ip & 0xFF);
                    this._out.write(sip);
                    if (depth >= 0) {
                        this._out.write(47);
                        this._out.write(Integer.toString(31 - depth));
                    }
                    this._out.write(10);
                }
                return;
            }
            if (depth < 0) {
                return;
            }
            LookupService.this.readNode(this._buf, this._x, offset);
            int x1 = this._x[1];
            this.walk(this._x[0], ip, depth - 1);
            this.walk(x1, ip |= 1 << depth, depth - 1);
        }
    }
}

