/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.data.DataHelper;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.TunnelController;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SystemVersion;

public class TunnelControllerGroup
implements ClientApp {
    private final Log _log;
    private volatile ClientAppState _state;
    private final I2PAppContext _context;
    private final ClientAppManager _mgr;
    private static volatile TunnelControllerGroup _instance;
    static final String DEFAULT_CONFIG_FILE = "i2ptunnel.config";
    private static final String CONFIG_DIR = "i2ptunnel.config.d";
    private static final String PREFIX = "tunnel.";
    private final List<TunnelController> _controllers;
    private final ReadWriteLock _controllersLock;
    private boolean _controllersLoaded;
    private final String _configFile;
    private final String _configDirectory;
    private static final String REGISTERED_NAME = "i2ptunnel";
    private final Map<I2PSession, Set<TunnelController>> _sessions;
    private ThreadPoolExecutor _executor;
    private static final AtomicLong _executorThreadCount;
    private final Object _executorLock = new Object();
    private static final long HANDLER_KEEPALIVE_MS = 120000L;
    private static final char[] ILLEGAL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TunnelControllerGroup getInstance() {
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            I2PAppContext ctx;
            if (_instance == null && !SystemVersion.isAndroid() && !(ctx = I2PAppContext.getGlobalContext()).isRouterContext()) {
                _instance = new TunnelControllerGroup(ctx, null, null);
                _instance.startup();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TunnelControllerGroup getInstance(I2PAppContext ctx) {
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance == null) {
                if (SystemVersion.isAndroid() || !ctx.isRouterContext()) {
                    _instance = new TunnelControllerGroup(ctx, null, null);
                    _instance.startup();
                }
            } else if (SystemVersion.isAndroid() && TunnelControllerGroup._instance._context != ctx) {
                ctx.logManager().getLog(TunnelControllerGroup.class).warn("Old context in TCG");
                _instance.shutdown();
                _instance = new TunnelControllerGroup(ctx, null, null);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunnelControllerGroup(I2PAppContext context, ClientAppManager mgr, String[] args) {
        this._state = ClientAppState.UNINITIALIZED;
        this._context = context;
        this._mgr = mgr;
        this._log = this._context.logManager().getLog(TunnelControllerGroup.class);
        this._controllers = new ArrayList<TunnelController>();
        this._controllersLock = new ReentrantReadWriteLock(true);
        if (args == null || args.length <= 0) {
            this._configFile = DEFAULT_CONFIG_FILE;
            this._configDirectory = CONFIG_DIR;
        } else if (args.length == 1) {
            String[] answer = this.setupArguments(args);
            this._configFile = answer[0];
            this._configDirectory = answer[1];
        } else {
            throw new IllegalArgumentException("Usage: TunnelControllerGroup [filename] [configdirectory] ");
        }
        this._sessions = new HashMap<I2PSession, Set<TunnelController>>(4);
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance == null) {
                _instance = this;
            } else {
                this._log.logAlways(30, "New TunnelControllerGroup, now you have two");
                if (this._log.shouldLog(30)) {
                    this._log.warn("I did it", new Exception());
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this._state = ClientAppState.INITIALIZED;
            return;
        }
    }

    private String[] setupArguments(String[] args) {
        String configFile = DEFAULT_CONFIG_FILE;
        String configDirectory = CONFIG_DIR;
        File check = new File(args[0]);
        if (!check.isAbsolute()) {
            check = new File(this._context.getConfigDir(), args[0]);
        }
        if (check.isFile()) {
            configFile = args[0];
        } else if (check.isDirectory()) {
            configDirectory = args[0];
        }
        return new String[]{configFile, configDirectory};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            _instance = new TunnelControllerGroup(I2PAppContext.getGlobalContext(), null, args);
            _instance.startup();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public I2PAppContext getContext() {
        return this._context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        File configFile = new File(this._configFile);
        if (!configFile.isAbsolute()) {
            configFile = new File(this._context.getConfigDir(), this._configFile);
        }
        try {
            if (this._log.shouldInfo()) {
                this._log.info("Configuring tunnels from " + String.valueOf(configFile));
            }
            this.loadControllers(configFile);
        }
        catch (IllegalArgumentException iae) {
            if (DEFAULT_CONFIG_FILE.equals(configFile.getName()) && !this._context.isRouterContext()) {
                TunnelControllerGroup tunnelControllerGroup = this;
                synchronized (tunnelControllerGroup) {
                    this._controllersLoaded = true;
                }
                this._log.logAlways(30, "Not in router context and no preconfigured tunnels");
            }
            throw iae;
        }
        this.startControllers();
        if (this._mgr != null) {
            this._mgr.register(this);
        } else {
            this._context.addShutdownTask(new Shutdown());
        }
    }

    @Override
    public ClientAppState getState() {
        return this._state;
    }

    @Override
    public String getName() {
        return REGISTERED_NAME;
    }

    @Override
    public String getDisplayName() {
        return REGISTERED_NAME;
    }

    private void changeState(ClientAppState state) {
        this.changeState(state, null);
    }

    private synchronized void changeState(ClientAppState state, Exception e) {
        this._state = state;
        if (this._mgr != null) {
            this._mgr.notify(this, state, null, e);
        }
    }

    @Override
    public void shutdown(String[] args) {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this._state != ClientAppState.STARTING && this._state != ClientAppState.RUNNING) {
            return;
        }
        this.changeState(ClientAppState.STOPPING);
        if (this._mgr != null) {
            this._mgr.unregister(this);
        }
        this.unloadControllers();
        Class<TunnelControllerGroup> clazz = TunnelControllerGroup.class;
        synchronized (TunnelControllerGroup.class) {
            if (_instance == this) {
                _instance = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.killClientExecutor();
            this.changeState(ClientAppState.STOPPED);
            return;
        }
    }

    private boolean shouldMigrate() {
        try {
            if (this._context.isRouterContext() && !SystemVersion.isAndroid() && !this._context.getConfigDir().getCanonicalPath().equals(this._context.getBaseDir().getCanonicalPath())) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public synchronized void loadControllers(File cfgFile) {
        if (this._controllersLoaded) {
            return;
        }
        this.loadControllers(cfgFile, this.shouldMigrate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadControllers(File cfgFile, boolean shouldMigrate) {
        if (this._log.shouldInfo()) {
            this._log.info("Getting controllers from config file " + String.valueOf(cfgFile));
        }
        SecureDirectory dir = new SecureDirectory(this._context.getConfigDir(), CONFIG_DIR);
        List<Properties> props = null;
        if (cfgFile.exists()) {
            try {
                props = this.loadConfig(cfgFile);
                if (shouldMigrate && !dir.exists()) {
                    boolean ok = this.migrate(props, cfgFile, dir);
                    if (!ok) {
                        shouldMigrate = false;
                    }
                    this._log.logAlways(30, "Migrated tunnel configurations to " + String.valueOf(dir) + " from " + String.valueOf(cfgFile));
                }
                this._log.logAlways(30, "Not migrating tunnel configurations");
            }
            catch (IOException ioe) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Unable to load the controllers from " + cfgFile.getAbsolutePath());
                }
                throw new IllegalArgumentException("Unable to load the controllers from " + String.valueOf(cfgFile), ioe);
            }
        } else if (!shouldMigrate) {
            throw new IllegalArgumentException("Unable to load the controllers from " + String.valueOf(cfgFile));
        }
        this._controllersLock.writeLock().lock();
        try {
            if (shouldMigrate && dir.isDirectory()) {
                List<File> fileList = this.listFiles();
                for (File f : fileList) {
                    try {
                        props = this.loadConfig(f);
                        if (!props.isEmpty()) {
                            for (Properties cfg : props) {
                                String type = cfg.getProperty("type");
                                if (type == null) continue;
                                TunnelController controller = new TunnelController(cfg, "");
                                this._controllers.add(controller);
                            }
                            if (!this._log.shouldLog(20)) continue;
                            this._log.info("Loaded application config from " + f.toString());
                            continue;
                        }
                        if (!this._log.shouldLog(40)) continue;
                        this._log.error("Error loading the client app properties from " + String.valueOf(f));
                    }
                    catch (IOException ioe) {
                        if (!this._log.shouldLog(40)) continue;
                        this._log.error("Error loading the client app properties from " + String.valueOf(f) + " " + String.valueOf(ioe));
                    }
                }
            } else if (props != null) {
                for (Properties cfg : props) {
                    String type = cfg.getProperty("type");
                    if (type == null) continue;
                    TunnelController controller = new TunnelController(cfg, "");
                    this._controllers.add(controller);
                }
            }
        }
        finally {
            this._controllersLock.writeLock().unlock();
        }
        this._controllersLoaded = true;
        int i = this._controllers.size();
        if (i > 0) {
            if (this._log.shouldLog(20)) {
                this._log.info(i + " controllers loaded from " + String.valueOf(cfgFile));
            }
        } else {
            this._log.logAlways(30, "No i2ptunnel configurations found in " + String.valueOf(cfgFile) + " or " + String.valueOf(dir));
        }
    }

    private boolean migrate(List<Properties> tunnels, File from, File dir) {
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return false;
        }
        boolean ok = true;
        int i = 0;
        for (Properties props : tunnels) {
            String tname = props.getProperty("name");
            tname = tname == null ? "tunnel" : TunnelControllerGroup.sanitize(tname);
            String name = i + "-" + tname + "-i2ptunnel.config";
            if (i < 10) {
                name = "0" + name;
            }
            File f = new File(dir, name);
            props.setProperty("configFile", f.getAbsolutePath());
            try {
                DataHelper.storeProps(props, f);
            }
            catch (IOException ioe) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Error migrating the i2ptunnel configuration to " + String.valueOf(f), ioe);
                }
                ok = false;
            }
            ++i;
        }
        if (ok && !FileUtil.rename(from, new File(from.getAbsolutePath() + ".bak"))) {
            from.delete();
        }
        return ok;
    }

    private synchronized void startControllers() {
        this.changeState(ClientAppState.STARTING);
        I2PAppThread startupThread = new I2PAppThread(new StartControllers(), "Startup tunnels");
        startupThread.start();
        this.changeState(ClientAppState.RUNNING);
    }

    public synchronized void reloadControllers() {
        this.unloadControllers();
        File cfgFile = new File(this._configFile);
        if (!cfgFile.isAbsolute()) {
            cfgFile = new File(this._context.getConfigDir(), this._configFile);
        }
        this.loadControllers(cfgFile);
        this.startControllers();
    }

    public synchronized void unloadControllers() {
        if (!this._controllersLoaded) {
            return;
        }
        this._controllersLock.writeLock().lock();
        try {
            this.destroyAllControllers();
            this._controllers.clear();
        }
        finally {
            this._controllersLock.writeLock().unlock();
        }
        this._controllersLoaded = false;
        if (this._log.shouldLog(20)) {
            this._log.info("All controllers stopped and unloaded");
        }
    }

    public synchronized void addController(TunnelController controller) {
        this._controllersLock.writeLock().lock();
        try {
            this._controllers.add(controller);
        }
        finally {
            this._controllersLock.writeLock().unlock();
        }
    }

    public synchronized List<String> removeController(TunnelController controller) {
        if (controller == null) {
            return new ArrayList<String>();
        }
        controller.stopTunnel();
        List<String> msgs = controller.clearMessages();
        this._controllersLock.writeLock().lock();
        try {
            this._controllers.remove(controller);
        }
        finally {
            this._controllersLock.writeLock().unlock();
        }
        msgs.add("Tunnel " + controller.getName() + " removed");
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<String> stopAllControllers() {
        ArrayList<String> msgs = new ArrayList<String>();
        this._controllersLock.readLock().lock();
        try {
            for (TunnelController controller : this._controllers) {
                controller.stopTunnel();
                msgs.addAll(controller.clearMessages());
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this._controllers.size() + " controllers stopped");
            }
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
        return msgs;
    }

    private void destroyAllControllers() {
        for (TunnelController controller : this._controllers) {
            controller.destroyTunnel();
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this._controllers.size() + " controllers stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<String> startAllControllers() {
        ArrayList<String> msgs = new ArrayList<String>();
        this._controllersLock.readLock().lock();
        try {
            for (TunnelController controller : this._controllers) {
                controller.startTunnelBackground();
                msgs.addAll(controller.clearMessages());
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this._controllers.size() + " controllers started");
            }
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<String> restartAllControllers() {
        ArrayList<String> msgs = new ArrayList<String>();
        this._controllersLock.readLock().lock();
        try {
            for (TunnelController controller : this._controllers) {
                controller.restartTunnel();
                msgs.addAll(controller.clearMessages());
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this._controllers.size() + " controllers restarted");
            }
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> clearAllMessages() {
        ArrayList<String> msgs = new ArrayList<String>();
        this._controllersLock.readLock().lock();
        try {
            for (TunnelController controller : this._controllers) {
                msgs.addAll(controller.clearMessages());
            }
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void saveConfig() throws IOException {
        this._controllersLock.readLock().lock();
        if (this.shouldMigrate()) {
            try {
                for (TunnelController controller : this._controllers) {
                    this.saveConfig(controller);
                }
            }
            finally {
                this._controllersLock.readLock().unlock();
            }
        }
        try {
            File cfgFile = new File(this._configFile);
            if (!cfgFile.isAbsolute()) {
                cfgFile = new File(this._context.getConfigDir(), this._configFile);
            }
            this.saveConfig(cfgFile);
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
    }

    @Deprecated
    public synchronized void saveConfig(String cfgFile) throws IOException {
        this.saveConfig(new File(cfgFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveConfig(File cfgFile) throws IOException {
        File parent = cfgFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        OrderedProperties map = new OrderedProperties();
        this._controllersLock.readLock().lock();
        try {
            int i = 0;
            for (TunnelController controller : this._controllers) {
                Properties cur = controller.getConfig(PREFIX + i + ".");
                map.putAll((Map<?, ?>)cur);
                ++i;
            }
            map.setProperty("configFile", cfgFile.getAbsolutePath());
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
        DataHelper.storeProps(map, cfgFile);
    }

    public synchronized void saveConfig(TunnelController tc) throws IOException {
        if (!this.shouldMigrate()) {
            this.saveConfig();
            return;
        }
        if (this._log.shouldInfo()) {
            this._log.info("Saving tunnel configuration for " + String.valueOf(tc));
        }
        OrderedProperties inputController = new OrderedProperties();
        inputController.putAll((Map<?, ?>)tc.getConfig(""));
        File cfgFile = this.assureConfigFile(tc);
        inputController.setProperty("configFile", cfgFile.getAbsolutePath());
        DataHelper.storeProps(inputController, cfgFile);
        tc.setConfig(inputController, "");
    }

    public synchronized void removeConfig(TunnelController tc) throws IOException {
        File cfgFile = this.assureConfigFile(tc);
        if (!FileUtil.rename(cfgFile, new File(cfgFile.getAbsolutePath() + ".bak")) && !cfgFile.delete() && this._log.shouldLog(30)) {
            this._log.warn("could not delete config file" + cfgFile.toString());
        }
        if (!this.shouldMigrate()) {
            this.saveConfig();
        }
    }

    private static String sanitize(String rv) {
        for (int i = 0; i < ILLEGAL.length; ++i) {
            if (rv.indexOf(ILLEGAL[i]) < 0) continue;
            rv = rv.replace(ILLEGAL[i], '_');
        }
        return rv;
    }

    private synchronized File assureConfigFile(TunnelController tc) throws IOException {
        File folder;
        File file = tc.getConfigFile();
        if (file != null) {
            return file;
        }
        Properties inputController = tc.getConfig("");
        String fileName = inputController.getProperty("name");
        fileName = fileName == null ? "New Tunnel" : TunnelControllerGroup.sanitize(fileName);
        String configFileName = this._controllers.size() + "-" + fileName + "-i2ptunnel.config";
        if (this._controllers.size() < 10) {
            configFileName = "0" + configFileName;
        }
        if (!(folder = new File(this._configDirectory)).isAbsolute()) {
            folder = new File(this._context.getConfigDir(), this._configDirectory);
        }
        file = new File(folder, configFileName);
        tc.setConfigFile(file);
        return file;
    }

    private List<File> listFiles() {
        File folder = new File(this._configDirectory);
        if (!folder.isAbsolute()) {
            folder = new File(this._context.getConfigDir(), this._configDirectory);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Seeking controller configs in " + folder.toString());
        }
        File[] listOfFiles = folder.listFiles(new FileSuffixFilter(".config"));
        ArrayList<File> files = new ArrayList<File>();
        if (listOfFiles != null && listOfFiles.length > 0) {
            for (File afile : listOfFiles) {
                files.add(afile);
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Found controller config " + afile.toString());
            }
            Collections.sort(files);
        } else {
            File cfgFile = new File(this._configFile);
            if (!cfgFile.isAbsolute()) {
                cfgFile = new File(this._context.getConfigDir(), this._configFile);
            }
            files.add(cfgFile);
        }
        return files;
    }

    private synchronized List<Properties> loadConfig(File cfgFile) throws IOException {
        Properties config = new Properties();
        DataHelper.loadProps(config, cfgFile);
        Iterator<String> iterator = config.stringPropertyNames().iterator();
        if (iterator.hasNext()) {
            String key = iterator.next();
            if (key.startsWith(PREFIX)) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Found monolithic config file " + String.valueOf(cfgFile));
                }
                return this.splitMonolithicConfig(config);
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Found split config file " + String.valueOf(cfgFile));
            }
            ArrayList<Properties> rv = new ArrayList<Properties>(1);
            config.setProperty("configFile", cfgFile.getAbsolutePath());
            rv.add(config);
            return rv;
        }
        throw new IOException("No config found in " + String.valueOf(cfgFile));
    }

    private List<Properties> splitMonolithicConfig(Properties config) throws IOException {
        ArrayList<Properties> rv = new ArrayList<Properties>();
        int i = 0;
        while (true) {
            String prefix = PREFIX + i + ".";
            OrderedProperties p = new OrderedProperties();
            for (Map.Entry<Object, Object> e : config.entrySet()) {
                String key = (String)e.getKey();
                if (!key.startsWith(prefix)) continue;
                key = key.substring(prefix.length());
                String val = (String)e.getValue();
                p.setProperty(key, val);
            }
            if (p.isEmpty()) break;
            rv.add(p);
            ++i;
        }
        return rv;
    }

    public List<TunnelController> getControllers() {
        ArrayList<TunnelController> rv = new ArrayList<TunnelController>();
        File cfgFile = new File(this._configFile);
        if (!cfgFile.isAbsolute()) {
            cfgFile = new File(this._context.getConfigDir(), this._configFile);
        }
        rv.addAll(this.getControllers(cfgFile));
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TunnelController> getControllers(File cfgFile) {
        TunnelControllerGroup tunnelControllerGroup = this;
        synchronized (tunnelControllerGroup) {
            if (!this._controllersLoaded) {
                this.loadControllers(cfgFile);
            }
        }
        this._controllersLock.readLock().lock();
        try {
            ArrayList<TunnelController> rv;
            ArrayList<TunnelController> arrayList = rv = new ArrayList<TunnelController>(this._controllers);
            return arrayList;
        }
        finally {
            this._controllersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquire(TunnelController controller, I2PSession session) {
        Map<I2PSession, Set<TunnelController>> map = this._sessions;
        synchronized (map) {
            Set<TunnelController> owners = this._sessions.get(session);
            if (owners == null) {
                owners = new HashSet<TunnelController>(2);
                this._sessions.put(session, owners);
            }
            owners.add(controller);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Acquiring session " + String.valueOf(session) + " for " + String.valueOf(controller));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(TunnelController controller, I2PSession session) {
        block14: {
            boolean shouldClose = false;
            Map<I2PSession, Set<TunnelController>> map = this._sessions;
            synchronized (map) {
                Set<TunnelController> owners = this._sessions.get(session);
                if (owners != null) {
                    owners.remove(controller);
                    if (owners.isEmpty()) {
                        if (this._log.shouldLog(20)) {
                            this._log.info("After releasing session " + String.valueOf(session) + " by " + String.valueOf(controller) + ", no more owners remain");
                        }
                        shouldClose = true;
                        this._sessions.remove(session);
                    } else {
                        if (this._log.shouldLog(20)) {
                            this._log.info("After releasing session " + String.valueOf(session) + " by " + String.valueOf(controller) + ", " + owners.size() + " owners remain");
                        }
                        shouldClose = false;
                    }
                } else {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("After releasing session " + String.valueOf(session) + " by " + String.valueOf(controller) + ", no owners were even known?!");
                    }
                    shouldClose = true;
                }
            }
            if (shouldClose) {
                try {
                    session.destroySession();
                    if (this._log.shouldLog(20)) {
                        this._log.info("Session destroyed: " + String.valueOf(session));
                    }
                }
                catch (I2PSessionException ise) {
                    if (!this._log.shouldLog(40)) break block14;
                    this._log.error("Error closing the client session", ise);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadPoolExecutor getClientExecutor() {
        Object object = this._executorLock;
        synchronized (object) {
            if (this._executor == null) {
                this._executor = new CustomThreadPoolExecutor();
            }
        }
        return this._executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killClientExecutor() {
        Object object = this._executorLock;
        synchronized (object) {
            if (this._executor != null) {
                this._executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
                this._executor.shutdownNow();
                this._executor = null;
            }
        }
        I2PTunnelClientBase.killSharedClient();
    }

    static {
        _executorThreadCount = new AtomicLong();
        ILLEGAL = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u2028', '\u2029'};
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            TunnelControllerGroup.this.shutdown();
        }
    }

    private class StartControllers
    implements Runnable {
        private StartControllers() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TunnelControllerGroup tunnelControllerGroup = TunnelControllerGroup.this;
            synchronized (tunnelControllerGroup) {
                TunnelControllerGroup.this._controllersLock.readLock().lock();
                try {
                    if (TunnelControllerGroup.this._controllers.size() <= 0) {
                        TunnelControllerGroup.this._log.logAlways(30, "No configured tunnels to start");
                        return;
                    }
                    for (TunnelController controller : TunnelControllerGroup.this._controllers) {
                        if (!controller.getStartOnLoad()) continue;
                        controller.startTunnelBackground();
                    }
                }
                finally {
                    TunnelControllerGroup.this._controllersLock.readLock().unlock();
                }
            }
        }
    }

    static class CustomThreadPoolExecutor
    extends ThreadPoolExecutor {
        public CustomThreadPoolExecutor() {
            super(0, Integer.MAX_VALUE, 120000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new CustomThreadFactory());
        }
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private CustomThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread rv = Executors.defaultThreadFactory().newThread(r);
            rv.setName("I2PTunnel Client Runner " + _executorThreadCount.incrementAndGet());
            rv.setDaemon(true);
            return rv;
        }
    }
}

