/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import javax.imageio.stream.ImageInputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.SummaryListener;
import net.i2p.rrd4j.SimpleSVGImageWorker;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import org.rrd4j.core.RrdException;
import org.rrd4j.data.Variable;
import org.rrd4j.graph.ElementsNames;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;

class SummaryRenderer {
    private final Log _log;
    private final SummaryListener _listener;
    private final I2PAppContext _context;
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final Color BACK_COLOR;
    private static final Color SHADEA_COLOR;
    private static final Color SHADEB_COLOR;
    private static final Color GRID_COLOR;
    private static final Color MGRID_COLOR;
    private static final Color FONT_COLOR;
    private static final Color FRAME_COLOR;
    private static final Color AREA_COLOR;
    private static final Color LINE_COLOR;
    private static final Color RESTART_BAR_COLOR;
    private static final Color BACK_COLOR_DARK;
    private static final Color SHADEA_COLOR_DARK;
    private static final Color SHADEB_COLOR_DARK;
    private static final Color GRID_COLOR_DARK;
    private static final Color MGRID_COLOR_DARK;
    private static final Color FONT_COLOR_DARK;
    private static final Color FRAME_COLOR_DARK;
    private static final Color AREA_COLOR_DARK;
    private static final Color LINE_COLOR_DARK;
    private static final Color RESTART_BAR_COLOR_DARK;
    private static final Color AXIS_COLOR_DARK;
    private static final Color CANVAS_COLOR_DARK;
    private static final Color ARROW_COLOR;
    private static final boolean IS_WIN;
    private static final String DEFAULT_FONT_NAME;
    private static final String DEFAULT_TITLE_FONT_NAME = "Dialog";
    private static final String DEFAULT_LEGEND_FONT_NAME = "Dialog";
    private static final String PROP_FONT_MONO = "routerconsole.graphFont.unit";
    private static final String PROP_FONT_LEGEND = "routerconsole.graphFont.legend";
    private static final String PROP_FONT_TITLE = "routerconsole.graphFont.title";
    private static final int SIZE_MONO = 10;
    private static final int SIZE_LEGEND = 10;
    private static final int SIZE_TITLE = 13;
    private static final long[] RATES;
    private static final Stroke GRID_STROKE;
    private static final Stroke TICK_STROKE;

    public SummaryRenderer(I2PAppContext ctx, SummaryListener lsnr) {
        this._log = ctx.logManager().getLog(SummaryRenderer.class);
        this._listener = lsnr;
        this._context = ctx;
        ctx.statManager().createRateStat("graph.renderTime", "", "Router", RATES);
    }

    @Deprecated
    public static synchronized void render(I2PAppContext ctx, OutputStream out, String filename) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void render(OutputStream out) throws IOException {
        this.render(out, 400, 100, false, false, false, false, -1, 0, false);
    }

    public void render(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int endp, boolean showCredit) throws IOException {
        this.render(out, width, height, hideLegend, hideGrid, hideTitle, showEvents, periodCount, endp, showCredit, null, null);
    }

    public void render(OutputStream out, int width, int height, boolean hideLegend, boolean hideGrid, boolean hideTitle, boolean showEvents, int periodCount, int endp, boolean showCredit, SummaryListener lsnr2, String titleOverride) throws IOException {
        long begin = System.currentTimeMillis();
        long end = Math.min(this._listener.now(), begin - 75000L);
        long period = this._listener.getRate().getPeriod();
        if (endp > 0) {
            end -= period * (long)endp;
        }
        if (periodCount <= 0 || periodCount > this._listener.getRows()) {
            periodCount = this._listener.getRows();
        }
        long start = end - period * (long)periodCount;
        ImageInputStream ios = null;
        try {
            RrdGraph graph;
            Object descr2;
            Color areaColor;
            String descr;
            String plotName;
            boolean localTime;
            boolean isDark;
            RrdGraphDef def = new RrdGraphDef(start / 1000L, end / 1000L);
            boolean bl = isDark = !this._context.getProperty("routerconsole.theme", "light").equals("light");
            if (isDark) {
                def.setColor(ElementsNames.back, (Paint)BACK_COLOR_DARK);
                def.setColor(ElementsNames.shadea, (Paint)SHADEA_COLOR_DARK);
                def.setColor(ElementsNames.shadeb, (Paint)SHADEB_COLOR_DARK);
                def.setColor(ElementsNames.grid, (Paint)GRID_COLOR_DARK);
                def.setColor(ElementsNames.mgrid, (Paint)MGRID_COLOR_DARK);
                def.setColor(ElementsNames.font, (Paint)FONT_COLOR_DARK);
                def.setColor(ElementsNames.frame, (Paint)FRAME_COLOR_DARK);
                def.setColor(ElementsNames.xaxis, (Paint)AXIS_COLOR_DARK);
                def.setColor(ElementsNames.yaxis, (Paint)AXIS_COLOR_DARK);
                def.setColor(ElementsNames.canvas, (Paint)CANVAS_COLOR_DARK);
            } else {
                def.setColor(ElementsNames.back, (Paint)BACK_COLOR);
                def.setColor(ElementsNames.shadea, (Paint)SHADEA_COLOR);
                def.setColor(ElementsNames.shadeb, (Paint)SHADEB_COLOR);
                def.setColor(ElementsNames.grid, (Paint)GRID_COLOR);
                def.setColor(ElementsNames.mgrid, (Paint)MGRID_COLOR);
                def.setColor(ElementsNames.font, (Paint)FONT_COLOR);
                def.setColor(ElementsNames.frame, (Paint)FRAME_COLOR);
            }
            def.setColor(ElementsNames.arrow, (Paint)ARROW_COLOR);
            String lang = Messages.getLanguage(this._context);
            int smallSize = 10;
            int legendSize = 10;
            int largeSize = 13;
            if ("ar".equals(lang) || "ja".equals(lang) || "zh".equals(lang) && !IS_WIN) {
                smallSize += 2;
                legendSize += 2;
                largeSize += 3;
            }
            String ssmall = this._context.getProperty(PROP_FONT_MONO, DEFAULT_FONT_NAME);
            String slegend = this._context.getProperty(PROP_FONT_LEGEND, "Dialog");
            String stitle = this._context.getProperty(PROP_FONT_TITLE, "Dialog");
            Font small = new Font(ssmall, 0, smallSize);
            Font legnd = new Font(slegend, 0, legendSize);
            Font large = new Font(stitle, 0, largeSize);
            def.setFont(RrdGraphDef.FONTTAG_DEFAULT, small);
            def.setFont(RrdGraphDef.FONTTAG_AXIS, small);
            def.setFont(RrdGraphDef.FONTTAG_UNIT, small);
            def.setFont(RrdGraphDef.FONTTAG_LEGEND, legnd);
            def.setFont(RrdGraphDef.FONTTAG_TITLE, large);
            boolean bl2 = localTime = !this._context.getBooleanProperty("routerconsole.graphUTC");
            if (localTime) {
                def.setTimeZone(SystemVersion.getSystemTimeZone(this._context));
            }
            def.setMinValue(0.0);
            String name = this._listener.getRate().getRateStat().getName();
            if (!(name.indexOf("Size") < 0 && name.indexOf("memory") < 0 || showEvents)) {
                def.setBase(1024.0);
            }
            if (titleOverride != null) {
                def.setTitle(titleOverride);
            } else if (!hideTitle) {
                String p = IS_WIN && "zh".equals(Messages.getLanguage(this._context)) ? DataHelper.formatDuration(period) : DataHelper.formatDuration2(period).replace("&nbsp;", " ");
                String title = showEvents ? name + " " + this._t("events in {0}", p) : name + " " + this._t("averaged for {0}", p);
                def.setTitle(title);
            }
            String path = this._listener.getData().getPath();
            String[] dsNames = this._listener.getData().getDsNames();
            boolean bps = false;
            if (showEvents) {
                plotName = dsNames[1];
                descr = this._t("Events per period");
            } else {
                plotName = dsNames[0];
                descr = this._listener.getRate().getRateStat().getDescription();
                bps = descr.toLowerCase(Locale.US).contains("bytes/sec");
                descr = this._t(descr);
            }
            def.datasource(plotName, path, plotName, SummaryListener.CF, this._listener.getBackendFactory());
            Color color = areaColor = isDark ? AREA_COLOR_DARK : AREA_COLOR;
            if (descr.length() > 0) {
                def.area(plotName, (Paint)areaColor, descr + "\\l");
            } else {
                def.area(plotName, areaColor);
            }
            if (!hideLegend) {
                Variable var = new Variable.AVERAGE();
                def.datasource("avg", plotName, var);
                if (bps) {
                    def.gprint("avg", "   " + this._t("Avg") + ": %.2f %sBps");
                } else {
                    def.gprint("avg", "   " + this._t("Avg") + ": %.2f %s");
                }
                var = new Variable.MAX();
                def.datasource("max", plotName, var);
                if (bps) {
                    def.gprint("max", " " + this._t("Max") + ": %.2f %SBps");
                } else {
                    def.gprint("max", " " + this._t("Max") + ": %.2f %S");
                }
                var = new Variable.LAST();
                def.datasource("last", plotName, var);
                if (bps) {
                    def.gprint("last", " " + this._t("Now") + ": %.2f %SBps\\l");
                } else {
                    def.gprint("last", " " + this._t("Now") + ": %.2f %S\\l");
                }
            }
            String plotName2 = null;
            if (lsnr2 != null) {
                String[] dsNames2 = lsnr2.getData().getDsNames();
                plotName2 = dsNames2[0];
                String path2 = lsnr2.getData().getPath();
                descr2 = lsnr2.getRate().getRateStat().getDescription();
                bps = ((String)descr2).toLowerCase(Locale.US).contains("bytes/sec");
                descr2 = this._t((String)descr2);
                def.datasource(plotName2, path2, plotName2, SummaryListener.CF, lsnr2.getBackendFactory());
                Color lineColor = isDark ? LINE_COLOR_DARK : LINE_COLOR;
                def.line(plotName2, (Paint)lineColor, (String)descr2 + "\\l", 2.0f);
                if (!hideLegend) {
                    Variable var = new Variable.AVERAGE();
                    def.datasource("avg2", plotName2, var);
                    if (bps) {
                        def.gprint("avg2", "   " + this._t("Avg") + ": %.2f %sBps");
                    } else {
                        def.gprint("avg2", "   " + this._t("Avg") + ": %.2f %s");
                    }
                    var = new Variable.MAX();
                    def.datasource("max2", plotName2, var);
                    if (bps) {
                        def.gprint("max2", " " + this._t("Max") + ": %.2f %SBps");
                    } else {
                        def.gprint("max2", " " + this._t("Max") + ": %.2f %S");
                    }
                    var = new Variable.LAST();
                    def.datasource("last2", plotName2, var);
                    if (bps) {
                        def.gprint("last2", " " + this._t("Now") + ": %.2f %SBps\\l");
                    } else {
                        def.gprint("last2", " " + this._t("Now") + ": %.2f %S\\l");
                    }
                }
            }
            if (!hideLegend) {
                Color restartBarColor;
                SortedMap<Long, String> events = ((RouterContext)this._context).router().eventLog().getEvents("started", start);
                Color color2 = restartBarColor = isDark ? RESTART_BAR_COLOR_DARK : RESTART_BAR_COLOR;
                if (localTime) {
                    Map.Entry event;
                    long started;
                    descr2 = events.entrySet().iterator();
                    while (descr2.hasNext() && (started = ((Long)(event = (Map.Entry)descr2.next()).getKey()).longValue()) < end) {
                        String legend = Messages.isRTL(lang) ? this._t("Restart") + " " + DataHelper.formatTime(started) + " - " + (String)event.getValue() + "\\l" : this._t("Restart") + " " + DataHelper.formatTime(started) + " [" + (String)event.getValue() + "]\\l";
                        def.vrule(started / 1000L, (Paint)restartBarColor, legend, 2.0f);
                    }
                    def.comment(DataHelper.formatTime(start) + " \u2014 " + DataHelper.formatTime(end) + "\\r");
                } else {
                    Map.Entry event;
                    long started;
                    SimpleDateFormat sdf = new SimpleDateFormat("dd MMM HH:mm");
                    Iterator iterator = events.entrySet().iterator();
                    while (iterator.hasNext() && (started = ((Long)(event = iterator.next()).getKey()).longValue()) < end) {
                        String legend = Messages.isRTL(lang) ? this._t("Restart") + " " + sdf.format(new Date(started)) + " - " + (String)event.getValue() + "\\l" : this._t("Restart") + " " + sdf.format(new Date(started)) + " [" + (String)event.getValue() + "]\\l";
                        def.vrule(started / 1000L, (Paint)restartBarColor, legend, 2.0f);
                    }
                    def.comment(sdf.format(new Date(start)) + " \u2014 " + sdf.format(new Date(end)) + " UTC\\r");
                }
            }
            if (!showCredit) {
                def.setShowSignature(false);
            }
            if (hideLegend) {
                def.setNoLegend(true);
            }
            if (hideGrid) {
                def.setDrawXGrid(false);
                def.setDrawYGrid(false);
            }
            def.setAntiAliasing(false);
            def.setTextAntiAliasing(true);
            def.setGridStroke(GRID_STROKE);
            def.setTickStroke(TICK_STROKE);
            def.setWidth(width);
            def.setHeight(height);
            def.setImageFormat("PNG");
            def.setLazy(true);
            try {
                SimpleSVGImageWorker svg = new SimpleSVGImageWorker(width, height);
                graph = new RrdGraph(def, svg);
            }
            catch (NullPointerException npe) {
                this._log.error("Error rendering graph", npe);
                StatSummarizer.setDisabled(this._context);
                throw new IOException("Error rendering - disabling graph generation. Missing font?");
            }
            catch (Error e) {
                this._log.error("Error rendering graph", e);
                StatSummarizer.setDisabled(this._context);
                throw new IOException("Error rendering - disabling graph generation. Missing font?");
            }
            out.write(graph.getRrdGraphInfo().getBytes());
            out.flush();
            this._context.statManager().addRateData("graph.renderTime", System.currentTimeMillis() - begin);
        }
        catch (RrdException re) {
            this._log.error("Error rendering", re);
            throw new IOException("Error plotting: " + re.getLocalizedMessage());
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error rendering", ioe);
            }
            throw ioe;
        }
        catch (OutOfMemoryError oom) {
            this._log.error("Error rendering", oom);
            throw new IOException("Error plotting: " + oom.getLocalizedMessage());
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String _t(String s) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s;
        }
        return Messages.getString(s, this._context);
    }

    private String _t(String s, String o) {
        if (IS_WIN && "zh".equals(Messages.getLanguage(this._context))) {
            return s.replace("{0}", o);
        }
        return Messages.getString(s, o, this._context);
    }

    static {
        SHADEA_COLOR = BACK_COLOR = new Color(246, 246, 255);
        SHADEB_COLOR = BACK_COLOR;
        GRID_COLOR = new Color(100, 100, 100, 75);
        MGRID_COLOR = new Color(255, 91, 91, 110);
        FRAME_COLOR = FONT_COLOR = new Color(51, 51, 63);
        AREA_COLOR = new Color(100, 160, 200, 200);
        LINE_COLOR = new Color(0, 30, 110, 255);
        RESTART_BAR_COLOR = new Color(223, 13, 13, 255);
        SHADEA_COLOR_DARK = BACK_COLOR_DARK = new Color(16, 16, 16);
        SHADEB_COLOR_DARK = BACK_COLOR_DARK;
        GRID_COLOR_DARK = new Color(244, 244, 190, 50);
        MGRID_COLOR_DARK = new Color(200, 200, 0, 50);
        FONT_COLOR_DARK = new Color(244, 244, 190);
        FRAME_COLOR_DARK = TRANSPARENT;
        AREA_COLOR_DARK = new Color(0, 72, 8, 220);
        LINE_COLOR_DARK = new Color(100, 200, 160);
        RESTART_BAR_COLOR_DARK = new Color(200, 16, 48, 220);
        AXIS_COLOR_DARK = new Color(244, 244, 190, 200);
        CANVAS_COLOR_DARK = new Color(20, 20, 20);
        ARROW_COLOR = TRANSPARENT;
        IS_WIN = SystemVersion.isWindows();
        DEFAULT_FONT_NAME = IS_WIN ? "Lucida Console" : "Monospaced";
        RATES = new long[]{3600000L};
        GRID_STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
        TICK_STROKE = new BasicStroke(0.0f);
    }
}

