/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.PortMapper;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.Callback;

public class HostCheckHandler
extends GzipHandler {
    private final I2PAppContext _context;
    private final PortMapper _portMapper;
    private final Set<String> _listenHosts;
    private static final String PROP_REDIRECT = "routerconsole.redirectToHTTPS";
    private static final String PROP_GZIP = "routerconsole.enableCompression";

    public HostCheckHandler(I2PAppContext ctx) {
        this._context = ctx;
        this._portMapper = ctx.portMapper();
        this._listenHosts = new HashSet<String>(8);
        this.setMinGzipSize(32768);
        if (this._context.getBooleanPropertyDefaultTrue(PROP_GZIP)) {
            this.addIncludedMimeTypes(new String[]{"application/javascript", "application/x-javascript", "application/xhtml+xml", "application/xml", "image/svg+xml", "text/css", "text/html", "text/plain"});
        } else {
            this.addIncludedMimeTypes(new String[]{"xyzzy"});
        }
    }

    public void setListenHosts(Set<String> hosts) {
        this._listenHosts.clear();
        this._listenHosts.addAll(hosts);
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String redir;
        int httpsPort;
        String host = request.getHeaders().get("Host");
        if (!this.allowHost(host)) {
            Log log = this._context.logManager().getLog(HostCheckHandler.class);
            host = DataHelper.stripHTML(HostCheckHandler.getHost(host));
            String s = "Console request denied.\n    To allow access using the hostname \"" + host + "\",\n    add the line \"routerconsole.allowedHosts=" + host + "\"\n    to advanced configuration and restart.";
            log.logAlways(30, s);
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)403, (String)s);
            return true;
        }
        if (!request.isSecure() && (httpsPort = this._portMapper.getPort("https_console")) > 0 && Request.getLocalPort((Request)request) != httpsPort && (Boolean.parseBoolean(redir = this._context.getProperty(PROP_REDIRECT)) || redir == null && "1".equals(request.getHeaders().get("Upgrade-Insecure-Requests")))) {
            HostCheckHandler.sendRedirect(httpsPort, request, response);
            callback.succeeded();
            return true;
        }
        return super.handle(request, response, callback);
    }

    private boolean allowHost(String host) {
        if (host == null) {
            return true;
        }
        if (host.equals("127.0.0.1:7657") || host.equals("localhost:7657") || host.equals("[::1]:7657") || host.equals("127.0.0.1:7667") || host.equals("localhost:7667") || host.equals("[::1]:7667")) {
            return true;
        }
        if (this._listenHosts.isEmpty()) {
            return true;
        }
        if (this._listenHosts.contains(host = HostCheckHandler.getHost(host))) {
            return true;
        }
        return Addresses.isIPAddress(host);
    }

    private static String getHost(String host) {
        if (host.startsWith("[")) {
            int brack = (host = host.substring(1)).indexOf(93);
            if (brack >= 0) {
                host = host.substring(0, brack);
            }
        } else {
            int colon = host.indexOf(58);
            if (colon >= 0) {
                host = host.substring(0, colon);
            }
        }
        return host;
    }

    private static void sendRedirect(int httpsPort, Request request, Response response) throws IOException {
        boolean ipv6;
        StringBuilder buf = new StringBuilder(64);
        buf.append("https://");
        String name = Request.getServerName((Request)request);
        boolean bl = ipv6 = name.indexOf(58) >= 0 && !name.startsWith("[");
        if (ipv6) {
            buf.append('[');
        }
        buf.append(name);
        if (ipv6) {
            buf.append(']');
        }
        buf.append(':').append(httpsPort).append(request.getHttpURI().getPath());
        String q = request.getHttpURI().getQuery();
        if (q != null) {
            buf.append('?').append(q);
        }
        response.getHeaders().put("Location", buf.toString());
        response.getHeaders().put("Vary", "Upgrade-Insecure-Requests");
        response.setStatus(307);
    }
}

