/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.ndt;

import edu.internet2.ndt.Message;
import edu.internet2.ndt.Protocol;
import edu.internet2.ndt.Tcpbw100;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class OsfwWorker
implements Runnable {
    private final ServerSocket _srvSocket;
    private final int _iTestTime;
    private boolean _iFinalized = false;
    private final Tcpbw100 _localTcpAppObj;

    OsfwWorker(ServerSocket srvSocketParam, int iParamTestTime) {
        this._srvSocket = srvSocketParam;
        this._iTestTime = iParamTestTime;
        this._localTcpAppObj = null;
    }

    OsfwWorker(ServerSocket srvSocketParam, int iParamTestTime, Tcpbw100 _localParam) {
        this._srvSocket = srvSocketParam;
        this._iTestTime = iParamTestTime;
        this._localTcpAppObj = _localParam;
    }

    public void finalize() {
        while (!this._iFinalized) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void run() {
        Message msg = new Message();
        Socket socketObj = null;
        try {
            this._srvSocket.setSoTimeout(this._iTestTime * 1000);
            try {
                socketObj = this._srvSocket.accept();
            }
            catch (Exception e) {
                this._localTcpAppObj.setS2cSFWTestResults(3);
                this._srvSocket.close();
                this._iFinalized = true;
                return;
            }
            Protocol sfwCtl = new Protocol(socketObj);
            if (sfwCtl.recv_msg(msg) != 0) {
                System.out.println("Simple firewall test: unrecognized message");
                this._localTcpAppObj.setS2cSFWTestResults(2);
                socketObj.close();
                this._srvSocket.close();
                this._iFinalized = true;
                return;
            }
            if (msg.getType() != 5) {
                this._localTcpAppObj.setS2cSFWTestResults(2);
                socketObj.close();
                this._srvSocket.close();
                this._iFinalized = true;
                return;
            }
            if (!new String(msg.getBody()).equals("Simple firewall test")) {
                System.out.println("Simple firewall test: Improper message");
                this._localTcpAppObj.setS2cSFWTestResults(2);
                socketObj.close();
                this._srvSocket.close();
                this._iFinalized = true;
                return;
            }
            this._localTcpAppObj.setS2cSFWTestResults(1);
        }
        catch (IOException ex) {
            this._localTcpAppObj.setS2cSFWTestResults(2);
        }
        try {
            if (socketObj != null) {
                socketObj.close();
            }
            this._srvSocket.close();
        }
        catch (IOException e) {
            System.err.println("OsfwWorker: Exception trying to close sockets" + String.valueOf(e));
        }
        this._iFinalized = true;
    }
}

