/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.graph;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.deploy.graph.Edge;
import org.eclipse.jetty.deploy.graph.Node;

public class Route {
    private final List<Edge> _edges = new CopyOnWriteArrayList<Edge>();
    private final List<Node> _nodes = new CopyOnWriteArrayList<Node>();

    public void add(Edge edge) {
        this._edges.add(edge);
        if (this._nodes.size() == 0) {
            this._nodes.add(edge.getFrom());
        } else assert (this._nodes.get(this._nodes.size() - 1).equals(edge.getFrom()));
        this._nodes.add(edge.getTo());
    }

    public Route forkRoute() {
        Route ep = new Route();
        for (Edge edge : this._edges) {
            ep.add(edge);
        }
        return ep;
    }

    public List<Node> getNodes() {
        return this._nodes;
    }

    public List<Node> getEdges() {
        return this._nodes;
    }

    public Node getNode(int index) {
        return this._nodes.get(index);
    }

    public Node firstNode() {
        if (this._nodes.size() == 0) {
            return null;
        }
        return this._nodes.get(0);
    }

    public Node lastNode() {
        if (this._nodes.size() == 0) {
            return null;
        }
        return this._nodes.get(this._nodes.size() - 1);
    }

    public int nodes() {
        return this._nodes.size();
    }

    public int edges() {
        return this._edges.size();
    }

    public boolean isEmpty() {
        return this._edges.isEmpty();
    }

    public Edge firstEdge() {
        if (this._edges.size() == 0) {
            return null;
        }
        return this._edges.get(0);
    }

    public Edge lastEdge() {
        if (this._edges.size() == 0) {
            return null;
        }
        return this._edges.get(this._edges.size() - 1);
    }

    public Edge getEdge(int index) {
        return this._edges.get(index);
    }

    public String toString() {
        return super.toString() + this._nodes.toString();
    }
}

