/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.datagram.Datagram2;
import net.i2p.client.datagram.Datagram3;
import net.i2p.client.datagram.I2PDatagramDissector;
import net.i2p.client.datagram.I2PDatagramMaker;
import net.i2p.client.datagram.I2PInvalidDatagramException;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.sam.SAMDatagramReceiver;
import net.i2p.sam.SAMMessageSession;

class SAMDatagramSession
extends SAMMessageSession {
    public static final int DGRAM_SIZE_MAX = 31744;
    protected SAMDatagramReceiver recv;
    private final I2PDatagramMaker dgramMaker;
    private final I2PDatagramDissector dgramDissector;
    private final int version;

    protected SAMDatagramSession(String dest, Properties props, SAMDatagramReceiver recv, int v) throws IOException, DataFormatException, I2PSessionException {
        super(dest, props);
        if (v == 1) {
            this.dgramMaker = new I2PDatagramMaker(this.getI2PSession());
            this.dgramDissector = new I2PDatagramDissector();
        } else if (v == 2 || v == 3) {
            this.dgramMaker = null;
            this.dgramDissector = null;
        } else {
            throw new IllegalArgumentException("Bad version: " + v);
        }
        this.version = v;
    }

    @Deprecated
    public SAMDatagramSession(InputStream destStream, Properties props, SAMDatagramReceiver recv) throws IOException, DataFormatException, I2PSessionException {
        super(destStream, props);
        this.recv = recv;
        this.dgramMaker = new I2PDatagramMaker(this.getI2PSession());
        this.dgramDissector = new I2PDatagramDissector();
        this.version = 1;
    }

    protected SAMDatagramSession(I2PSession sess, Properties props, int listenPort, SAMDatagramReceiver recv, int v) throws IOException, DataFormatException, I2PSessionException {
        super(sess, 17, listenPort);
        this.recv = recv;
        if (v == 1) {
            this.dgramMaker = new I2PDatagramMaker(this.getI2PSession());
            this.dgramDissector = new I2PDatagramDissector();
        } else if (v == 2 || v == 3) {
            this.dgramMaker = null;
            this.dgramDissector = null;
        } else {
            throw new IllegalArgumentException("Bad version: " + v);
        }
        this.version = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendBytes(String dest, byte[] data, int proto, int fromPort, int toPort) throws DataFormatException, I2PSessionException {
        byte[] dgram;
        if (data.length > 31744) {
            throw new DataFormatException("Datagram size exceeded (" + data.length + ")");
        }
        if (this.version == 1) {
            I2PDatagramMaker i2PDatagramMaker = this.dgramMaker;
            synchronized (i2PDatagramMaker) {
                dgram = this.dgramMaker.makeI2PDatagram(data);
            }
            proto = 17;
        } else if (this.version == 2) {
            Hash h = new Destination(dest).calculateHash();
            dgram = Datagram2.make(I2PAppContext.getGlobalContext(), this.getI2PSession(), data, h);
            proto = 19;
        } else {
            dgram = Datagram3.make(I2PAppContext.getGlobalContext(), this.getI2PSession(), data);
            proto = 20;
        }
        return this.sendBytesThroughMessageSession(dest, dgram, proto, fromPort, toPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendBytes(String dest, byte[] data, int proto, int fromPort, int toPort, boolean sendLeaseSet, int sendTags, int tagThreshold, int expiration) throws DataFormatException, I2PSessionException {
        byte[] dgram;
        if (data.length > 31744) {
            throw new DataFormatException("Datagram size exceeded (" + data.length + ")");
        }
        if (this.version == 1) {
            I2PDatagramMaker i2PDatagramMaker = this.dgramMaker;
            synchronized (i2PDatagramMaker) {
                dgram = this.dgramMaker.makeI2PDatagram(data);
            }
            proto = 17;
        } else if (this.version == 2) {
            Hash h = new Destination(dest).calculateHash();
            dgram = Datagram2.make(I2PAppContext.getGlobalContext(), this.getI2PSession(), data, h);
            proto = 19;
        } else {
            dgram = Datagram3.make(I2PAppContext.getGlobalContext(), this.getI2PSession(), data);
            proto = 20;
        }
        return this.sendBytesThroughMessageSession(dest, dgram, proto, fromPort, toPort, sendLeaseSet, sendTags, tagThreshold, expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void messageReceived(byte[] msg, int proto, int fromPort, int toPort) {
        Hash h;
        byte[] payload;
        Destination sender;
        block16: {
            try {
                Object dg;
                if (this.version == 1 && proto == 17) {
                    I2PDatagramDissector i2PDatagramDissector = this.dgramDissector;
                    synchronized (i2PDatagramDissector) {
                        this.dgramDissector.loadI2PDatagram(msg);
                        sender = this.dgramDissector.getSender();
                        payload = this.dgramDissector.extractPayload();
                    }
                    h = null;
                    break block16;
                }
                if (this.version == 2 && proto == 19) {
                    dg = Datagram2.load(I2PAppContext.getGlobalContext(), this.getI2PSession(), msg);
                    sender = ((Datagram2)dg).getSender();
                    payload = ((Datagram2)dg).getPayload();
                    h = null;
                    break block16;
                }
                if (this.version == 3 && proto == 20) {
                    dg = Datagram3.load(I2PAppContext.getGlobalContext(), this.getI2PSession(), msg);
                    sender = null;
                    payload = ((Datagram3)dg).getPayload();
                    h = ((Datagram3)dg).getSender();
                    break block16;
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("Dropping mismatched protocol, datagram version=" + this.version + " proto=" + proto);
                }
                return;
            }
            catch (DataFormatException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Dropping ill-formatted I2P repliable datagram", e);
                }
                return;
            }
            catch (I2PInvalidDatagramException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Dropping ill-signed I2P repliable datagram", e);
                }
                return;
            }
        }
        try {
            if (sender != null) {
                this.recv.receiveDatagramBytes(sender, payload, proto, fromPort, toPort);
            } else {
                this.recv.receiveDatagramBytes(h, payload, proto, fromPort, toPort);
            }
        }
        catch (IOException e) {
            this._log.error("Error forwarding message to receiver", e);
            this.close();
        }
    }

    @Override
    protected void shutDown() {
        this.recv.stopDatagramReceiving();
    }
}

