/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ObjectCounter<K>
implements Serializable {
    private static final long serialVersionUID = 3160378641721937421L;
    private final ConcurrentHashMap<K, AtomicInteger> map = new ConcurrentHashMap();

    public int increment(K h) {
        AtomicInteger i = this.map.putIfAbsent(h, new AtomicInteger(1));
        if (i != null) {
            return i.incrementAndGet();
        }
        return 1;
    }

    public void max(K h) {
        this.map.put(h, new AtomicInteger(0x3FFFFFFF));
    }

    public int count(K h) {
        AtomicInteger i = this.map.get(h);
        if (i != null) {
            return i.get();
        }
        return 0;
    }

    public Set<K> objects() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }

    public void clear(K h) {
        this.map.remove(h);
    }
}

