/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import net.i2p.data.DataHelper;
import net.i2p.util.I2PAppThread;
import net.i2p.util.LogManager;
import net.i2p.util.LogRecord;
import net.i2p.util.LogWriter;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;

class FileLogWriter
extends LogWriter {
    private volatile Writer _currentOut;
    private int _rotationNum = -1;
    private File _currentFile;
    private long _numBytesInCurrentFile;
    private static final int MAX_DISKFULL_MESSAGES = 8;
    private int _diskFullMessageCount;

    public FileLogWriter(LogManager manager) {
        super(manager);
    }

    @Override
    public synchronized String currentFile() {
        if (this._currentFile != null) {
            return this._currentFile.getAbsolutePath();
        }
        String rv = this.getNextFile().getAbsolutePath();
        this._rotationNum = -1;
        return rv;
    }

    @Override
    protected void writeRecord(LogRecord rec, String formatted) {
        this.writeRecord(rec.getPriority(), formatted);
    }

    @Override
    protected synchronized void writeRecord(int priority, String val) {
        block7: {
            if (val == null) {
                return;
            }
            if (this._currentOut == null) {
                this.rotateFile();
                if (this._currentOut == null) {
                    return;
                }
            }
            try {
                this._currentOut.write(val);
                this._numBytesInCurrentFile += (long)val.length();
            }
            catch (Throwable t) {
                if (!this._write) {
                    return;
                }
                if (++this._diskFullMessageCount >= 8) break block7;
                System.err.println("Error writing log, disk full? " + String.valueOf(t));
            }
        }
        if (this._numBytesInCurrentFile >= (long)(this._manager.getFileSize() - 1024)) {
            this.rotateFile();
        }
    }

    @Override
    protected void flushWriter() {
        block3: {
            try {
                if (this._currentOut != null) {
                    this._currentOut.flush();
                }
            }
            catch (IOException ioe) {
                if (!this._write || ++this._diskFullMessageCount >= 8) break block3;
                System.err.println("Error writing the router log - disk full? " + String.valueOf(ioe));
            }
        }
    }

    @Override
    protected void closeWriter() {
        this.closeWriter(this._currentFile, false);
    }

    private void closeWriter(File currentFile, boolean threadGzipper) {
        Writer out = this._currentOut;
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this._manager.shouldGzip() && currentFile != null && currentFile.length() >= this._manager.getMinGzipSize()) {
            Gzipper gzipper = new Gzipper(currentFile);
            if (threadGzipper) {
                gzipper.setPriority(1);
                ((Thread)gzipper).start();
            } else {
                ((Thread)gzipper).run();
            }
        }
    }

    private void rotateFile() {
        block6: {
            File f;
            File old = this._currentFile;
            this._currentFile = f = this.getNextFile();
            this._numBytesInCurrentFile = 0L;
            File parent = f.getParentFile();
            if (parent != null) {
                SecureDirectory sd;
                boolean ok;
                if (!parent.exists() && !(ok = ((File)(sd = new SecureDirectory(parent.getAbsolutePath()))).mkdirs())) {
                    System.err.println("Unable to create the parent directory: " + parent.getAbsolutePath());
                }
                if (!parent.isDirectory()) {
                    System.err.println("Cannot put the logs in a subdirectory of a plain file: " + f.getAbsolutePath());
                }
            }
            this.closeWriter(old, true);
            if (this._manager.shouldGzip()) {
                new File(f.getPath() + ".gz").delete();
            }
            try {
                this._currentOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(f), "UTF-8"));
            }
            catch (IOException ioe) {
                if (++this._diskFullMessageCount >= 8) break block6;
                System.err.println("Error creating log file [" + f.getAbsolutePath() + "]" + String.valueOf(ioe));
            }
        }
    }

    private File getNextFile() {
        String pattern = this._manager.getBaseLogfilename();
        File f = new File(pattern);
        File base = null;
        if (!f.isAbsolute()) {
            base = this._manager.getContext().getLogDir();
        }
        if (pattern.indexOf(35) < 0 && pattern.indexOf(64) <= 0) {
            if (base != null) {
                return new File(base, pattern);
            }
            return f;
        }
        int max = this._manager.getRotationLimit();
        if (this._rotationNum == -1) {
            return this.getFirstFile(base, pattern, max);
        }
        ++this._rotationNum;
        if (this._rotationNum > max) {
            this._rotationNum = 0;
        }
        String newf = FileLogWriter.replace(pattern, this._rotationNum);
        if (base != null) {
            return new File(base, newf);
        }
        return new File(newf);
    }

    private File getFirstFile(File base, String pattern, int max) {
        for (int i = 0; i < max; ++i) {
            File f = base != null ? new File(base, FileLogWriter.replace(pattern, i)) : new File(FileLogWriter.replace(pattern, i));
            if (f.exists() || this._manager.shouldGzip() && new File(f.getPath() + ".gz").exists()) continue;
            this._rotationNum = i;
            return f;
        }
        File oldest = null;
        for (int i = 0; i < max; ++i) {
            File f = base != null ? new File(base, FileLogWriter.replace(pattern, i)) : new File(FileLogWriter.replace(pattern, i));
            if (oldest == null) {
                oldest = f;
                continue;
            }
            File ff = !this._manager.shouldGzip() || f.exists() ? f : new File(f.getPath() + ".gz");
            File oo = !this._manager.shouldGzip() || oldest.exists() ? oldest : new File(oldest.getPath() + ".gz");
            if (ff.lastModified() >= oo.lastModified()) continue;
            this._rotationNum = i;
            oldest = f;
        }
        return oldest;
    }

    private static final String replace(String pattern, int num) {
        int len = pattern.length();
        StringBuilder buf = new StringBuilder(len + 1);
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (c != '#' && c != '@') {
                buf.append(c);
                continue;
            }
            buf.append(num);
        }
        return buf.toString();
    }

    private static class Gzipper
    extends I2PAppThread {
        private final File _f;

        public Gzipper(File f) {
            super("Log file compressor");
            this._f = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File to = new File(this._f.getPath() + ".gz");
            InputStream in = null;
            OutputStream out = null;
            try {
                in = new BufferedInputStream(new FileInputStream(this._f));
                out = new BufferedOutputStream(new GZIPOutputStream(new SecureFileOutputStream(to)));
                DataHelper.copy(in, out);
            }
            catch (IOException ioe) {
                System.out.println("Error compressing log file " + String.valueOf(this._f));
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                to.setLastModified(this._f.lastModified());
                this._f.delete();
            }
        }
    }
}

