/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.EmptyProperties;
import net.i2p.util.ByteArrayStream;
import net.i2p.util.ByteCache;
import net.i2p.util.FileUtil;
import net.i2p.util.OrderedProperties;
import net.i2p.util.ReusableGZIPInputStream;
import net.i2p.util.ReusableGZIPOutputStream;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;

public class DataHelper {
    private static final boolean SHOULD_SYNC = !SystemVersion.isAndroid() && !SystemVersion.isARM();
    private static final Map<String, String> _propertiesKeyCache;
    private static final Pattern ILLEGAL_KEY;
    private static final Pattern ILLEGAL_VALUE;
    private static final DateFormat DATE_FORMAT;
    private static final DateFormat TIME_FORMAT;
    private static boolean _date_tz_set;
    private static boolean _time_tz_set;
    private static final byte[] EMPTY_BUFFER;
    public static final int DATE_LENGTH = 8;
    private static final int MAX_LINE_LENGTH = 8192;
    private static final String BUNDLE_NAME = "net.i2p.util.messages";
    private static final String[] escapeChars;
    private static final String[] escapeCodes;
    public static final int MAX_UNCOMPRESSED = 40960;
    public static final int MAX_COMPRESSION = 9;
    public static final int HIGH_COMPRESSION = 5;
    public static final int MEDIUM_COMPRESSION = 3;
    public static final int NO_COMPRESSION = 0;
    private static final ConcurrentHashMap<String, Pattern> patterns;

    public static Properties readProperties(InputStream rawStream) throws DataFormatException, IOException {
        OrderedProperties props = new OrderedProperties();
        DataHelper.readProperties(rawStream, props);
        return props;
    }

    public static Properties readProperties(InputStream rawStream, Properties props) throws DataFormatException, IOException {
        return DataHelper.readProperties(rawStream, props, false);
    }

    public static Properties readProperties(InputStream rawStream, Properties props, boolean enforceOrder) throws DataFormatException, IOException {
        int size = (int)DataHelper.readLong(rawStream, 2);
        if (size == 0) {
            return props != null ? props : EmptyProperties.INSTANCE;
        }
        if (props == null) {
            props = new OrderedProperties();
        }
        byte[] data = new byte[size];
        DataHelper.read(rawStream, data);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        String prev = "";
        while (in.available() > 0) {
            String key = DataHelper.readString(in);
            String cached = _propertiesKeyCache.get(key);
            if (cached != null) {
                key = cached;
            }
            if (enforceOrder && key.compareTo(prev) <= 0) {
                throw new DataFormatException("option " + key + " out of order");
            }
            prev = key;
            int b = in.read();
            if (b != 61) {
                throw new DataFormatException("Bad key");
            }
            String val = DataHelper.readString(in);
            b = in.read();
            if (b != 59) {
                throw new DataFormatException("Bad value");
            }
            Object old = props.put(key, val);
            if (old == null) continue;
            throw new DataFormatException("Duplicate key " + key);
        }
        return props;
    }

    public static void writeProperties(OutputStream rawStream, Properties props) throws DataFormatException, IOException {
        DataHelper.writeProperties(rawStream, props, false);
    }

    public static void writeProperties(OutputStream rawStream, Properties props, boolean utf8) throws DataFormatException, IOException {
        DataHelper.writeProperties(rawStream, props, utf8, props != null && props.size() > 1 && !(props instanceof OrderedProperties));
    }

    public static void writeProperties(OutputStream rawStream, Properties props, boolean utf8, boolean sort) throws DataFormatException, IOException {
        if (props != null && !props.isEmpty()) {
            Properties p;
            if (sort && props.size() > 1) {
                p = new OrderedProperties();
                p.putAll((Map<?, ?>)props);
            } else {
                p = props;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(p.size() * 64);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (utf8) {
                    DataHelper.writeStringUTF8(baos, key);
                } else {
                    DataHelper.writeString(baos, key);
                }
                baos.write(61);
                if (utf8) {
                    DataHelper.writeStringUTF8(baos, val);
                } else {
                    DataHelper.writeString(baos, val);
                }
                baos.write(59);
            }
            if (baos.size() > 65535) {
                throw new DataFormatException("Properties too big (65535 max): " + baos.size());
            }
            DataHelper.writeLong(rawStream, 2, baos.size());
            baos.writeTo(rawStream);
        } else {
            DataHelper.writeLong(rawStream, 2, 0L);
        }
    }

    public static int toProperties(byte[] target, int offset, Properties props) throws DataFormatException, IOException {
        if (props != null && !props.isEmpty()) {
            Properties p;
            if (props instanceof OrderedProperties) {
                p = props;
            } else {
                p = new OrderedProperties();
                p.putAll((Map<?, ?>)props);
            }
            ByteArrayStream baos = new ByteArrayStream(p.size() * 64);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                DataHelper.writeStringUTF8(baos, key);
                baos.write(61);
                DataHelper.writeStringUTF8(baos, val);
                baos.write(59);
            }
            if (baos.size() > 65535) {
                throw new DataFormatException("Properties too big (65535 max): " + baos.size());
            }
            DataHelper.toLong(target, offset, 2, baos.size());
            baos.copyTo(target, offset += 2);
            return offset += baos.size();
        }
        DataHelper.toLong(target, offset, 2, 0L);
        return offset + 2;
    }

    public static int fromProperties(byte[] source, int offset, Properties target) throws DataFormatException {
        int size = (int)DataHelper.fromLong(source, offset, 2);
        ByteArrayInputStream in = new ByteArrayInputStream(source, offset += 2, size);
        while (in.available() > 0) {
            String val;
            int b;
            String key;
            try {
                key = DataHelper.readString(in);
                String cached = _propertiesKeyCache.get(key);
                if (cached != null) {
                    key = cached;
                }
                if ((b = in.read()) != 61) {
                    throw new DataFormatException("Bad key");
                }
            }
            catch (IOException ioe) {
                throw new DataFormatException("Bad key", ioe);
            }
            try {
                val = DataHelper.readString(in);
                b = in.read();
                if (b != 59) {
                    throw new DataFormatException("Bad value");
                }
            }
            catch (IOException ioe) {
                throw new DataFormatException("Bad value", ioe);
            }
            Object old = target.put(key, val);
            if (old == null) continue;
            throw new DataFormatException("Duplicate key " + key);
        }
        return offset + size;
    }

    public static byte[] toProperties(Properties opts) throws DataFormatException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2 + 32 * opts.size());
            DataHelper.writeProperties(baos, opts, true, false);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO error writing to memory?! " + ioe.getMessage());
        }
    }

    public static String toString(Properties options) {
        return DataHelper.toString(options);
    }

    public static String toString(Map<?, ?> options) {
        StringBuilder buf = new StringBuilder();
        if (options != null) {
            for (Map.Entry<?, ?> entry : options.entrySet()) {
                String key = (String)entry.getKey();
                String val = entry.getValue().toString();
                buf.append("[").append(key).append("] = [").append(val).append("]");
            }
        } else {
            buf.append("(null properties map)");
        }
        return buf.toString();
    }

    public static void loadProps(Properties props, File file) throws IOException {
        DataHelper.loadProps(props, file, false);
    }

    public static void loadProps(Properties props, File file, boolean forceLowerCase) throws IOException {
        DataHelper.loadProps(props, new FileInputStream(file), forceLowerCase);
    }

    public static void loadProps(Properties props, InputStream inStr) throws IOException {
        DataHelper.loadProps(props, inStr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProps(Properties props, InputStream inStr, boolean forceLowerCase) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(inStr, "UTF-8"), 4096);
            String line = null;
            while ((line = in.readLine()) != null) {
                int split;
                if (line.trim().length() <= 0 || line.charAt(0) == '#' || line.charAt(0) == ';') continue;
                if (line.indexOf(35) > 0) {
                    line = line.substring(0, line.indexOf(35)).trim();
                }
                if ((split = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, split);
                String val = line.substring(split + 1).trim();
                if (forceLowerCase) {
                    props.setProperty(key.toLowerCase(Locale.US), val);
                    continue;
                }
                props.setProperty(key, val);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProps(Properties props, File file) throws IOException {
        SecureFileOutputStream fos = null;
        PrintWriter out = null;
        IllegalArgumentException iae = null;
        File tmpFile = new File(file.getPath() + ".tmp");
        try {
            fos = new SecureFileOutputStream(tmpFile);
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8")));
            if (file.getName().equals("router.config")) {
                out.println("# WARNING: Do NOT copy this file from one router to another, this may cause serious problems.");
            }
            out.println("# NOTE: This I2P config file must use UTF-8 encoding");
            out.println("# Last saved: " + DataHelper.formatTime(System.currentTimeMillis()));
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String name = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (ILLEGAL_KEY.matcher(name).find()) {
                    if (iae != null) continue;
                    iae = new IllegalArgumentException("Invalid character (one of \"#;=\\r\\n\") in key: \"" + name + "\" = \"" + val + "\"");
                    continue;
                }
                if (ILLEGAL_VALUE.matcher(val).find()) {
                    if (iae != null) continue;
                    iae = new IllegalArgumentException("Invalid character (one of \"#\\r\\n\") in value: \"" + name + "\" = \"" + val + "\"");
                    continue;
                }
                out.println(name + "=" + val);
            }
            if (SHOULD_SYNC) {
                out.flush();
                fos.getFD().sync();
            }
            out.close();
            if (out.checkError()) {
                out = null;
                tmpFile.delete();
                throw new IOException("Failed to write properties to " + String.valueOf(tmpFile));
            }
            out = null;
            if (!FileUtil.rename(tmpFile, file)) {
                throw new IOException("Failed rename from " + String.valueOf(tmpFile) + " to " + String.valueOf(file));
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (iae != null) {
            throw iae;
        }
    }

    public static String toString(Collection<?> col) {
        StringBuilder buf = new StringBuilder();
        if (col != null) {
            Iterator<?> iter = col.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                buf.append("[").append(o).append("]");
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
        } else {
            buf.append("null");
        }
        return buf.toString();
    }

    public static String toString(byte[] buf) {
        if (buf == null) {
            return "";
        }
        return DataHelper.toString(buf, buf.length);
    }

    public static String toString(byte[] buf, int len) {
        if (buf == null) {
            buf = EMPTY_BUFFER;
        }
        StringBuilder out = new StringBuilder();
        if (len > buf.length) {
            for (int i = 0; i < len - buf.length; ++i) {
                out.append("00");
            }
        }
        int min = Math.min(buf.length, len);
        for (int i = 0; i < min; ++i) {
            int bi = buf[i] & 0xFF;
            if (bi < 16) {
                out.append('0');
            }
            out.append(Integer.toHexString(bi));
        }
        return out.toString();
    }

    @Deprecated
    public static String toDecimalString(byte[] buf, int len) {
        if (buf == null) {
            return "0";
        }
        BigInteger val = new BigInteger(1, buf);
        return val.toString();
    }

    public static final String toHexString(byte[] data) {
        if (data == null || data.length <= 0) {
            return "00";
        }
        BigInteger bi = new BigInteger(1, data);
        return bi.toString(16);
    }

    @Deprecated
    public static final byte[] fromHexString(String val) {
        BigInteger bv = new BigInteger(val, 16);
        return bv.toByteArray();
    }

    public static long readLong(InputStream rawStream, int numBytes) throws DataFormatException, IOException {
        if (numBytes > 8) {
            throw new DataFormatException("readLong doesn't currently support reading numbers > 8 bytes [as thats bigger than java's long]");
        }
        long rv = 0L;
        for (int i = 0; i < numBytes; ++i) {
            int cur = rawStream.read();
            if (cur == -1) {
                throw new EOFException("EOF reading " + numBytes + " byte value");
            }
            if (cur == 0) continue;
            rv = cur & 0xFF;
            for (int j = i + 1; j < numBytes; ++j) {
                rv <<= 8;
                cur = rawStream.read();
                if (cur == -1) {
                    throw new EOFException("EOF reading " + numBytes + " byte value");
                }
                rv |= (long)(cur & 0xFF);
            }
            break;
        }
        if (rv < 0L) {
            throw new DataFormatException("readLong got a negative? " + rv + " numBytes=" + numBytes);
        }
        return rv;
    }

    public static void writeLong(OutputStream rawStream, int numBytes, long value) throws DataFormatException, IOException {
        if (numBytes <= 0 || numBytes > 8) {
            throw new DataFormatException("Bad byte count " + numBytes);
        }
        if (value < 0L) {
            throw new DataFormatException("Value is negative (" + value + ")");
        }
        for (int i = (numBytes - 1) * 8; i >= 0; i -= 8) {
            byte cur = (byte)(value >> i);
            rawStream.write(cur);
        }
    }

    public static byte[] toLong(int numBytes, long value) throws IllegalArgumentException {
        byte[] val = new byte[numBytes];
        DataHelper.toLong(val, 0, numBytes, value);
        return val;
    }

    public static void toLong(byte[] target, int offset, int numBytes, long value) throws IllegalArgumentException {
        if (numBytes <= 0 || numBytes > 8) {
            throw new IllegalArgumentException("Invalid number of bytes");
        }
        if (value < 0L) {
            throw new IllegalArgumentException("Negative value not allowed");
        }
        for (int i = offset + numBytes - 1; i >= offset; --i) {
            target[i] = (byte)value;
            value >>= 8;
        }
    }

    public static void toLongLE(byte[] target, int offset, int numBytes, long value) {
        if (numBytes <= 0 || numBytes > 8) {
            throw new IllegalArgumentException("Invalid number of bytes");
        }
        if (value < 0L) {
            throw new IllegalArgumentException("Negative value not allowed");
        }
        int limit = offset + numBytes;
        for (int i = offset; i < limit; ++i) {
            target[i] = (byte)value;
            value >>= 8;
        }
    }

    public static long fromLong(byte[] src, int offset, int numBytes) {
        if (numBytes <= 0 || numBytes > 8) {
            throw new IllegalArgumentException("Invalid number of bytes");
        }
        if (src == null || src.length == 0) {
            return 0L;
        }
        long rv = 0L;
        int limit = offset + numBytes;
        for (int i = offset; i < limit; ++i) {
            rv <<= 8;
            rv |= (long)(src[i] & 0xFF);
        }
        if (rv < 0L) {
            throw new IllegalArgumentException("fromLong got a negative? " + rv + ": offset=" + offset + " numBytes=" + numBytes);
        }
        return rv;
    }

    public static long fromLongLE(byte[] src, int offset, int numBytes) {
        if (numBytes <= 0 || numBytes > 8) {
            throw new IllegalArgumentException("Invalid number of bytes");
        }
        long rv = 0L;
        for (int i = offset + numBytes - 1; i >= offset; --i) {
            rv <<= 8;
            rv |= (long)(src[i] & 0xFF);
        }
        if (rv < 0L) {
            throw new IllegalArgumentException("fromLong got a negative? " + rv + ": offset=" + offset + " numBytes=" + numBytes);
        }
        return rv;
    }

    public static long fromLong8(byte[] src, int offset) {
        long rv = 0L;
        int limit = offset + 8;
        for (int i = offset; i < limit; ++i) {
            rv <<= 8;
            rv |= (long)(src[i] & 0xFF);
        }
        return rv;
    }

    public static void toLong8(byte[] target, int offset, long value) {
        for (int i = offset + 7; i >= offset; --i) {
            target[i] = (byte)value;
            value >>= 8;
        }
    }

    public static Date readDate(InputStream in) throws DataFormatException, IOException {
        long date = DataHelper.readLong(in, 8);
        if (date == 0L) {
            return null;
        }
        return new Date(date);
    }

    public static void writeDate(OutputStream out, Date date) throws DataFormatException, IOException {
        if (date == null) {
            DataHelper.writeLong(out, 8, 0L);
        } else {
            DataHelper.writeLong(out, 8, date.getTime());
        }
    }

    @Deprecated
    public static byte[] toDate(Date date) throws IllegalArgumentException {
        if (date == null) {
            return DataHelper.toLong(8, 0L);
        }
        return DataHelper.toLong(8, date.getTime());
    }

    public static void toDate(byte[] target, int offset, long when) throws IllegalArgumentException {
        DataHelper.toLong(target, offset, 8, when);
    }

    public static Date fromDate(byte[] src, int offset) throws DataFormatException {
        if (src == null || offset + 8 > src.length) {
            throw new DataFormatException("Not enough data to read a date");
        }
        try {
            long when = DataHelper.fromLong(src, offset, 8);
            if (when <= 0L) {
                return null;
            }
            return new Date(when);
        }
        catch (IllegalArgumentException iae) {
            throw new DataFormatException(iae.getMessage());
        }
    }

    public static String readString(InputStream in) throws DataFormatException, IOException {
        int size = in.read();
        if (size == -1) {
            throw new EOFException("EOF reading string");
        }
        if (size == 0) {
            return "";
        }
        byte[] raw = new byte[size &= 0xFF];
        DataHelper.read(in, raw);
        return new String(raw, "UTF-8");
    }

    public static void writeString(OutputStream out, String string) throws DataFormatException, IOException {
        if (string == null) {
            out.write(0);
        } else {
            int len = string.length();
            if (len > 255) {
                throw new DataFormatException("The I2P data spec limits strings to 255 bytes or less, but this is " + len + " [" + string + "]");
            }
            out.write((byte)len);
            for (int i = 0; i < len; ++i) {
                out.write((byte)(string.charAt(i) & 0xFF));
            }
        }
    }

    public static void writeStringUTF8(OutputStream out, String string) throws DataFormatException, IOException {
        if (string == null) {
            out.write(0);
        } else {
            byte[] raw = string.getBytes("UTF-8");
            int len = raw.length;
            if (len > 255) {
                throw new DataFormatException("The I2P data spec limits strings to 255 bytes or less, but this is " + len + " [" + string + "]");
            }
            out.write((byte)len);
            out.write(raw);
        }
    }

    public static final boolean eq(Object lhs, Object rhs) {
        try {
            boolean eq = lhs == null && rhs == null || lhs != null && lhs.equals(rhs);
            return eq;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public static final boolean eq(Collection<?> lhs, Collection<?> rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.size() != rhs.size()) {
            return false;
        }
        Iterator<?> liter = lhs.iterator();
        Iterator<?> riter = rhs.iterator();
        while (liter.hasNext() && riter.hasNext()) {
            if (DataHelper.eq(liter.next(), riter.next())) continue;
            return false;
        }
        return true;
    }

    public static final boolean eq(byte[] lhs, byte[] rhs) {
        return Arrays.equals(lhs, rhs);
    }

    @Deprecated
    public static final boolean eq(int lhs, int rhs) {
        return lhs == rhs;
    }

    @Deprecated
    public static final boolean eq(long lhs, long rhs) {
        return lhs == rhs;
    }

    @Deprecated
    public static final boolean eq(byte lhs, byte rhs) {
        return lhs == rhs;
    }

    public static final boolean eq(byte[] lhs, int offsetLeft, byte[] rhs, int offsetRight, int length) {
        if (lhs == null || rhs == null) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (lhs[offsetLeft + i] == rhs[offsetRight + i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean eqCT(byte[] lhs, int offsetLeft, byte[] rhs, int offsetRight, int length) {
        int r = 0;
        for (int i = 0; i < length; ++i) {
            r |= lhs[offsetLeft + i] ^ rhs[offsetRight + i];
        }
        return r == 0;
    }

    public static final int compareTo(byte[] lhs, byte[] rhs) {
        if (rhs == null && lhs == null) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (rhs.length < lhs.length) {
            return 1;
        }
        if (rhs.length > lhs.length) {
            return -1;
        }
        for (int i = 0; i < rhs.length; ++i) {
            if ((rhs[i] & 0xFF) > (lhs[i] & 0xFF)) {
                return -1;
            }
            if ((rhs[i] & 0xFF) >= (lhs[i] & 0xFF)) continue;
            return 1;
        }
        return 0;
    }

    public static final byte[] xor(byte[] lhs, byte[] rhs) {
        if (lhs == null || rhs == null || lhs.length != rhs.length) {
            return null;
        }
        byte[] diff = new byte[lhs.length];
        DataHelper.xor(lhs, 0, rhs, 0, diff, 0, lhs.length);
        return diff;
    }

    public static final void xor(byte[] lhs, int startLeft, byte[] rhs, int startRight, byte[] out, int startOut, int len) {
        if (lhs == null || rhs == null || out == null) {
            throw new NullPointerException("Null params to xor");
        }
        if (lhs.length < startLeft + len) {
            throw new IllegalArgumentException("Left hand side is too short");
        }
        if (rhs.length < startRight + len) {
            throw new IllegalArgumentException("Right hand side is too short");
        }
        if (out.length < startOut + len) {
            throw new IllegalArgumentException("Result is too short");
        }
        for (int i = 0; i < len; ++i) {
            out[startOut + i] = (byte)(lhs[startLeft + i] ^ rhs[startRight + i]);
        }
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public static int hashCode(Date obj) {
        if (obj == null) {
            return 0;
        }
        return (int)obj.getTime();
    }

    public static int hashCode(byte[] b) {
        int rv = 0;
        if (b != null) {
            if (b.length <= 32) {
                rv = Arrays.hashCode(b);
            } else {
                for (int i = 0; i < 32; ++i) {
                    rv ^= b[i] << i;
                }
            }
        }
        return rv;
    }

    public static int hashCode(Collection<?> col) {
        if (col == null) {
            return 0;
        }
        int c = 0;
        Iterator<?> iter = col.iterator();
        while (iter.hasNext()) {
            c = 7 * c + DataHelper.hashCode(iter.next());
        }
        return c;
    }

    public static void skip(InputStream in, long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException();
        }
        if (n == 0L) {
            return;
        }
        long read = 0L;
        long nm1 = n - 1L;
        if (nm1 > 0L) {
            do {
                long c;
                if ((c = in.skip(nm1 - read)) < 0L) {
                    throw new EOFException("EOF while skipping " + n + ", read only " + read);
                }
                if (c == 0L) {
                    if (in.read() == -1) {
                        throw new EOFException("EOF while skipping " + n + ", read only " + read);
                    }
                    ++read;
                    continue;
                }
                read += c;
            } while (read < nm1);
        }
        if (in.read() == -1) {
            throw new EOFException("EOF while skipping " + n + ", read only " + read);
        }
    }

    public static int read(InputStream in, byte[] target) throws IOException {
        return DataHelper.read(in, target, 0, target.length);
    }

    public static int read(InputStream in, byte[] target, int offset, int length) throws IOException {
        int cur;
        int numRead;
        for (cur = 0; cur < length; cur += numRead) {
            numRead = in.read(target, offset + cur, length - cur);
            if (numRead != -1) continue;
            throw new EOFException("EOF after reading " + cur + " bytes of " + length + " byte value");
        }
        return offset + cur;
    }

    public static String readLine(InputStream in) throws IOException {
        return DataHelper.readLine(in, (MessageDigest)null);
    }

    public static String readLine(InputStream in, MessageDigest hash) throws IOException {
        StringBuilder buf = new StringBuilder(128);
        boolean ok = DataHelper.readLine(in, buf, hash);
        if (ok) {
            return buf.toString();
        }
        return null;
    }

    public static boolean readLine(InputStream in, StringBuilder buf) throws IOException {
        return DataHelper.readLine(in, buf, null);
    }

    public static boolean readLine(InputStream in, StringBuilder buf, MessageDigest hash) throws IOException {
        int c = -1;
        int i = 0;
        while ((c = in.read()) != -1) {
            if (++i > 8192) {
                throw new IOException("Line too long - max 8192");
            }
            if (hash != null) {
                hash.update((byte)c);
            }
            if (c == 10) break;
            buf.append((char)c);
        }
        return c != -1 || i > 0;
    }

    public static void write(OutputStream out, byte[] data, MessageDigest hash) throws IOException {
        hash.update(data);
        out.write(data);
    }

    public static String formatDuration(long ms) {
        if (ms < 5000L) {
            return ms + "ms";
        }
        if (ms < 180000L) {
            return ms / 1000L + "s";
        }
        if (ms < 0x6DDD00L) {
            return ms / 60000L + "m";
        }
        if (ms < 259200000L) {
            return ms / 3600000L + "h";
        }
        if (ms < 94608000000L) {
            return ms / 86400000L + "d";
        }
        if (ms < 31536000000000L) {
            return ms / 31536000000L + "y";
        }
        return "n/a";
    }

    public static String formatDuration2(long ms) {
        String t;
        long ams;
        if (ms == 0L) {
            return "0";
        }
        long l = ams = ms >= 0L ? ms : 0L - ms;
        if (ams < 3000L) {
            t = DataHelper.ngettext("{0,number,####} ms", "{0,number,####} ms", (int)ms);
        } else if (ams < 120000L) {
            t = DataHelper.ngettext("{0} sec", "{0} sec", (int)(ms / 1000L));
        } else if (ams < 0x6DDD00L) {
            t = DataHelper.ngettext("{0} min", "{0} min", (int)(ms / 60000L));
        } else if (ams < 172800000L) {
            t = DataHelper.ngettext("{0} hour", "{0} hours", (int)(ms / 3600000L));
        } else if (ams < 94608000000L) {
            t = DataHelper.ngettext("{0} day", "{0} days", (int)(ms / 86400000L));
        } else if (ams < 31536000000000L) {
            t = DataHelper.ngettext("{0} year", "{0} years", (int)(ms / 31536000000L));
        } else {
            return DataHelper._t("n/a");
        }
        if (ms < 0L) {
            t = t.replace("-", "&minus;");
        }
        return t.replace(" ", "&nbsp;");
    }

    public static String formatDuration2(double ms) {
        String t;
        long ams;
        if (ms == 0.0) {
            return "0";
        }
        double adms = ms >= 0.0 ? ms : 0.0 - ms;
        long lms = (long)ms;
        long l = ams = lms >= 0L ? lms : 0L - lms;
        if (adms < 1.0E-9) {
            return "0";
        }
        if (adms < 0.001) {
            t = DataHelper.ngettext("{0,number,####} ns", "{0,number,###} ns", (int)Math.round(ms * 1000000.0));
        } else if (adms < 1.0) {
            t = DataHelper.ngettext("{0,number,####} \u03bcs", "{0,number,###} \u03bcs", (int)Math.round(ms * 1000.0));
        } else if (ams < 3000L) {
            t = DataHelper.ngettext("{0,number,####} ms", "{0,number,####} ms", (int)Math.round(ms));
        } else if (ams < 120000L) {
            t = DataHelper.ngettext("{0} sec", "{0} sec", (int)(ms / 1000.0));
        } else if (ams < 0x6DDD00L) {
            t = DataHelper.ngettext("{0} min", "{0} min", (int)(ms / 60000.0));
        } else if (ams < 172800000L) {
            t = DataHelper.ngettext("{0} hour", "{0} hours", (int)(ms / 3600000.0));
        } else if (ams < 94608000000L) {
            t = DataHelper.ngettext("{0} day", "{0} days", (int)(ms / 8.64E7));
        } else if (ams < 31536000000000L) {
            t = DataHelper.ngettext("{0} year", "{0} years", (int)(ms / 3.1536E10));
        } else {
            return DataHelper._t("n/a");
        }
        if (ms < 0.0) {
            t = t.replace("-", "&minus;");
        }
        return t.replace(" ", "&nbsp;");
    }

    private static String _t(String key) {
        return Translate.getString(key, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    private static String ngettext(String s, String p, int n) {
        return Translate.getString(n, s, p, I2PAppContext.getGlobalContext(), BUNDLE_NAME);
    }

    public static String formatSize(long bytes) {
        float val;
        int scale = 0;
        for (val = (float)bytes; val >= 1024.0f; val /= 1024.0f) {
            ++scale;
        }
        DecimalFormat fmt = new DecimalFormat("##0.00");
        String str = fmt.format(val);
        switch (scale) {
            case 1: {
                return str + "Ki";
            }
            case 2: {
                return str + "Mi";
            }
            case 3: {
                return str + "Gi";
            }
            case 4: {
                return str + "Ti";
            }
            case 5: {
                return str + "Pi";
            }
            case 6: {
                return str + "Ei";
            }
            case 7: {
                return str + "Zi";
            }
            case 8: {
                return str + "Yi";
            }
        }
        return Long.toString(bytes);
    }

    public static String formatSize2(long bytes) {
        return DataHelper.formatSize2(bytes, true);
    }

    public static String formatSize2(long bytes, boolean nonBreaking) {
        double val;
        String space;
        String string = space = nonBreaking ? "&#8239;" : " ";
        if (bytes < 1024L) {
            return bytes + space;
        }
        int scale = 0;
        for (val = (double)bytes; val >= 1024.0; val /= 1024.0) {
            ++scale;
        }
        DecimalFormat fmt = new DecimalFormat("##0.##");
        if (val >= 200.0) {
            fmt.setMaximumFractionDigits(0);
        } else if (val >= 20.0) {
            fmt.setMaximumFractionDigits(1);
        }
        String str = fmt.format(val) + space;
        switch (scale) {
            case 1: {
                return str + "Ki";
            }
            case 2: {
                return str + "Mi";
            }
            case 3: {
                return str + "Gi";
            }
            case 4: {
                return str + "Ti";
            }
            case 5: {
                return str + "Pi";
            }
            case 6: {
                return str + "Ei";
            }
            case 7: {
                return str + "Zi";
            }
            case 8: {
                return str + "Yi";
            }
        }
        return bytes + space;
    }

    public static String formatSize2Decimal(long bytes) {
        return DataHelper.formatSize2Decimal(bytes, true);
    }

    public static String formatSize2Decimal(long bytes, boolean nonBreaking) {
        double val;
        String space;
        String string = space = nonBreaking ? "&#8239;" : " ";
        if (bytes < 1000L) {
            return bytes + space;
        }
        int scale = 0;
        for (val = (double)bytes; val >= 1000.0; val /= 1000.0) {
            ++scale;
        }
        DecimalFormat fmt = new DecimalFormat("##0.##");
        if (val >= 200.0) {
            fmt.setMaximumFractionDigits(0);
        } else if (val >= 20.0) {
            fmt.setMaximumFractionDigits(1);
        }
        String str = fmt.format(val) + space;
        switch (scale) {
            case 1: {
                return str + "K";
            }
            case 2: {
                return str + "M";
            }
            case 3: {
                return str + "G";
            }
            case 4: {
                return str + "T";
            }
            case 5: {
                return str + "P";
            }
            case 6: {
                return str + "E";
            }
            case 7: {
                return str + "Z";
            }
            case 8: {
                return str + "Y";
            }
        }
        return bytes + space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(long now) {
        DateFormat dateFormat = DATE_FORMAT;
        synchronized (dateFormat) {
            if (!_date_tz_set) {
                TimeZone tz = SystemVersion.getSystemTimeZone();
                DATE_FORMAT.setTimeZone(tz);
                _date_tz_set = true;
            }
            return DATE_FORMAT.format(new Date(now));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatTime(long now) {
        DateFormat dateFormat = TIME_FORMAT;
        synchronized (dateFormat) {
            if (!_time_tz_set) {
                TimeZone tz = SystemVersion.getSystemTimeZone();
                TIME_FORMAT.setTimeZone(tz);
                _time_tz_set = true;
            }
            return TIME_FORMAT.format(new Date(now));
        }
    }

    public static String stripHTML(String orig) {
        if (orig == null) {
            return "";
        }
        String t1 = orig.replace('<', ' ');
        String rv = t1.replace('>', ' ');
        rv = rv.replace('\"', ' ');
        rv = rv.replace('\'', ' ');
        return rv;
    }

    public static String escapeHTML(String unescaped) {
        if (unescaped == null) {
            return null;
        }
        String escaped = unescaped;
        for (int i = 0; i < escapeChars.length; ++i) {
            escaped = escaped.replace(escapeChars[i], escapeCodes[i]);
        }
        return escaped;
    }

    public static byte[] compress(byte[] orig) {
        return DataHelper.compress(orig, 0, orig.length);
    }

    public static byte[] compress(byte[] orig, int offset, int size) {
        return DataHelper.compress(orig, offset, size, 3);
    }

    public static byte[] compress(byte[] orig, int offset, int size, int level) {
        if (orig == null) {
            return orig;
        }
        if (level == 0 && size <= Short.MAX_VALUE) {
            return DataHelper.zeroCompress(orig, offset, size);
        }
        if (size > 40960) {
            throw new IllegalArgumentException("tell jrandom size=" + size);
        }
        ReusableGZIPOutputStream out = ReusableGZIPOutputStream.acquire();
        out.setLevel(level);
        try {
            out.write(orig, offset, size);
            out.finish();
            out.flush();
            byte[] rv = out.getData();
            if (rv.length <= 18) {
                throw new IllegalStateException("Compression failed, input size: " + size + " output size: " + rv.length);
            }
            byte[] byArray = rv;
            return byArray;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IllegalStateException("Compression failed, input size: " + size, ioe);
        }
        finally {
            ReusableGZIPOutputStream.release(out);
        }
    }

    private static byte[] zeroCompress(byte[] in, int off, int len) {
        if (len > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        byte[] rv = new byte[len + 23];
        rv[0] = 31;
        rv[1] = -117;
        rv[2] = 8;
        rv[8] = 2;
        rv[9] = -1;
        rv[10] = 1;
        rv[11] = (byte)(len & 0xFF);
        rv[12] = (byte)(len >> 8 & 0xFF);
        rv[13] = ~rv[11];
        rv[14] = ~rv[12];
        System.arraycopy(in, off, rv, 15, len);
        CRC32 crc = new CRC32();
        crc.update(in, off, len);
        long val = crc.getValue();
        DataHelper.toLongLE(rv, rv.length - 8, 4, val);
        rv[rv.length - 4] = rv[11];
        rv[rv.length - 3] = rv[12];
        return rv;
    }

    public static byte[] decompress(byte[] orig) throws IOException {
        return orig != null ? DataHelper.decompress(orig, 0, orig.length) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] orig, int offset, int length) throws IOException {
        if (orig == null) {
            return orig;
        }
        if (length < 20) {
            throw new IOException("length");
        }
        if (length < 65559 && orig[offset + 10] == 1) {
            return DataHelper.zeroDecompress(orig, offset, length);
        }
        if (offset + length > orig.length) {
            throw new IOException("Bad params arrlen " + orig.length + " off " + offset + " len " + length);
        }
        ReusableGZIPInputStream in = ReusableGZIPInputStream.acquire();
        in.initialize(new ByteArrayInputStream(orig, offset, length));
        ByteCache cache = ByteCache.getInstance(8, 40960);
        ByteArray outBuf = (ByteArray)cache.acquire();
        try {
            int read;
            int written = 0;
            while ((read = in.read(outBuf.getData(), written, 40960 - written)) != -1) {
                if ((written += read) < 40960) continue;
                if (in.available() <= 0) break;
                throw new IOException("Uncompressed data larger than 40960");
            }
            byte[] rv = new byte[written];
            System.arraycopy(outBuf.getData(), 0, rv, 0, written);
            byte[] byArray = rv;
            return byArray;
        }
        finally {
            cache.release(outBuf);
            ReusableGZIPInputStream.release(in);
        }
    }

    private static byte[] zeroDecompress(byte[] in, int off, int len) throws IOException {
        if (len > 65558) {
            throw new IOException("length");
        }
        try {
            int olen = len - 23;
            if (in[off++] != 31 || in[off++] != -117 || in[off] != 8) {
                throw new IOException("header");
            }
            off += 8;
            if (in[off++] != 1 || DataHelper.fromLongLE(in, off, 2) != (long)olen) {
                throw new IOException("header");
            }
            if (in[off += 2] != (byte)(~in[off - 2]) || in[off + 1] != (byte)(~in[off - 1])) {
                throw new IOException("header");
            }
            int trailer = (off += 2) + olen;
            if (DataHelper.fromLongLE(in, trailer + 4, 4) != (long)olen) {
                throw new IOException("trailer");
            }
            CRC32 crc = new CRC32();
            crc.update(in, off, olen);
            long val = crc.getValue();
            if (val != DataHelper.fromLongLE(in, trailer, 4)) {
                throw new IOException("CRC");
            }
            byte[] rv = new byte[olen];
            System.arraycopy(in, off, rv, 0, olen);
            return rv;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IOException(aioobe);
        }
    }

    public static byte[] getUTF8(String orig) {
        if (orig == null) {
            return null;
        }
        try {
            return orig.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("no utf8!?");
        }
    }

    @Deprecated
    public static byte[] getUTF8(StringBuffer orig) {
        if (orig == null) {
            return null;
        }
        return DataHelper.getUTF8(orig.toString());
    }

    public static String getUTF8(byte[] orig) {
        if (orig == null) {
            return null;
        }
        try {
            return new String(orig, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("no utf8!?");
        }
    }

    public static String getUTF8(byte[] orig, int offset, int len) {
        if (orig == null) {
            return null;
        }
        try {
            return new String(orig, offset, len, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("no utf8!?");
        }
    }

    public static byte[] getASCII(String orig) {
        byte[] rv = new byte[orig.length()];
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = (byte)orig.charAt(i);
        }
        return rv;
    }

    public static String[] split(String s, String regex) {
        return DataHelper.split(s, regex, 0);
    }

    public static String[] split(String s, String regex, int limit) {
        Pattern p = patterns.get(regex);
        if (p == null) {
            if (!(regex.length() <= 1 || regex.startsWith("[") || regex.equals("\r\n") || regex.startsWith("\\"))) {
                System.out.println("Warning: Split on regex: \"" + regex + "\" should probably be enclosed with []");
            }
            p = Pattern.compile(regex);
            patterns.putIfAbsent(regex, p);
        }
        return p.split(s, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        ByteCache cache = ByteCache.getInstance(8, 8192);
        ByteArray ba = (ByteArray)cache.acquire();
        try {
            int read;
            byte[] buf = ba.getData();
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
        }
        finally {
            cache.release(ba);
        }
    }

    public static <T> void sort(List<T> list, Comparator<? super T> c) {
        try {
            Collections.sort(list, c);
        }
        catch (IllegalArgumentException iae1) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                Collections.sort(list, c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static <T> void sort(T[] a, Comparator<? super T> c) {
        try {
            Arrays.sort(a, c);
        }
        catch (IllegalArgumentException iae1) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                Arrays.sort(a, c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static void replace(StringBuilder buf, String from, String to) {
        int idx;
        int oidx = 0;
        while (oidx < buf.length() && (idx = buf.indexOf(from, oidx)) >= 0) {
            buf.replace(idx, idx + from.length(), to);
            oidx = idx + to.length();
        }
    }

    static {
        String[] keys = new String[]{"cost", "host", "port", "key", "mtu", "ihost0", "iport0", "ikey0", "itag0", "iexp0", "ihost1", "iport1", "ikey1", "itag1", "iexp1", "ihost2", "iport2", "ikey2", "itag2", "iexp2", "ihost3", "iport3", "ikey3", "itag3", "iexp3", "ih0", "ih1", "ih2", "ih3", "caps", "coreVersion", "netId", "router.version", "netdb.knownLeaseSets", "netdb.knownRouters", "stat_bandwidthReceiveBps.60m", "stat_bandwidthSendBps.60m", "stat_tunnel.buildClientExpire.60m", "stat_tunnel.buildClientReject.60m", "stat_tunnel.buildClientSuccess.60m", "stat_tunnel.buildExploratoryExpire.60m", "stat_tunnel.buildExploratoryReject.60m", "stat_tunnel.buildExploratorySuccess.60m", "stat_tunnel.participatingTunnels.60m", "stat_uptime", "family", "family.key", "family.sig", "version", "created", "upgraded", "lists", "a", "m", "s", "v", "notes", "i"};
        _propertiesKeyCache = new HashMap<String, String>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            _propertiesKeyCache.put(keys[i], keys[i]);
        }
        ILLEGAL_KEY = Pattern.compile("[#=\\r\\n;]");
        ILLEGAL_VALUE = Pattern.compile("[#\\r\\n]");
        DATE_FORMAT = DateFormat.getDateInstance(2);
        TIME_FORMAT = DateFormat.getDateTimeInstance(2, 3);
        EMPTY_BUFFER = new byte[0];
        escapeChars = new String[]{"&", "\"", "<", ">", "'"};
        escapeCodes = new String[]{"&amp;", "&quot;", "&lt;", "&gt;", "&apos;"};
        patterns = new ConcurrentHashMap();
    }
}

