/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import net.i2p.data.DataHelper;

public class Base64 {
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte[] ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    public static final String ALPHABET_I2P = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~";
    private static final byte[] ALPHABET_ALT = DataHelper.getASCII("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~");
    private static final byte[] DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, 63, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9};
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    public static String encode(String source) {
        return source != null ? Base64.encode(DataHelper.getUTF8(source)) : "";
    }

    public static String encode(byte[] source) {
        return source != null ? Base64.encode(source, 0, source.length) : "";
    }

    public static String encode(byte[] source, int off, int len) {
        return source != null ? Base64.encode(source, off, len, false) : "";
    }

    public static String encode(byte[] source, boolean useStandardAlphabet) {
        return source != null ? Base64.encode(source, 0, source.length, useStandardAlphabet) : "";
    }

    public static String encode(byte[] source, int off, int len, boolean useStandardAlphabet) {
        return source != null ? Base64.safeEncode(source, off, len, useStandardAlphabet) : "";
    }

    public static byte[] decode(String s) {
        return Base64.safeDecode(s, false);
    }

    public static byte[] decode(String s, boolean useStandardAlphabet) {
        return Base64.safeDecode(s, useStandardAlphabet);
    }

    private Base64() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Base64.help();
        }
        Base64.runApp(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runApp(String[] args) {
        String cmd = args[0].toLowerCase(Locale.US);
        if ("encodestring".equals(cmd)) {
            if (args.length != 2) {
                Base64.help();
            }
            System.out.println(Base64.encode(DataHelper.getUTF8(args[1])));
            return;
        }
        if ("decodestring".equals(cmd)) {
            byte[] dec;
            if (args.length != 2) {
                Base64.help();
            }
            if ((dec = Base64.decode(args[1])) != null) {
                try {
                    System.out.write(dec);
                }
                catch (IOException ioe) {
                    System.err.println("output error " + String.valueOf(ioe));
                    System.exit(1);
                }
            } else {
                System.err.println("decode error");
                System.exit(1);
            }
            return;
        }
        if ("test".equals(cmd)) {
            System.err.println("test disabled");
            System.exit(1);
        }
        if (!"encode".equals(cmd) && !"decode".equals(cmd)) {
            System.err.println("unknown command " + cmd);
            System.exit(1);
        }
        InputStream in = System.in;
        OutputStream out = System.out;
        try {
            if (args.length >= 3) {
                out = new FileOutputStream(args[2]);
            }
            if (args.length >= 2) {
                in = new FileInputStream(args[1]);
            }
            if ("encode".equals(cmd)) {
                Base64.encode(in, out);
            } else {
                Base64.decode(in, out);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        DataHelper.copy(in, baos);
        return baos.toByteArray();
    }

    private static void encode(InputStream in, OutputStream out) throws IOException {
        String encoded = Base64.encode(Base64.read(in));
        for (int i = 0; i < encoded.length(); ++i) {
            out.write((byte)(encoded.charAt(i) & 0xFF));
        }
    }

    private static void decode(InputStream in, OutputStream out) throws IOException {
        byte[] decoded = Base64.decode(DataHelper.getUTF8(Base64.read(in)));
        if (decoded == null) {
            throw new IOException("Invalid base 64 string");
        }
        out.write(decoded);
    }

    private static void help() {
        System.err.println("Usage: Base64 encode <inFile> <outFile>");
        System.err.println("       Base64 encode <inFile>");
        System.err.println("       Base64 encode (stdin to stdout)");
        System.err.println("       Base64 decode <inFile> <outFile>");
        System.err.println("       Base64 decode <inFile>");
        System.err.println("       Base64 decode (stdin to stdout)");
        System.err.println("       Base64 encodestring 'string to encode'");
        System.err.println("       Base64 decodestring 'string to decode'");
        System.err.println("       Base64 test");
        System.exit(1);
    }

    private static void encode3to4(byte[] source, int srcOffset, int numSigBytes, StringBuilder buf, byte[] alpha) {
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                buf.append((char)alpha[inBuff >>> 18]);
                buf.append((char)alpha[inBuff >>> 12 & 0x3F]);
                buf.append((char)alpha[inBuff >>> 6 & 0x3F]);
                buf.append((char)alpha[inBuff & 0x3F]);
                return;
            }
            case 2: {
                buf.append((char)alpha[inBuff >>> 18]);
                buf.append((char)alpha[inBuff >>> 12 & 0x3F]);
                buf.append((char)alpha[inBuff >>> 6 & 0x3F]);
                buf.append('=');
                return;
            }
            case 1: {
                buf.append((char)alpha[inBuff >>> 18]);
                buf.append((char)alpha[inBuff >>> 12 & 0x3F]);
                buf.append('=');
                buf.append('=');
                return;
            }
        }
    }

    private static String safeEncode(byte[] source, int off, int len, boolean useStandardAlphabet) {
        if (len + off > source.length) {
            throw new ArrayIndexOutOfBoundsException("Trying to encode too much!  source.len=" + source.length + " off=" + off + " len=" + len);
        }
        StringBuilder buf = new StringBuilder(len * 4 / 3);
        if (useStandardAlphabet) {
            Base64.encodeBytes(source, off, len, false, buf, ALPHABET);
        } else {
            Base64.encodeBytes(source, off, len, false, buf, ALPHABET_ALT);
        }
        return buf.toString();
    }

    private static byte[] safeDecode(String source, boolean useStandardAlphabet) {
        String toDecode;
        if (source == null) {
            return null;
        }
        if (useStandardAlphabet) {
            toDecode = source.replace('/', '~');
            toDecode = toDecode.replace('+', '-');
        } else {
            toDecode = source;
        }
        return Base64.standardDecode(toDecode);
    }

    private static void encodeBytes(byte[] source, int off, int len, boolean breakLines, StringBuilder out, byte[] alpha) {
        int d;
        int len2 = len - 2;
        int lineLength = 0;
        for (d = 0; d < len2; d += 3) {
            Base64.encode3to4(source, d + off, 3, out, alpha);
            if (!breakLines || (lineLength += 4) != 76) continue;
            out.append('\n');
            lineLength = 0;
        }
        if (d < len) {
            Base64.encode3to4(source, d + off, len - d, out, alpha);
        }
    }

    private static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset) {
        byte decode0 = DECODABET[source[srcOffset++]];
        byte decode1 = DECODABET[source[srcOffset++]];
        if (decode0 < 0 || decode1 < 0) {
            return -1;
        }
        if (source[srcOffset] == 61) {
            if (source[srcOffset + 1] != 61) {
                return -1;
            }
            if ((decode1 & 0xF) != 0) {
                return -1;
            }
            int outBuff = decode0 << 18 | decode1 << 12;
            destination[destOffset] = (byte)(outBuff >> 16);
            return 1;
        }
        if (source[srcOffset + 1] == 61) {
            byte decode2 = DECODABET[source[srcOffset]];
            if (decode2 < 0) {
                return -1;
            }
            if ((decode2 & 3) != 0) {
                return -1;
            }
            int outBuff = decode0 << 18 | decode1 << 12 | decode2 << 6;
            destination[destOffset++] = (byte)(outBuff >> 16);
            destination[destOffset] = (byte)(outBuff >> 8);
            return 2;
        }
        byte decode2 = DECODABET[source[srcOffset++]];
        byte decode3 = DECODABET[source[srcOffset]];
        if (decode2 < 0 || decode3 < 0) {
            return -1;
        }
        int outBuff = decode0 << 18 | decode1 << 12 | decode2 << 6 | decode3;
        destination[destOffset++] = (byte)(outBuff >> 16);
        destination[destOffset++] = (byte)(outBuff >> 8);
        destination[destOffset] = (byte)outBuff;
        return 3;
    }

    private static byte[] standardDecode(String s) {
        byte[] bytes = DataHelper.getUTF8(s);
        if (bytes.length != s.length()) {
            return null;
        }
        return Base64.decode(bytes, 0, bytes.length);
    }

    public static String decodeToString(String s) {
        byte[] b = Base64.decode(s);
        if (b == null) {
            return null;
        }
        return DataHelper.getUTF8(b);
    }

    private static byte[] decode(byte[] source, int off, int len) {
        int remaining;
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        int i = off;
        int end = off + len;
        int converted = 0;
        while (i + 3 < end) {
            converted = Base64.decode4to3(source, i, outBuff, outBuffPosn);
            if (converted < 0) {
                return null;
            }
            outBuffPosn += converted;
            i += 4;
            if (converted >= 3) continue;
        }
        if ((remaining = end - i) > 0) {
            if (converted > 0 && converted < 3) {
                return null;
            }
            if (remaining == 1 || remaining > 3) {
                return null;
            }
            byte[] b4 = new byte[]{source[i++], source[i++], remaining == 3 ? source[i] : (byte)61, 61};
            converted = Base64.decode4to3(b4, 0, outBuff, outBuffPosn);
            if (converted < 0) {
                return null;
            }
            outBuffPosn += converted;
        }
        if (outBuffPosn == outBuff.length) {
            return outBuff;
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }
}

