/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionException;
import net.i2p.client.impl.I2PSessionImpl;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class SessionIdleTimer
implements SimpleTimer.TimedEvent {
    public static final long MINIMUM_TIME = 300000L;
    private static final long DEFAULT_REDUCE_TIME = 1200000L;
    private static final long DEFAULT_CLOSE_TIME = 1800000L;
    private final Log _log;
    private final I2PAppContext _context;
    private final I2PSessionImpl _session;
    private final boolean _reduceEnabled;
    private final int _reduceQuantity;
    private final long _reduceTime;
    private final boolean _shutdownEnabled;
    private final long _shutdownTime;
    private final long _minimumTime;
    private long _lastActive;

    public SessionIdleTimer(I2PAppContext context, I2PSessionImpl session, boolean reduce, boolean shutdown) {
        String p;
        if (!reduce && !shutdown) {
            throw new IllegalArgumentException("At least one must be enabled");
        }
        this._context = context;
        this._log = context.logManager().getLog(SessionIdleTimer.class);
        this._session = session;
        Properties props = session.getOptions();
        long minimumTime = Long.MAX_VALUE;
        long reduceTime = 0L;
        long shutdownTime = 0L;
        int reduceQuantity = 0;
        if (reduce) {
            reduceQuantity = 1;
            p = props.getProperty("i2cp.reduceQuantity");
            if (p != null) {
                try {
                    reduceQuantity = Math.max(Integer.parseInt(p), 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            reduceTime = 1200000L;
            p = props.getProperty("i2cp.reduceIdleTime");
            if (p != null) {
                try {
                    reduceTime = Math.max(Long.parseLong(p), 300000L);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            minimumTime = reduceTime;
        }
        if (shutdown) {
            shutdownTime = 1800000L;
            p = props.getProperty("i2cp.closeIdleTime");
            if (p != null) {
                try {
                    shutdownTime = Math.max(Long.parseLong(p), 300000L);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            minimumTime = Math.min(minimumTime, shutdownTime);
            if (reduce && shutdownTime <= reduceTime) {
                reduce = false;
            }
        }
        this._reduceEnabled = reduce;
        this._reduceQuantity = reduceQuantity;
        this._reduceTime = reduceTime;
        this._shutdownEnabled = shutdown;
        this._shutdownTime = shutdownTime;
        this._minimumTime = minimumTime;
    }

    @Override
    public void timeReached() {
        if (this._session.isClosed()) {
            return;
        }
        long now = this._context.clock().now();
        long lastActivity = this._session.lastActivity();
        if (this._log.shouldDebug()) {
            this._log.debug("Fire idle timer, last activity: " + DataHelper.formatDuration(now - lastActivity) + " ago ");
        }
        long nextDelay = 0L;
        if (this._shutdownEnabled && now - lastActivity >= this._shutdownTime) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Closing on idle " + String.valueOf(this._session));
            }
            this._session.destroySession();
            return;
        }
        if (lastActivity <= this._lastActive && !this._shutdownEnabled) {
            if (this._log.shouldDebug()) {
                this._log.debug("Still idle, sleeping again " + String.valueOf(this._session));
            }
            nextDelay = this._reduceTime;
        } else if (this._reduceEnabled && now - lastActivity >= this._reduceTime) {
            if (this._log.shouldDebug()) {
                this._log.debug("Reducing quantity on idle " + String.valueOf(this._session));
            }
            try {
                this._session.getProducer().updateTunnels(this._session, this._reduceQuantity);
            }
            catch (I2PSessionException ise) {
                this._log.error("bork idle reduction " + String.valueOf(ise));
            }
            this._session.setReduced();
            this._lastActive = lastActivity;
            nextDelay = this._shutdownEnabled ? this._shutdownTime - (now - lastActivity) : this._reduceTime;
        } else {
            nextDelay = this._minimumTime - (now - lastActivity);
        }
        this._context.simpleTimer2().addEvent(this, nextDelay);
    }
}

