/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.CPUInformation;

import freenet.support.CPUInformation.AMDCPUInfo;
import freenet.support.CPUInformation.CPUID;
import freenet.support.CPUInformation.CPUIDCPUInfo;
import freenet.support.CPUInformation.UnknownCPUException;

class AMDInfoImpl
extends CPUIDCPUInfo
implements AMDCPUInfo {
    private static boolean isK6Compatible;
    private static boolean isK6_2_Compatible;
    private static boolean isK6_3_Compatible;
    private static boolean isGeodeCompatible;
    private static boolean isAthlonCompatible;
    private static boolean isAthlon64Compatible;
    private static boolean isK10Compatible;
    private static boolean isBobcatCompatible;
    private static boolean isJaguarCompatible;
    private static boolean isBulldozerCompatible;
    private static boolean isPiledriverCompatible;
    private static boolean isSteamrollerCompatible;
    private static boolean isExcavatorCompatible;
    private static boolean isZenCompatible;
    private static boolean isZen2Compatible;

    AMDInfoImpl() {
    }

    @Override
    public boolean IsK6Compatible() {
        return isK6Compatible;
    }

    @Override
    public boolean IsK6_2_Compatible() {
        return isK6_2_Compatible;
    }

    @Override
    public boolean IsK6_3_Compatible() {
        return isK6_3_Compatible;
    }

    @Override
    public boolean IsGeodeCompatible() {
        return isGeodeCompatible;
    }

    @Override
    public boolean IsAthlonCompatible() {
        return isAthlonCompatible;
    }

    @Override
    public boolean IsAthlon64Compatible() {
        return isAthlon64Compatible;
    }

    @Override
    public boolean IsK10Compatible() {
        return isK10Compatible;
    }

    @Override
    public boolean IsBobcatCompatible() {
        return isBobcatCompatible;
    }

    @Override
    public boolean IsJaguarCompatible() {
        return isJaguarCompatible;
    }

    @Override
    public boolean IsBulldozerCompatible() {
        return isBulldozerCompatible;
    }

    @Override
    public boolean IsPiledriverCompatible() {
        return isPiledriverCompatible;
    }

    @Override
    public boolean IsSteamrollerCompatible() {
        return isSteamrollerCompatible;
    }

    @Override
    public boolean IsExcavatorCompatible() {
        return isExcavatorCompatible;
    }

    @Override
    public boolean IsZenCompatible() {
        return isZenCompatible;
    }

    @Override
    public boolean IsZen2Compatible() {
        return isZen2Compatible;
    }

    @Override
    public String getCPUModelString() throws UnknownCPUException {
        String smodel = this.identifyCPU();
        if (smodel != null) {
            return smodel;
        }
        throw new UnknownCPUException("Unknown AMD CPU; Family=" + CPUID.getCPUFamily() + "/" + CPUID.getCPUExtendedFamily() + ", Model=" + CPUID.getCPUModel() + "/" + CPUID.getCPUExtendedModel());
    }

    private String identifyCPU() {
        Object modelString = null;
        int family = CPUID.getCPUFamily();
        int model = CPUID.getCPUModel();
        if (family == 15) {
            family += CPUID.getCPUExtendedFamily();
            model += CPUID.getCPUExtendedModel() << 4;
        }
        block0 : switch (family) {
            case 4: {
                switch (model) {
                    case 3: {
                        modelString = "486 DX/2";
                        break block0;
                    }
                    case 7: {
                        modelString = "486 DX/2-WB";
                        break block0;
                    }
                    case 8: {
                        modelString = "486 DX/4";
                        break block0;
                    }
                    case 9: {
                        modelString = "486 DX/4-WB";
                        break block0;
                    }
                    case 14: {
                        modelString = "Am5x86-WT";
                        break block0;
                    }
                    case 15: {
                        modelString = "Am5x86-WB";
                        break block0;
                    }
                }
                modelString = "AMD 486/586 model " + model;
                break;
            }
            case 5: {
                isK6Compatible = true;
                switch (model) {
                    case 0: {
                        modelString = "K5/SSA5";
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        modelString = "K5";
                        break block0;
                    }
                    case 4: {
                        isK6Compatible = false;
                        isGeodeCompatible = true;
                        modelString = "Geode GX1/GXLV/GXm";
                        break block0;
                    }
                    case 5: {
                        isK6Compatible = false;
                        isGeodeCompatible = true;
                        modelString = "Geode GX2/LX";
                        break block0;
                    }
                    case 6: 
                    case 7: {
                        modelString = "K6";
                        break block0;
                    }
                    case 8: {
                        isK6_2_Compatible = true;
                        modelString = "K6-2";
                        break block0;
                    }
                    case 9: {
                        isK6_2_Compatible = true;
                        isK6_3_Compatible = true;
                        modelString = "K6-3";
                        break block0;
                    }
                    case 13: {
                        isK6_2_Compatible = true;
                        modelString = "K6-2+ or K6-III+";
                        break block0;
                    }
                }
                modelString = "AMD K5/K6 model " + model;
                break;
            }
            case 6: {
                isK6Compatible = true;
                isK6_2_Compatible = true;
                isK6_3_Compatible = true;
                isAthlonCompatible = true;
                switch (model) {
                    case 0: 
                    case 1: {
                        modelString = "Athlon (250 nm)";
                        break block0;
                    }
                    case 2: {
                        modelString = "Athlon (180 nm)";
                        break block0;
                    }
                    case 3: {
                        modelString = "Duron";
                        break block0;
                    }
                    case 4: {
                        modelString = "Athlon (Thunderbird)";
                        break block0;
                    }
                    case 6: {
                        modelString = "Athlon (Palamino)";
                        break block0;
                    }
                    case 7: {
                        modelString = "Duron (Morgan)";
                        break block0;
                    }
                    case 8: {
                        modelString = "Athlon (Thoroughbred)";
                        break block0;
                    }
                    case 10: {
                        modelString = "Athlon (Barton)";
                        break block0;
                    }
                }
                modelString = "AMD Athlon/Duron model " + model;
                break;
            }
            case 15: {
                isK6Compatible = true;
                isK6_2_Compatible = true;
                isK6_3_Compatible = true;
                isAthlonCompatible = true;
                isAthlon64Compatible = true;
                switch (model) {
                    case 4: {
                        modelString = "Athlon 64/Mobile XP-M";
                        break block0;
                    }
                    case 5: {
                        modelString = "Athlon 64 FX Opteron";
                        break block0;
                    }
                    case 7: {
                        modelString = "Athlon 64 FX (Sledgehammer S939, 130 nm)";
                        break block0;
                    }
                    case 8: {
                        modelString = "Mobile A64/Sempron/XP-M";
                        break block0;
                    }
                    case 11: {
                        modelString = "Athlon 64 (Clawhammer S939, 130 nm)";
                        break block0;
                    }
                    case 12: 
                    case 14: {
                        modelString = "Athlon 64/Sempron (Newcastle S754, 130 nm)";
                        break block0;
                    }
                    case 15: {
                        modelString = "Athlon 64/Sempron (Clawhammer S939, 130 nm)";
                        break block0;
                    }
                    case 18: {
                        modelString = "Sempron (Palermo, 90 nm)";
                        break block0;
                    }
                    case 20: {
                        modelString = "Athlon 64 (Winchester S754, 90 nm)";
                        break block0;
                    }
                    case 23: {
                        modelString = "Athlon 64 (Winchester S939, 90 nm)";
                        break block0;
                    }
                    case 24: {
                        modelString = "Mobile A64/Sempron/XP-M (Winchester S754, 90 nm)";
                        break block0;
                    }
                    case 26: {
                        modelString = "Athlon 64 (Winchester S939, 90 nm)";
                        break block0;
                    }
                    case 27: {
                        modelString = "Athlon 64/Sempron (Winchester/Palermo 90 nm)";
                        break block0;
                    }
                    case 28: {
                        modelString = "Sempron (Palermo, 90 nm)";
                        break block0;
                    }
                    case 31: {
                        modelString = "Athlon 64/Sempron (Winchester/Palermo, 90 nm)";
                        break block0;
                    }
                    case 33: {
                        modelString = "Dual-Core Opteron (Italy-Egypt S940, 90 nm)";
                        break block0;
                    }
                    case 35: {
                        modelString = "Athlon 64 X2/A64 FX/Opteron (Toledo/Denmark S939, 90 nm)";
                        break block0;
                    }
                    case 36: {
                        modelString = "Mobile A64/Turion (Lancaster/Richmond/Newark, 90 nm)";
                        break block0;
                    }
                    case 37: {
                        modelString = "Opteron (Troy/Athens S940, 90 nm)";
                        break block0;
                    }
                    case 39: {
                        modelString = "Athlon 64 (San Diego, 90 nm)";
                        break block0;
                    }
                    case 43: {
                        modelString = "Athlon 64 X2 (Manchester, 90 nm)";
                        break block0;
                    }
                    case 44: {
                        modelString = "Sempron/mobile Sempron (Palermo/Albany/Roma S754, 90 nm)";
                        break block0;
                    }
                    case 47: {
                        modelString = "Athlon 64/Sempron (Venice/Palermo S939, 90 nm)";
                        break block0;
                    }
                    case 65: {
                        modelString = "Second-Generaton Opteron (Santa Rosa S1207, 90 nm)";
                        break block0;
                    }
                    case 67: {
                        modelString = "Athlon 64 X2/2nd-gen Opteron (Windsor/Santa Rosa, 90 nm)";
                        break block0;
                    }
                    case 72: {
                        modelString = "Athlon 64 X2/Turion 64 X2 (Windsor/Taylor/Trinidad, 90 nm)";
                        break block0;
                    }
                    case 75: {
                        modelString = "Athlon 64 X2 (Windsor, 90 nm)";
                        break block0;
                    }
                    case 76: {
                        modelString = "Mobile A64/mobile Sempron/Turion (Keene/Trinidad/Taylor, 90 nm)";
                        break block0;
                    }
                    case 79: {
                        modelString = "Athlon 64/Sempron (Orleans/Manila AM2, 90 nm)";
                        break block0;
                    }
                    case 93: {
                        modelString = "Opteron Gen 2 (Santa Rosa, 90 nm)";
                        break block0;
                    }
                    case 95: {
                        modelString = "A64/Sempron/mobile Sempron (Orleans/Manila/Keene, 90 nm)";
                        break block0;
                    }
                    case 104: {
                        modelString = "Turion 64 X2 (Tyler S1, 65 nm)";
                        break block0;
                    }
                    case 107: {
                        modelString = "Athlon 64 X2/Sempron X2/Athlon Neo X2 (Brisbane/Huron, 65 nm)";
                        break block0;
                    }
                    case 108: {
                        modelString = "A64/Athlon Neo/Sempron/Mobile Sempron (Lima/Huron/Sparta/Sherman, 65 nm)";
                        break block0;
                    }
                    case 111: {
                        modelString = "Neo/Sempron/mobile Sempron (Huron/Sparta/Sherman, 65 nm)";
                        break block0;
                    }
                    case 124: {
                        modelString = "Athlon/Sempron/mobile Sempron (Lima/Sparta/Sherman, 65 nm)";
                        break block0;
                    }
                    case 127: {
                        modelString = "A64/Athlon Neo/Sempron/mobile Sempron (Lima/Huron/Sparta/Sherman, 65 nm)";
                        break block0;
                    }
                    case 193: {
                        modelString = "Athlon 64 FX (Windsor S1207 90 nm)";
                        break block0;
                    }
                }
                modelString = "AMD Athlon/Duron/Sempron model " + model;
                break;
            }
            case 16: {
                isK6Compatible = true;
                isK6_2_Compatible = true;
                isK6_3_Compatible = true;
                isAthlonCompatible = true;
                isAthlon64Compatible = true;
                isK10Compatible = true;
                switch (model) {
                    case 2: {
                        modelString = "Phenom / Athlon / Opteron Gen 3 (Barcelona/Agena/Toliman/Kuma, 65 nm)";
                        break block0;
                    }
                    case 4: {
                        modelString = "Phenom II / Opteron Gen 3 (Shanghai/Deneb/Heka/Callisto, 45 nm)";
                        break block0;
                    }
                    case 5: {
                        modelString = "Athlon II X2/X3/X4 (Regor/Rana/Propus AM3, 45 nm)";
                        break block0;
                    }
                    case 6: {
                        modelString = "Mobile Athlon II/Turion II/Phenom II/Sempron/V-series (Regor/Caspian/Champlain, 45 nm)";
                        break block0;
                    }
                    case 8: {
                        modelString = "Six-Core Opteron/Opteron 4100 series (Istanbul/Lisbon, 45 nm)";
                        break block0;
                    }
                    case 9: {
                        modelString = "Opteron 6100 series (Magny-Cours G34, 45 nm)";
                        break block0;
                    }
                    case 10: {
                        modelString = "Phenom II X4/X6 (Zosma/Thuban AM3, 45 nm)";
                        break block0;
                    }
                }
                modelString = "AMD Athlon/Opteron model " + model;
                break;
            }
            case 17: {
                isK6Compatible = true;
                isK6_2_Compatible = true;
                isK6_3_Compatible = true;
                isAthlonCompatible = true;
                isAthlon64Compatible = true;
                switch (model) {
                    case 3: {
                        modelString = "AMD Turion X2/Athlon X2/Sempron (Lion/Sable, 65 nm)";
                        break block0;
                    }
                }
                modelString = "AMD Athlon/Turion/Sempron model " + model;
                break;
            }
            case 18: {
                isK6Compatible = true;
                isK6_2_Compatible = true;
                isK6_3_Compatible = true;
                isAthlonCompatible = true;
                isAthlon64Compatible = true;
                modelString = "AMD APU model " + model;
                break;
            }
            case 20: {
                isK6Compatible = true;
                isK6_2_Compatible = true;
                isK6_3_Compatible = true;
                isAthlonCompatible = true;
                isAthlon64Compatible = true;
                isBobcatCompatible = true;
                switch (model) {
                    case 1: 
                    case 3: {
                        modelString = "AMD Bobcat APU";
                        break block0;
                    }
                }
                modelString = "AMD Bobcat APU model " + model;
                break;
            }
            case 21: {
                isK6Compatible = true;
                isK6_2_Compatible = true;
                isK6_3_Compatible = true;
                isAthlonCompatible = true;
                isAthlon64Compatible = true;
                isBulldozerCompatible = true;
                if (!this.hasAVX()) {
                    modelString = "Bulldozer";
                    break;
                }
                if (model >= 80 && model <= 95) {
                    isPiledriverCompatible = true;
                    isSteamrollerCompatible = true;
                    isExcavatorCompatible = true;
                    modelString = "Excavator";
                    break;
                }
                if (model >= 48 && model <= 63) {
                    isPiledriverCompatible = true;
                    isSteamrollerCompatible = true;
                    modelString = "Steamroller";
                    break;
                }
                if (model >= 16 && model <= 31 || this.hasTBM()) {
                    isPiledriverCompatible = true;
                    modelString = "Piledriver";
                    break;
                }
                modelString = "Bulldozer";
                break;
            }
            case 22: {
                isK6Compatible = true;
                isK6_2_Compatible = true;
                isK6_3_Compatible = true;
                isAthlonCompatible = true;
                isAthlon64Compatible = true;
                isBobcatCompatible = true;
                isJaguarCompatible = true;
                modelString = "Jaguar";
                break;
            }
            case 23: 
            case 25: 
            case 26: {
                isK6Compatible = true;
                isK6_2_Compatible = true;
                isK6_3_Compatible = true;
                isAthlonCompatible = true;
                isAthlon64Compatible = true;
                isPiledriverCompatible = true;
                isSteamrollerCompatible = true;
                isExcavatorCompatible = true;
                isBulldozerCompatible = true;
                isZenCompatible = true;
                boolean bl = isZen2Compatible = family != 23;
                if (family == 26) {
                    modelString = "Ryzen/Epyc Zen 5 model " + model;
                    break;
                }
                if (isZen2Compatible) {
                    modelString = "Ryzen/Epyc Zen 3 model " + model;
                    break;
                }
                if (model == 1) {
                    modelString = "Ryzen 7";
                    break;
                }
                modelString = "Ryzen/Epyc model " + model;
                break;
            }
            case 24: {
                isK6Compatible = true;
                isK6_2_Compatible = true;
                isK6_3_Compatible = true;
                isAthlonCompatible = true;
                isAthlon64Compatible = true;
                modelString = "Hygon Dhyana model " + model;
            }
        }
        return modelString;
    }
}

