/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TimeUnit {
    SECOND{

        @Override
        public String getLabel() {
            return "s";
        }
    }
    ,
    MINUTE{

        @Override
        public String getLabel() {
            return "HH:mm";
        }
    }
    ,
    HOUR{

        @Override
        public String getLabel() {
            return "HH:mm";
        }
    }
    ,
    DAY{

        @Override
        public String getLabel() {
            return "EEE dd";
        }
    }
    ,
    WEEK{

        @Override
        public String getLabel() {
            return "'Week 'w";
        }
    }
    ,
    MONTH{

        @Override
        public String getLabel() {
            return "MMM";
        }
    }
    ,
    YEAR{

        @Override
        public String getLabel() {
            return "yy";
        }
    };


    public abstract String getLabel();

    public static TimeUnit resolveUnit(int unitKey) {
        switch (unitKey) {
            case 13: {
                return SECOND;
            }
            case 12: {
                return MINUTE;
            }
            case 11: {
                return HOUR;
            }
            case 5: {
                return DAY;
            }
            case 3: {
                return WEEK;
            }
            case 2: {
                return MONTH;
            }
            case 1: {
                return YEAR;
            }
        }
        throw new IllegalArgumentException("Unidentified key " + unitKey);
    }
}

