/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.rrd4j;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import net.i2p.data.DataHelper;
import net.i2p.rrd4j.SimpleSVGGraphics2D;

public class SimpleSVGMaker {
    private final StringBuilder buf;
    private int clipid;

    public SimpleSVGMaker(StringBuilder buf) {
        this.buf = buf;
    }

    public void startSVG(int width, int height, Color bgcolor, String id, String clz) {
        this.buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ");
        this.addIDClass(id, clz);
        this.addString("viewBox", "0 0 " + width + " " + height);
        this.addInt("width", width);
        this.addInt("height", height);
        this.buf.append(">\n");
        if (bgcolor != null && bgcolor.getAlpha() > 0) {
            this.drawRect(0, 0, width, height, null, bgcolor, null, null, Collections.emptyMap());
        }
    }

    public void endSVG() {
        this.buf.append("</svg>\n");
    }

    public void startGroup(String id, String clz, String att, String val) {
        this.buf.append("<g ");
        this.addIDClass(id, clz);
        if (att != null && val != null) {
            this.addString(att, val);
        }
        this.buf.append(">\n");
    }

    public void endGroup() {
        this.buf.append("</g>\n");
    }

    public String defineClipPath(Rectangle clip) {
        this.buf.append("<clipPath ");
        String rv = "clip-" + this.hashCode() + "-" + this.clipid++;
        this.addIDClass(rv, null);
        this.buf.append("><rect ");
        this.addInt("x", (int)clip.getX());
        this.addInt("y", (int)clip.getY());
        this.addInt("width", (int)clip.getWidth());
        this.addInt("height", (int)clip.getHeight());
        this.buf.append("/></clipPath>\n");
        return rv;
    }

    public void drawCircle(int x, int y, int radius, Color border, Color fill, BasicStroke stroke, String clipid, Map<Object, Object> hints) {
        this.buf.append("<circle ");
        this.addAttributes(hints);
        this.addClipPath(clipid);
        this.addInt("cx", x);
        this.addInt("cy", y);
        this.addInt("r", radius);
        this.addStroke("fill", fill, null);
        this.addStroke("stroke", border, stroke);
        String title = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_TITLE);
        String inner = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_INNERSVG);
        if (title != null || inner != null) {
            this.buf.append(">\n");
            this.addInner(title, inner);
            this.buf.append("</circle>\n");
        } else {
            this.buf.append("/>\n");
        }
    }

    public void drawSquare(int x, int y, int sz, Color border, Color fill, BasicStroke stroke, String clipid, Map<Object, Object> hints) {
        this.drawRect(x - sz / 2, y - sz / 2, sz, sz, border, fill, stroke, clipid, hints);
    }

    public void drawRect(int x, int y, int width, int height, Color border, Color fill, BasicStroke stroke, String clipid, Map<Object, Object> hints) {
        this.buf.append("<rect ");
        this.addAttributes(hints);
        this.addClipPath(clipid);
        this.addInt("x", x);
        this.addInt("y", y);
        this.addInt("width", width);
        this.addInt("height", height);
        this.addStroke("fill", fill, null);
        this.addStroke("stroke", border, stroke);
        this.buf.append("shape-rendering=\"crispEdges\" ");
        String title = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_TITLE);
        String inner = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_INNERSVG);
        if (title != null || inner != null) {
            this.buf.append(">\n");
            this.addInner(title, inner);
            this.buf.append("</rect>\n");
        } else {
            this.buf.append("/>\n");
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2, Color color, BasicStroke stroke, String clipid, Map<Object, Object> hints) {
        this.buf.append("<line ");
        this.addAttributes(hints);
        this.addClipPath(clipid);
        this.addInt("x1", x1);
        this.addInt("y1", y1);
        this.addInt("x2", x2);
        this.addInt("y2", y2);
        this.addStroke("stroke", color, stroke);
        if (x1 == x2 || y1 == y2) {
            this.buf.append("shape-rendering=\"crispEdges\" ");
        }
        String title = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_TITLE);
        String inner = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_INNERSVG);
        if (title != null || inner != null) {
            this.buf.append(">\n");
            this.addInner(title, inner);
            this.buf.append("</line>\n");
        } else {
            this.buf.append("/>\n");
        }
    }

    public void drawPolyline(int[] x, int[] y, int sz, Color color, BasicStroke stroke, String clipid, Map<Object, Object> hints) {
        if (sz < 2) {
            return;
        }
        this.buf.append("<path ");
        this.addAttributes(hints);
        this.addClipPath(clipid);
        this.buf.append("d=\"M");
        this.buf.append(x[0]).append(',').append(y[0]);
        for (int i = 1; i < sz; ++i) {
            int dx = x[i] - x[i - 1];
            int dy = y[i] - y[i - 1];
            if (dx == 0) {
                this.buf.append('v').append(dy);
                continue;
            }
            if (dy == 0) {
                this.buf.append('h').append(dx);
                continue;
            }
            this.buf.append('l').append(dx).append(',').append(dy);
        }
        this.buf.append("\" ");
        this.addStroke("stroke", color, stroke);
        this.buf.append("fill=\"none\" ");
        if (x[0] == x[1] || y[0] == y[1]) {
            this.buf.append("shape-rendering=\"crispEdges\" ");
        }
        String title = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_TITLE);
        String inner = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_INNERSVG);
        if (title != null || inner != null) {
            this.buf.append(">\n");
            this.addInner(title, inner);
            this.buf.append("</path>\n");
        } else {
            this.buf.append("/>\n");
        }
    }

    public void fillPolygon(int[] x, int[] y, int sz, Color color, String clipid, Map<Object, Object> hints) {
        if (sz < 2) {
            return;
        }
        this.buf.append("<path ");
        this.addAttributes(hints);
        this.addClipPath(clipid);
        this.buf.append("d=\"M");
        this.buf.append(x[0]).append(',').append(y[0]);
        for (int i = 1; i < sz; ++i) {
            int dx = x[i] - x[i - 1];
            int dy = y[i] - y[i - 1];
            if (dx == 0) {
                this.buf.append('v').append(dy);
                continue;
            }
            if (dy == 0) {
                this.buf.append('h').append(dx);
                continue;
            }
            this.buf.append('l').append(dx).append(',').append(dy);
        }
        this.buf.append("Z\" ");
        this.addStroke("fill", color, null);
        this.buf.append("stroke=\"none\" ");
        if (x[0] == x[1] || y[0] == y[1]) {
            this.buf.append("shape-rendering=\"crispEdges\" ");
        }
        String title = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_TITLE);
        String inner = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_INNERSVG);
        if (title != null || inner != null) {
            this.buf.append(">\n");
            this.addInner(title, inner);
            this.buf.append("</path>\n");
        } else {
            this.buf.append("/>\n");
        }
    }

    public void drawText(String text, int x, int y, Color color, Font font, String clipid, Map<Object, Object> hints) {
        this.buf.append("<text ");
        this.addAttributes(hints);
        this.addClipPath(clipid);
        this.addInt("x", x);
        this.addInt("y", y);
        this.addStroke("fill", color, null);
        if (font != null) {
            this.addString("font-family", font.getFamily());
            this.buf.append("font-size=\"").append(font.getSize()).append("px\" ");
            if (font.isBold()) {
                this.buf.append("font-weight=\"bold\" ");
            }
            if (font.isItalic()) {
                this.buf.append("font-style=\"italic\" ");
            }
        }
        this.buf.append("text-rendering=\"optimizeLegibility\">").append(DataHelper.escapeHTML((String)text));
        String title = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_TITLE);
        if (title != null) {
            this.addInner(title, null);
        }
        this.buf.append("</text>\n");
    }

    private void addInt(String key, int val) {
        this.buf.append(key).append("=\"").append(val).append("\" ");
    }

    private void addString(String key, String val) {
        this.buf.append(key).append("=\"").append(DataHelper.escapeHTML((String)val)).append("\" ");
    }

    private void addIDClass(String id, String clz) {
        if (id != null) {
            this.addString("id", id);
        }
        if (clz != null) {
            this.addString("class", clz);
        }
    }

    private void addAttributes(Map<Object, Object> hints) {
        Map atts;
        String clz;
        String id = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_ID);
        if (id != null) {
            this.addString("id", id);
        }
        if ((clz = (String)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_CLASS)) != null) {
            this.addString("class", clz);
        }
        if ((atts = (Map)hints.remove(SimpleSVGGraphics2D.KEY_ELEMENT_ATTMAP)) != null) {
            for (Map.Entry e : atts.entrySet()) {
                this.addString((String)e.getKey(), (String)e.getValue());
            }
        }
    }

    private void addStroke(String type, Color color, BasicStroke stroke) {
        int width;
        this.buf.append(type);
        if (color != null) {
            this.buf.append("=\"#").append(String.format(Locale.US, "%06x", color.getRGB() & 0xFFFFFF));
            int alpha = color.getAlpha();
            if (alpha < 255) {
                this.buf.append(String.format(Locale.US, "%02x", alpha));
            }
            this.buf.append("\" ");
        } else {
            this.buf.append("=\"none\" ");
        }
        if (stroke != null && (width = (int)stroke.getLineWidth()) > 0) {
            float[] dash;
            if (width != 1) {
                this.buf.append(type).append("-width=\"").append(width).append("\" ");
            }
            if ((dash = stroke.getDashArray()) != null && dash.length > 1) {
                this.buf.append("stroke-dasharray=\"");
                for (int i = 0; i < dash.length; ++i) {
                    this.buf.append((int)dash[i]);
                    if (i == dash.length - 1) continue;
                    this.buf.append(' ');
                }
                this.buf.append("\" ");
            }
        }
    }

    private void addClipPath(String clipid) {
        if (clipid != null) {
            this.buf.append("clip-path='url(#").append(clipid).append(")' ");
        }
    }

    private void addInner(String title, String inner) {
        if (title != null) {
            this.buf.append("  <title>").append(DataHelper.escapeHTML((String)title)).append("</title>\n");
        }
        if (inner != null) {
            this.buf.append("  ").append(inner).append("\n");
        }
    }
}

