/*
 * Decompiled with CFR 0.152.
 */
package net.metanotion.io.block;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.metanotion.io.RandomAccessInterface;
import net.metanotion.io.block.BlockFile;

class FreeListBlock {
    private static final long MAGIC = 2550851911464219683L;
    private static final long MAGIC_FREE = 9088622842173792638L;
    private static final int HEADER_LEN = 16;
    private static final int MAX_SIZE = 252;
    public final int page;
    private int nextPage;
    private int len;
    private final int[] branches;
    private final RandomAccessInterface file;

    public FreeListBlock(RandomAccessInterface file, int startPage) throws IOException {
        this.file = file;
        this.page = startPage;
        BlockFile.pageSeek(file, startPage);
        long magic = file.readLong();
        if (magic != 2550851911464219683L) {
            throw new IOException("Bad freelist magic number 0x" + Long.toHexString(magic) + " on page " + startPage);
        }
        this.nextPage = file.readUnsignedInt();
        this.len = file.readUnsignedInt();
        if (this.len > 252) {
            throw new IOException("Bad freelist size " + this.len);
        }
        this.branches = new int[252];
        if (this.len > 0) {
            int good = 0;
            for (int i = 0; i < this.len; ++i) {
                int fpg = file.readInt();
                if (fpg <= 2) continue;
                this.branches[good++] = fpg;
            }
            if (good != this.len) {
                Log log = I2PAppContext.getGlobalContext().logManager().getLog(BlockFile.class);
                log.error(this.len - good + " bad pages in " + String.valueOf(this));
                this.len = good;
                this.writeBlock();
            }
        }
    }

    public void writeBlock() throws IOException {
        BlockFile.pageSeek(this.file, this.page);
        this.file.writeLong(2550851911464219683L);
        this.file.writeInt(this.nextPage);
        this.file.writeInt(this.len);
        for (int i = 0; i < this.len; ++i) {
            this.file.writeInt(this.branches[i]);
        }
    }

    private void writeLen() throws IOException {
        BlockFile.pageSeek(this.file, this.page);
        this.file.skipBytes(12);
        this.file.writeInt(this.len);
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nxt) throws IOException {
        this.nextPage = nxt;
        BlockFile.pageSeek(this.file, this.page);
        this.file.skipBytes(8);
        this.file.writeInt(nxt);
    }

    private void writeFreePage() throws IOException {
        BlockFile.pageSeek(this.file, this.page);
        this.file.skipBytes(12);
        this.file.writeInt(this.len);
        if (this.len > 1) {
            this.file.skipBytes((this.len - 1) * 4);
        }
        this.file.writeInt(this.branches[this.len - 1]);
    }

    public boolean isEmpty() {
        return this.len <= 0;
    }

    public boolean isFull() {
        return this.len >= 252;
    }

    public void addPage(int freePage) throws IOException {
        if (this.len >= 252) {
            throw new IllegalStateException("full");
        }
        if (this.getMagic(freePage) == 9088622842173792638L) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(BlockFile.class);
            log.error("Double free page " + freePage, new Exception());
            return;
        }
        this.branches[this.len++] = freePage;
        this.markFree(freePage);
        this.writeFreePage();
    }

    public int takePage() throws IOException {
        if (this.len <= 0) {
            throw new IllegalStateException("empty");
        }
        --this.len;
        this.writeLen();
        int rv = this.branches[this.len];
        if (rv <= 2) {
            throw new IOException("Bad free page " + rv);
        }
        long magic = this.getMagic(rv);
        if (magic != 9088622842173792638L) {
            throw new IOException("Bad free page magic number 0x" + Long.toHexString(magic) + " on page " + rv);
        }
        return rv;
    }

    private void markFree(int freePage) throws IOException {
        BlockFile.pageSeek(this.file, freePage);
        this.file.writeLong(9088622842173792638L);
    }

    private long getMagic(int freePage) throws IOException {
        BlockFile.pageSeek(this.file, freePage);
        long magic = this.file.readLong();
        return magic;
    }

    public static void initPage(RandomAccessInterface file, int page) throws IOException {
        BlockFile.pageSeek(file, page);
        file.writeLong(2550851911464219683L);
        file.writeInt(0);
        file.writeInt(0);
    }

    public boolean flbck(boolean fix) throws IOException {
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(BlockFile.class);
        log.info(this.toString());
        if (this.nextPage > 0) {
            new FreeListBlock(this.file, this.nextPage).flbck(fix);
        }
        return true;
    }

    public String toString() {
        return "FLB with " + this.len + " / 252 page " + this.page + " next page " + this.nextPage;
    }
}

