/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.streamr;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.streamr.MultiSource;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

public class Subscriber
implements Sink {
    private final I2PAppContext ctx = I2PAppContext.getGlobalContext();
    private final Log log = this.ctx.logManager().getLog(this.getClass());
    private final Map<MultiSource.MSink, Long> subscriptions;
    private final MultiSource multi;
    private final SimpleTimer2.TimedEvent timer;
    private volatile boolean timerRunning;
    private static final int MAX_SUBSCRIPTIONS = 10;
    private static final long EXPIRATION = 60000L;

    public Subscriber(MultiSource multi) {
        this.multi = multi;
        this.subscriptions = new ConcurrentHashMap<MultiSource.MSink, Long>();
        this.timer = new Expire();
    }

    @Override
    public void send(Destination dest, int fromPort, int toPort, byte[] data) {
        if (dest == null || data.length < 1) {
            if (this.log.shouldWarn()) {
                this.log.warn("bad subscription from " + dest.toBase32() + ":" + fromPort);
            }
        } else {
            MultiSource.MSink ms = new MultiSource.MSink(dest, toPort, fromPort);
            int ctrl = data[0] & 0xFF;
            if (ctrl == 0) {
                if (this.subscriptions.put(ms, this.ctx.clock().now()) == null) {
                    if (this.subscriptions.size() > 10) {
                        this.subscriptions.remove(dest);
                        if (this.log.shouldWarn()) {
                            this.log.warn("Too many subscriptions, denying: " + String.valueOf(ms));
                        }
                        return;
                    }
                    if (this.log.shouldWarn()) {
                        this.log.warn("Add subscription: " + String.valueOf(ms));
                    }
                    this.multi.add(ms);
                    if (!this.timerRunning) {
                        this.timer.reschedule(60000L);
                        this.timerRunning = true;
                    }
                } else if (this.log.shouldInfo()) {
                    this.log.info("Continue subscription: " + String.valueOf(ms));
                }
            } else if (ctrl == 1) {
                if (this.log.shouldWarn()) {
                    this.log.warn("Remove subscription: " + String.valueOf(ms));
                }
                if (this.subscriptions.remove(ms) != null) {
                    this.multi.remove(ms);
                }
            } else if (this.log.shouldWarn()) {
                this.log.warn("bad subscription flag " + ctrl + " from " + String.valueOf(ms));
            }
        }
    }

    private class Expire
    extends SimpleTimer2.TimedEvent {
        public Expire() {
            super(Subscriber.this.ctx.simpleTimer2());
        }

        @Override
        public void timeReached() {
            if (Subscriber.this.subscriptions.isEmpty()) {
                Subscriber.this.timerRunning = false;
                return;
            }
            long exp = Subscriber.this.ctx.clock().now() - 60000L;
            Iterator<Map.Entry<MultiSource.MSink, Long>> iter = Subscriber.this.subscriptions.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<MultiSource.MSink, Long> e = iter.next();
                long then = e.getValue();
                if (then >= exp) continue;
                MultiSource.MSink ms = e.getKey();
                iter.remove();
                Subscriber.this.multi.remove(ms);
                if (!Subscriber.this.log.shouldWarn()) continue;
                Subscriber.this.log.warn("Expired subscription: " + String.valueOf(ms));
            }
            if (!Subscriber.this.subscriptions.isEmpty()) {
                this.schedule(60000L);
                Subscriber.this.timerRunning = true;
            } else {
                Subscriber.this.timerRunning = false;
            }
        }
    }
}

