/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.streamr;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.i2p.I2PAppContext;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;
import net.i2p.util.Log;

public class MultiSource
implements Source,
Sink {
    private Sink sink;
    private final List<MSink> sinks;
    private final Log log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());

    public MultiSource() {
        this.sinks = new CopyOnWriteArrayList<MSink>();
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public void start() {
    }

    public void stop() {
        this.sinks.clear();
    }

    @Override
    public void send(Destination ignored_from, int ignored_fromPort, int ignored_toPort, byte[] data) {
        if (this.sinks.isEmpty()) {
            if (this.log.shouldDebug()) {
                this.log.debug("No subscribers to send " + data.length + " bytes to");
            }
            return;
        }
        if (this.log.shouldDebug()) {
            this.log.debug("Sending " + data.length + " bytes to " + this.sinks.size() + " subscribers");
        }
        for (MSink ms : this.sinks) {
            this.sink.send(ms.dest, ms.fromPort, ms.toPort, data);
        }
    }

    public void add(MSink ms) {
        this.sinks.add(ms);
    }

    public void remove(MSink ms) {
        this.sinks.remove(ms);
    }

    static class MSink {
        public final Destination dest;
        public final int fromPort;
        public final int toPort;

        public MSink(Destination dest, int fromPort, int toPort) {
            this.dest = dest;
            this.fromPort = fromPort;
            this.toPort = toPort;
        }

        public int hashCode() {
            return this.dest.hashCode() | this.fromPort | this.toPort << 16;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MSink)) {
                return false;
            }
            MSink s = (MSink)o;
            return this.dest.equals(s.dest) && this.fromPort == s.fromPort && this.toPort == s.toPort;
        }

        public String toString() {
            return "from port " + this.fromPort + " to " + this.dest.toBase32() + ":" + this.toPort;
        }
    }
}

