/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketAddress;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.irc.DCCClientManager;
import net.i2p.i2ptunnel.irc.DCCHelper;
import net.i2p.i2ptunnel.irc.I2PTunnelDCCServer;
import net.i2p.i2ptunnel.irc.IrcInboundFilter;
import net.i2p.i2ptunnel.irc.IrcOutboundFilter;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PAppThread;

public class I2PTunnelIRCClient
extends I2PTunnelClientBase {
    private final List<I2PSocketAddress> _addrs;
    private static final long DEFAULT_READ_TIMEOUT = 600000L;
    protected long readTimeout = 600000L;
    private final boolean _dccEnabled;
    private I2PTunnelDCCServer _DCCServer;
    private DCCClientManager _DCCClientManager;
    public static final String PROP_DCC = "i2ptunnel.ircclient.enableDCC";

    public I2PTunnelIRCClient(int localPort, String destinations, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel, String pkf) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "IRC Client on " + tunnel.listenHost + ":" + localPort, tunnel, pkf);
        Properties opts = tunnel.getClientOptions();
        opts.setProperty("i2p.streaming.connectDelay", "200");
        opts.remove("i2p.streaming.maxWindowSize");
        this._addrs = new ArrayList<I2PSocketAddress>(4);
        this.buildAddresses(destinations);
        if (this._addrs.isEmpty()) {
            l.log("No target destinations found");
            this.notifyEvent("openClientResult", "error");
            throw new IllegalArgumentException("No valid target destinations found");
        }
        this.setName("IRC Client on " + tunnel.listenHost + ":" + localPort);
        this._dccEnabled = Boolean.parseBoolean(tunnel.getClientOptions().getProperty(PROP_DCC));
        this.notifyEvent("openIRCClientResult", "ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildAddresses(String destinations) {
        if (destinations == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(destinations, ", ");
        List<I2PSocketAddress> list = this._addrs;
        synchronized (list) {
            this._addrs.clear();
            while (tok.hasMoreTokens()) {
                String destination = tok.nextToken();
                try {
                    I2PSocketAddress addr = new I2PSocketAddress(destination);
                    this._addrs.add(addr);
                    if (!addr.isUnresolved()) continue;
                    String name = addr.getHostName();
                    if (name.length() == 60 && name.endsWith(".b32.i2p")) {
                        this.l.log("Warning - Could not resolve " + name + ", perhaps it is not up, will retry when connecting.");
                        continue;
                    }
                    this.l.log("Warning - Could not resolve " + name + ", you must add it to your address book for it to work.");
                }
                catch (IllegalArgumentException iae) {
                    this.l.log("Bad destination " + destination + " - " + String.valueOf(iae));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clientConnectionRun(Socket s) {
        if (this._log.shouldLog(20)) {
            this._log.info("New connection local addr is: " + String.valueOf(s.getLocalAddress()) + " from: " + String.valueOf(s.getInetAddress()));
        }
        Closeable i2ps = null;
        I2PSocketAddress addr = this.pickDestination();
        try {
            if (addr == null) {
                throw new UnknownHostException("No valid destination configured");
            }
            Destination clientDest = addr.getAddress();
            if (clientDest == null) {
                throw new UnknownHostException("Could not resolve " + addr.getHostName());
            }
            int port = addr.getPort();
            try {
                i2ps = this.createI2PSocket(clientDest, port);
            }
            catch (RuntimeException re) {
                this._log.error("Error connecting", re);
                try {
                    String name = addr != null ? addr.getHostName() : "undefined";
                    String msg = ":" + name + " 499 you :" + re.getMessage() + "\r\n";
                    s.getOutputStream().write(DataHelper.getUTF8(msg));
                }
                catch (IOException name) {
                    // empty catch block
                }
                throw re;
            }
            i2ps.setReadTimeout(this.readTimeout);
            StringBuffer expectedPong = new StringBuffer();
            DCC dcc = this._dccEnabled ? new DCC(s.getLocalAddress().getAddress()) : null;
            I2PAppThread in = new I2PAppThread(new IrcInboundFilter(s, (I2PSocket)i2ps, expectedPong, this._log, dcc), "IRC Client " + this._clientId + " in", true);
            ((Thread)in).start();
            IrcOutboundFilter out = new IrcOutboundFilter(s, (I2PSocket)i2ps, expectedPong, this._log, dcc);
            out.run();
        }
        catch (IOException ex) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error connecting", ex);
            }
            try {
                String name = addr != null ? addr.getHostName() : "undefined";
                String msg = ":" + name + " 499 you :" + String.valueOf(ex) + "\r\n";
                s.getOutputStream().write(DataHelper.getUTF8(msg));
            }
            catch (IOException name) {
                // empty catch block
            }
        }
        catch (I2PException ex) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error connecting", ex);
            }
            try {
                String name = addr != null ? addr.getHostName() : "undefined";
                String msg = ":" + name + " 499 you :" + String.valueOf(ex) + "\r\n";
                s.getOutputStream().write(DataHelper.getUTF8(msg));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            I2PTunnelIRCClient.closeSocket(s);
            if (i2ps != null) {
                try {
                    i2ps.close();
                }
                catch (IOException ex) {}
                Object ex = this.sockLock;
                synchronized (ex) {
                    this.mySockets.remove(i2ps);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final I2PSocketAddress pickDestination() {
        List<I2PSocketAddress> list = this._addrs;
        synchronized (list) {
            int size = this._addrs.size();
            if (size <= 0) {
                if (this._log.shouldLog(40)) {
                    this._log.error("No client targets?!");
                }
                return null;
            }
            if (size == 1) {
                return this._addrs.get(0);
            }
            int index = this._context.random().nextInt(size);
            return this._addrs.get(index);
        }
    }

    @Override
    public void optionsUpdated(I2PTunnel tunnel) {
        if (this.getTunnel() != tunnel) {
            return;
        }
        Properties props = tunnel.getClientOptions();
        String targets = props.getProperty("targetDestination");
        this.buildAddresses(targets);
        super.optionsUpdated(tunnel);
    }

    @Override
    public void startRunning() {
        super.startRunning();
        if (this.open) {
            this._context.portMapper().register("irc", this.getTunnel().listenHost, this.getLocalPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(boolean forced) {
        int reg = this._context.portMapper().getPort("irc");
        if (reg == this.getLocalPort()) {
            this._context.portMapper().unregister("irc");
        }
        I2PTunnelIRCClient i2PTunnelIRCClient = this;
        synchronized (i2PTunnelIRCClient) {
            if (this._DCCServer != null) {
                this._DCCServer.close(forced);
                this._DCCServer = null;
            }
            if (this._DCCClientManager != null) {
                this._DCCClientManager.close(forced);
                this._DCCClientManager = null;
            }
        }
        return super.close(forced);
    }

    private class DCC
    implements DCCHelper {
        private final byte[] _localAddr;

        public DCC(byte[] local) {
            this._localAddr = local.length == 4 ? local : new byte[]{127, 0, 0, 1};
        }

        @Override
        public boolean isEnabled() {
            return I2PTunnelIRCClient.this._dccEnabled;
        }

        @Override
        public String getB32Hostname() {
            return I2PTunnelIRCClient.this.sockMgr.getSession().getMyDestination().toBase32();
        }

        @Override
        public byte[] getLocalAddress() {
            return this._localAddr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int newOutgoing(byte[] ip, int port, String type) {
            I2PTunnelDCCServer server;
            DCC dCC = this;
            synchronized (dCC) {
                if (I2PTunnelIRCClient.this._DCCServer == null) {
                    if (I2PTunnelIRCClient.this._log.shouldLog(20)) {
                        I2PTunnelIRCClient.this._log.info("Starting DCC Server");
                    }
                    I2PTunnelIRCClient.this._DCCServer = new I2PTunnelDCCServer(I2PTunnelIRCClient.this.sockMgr, I2PTunnelIRCClient.this.l, I2PTunnelIRCClient.this, I2PTunnelIRCClient.this.getTunnel());
                    I2PTunnelIRCClient.this._DCCServer.startRunning();
                }
                server = I2PTunnelIRCClient.this._DCCServer;
            }
            int rv = server.newOutgoing(ip, port, type);
            if (I2PTunnelIRCClient.this._log.shouldLog(20)) {
                I2PTunnelIRCClient.this._log.info("New outgoing " + type + " " + port + " returns " + rv);
            }
            return rv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int newIncoming(String b32, int port, String type) {
            DCCClientManager tracker;
            DCC dCC = this;
            synchronized (dCC) {
                if (I2PTunnelIRCClient.this._DCCClientManager == null) {
                    if (I2PTunnelIRCClient.this._log.shouldLog(20)) {
                        I2PTunnelIRCClient.this._log.info("Starting DCC Client");
                    }
                    I2PTunnelIRCClient.this._DCCClientManager = new DCCClientManager(I2PTunnelIRCClient.this.sockMgr, I2PTunnelIRCClient.this.l, I2PTunnelIRCClient.this, I2PTunnelIRCClient.this.getTunnel());
                }
                tracker = I2PTunnelIRCClient.this._DCCClientManager;
            }
            int rv = tracker.newIncoming(b32, port, type);
            if (I2PTunnelIRCClient.this._log.shouldLog(20)) {
                I2PTunnelIRCClient.this._log.info("New incoming " + type + " " + b32 + " " + port + " returns " + rv);
            }
            return rv;
        }

        @Override
        public int resumeOutgoing(int port) {
            DCCClientManager tracker = I2PTunnelIRCClient.this._DCCClientManager;
            if (tracker != null) {
                return tracker.resumeOutgoing(port);
            }
            return -1;
        }

        @Override
        public int resumeIncoming(int port) {
            I2PTunnelDCCServer server = I2PTunnelIRCClient.this._DCCServer;
            if (server != null) {
                return server.resumeIncoming(port);
            }
            return -1;
        }

        @Override
        public int acceptOutgoing(int port) {
            I2PTunnelDCCServer server = I2PTunnelIRCClient.this._DCCServer;
            if (server != null) {
                return server.acceptOutgoing(port);
            }
            return -1;
        }

        @Override
        public int acceptIncoming(int port) {
            DCCClientManager tracker = I2PTunnelIRCClient.this._DCCClientManager;
            if (tracker != null) {
                return tracker.acceptIncoming(port);
            }
            return -1;
        }
    }
}

