/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import net.i2p.I2PAppContext;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.SchedulerImpl;

class SchedulerClosing
extends SchedulerImpl {
    public SchedulerClosing(I2PAppContext ctx) {
        super(ctx);
    }

    @Override
    public boolean accept(Connection con) {
        if (con == null) {
            return false;
        }
        long timeSinceClose = this._context.clock().now() - con.getCloseSentOn();
        boolean ok = !(con.getResetSent() || con.getResetReceived() || con.getCloseSentOn() <= 0L && con.getCloseReceivedOn() <= 0L || timeSinceClose >= 300000L || con.getUnackedPacketsReceived() <= 0 && con.getUnackedPacketsSent() <= 0);
        return ok;
    }

    @Override
    public void eventOccurred(Connection con) {
        long remaining;
        long nextSend = con.getNextSendTime();
        long now = this._context.clock().now();
        if (nextSend <= 0L) {
            remaining = con.getOptions().getSendAckDelay();
            nextSend = now + remaining;
            con.setNextSendTime(nextSend);
        } else {
            remaining = nextSend - now;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Event occurred w/ remaining: " + remaining + " on " + String.valueOf(con));
        }
        if (remaining <= 0L) {
            if (con.getCloseSentOn() <= 0L) {
                con.sendAvailable();
            }
            con.setNextSendTime(now + (long)con.getOptions().getSendAckDelay());
        } else {
            this.reschedule(remaining, con);
        }
    }
}

