/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Locale;
import org.rrd4j.core.Util;

public class XmlWriter
implements AutoCloseable {
    static final String INDENT_STR = "   ";
    private static final String STYLE = "style";
    private static final DateTimeFormatter ISOLIKE = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSZ").withLocale(Locale.ENGLISH).withZone(ZoneId.of("UTC"));
    private static final String DEFAULT_NAN_STRING = Double.toString(Double.NaN);
    private final PrintWriter writer;
    private final StringBuilder indent = new StringBuilder();
    private final Deque<String> openTags = new LinkedList<String>();
    private final DateTimeFormatter timeFormatter;
    private final DoubleFormater doubleFormatter;

    private XmlWriter(PrintWriter writer, DateTimeFormatter timeFormatter, DoubleFormater doubleFormatter) {
        this.writer = writer;
        this.timeFormatter = timeFormatter;
        this.doubleFormatter = doubleFormatter;
    }

    public XmlWriter(OutputStream stream) {
        this.writer = new PrintWriter(stream, true);
        this.timeFormatter = ISOLIKE;
        this.doubleFormatter = (d, n) -> Util.formatDouble(d, n, true);
    }

    public XmlWriter(OutputStream stream, boolean autoFlush) {
        this.writer = new PrintWriter(stream, autoFlush);
        this.timeFormatter = ISOLIKE;
        this.doubleFormatter = (d, n) -> Util.formatDouble(d, n, true);
    }

    public XmlWriter(PrintWriter stream) {
        this.writer = stream;
        this.timeFormatter = ISOLIKE;
        this.doubleFormatter = (d, n) -> Util.formatDouble(d, n, true);
    }

    public XmlWriter withTimeZone(ZoneId zid) {
        if (this.indent.length() != 0 || !this.openTags.isEmpty()) {
            throw new IllegalStateException("Can't be used on a already used XmlWriter");
        }
        DateTimeFormatter dtf = this.timeFormatter.withZone(zid);
        return new XmlWriter(this.writer, dtf, this.doubleFormatter);
    }

    public XmlWriter withDoubleFormatter(DoubleFormater doubleFormatter) {
        if (this.indent.length() != 0 || !this.openTags.isEmpty()) {
            throw new IllegalStateException("Can't be used on a already used XmlWriter");
        }
        return new XmlWriter(this.writer, this.timeFormatter, doubleFormatter);
    }

    public void startTag(String tag) {
        this.writer.println(String.valueOf(this.indent) + "<" + tag + ">");
        this.openTags.push(tag);
        this.indent.append(INDENT_STR);
    }

    public void closeTag() {
        String tag = this.openTags.pop();
        this.indent.setLength(this.indent.length() - INDENT_STR.length());
        this.writer.println(String.valueOf(this.indent) + "</" + tag + ">");
    }

    public void writeTag(String tag, Object value) {
        if (value != null) {
            this.writer.println(String.valueOf(this.indent) + "<" + tag + ">" + XmlWriter.escape(value.toString()) + "</" + tag + ">");
        } else {
            this.writer.println(String.valueOf(this.indent) + "<" + tag + "></" + tag + ">");
        }
    }

    public void writeTag(String tag, int value) {
        this.writeTag(tag, Integer.toString(value));
    }

    public void writeTag(String tag, long value) {
        this.writeTag(tag, Long.toString(value));
    }

    public void writeTag(String tag, double value, String nanString) {
        this.writeTag(tag, this.doubleFormatter.format(value, nanString));
    }

    public void writeTag(String tag, double value) {
        this.writeTag(tag, this.doubleFormatter.format(value, DEFAULT_NAN_STRING));
    }

    public void writeTag(String tag, boolean value) {
        this.writeTag(tag, Boolean.toString(value));
    }

    public void writeTag(String tag, Color value) {
        int rgb = value.getRGB() & 0xFFFFFF;
        this.writeTag(tag, "#" + Integer.toHexString(rgb).toUpperCase());
    }

    public void writeTag(String tag, Font value) {
        this.startTag(tag);
        this.writeTag("name", value.getName());
        int style = value.getStyle();
        if ((style & 1) != 0 && (style & 2) != 0) {
            this.writeTag(STYLE, "BOLDITALIC");
        } else if ((style & 1) != 0) {
            this.writeTag(STYLE, "BOLD");
        } else if ((style & 2) != 0) {
            this.writeTag(STYLE, "ITALIC");
        } else {
            this.writeTag(STYLE, "PLAIN");
        }
        this.writeTag("size", value.getSize());
        this.closeTag();
    }

    public void writeTag(String tag, File value) {
        this.writeTag(tag, value.getPath());
    }

    public void flush() {
        this.writer.flush();
    }

    public void writeComment(Object comment) {
        this.writer.println(String.valueOf(this.indent) + "<!-- " + XmlWriter.escape(comment.toString()) + " -->");
    }

    public void writeComment(long timestamp) {
        this.writer.println(String.valueOf(this.indent) + "<!-- " + XmlWriter.escape(this.formatTimestamp(timestamp)) + " -->");
    }

    public String formatTimestamp(long timestamp) {
        return this.timeFormatter.format(Instant.ofEpochSecond(timestamp));
    }

    private static String escape(String s) {
        return s.replace("<", "&lt;").replace(">", "&gt;");
    }

    @Override
    public void close() {
        this.writer.flush();
        this.writer.close();
    }

    @FunctionalInterface
    public static interface DoubleFormater {
        public String format(double var1, String var3);
    }
}

