/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.rrd4j.core.ByteBufferBackend;
import org.rrd4j.core.RrdFileBackend;
import org.rrd4j.core.RrdRandomAccessFileBackend;
import org.rrd4j.core.RrdSyncThreadPool;

public class RrdNioBackend
extends ByteBufferBackend
implements RrdFileBackend {
    private static final Method cleanerMethod;
    private static final Method cleanMethod;
    private static final Method invokeCleaner;
    private static final Object unsafe;
    private MappedByteBuffer byteBuffer;
    private final FileChannel file;
    private final boolean readOnly;
    private ScheduledFuture<?> syncRunnableHandle = null;

    protected RrdNioBackend(String path, boolean readOnly, RrdSyncThreadPool threadPool, int syncPeriod) throws IOException {
        super(path);
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>(3);
        options.add(StandardOpenOption.READ);
        options.add(StandardOpenOption.CREATE);
        if (!readOnly) {
            options.add(StandardOpenOption.WRITE);
        }
        this.file = FileChannel.open(Paths.get(path, new String[0]), options, new FileAttribute[0]);
        this.readOnly = readOnly;
        try {
            this.mapFile(this.file.size());
        }
        catch (IOException | RuntimeException ex) {
            this.file.close();
            super.close();
            throw ex;
        }
        try {
            if (!readOnly && threadPool != null) {
                Runnable syncRunnable = this::sync;
                this.syncRunnableHandle = threadPool.scheduleWithFixedDelay(syncRunnable, syncPeriod, syncPeriod, TimeUnit.SECONDS);
            }
        }
        catch (RuntimeException rte) {
            this.unmapFile();
            this.file.close();
            super.close();
            throw rte;
        }
    }

    private void mapFile(long length) throws IOException {
        if (length > 0L) {
            FileChannel.MapMode mapMode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            this.byteBuffer = this.file.map(mapMode, 0L, length);
            this.setByteBuffer(this.byteBuffer);
        }
    }

    private void unmapFile() {
        if (this.byteBuffer != null && this.byteBuffer.isDirect()) {
            try {
                if (cleanMethod != null) {
                    Object cleaner = cleanerMethod.invoke((Object)this.byteBuffer, new Object[0]);
                    cleanMethod.invoke(cleaner, new Object[0]);
                } else {
                    invokeCleaner.invoke(unsafe, this.byteBuffer);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.byteBuffer = null;
    }

    @Override
    protected synchronized void setLength(long newLength) throws IOException {
        if (newLength < 0L || newLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal offset: " + newLength);
        }
        this.unmapFile();
        this.file.truncate(newLength);
        this.mapFile(newLength);
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (!this.readOnly && this.syncRunnableHandle != null) {
                this.syncRunnableHandle.cancel(false);
                this.syncRunnableHandle = null;
                this.sync();
            }
            this.unmapFile();
        }
        finally {
            this.file.close();
            super.close();
        }
    }

    protected synchronized void sync() {
        if (this.byteBuffer != null) {
            this.byteBuffer.force();
        }
    }

    @Override
    public synchronized long getLength() throws IOException {
        return this.file.size();
    }

    @Override
    public String getCanonicalPath() {
        return Paths.get(this.getPath(), new String[0]).toAbsolutePath().normalize().toString();
    }

    static {
        Method invokeCleanerTemp;
        Object unsafeTemp;
        Method cleanMethodTemp;
        Method cleanerMethodTemp;
        try {
            Class<?> directBufferClass = RrdRandomAccessFileBackend.class.getClassLoader().loadClass("sun.nio.ch.DirectBuffer");
            Class<?> cleanerClass = RrdNioBackend.class.getClassLoader().loadClass("sun.misc.Cleaner");
            cleanerMethodTemp = directBufferClass.getMethod("cleaner", new Class[0]);
            cleanerMethodTemp.setAccessible(true);
            cleanMethodTemp = cleanerClass.getMethod("clean", new Class[0]);
            cleanMethodTemp.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            cleanerMethodTemp = null;
            cleanMethodTemp = null;
        }
        try {
            Field singleoneInstanceField = RrdRandomAccessFileBackend.class.getClassLoader().loadClass("sun.misc.Unsafe").getDeclaredField("theUnsafe");
            singleoneInstanceField.setAccessible(true);
            unsafeTemp = singleoneInstanceField.get(null);
            invokeCleanerTemp = unsafeTemp.getClass().getMethod("invokeCleaner", ByteBuffer.class);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            invokeCleanerTemp = null;
            unsafeTemp = null;
        }
        cleanerMethod = cleanerMethodTemp;
        cleanMethod = cleanMethodTemp;
        invokeCleaner = invokeCleanerTemp;
        unsafe = unsafeTemp;
    }
}

